/**************************************/
/* kep.h			      */
/*				      */
/* General definitions for aa program */
/**************************************/

/***** description
 *
 *	$Id: kep.h,v 1.2 1993/04/21 15:16:15 craig Exp $
 *
 */

/***** modification history
 *
 *	$Log: kep.h,v $
 * Revision 1.2  1993/04/21  15:16:15  craig
 * First working version.  Removed everything except the orbit and
 * star structures.
 *
 *
 */

struct orbit
{
    char   obname[16];			/* name of the object */
    double epoch;			/* epoch of orbital elements */
    double i;				/* inclination	 */
    double W;				/* longitude of the ascending node */
    double w;				/* argument of the perihelion */
    double a;				/* mean distance (semimajor axis) */
    double dm;				/* daily motion */
    double ecc;				/* eccentricity */
    double M;				/* mean anomaly */
    double equinox;			/* epoch of equinox and ecliptic */
    double mag;				/* visual magnitude at 1AU from
					   earth and sun */
    double sdiam;			/* equatorial semidiameter at 1au,
					   arc seconds */
    /* The following used by perterbation formulas: */
    int    (*oelmnt) ();		/* address of program to compute
					   elements */
    int    (*celmnt) ();		/* program to correct longitude
					   and radius */
    double L;				/* computed mean longitude */
    double r;				/* computed radius vector */
    double plat;			/* perturbation in ecliptic
					   latitude */
};

struct star
{
    char   obname[32];			/* Object name (31 chars) */
    double epoch;			/* Epoch of coordinates */
    double ra;				/* Right Ascension, radians */
    double dec;				/* Declination, radians */
    double px;				/* Parallax, radians */
    double mura;			/* proper motion in R.A.,
					   rad/century */
    double mudec;			/* proper motion in Dec.,
					   rad/century */
    double v;				/* radial velocity, km/s */
    double equinox;			/* Epoch of equinox and ecliptic */
};

/* Note the items for a star are in different measurement units
 * in the ASCII file description.
 */
