/************************************************/
/* aaproto.h					*/
/*						*/
/* function prototypes for astronomical alminac	*/
/************************************************/

/***** description
 *
 *	$Id: aaproto.h,v 1.3 1993/05/18 16:32:10 craig Exp $
 *
 */

/***** modification history
 *
 *	$Log: aaproto.h,v $
 * Revision 1.3  1993/05/18  16:32:10  craig
 * reflects various changes in the almanac software to make
 * the subroutines more flexable with reguards to printing.
 *
 * Revision 1.2  1993/04/22  21:07:42  craig
 * changed the function prototype for kinit.  kinit was changed
 * to allow for the input of a filename and a flag.
 *
 * Revision 1.1  1993/04/21  14:58:29  craig
 * Initial revision
 *
 *
 */

/***** include files *****/

/* #include "../astro.h" */		/* for POLAR struct */

#include <stdio.h>			/* for FILE */
#include "kep.h"			/* for orbit and star structs */

/***** routines in altaz.c *****/

int    altaz (double *pol, double J, double *objalt, double *objaz,
	   double *objra, double *objdec);

/***** routines in angles.c *****/

int    angles (double *p, double *q, double *e);

/***** routines in annuab.c *****/

int    annuab (double *p);

/***** routines in cmoon.c *****/

int    gmoon (double J, double *rect, double *pol);
int    domoon (void);

/***** routines in constel.c *****/

int    showcname (char *in);

/***** routines in deflec.c *****/

int    relativity (double *p, double *q, double *e);

/***** routines in deltat.c *****/

int    update (FILE *out);
double deltat (double Y);

/***** routines in diurab.c *****/

int    diurab (double last, double *ra, double *dec);

/***** routines in diurpx.c *****/

int    diurpx (double last, double *ra, double *dec, double dist);

/***** routines in dms.c *****/

int    dms (FILE *out, double x);
int    hms (FILE *out, double x);
int    deltap (double *p0, double *p1, double *dr, double *dd);
int    getint (char *msg, int *num);
int    jtocal (FILE *out, double J);
int    showrd (char *msg, double *p, double *pol);
int    getlong (char *msg, long *num);
int    showcor (char *strng, double *p, double *dp);
int    getdouble (char *msg, double *num);
int    getstring (char *msg, char *num, int maxsize);

double modtp (double x);
double caltoj (long year, int month, double day);
double gethms (void);
double mod360 (double x);
double getdate (void);

/***** routines in epsiln.c *****/

int    epsiln (double J);

/***** routines in fk4fk5.c *****/

int    fk4fk5 (double *p, double *m, struct star *el);

/***** routines in kepler.c *****/

int    kepler (double j, struct orbit *e, double *rect, double *polar);

/***** routines in kfiles.c *****/

int    kinit (void);
int    getstar (struct star *el);
int    getorbit (struct orbit *el);

FILE  *fincat (char *name, int n, char *str1, char *str2);

/***** routines in lightt.c *****/

int    lightt (struct orbit *elemnt, double *q, double *e);

/***** routines in lonlat.c *****/

int    lonlat (double *pp, double J, double *polar);

/***** routines in nutate.c *****/

int    sscc (int k, double arg, int n);
int    nutlo (double J);
int    nutate (double J, double *p);

/***** routines in precess.c *****/

int    precess (double *R, double J, int direction);

/***** routines in refrac.c *****/

double refrac (double alt);

/***** routines in rplanet.c *****/

int    reduce (struct orbit *elemnt, double *q, double *p);

/***** routines in rstar.c *****/

int    rstar (struct star *el, double *alt, double *az, double *ra, 
	   double *dec);

/***** routines in sidrlt.c *****/

double sidrlt (double j, double tlong);

/***** routines in sun.c *****/

int    dosun (double *alt, double *az, double *ra, double *dec,
	   double *sdiam);

/***** routines in trnsit.c *****/

int    trnsit (double J, double lha, double dec);

/***** routines in vearth.c *****/

int    velearth (double J);

/***** routines in oearth.c *****/

int    cearth (struct orbit *e);
int    oearth (struct orbit *e, double J);

/***** routines in manoms.c *****/

int    manoms (double J);

/***** routines in ojupiter.c *****/

int    pjup (void);
int    cjupiter (struct orbit *e);
int    ojupiter (struct orbit *e, double J);

/***** routines in omars.c *****/

int    cmars (struct orbit *e);
int    omars (struct orbit *e, double J);

/***** routines in omercury.c *****/

int    cmercury (struct orbit *e);
int    omercury (struct orbit *e, double J);

/***** routines in oneptune.c *****/

int    cneptune (struct orbit *e);
int    oneptune (struct orbit *e, double J);

/***** routines in osaturn.c *****/

int    csaturn (struct orbit *e);
int    osaturn (struct orbit *e, double J);

/***** routines in ouranus.c *****/

int    curanus (struct orbit *e);
int    ouranus (struct orbit *e, double J);

/***** routines in ovenus.c *****/

int    cvenus (struct orbit *e);
int    ovenus (struct orbit *e, double J);

/***** routines in cnstinit.c *****/

void   cnstinit (void);

/***** routines in matan2.c *****/

double matan2 (double y, double x);
