*      DRIVER                                                 3 NOV 80

*   WGS-72 PHYSICAL AND GEOPOTENTIAL CONSTANTS
*          CK2= .5*J2*AE**2     CK4=-.375*J4*AE**4

      DOUBLE PRECISION EPOCH,DS50
      COMMON/E1/XMO,XNODEO,OMEGAO,EO,XINCL,XNO,XNDT2O,XNDD6O,BSTAR,
     1            X,Y,Z,XDOT,YDOT,ZDOT,EPOCH,DS50
      COMMON/C1/CK2,CK4,E6A,QOMS2T,S,TOTHRD,
     1           XJ3,XKE,XKMPER,XMNPDA,AE
      COMMON/C2/DE2RA,PI,PIO2,TWOPI,X3PIO2
      DATA IHG/1HG/
      DATA DE2RA,E6A,PI,PIO2,QO,SO,TOTHRD,TWOPI,X3PIO2,XJ2,XJ3,
     1            XJ4,XKE,XKMPER,XMNPDA,AE/.174532925E-1,1.E-6,
     2            3.14159265,1.57079633,120.0,78.0,.66666667,
     4            6.2831853,4.71238898,1.082616E-3,-.253881E-5,
     5            -1.65597E-6,.743669161E-1,6378.135,1440.,1./
      DIMENSION ISET(5)
      CHARACTER ABUF*80(2)
      DATA (ISET(I),I=1,5)/3HSGP,4HSGP4,4HSDP4,4HSGP8,4HSDP8/

*     SELECT EPHEMERIS TYPE AND OUTPUT TIMES

      CK2=.5*XJ2*AE**2
      CK4=-.375*XJ4*AE**4
      QOMS2T=((QO-SO)*AE/XKMPER)**4
      S=AE*(1.+SO/XKMPER)
    2 READ (5,700) IEPT, TS,TF,DELT
      IF(IEPT.LE.0) STOP
      IDEEP=0

*     READ IN MEAN ELEMENTS FROM 2 CARD T(TRANS) OR G(INTERN) FORMAT

      READ (5,706) ABUF
      DECODE(ABUF(1),707)  ITYPE
      IF(ITYPE.EQ.IHG) GO TO 5
      DECODE (ABUF,702) EPOCH,XNDT2O,XNDD6O,IEXP,BSTAR,IBEXP,XINCL,
     1        XNODEO,EO,OMEGAO,XMO,XNO
      GO TO 7
    5 DECODE(ABUF,701) EPOCH,XMO,XNODEO,OMEGAO,EO,XINCL,XNO,XNDT2O,
     1        XNDD6O,IEXP,BSTAR,IBEXP
   7  IF(XNO.LE.0.) STOP
      WRITE(6,704) ABUF,ISET(IEPT)
      IF(IEPT.GT.5) GO TO 900
      XNDD6O=XNDD6O*(10.**IEXP)
      XNODEO=XNODEO*DE2RA
      OMEGAO=OMEGAO*DE2RA
      XMO=XMO*DE2RA
      XINCL=XINCL*DE2RA
      TEMP=TWOPI/XMNPDA/XMNPDA
      XNO=XNO*TEMP*XMNPDA
      XNDT2O=XNDT2O*TEMP
      XNDD6O=XNDD6O*TEMP/XMNPDA

*     INPUT CHECK FOR PERIOD VS EPHEMERIS SELECTED
*     PERIOD GE 225 MINUTES  IS DEEP SPACE

      A1=(XKE/XNO)**TOTHRD
      TEMP=1.5*CK2*(3.*COS(XINCL)**2-1.)/(1.-EO*EO)**1.5
      DEL1=TEMP/(A1*A1)
      AO=A1*(1.-DEL1*(.5*TOTHRD+DEL1*(1.+134./81.*DEL1)))
      DELO=TEMP/(AO*AO)
      XNODP=XNO/(1.+DELO)
      IF((TWOPI/XNODP/XMNPDA) .GE. .15625) IDEEP=1

      BSTAR=BSTAR*(10.**IBEXP)/AE
      TSINCE=TS
      IFLAG=1
      IF(IDEEP .EQ. 1 .AND. (IEPT .EQ. 1 .OR. IEPT .EQ. 2
     1           .OR. IEPT .EQ. 4)) GO TO 800
    9 IF(IDEEP .EQ. 0 .AND. (IEPT .EQ. 3 .OR. IEPT .EQ. 5))
     1           GO TO 850
   10 GO TO (21,22,23,24,25), IEPT
   21 CALL SGP(IFLAG,TSINCE)
      GO TO 60
   22 CALL SGP4(IFLAG,TSINCE)
      GO TO 60
   23 CALL SDP4(IFLAG,TSINCE)
      GO TO 60
   24 CALL SGP8(IFLAG,TSINCE)
      GO TO 60
   25 CALL SDP8(IFLAG,TSINCE)
   60 X=X*XKMPER/AE
      Y=Y*XKMPER/AE
      Z=Z*XKMPER/AE
      XDOT=XDOT*XKMPER/AE*XMNPDA/86400.
      YDOT=YDOT*XKMPER/AE*XMNPDA/86400.
      ZDOT=ZDOT*XKMPER/AE*XMNPDA/86400.
      WRITE(6,705) TSINCE,X,Y,Z,XDOT,YDOT,ZDOT
      TSINCE=TSINCE+DELT
      IF(ABS(TSINCE) .GT. ABS(TF)) GO TO 2
      GO TO 10
  700 FORMAT(I1,3F10.0)
  701 FORMAT(29X,D14.8,1X,3F8.4,/,6X,F8.7,F8.4,1X,2F11.9,1X,F6.5,I2,
     1       4X,F8.7,I2)
  702 FORMAT(18X,D14.8,1X,F10.8,2(1X,F6.5,I2),/,7X,2(1X,F8.4),1X,
     1       F7.7,2(1X,F8.4),1X,F11.8)
  703 FORMAT(79X,A1)
  704 FORMAT(1H1,A80,/,1X,A80,//,1X,A4,7H TSINCE,
     1 14X,1HX,16X,1HY,16X,1HZ,14X,
     1 4HXDOT,13X,4HYDOT,13X,4HZDOT,//)
  705 FORMAT(7F17.8)
  706 FORMAT(A80)
  707 FORMAT(79X,A1)
  930 FORMAT("SHOULD USE DEEP SPACE EPHEMERIS")
  940 FORMAT("SHOULD USE NEAR EARTH EPHEMERIS")
  950 FORMAT("EPHEMERIS NUMBER",I2," NOT LEGAL, WILL SKIP THIS CASE")
  800 WRITE(6,930)
      GO TO 9
  850 WRITE(6,940)
      GO TO 10
  900 WRITE(6,950) IEPT
      GO TO 2
      END
