/****************************************/
/* bdriver.c				*/
/*					*/
/* batch satellite epherimus driver	*/
/****************************************/

/***** description
 *
 *	$Id: bdriver.c,v 1.2 1993/05/12 18:58:00 craig Exp $
 *
 */

/***** modification history
 *
 *	$Log: bdriver.c,v $
 * Revision 1.2  1993/05/12  18:58:00  craig
 * Changed the orbit calculation section to use the new satreduce
 * subroutine and the new do_orbit routine.
 *
 * Revision 1.1  1993/04/30  18:29:57  craig
 * Initial revision
 *
 *
 */

/***** include files *****/

#include <string.h>
#include <math.h>
#include "satellite.h"
#include "satproto.h"
#include "aaproto.h"

/***** global variables *****/

FILE  *elefile;

struct star fstar;
struct ELEMENT element;

/* from cnstinit.c */

extern int prtflg;

extern FILE *outfile;

extern double JD;
extern double UT;

extern struct PCONSTANTS pcnsts;
extern struct MCONSTANTS mcnsts;


/***********/
/* bdriver */
/***********/

int    main (void)
{
    /***** Local variables *****/

    int    iept, iflag;

    char   fname[32];

    double delo, delt, del1, temp;
    double a1, xnodp, ao;

    double oalt, oaz, ora, odec;
    double nalt, naz, nra, ndec;
    double N, D, x;

    double JDTIME, JDSTOP, JDSTART;


    /***** initialize constants *****/

    prtflg = 0;
    cnstinit ();

    if (kinit () == -1)
    {
	fprintf (stderr, "Unable to find a ./.site.ini or a ");
	fprintf (stderr, "~/.site.ini site initialization file.\n");
	exit (-1);
    }

    /***** initialize inputs *****/

    strcpy (fname, "ntest.tle");
    delt = 5.;
    outfile = stdout;

    /***** select files and output times *****/

    getstring ("Element file name: ", fname, 32);

    /*** open the element file ***/

    elefile = fopen (fname, "r");

    if (elefile == NULL)
    {
	fprintf (stderr, "Error in opening element file: %s\n", fname);
	return (-1);
    }

    printf ("Output file name: ( stdout ) ? ");

    if (strlen (gets (fname)))
    {
	/*** open the output file ***/

	outfile = fopen (fname, "w");

	if (outfile == NULL)
	{
	    fprintf (stderr, "Error in opening output file: %s\n",
		fname);
	    exit (-1);
	}
    }

    printf ("\nEnter start time: \n\n");
    JDSTART = getdate ();
    JDSTART += gethms ();
    JD = JDSTART;
    update (stdout);

    /* printf ("\n Julian day %.7f\n\n", JD); */

    printf ("\nEnter end time: \n\n");
    JDSTOP = getdate ();
    JDSTOP += gethms ();

    getdouble ("\nTime increment: (minutes) ", &delt);

    /* read the element file */

    while (rdelement () == 0)
    {
	/***** INPUT CHECK FOR PERIOD VS EPHEMERIS SELECTED *****/
	/***** PERIOD GE 225 MINUTES  IS DEEP SPACE *****/

	a1 = pow (pcnsts.xke / element.xno, mcnsts.tothrd);
	temp = pcnsts.ck2 * 1.5 *
	    (cos (element.xincl) * cos (element.xincl) * 3. - 1.) /
	    pow (1. - element.eo * element.eo, 1.5);

	del1 = temp / (a1 * a1);
	ao = a1 * (1. - del1 * (mcnsts.tothrd * .5 + del1 *
		(del1 * 134. / 81. + 1.)));
	delo = temp / (ao * ao);
	xnodp = element.xno / (delo + 1.);

	if (mcnsts.twopi / xnodp / pcnsts.xmnpda >= .15625)
	{
	    iept = 3;
	}
	else
	{
	    iept = 2;
	}

	iflag = 1;

	/***** do the ephemeris *****/

        JDTIME = JDSTART;

	while (JDTIME <= JDSTOP)
	{
	    /* update the time */

	    JD = JDTIME;

	    do_orbit (iflag, iept);

            satreduce (&oalt, &oaz, &ora, &odec);

	    if (oalt > 0.)
	    {
	        /* find the rate at which ra and dec are changing */

	        JD = JDTIME + delt / pcnsts.xmnpda;
    
	        do_orbit (iflag, iept);

	        satreduce (&nalt, &naz, &nra, &ndec);

	        JD = JDTIME;

	        update (outfile);

	        x = mcnsts.ra2de / delt;

	        N = nra - ora;

	        if (N > mcnsts.pi)
	        {
		    N -= mcnsts.twopi;
	        }
	        else if ( N < -mcnsts.pi)
	        {
		    N += mcnsts.twopi;
	        }
    
	        N = x * N;
	        D = x * (ndec - odec);

	        fprintf (outfile, "\n");
	        jtocal (outfile, UT);
	        fprintf (outfile, "\t%s Position: \n", element.name);
	        fprintf (outfile, 
		    "\t\tAltitude %.3f deg Azimuth %.3f deg\n", oalt, oaz);
	        fprintf (outfile, "\t\tR.A.");
	        hms (outfile, ora);
	        fprintf (outfile, " Dec.");
	        dms (outfile, odec);
	        fprintf (outfile, "\n");
                fprintf (outfile, 
	            "\t\tdRA/dt %.2f deg/min, dDec/dt %.2f deg/min\n", N, D );
                fprintf (outfile, "\n");
	    }
        
	    JDTIME += delt / pcnsts.xmnpda;
        }

    }

    if (strlen (fname))
    {
	/*** close the output file ***/

	fclose (outfile);
    }

    /*** close the element file ***/

    fclose (elefile);

    exit (0);
}
