/************************************************/
/* ovenus.c					*/
/*						*/
/* Orbital elements and perturbations for the	*/
/* planet Venus using formulas given by Meeus	*/
/************************************************/

/***** description
 *
 *	$Id: ovenus.c,v 1.3 1993/04/21 21:41:40 craig Exp $
 *
 */

/***** modification history
 *
 *	$Log: ovenus.c,v $
 * Revision 1.3  1993/04/21  21:41:40  craig
 * Changed the path of the satellite.h include.
 * Changed ecnsts to pcnsts.
 *
 * Revision 1.2  1993/04/21  15:31:17  craig
 * First working version.  Ran through indent and converted to ansi.
 * Added hooks for working with the satellite programs.
 *
 *
 */

/***** include files *****/

#include <math.h>
#include "aaproto.h"
#include "satellite.h"

/***** global variables *****/

extern struct MCONSTANTS mcnsts;
extern struct PCONSTANTS pcnsts;

/* from oearth.c */

extern double M;
extern double T;

/* from manoms.c */

extern double M2;
extern double M5;

/* from ojupiter.c */

extern double f;

/********************/
/* ovenus	    */
/*		    */
/* Orbital elements */
/********************/

int    ovenus (struct orbit * e, double J)
{
    double p;

    e->epoch = J;
    manoms (J);
    e->M = M2;
    e->a = 0.7233316;
    e->ecc = (0.000000091 * T - 0.00004774) * T + 0.00682069;

    e->equinox = pcnsts.J2000;
    e->i = ((1.8e-8 * T - 3.250e-5) * T - 0.0007913) * T + 3.395459;
    f = ((-7.94e-7 * T - 0.00114464) * T + 0.2892764) * T + 54.602827;
    e->w = mod360 (f);
    f = ((7.69e-7 * T - 0.00014010) * T - 0.2776656) * T + 76.957740;
    e->W = mod360 (f);
    f = e->M + e->w + e->W;
    e->L = mod360 (f);

    /* The following perturbation is applied before solving Kepler's
       equation: */

    f = (237.24 + 150.27 * T) * mcnsts.de2ra;
    p = 0.00077 * sin (f);
    e->L += p;
    e->M += p;

    return (0);
}

/********************************************************/
/* cvenus						*/
/*							*/
/* Perturbations added after solving Kepler's equation	*/
/********************************************************/

int    cvenus (struct orbit * e)
{
    double p;

    /* perturbation in longitude */

    f = (2.0 * M - 2.0 * M2 - 148.225) * mcnsts.de2ra;
    p = 0.00313 * cos (f);
    f = (3.0 * M - 3.0 * M2 + 2.565) * mcnsts.de2ra;
    p += 0.00198 * cos (f);
    f = (M - M2 - 119.107) * mcnsts.de2ra;
    p += 0.00136 * cos (f);
    f = (3.0 * M - 2.0 * M2 - 135.912) * mcnsts.de2ra;
    p += 0.00096 * cos (f);
    f = (M5 - M2 - 208.087) * mcnsts.de2ra;
    p += 0.00082 * cos (f);
    e->L += p * mcnsts.de2ra;

    /* perturbation in radius vector */

    f = (2.0 * M - 2.0 * M2 - 58.208) * mcnsts.de2ra;
    p = 0.000022501 * cos (f);
    f = (3.0 * M - 3.0 * M2 + 92.577) * mcnsts.de2ra;
    p += 0.000019045 * cos (f);
    f = (M5 - M2 - 118.090) * mcnsts.de2ra;
    p += 0.000006887 * cos (f);
    f = (M - M2 - 29.110) * mcnsts.de2ra;
    p += 0.000005172 * cos (f);
    f = (5.0 * M - 4 * M2 - 104.208) * mcnsts.de2ra;
    p += 0.000003620 * cos (f);
    f = (4.0 * M - 4.0 * M2 + 63.513) * mcnsts.de2ra;
    p += 0.000003283 * cos (f);
    f = (2.0 * M5 - 2.0 * M2 - 55.167) * mcnsts.de2ra;
    p += 0.000003074 * cos (f);
    e->r += p;
    return (0);
}
