/*************************************************/
/* omercury.c					 */
/*						 */
/* Orbital elements and perturbations for the    */
/* planet Mercury using formulas given by Meeus. */
/*************************************************/

/***** description
 *
 *	$Id: omercury.c,v 1.3 1993/04/21 21:32:57 craig Exp $
 *
 */

/***** modification history
 *
 *	$Log: omercury.c,v $
 * Revision 1.3  1993/04/21  21:32:57  craig
 * Changed the path of the satellite.h include.
 * Changed ecnsts to pcnsts.
 *
 * Revision 1.2  1993/04/21  15:26:27  craig
 * First working version.  Ran through indent and converted to ansi.
 * Added hooks for working with the satellite programs.
 *
 *
 */

/***** include files *****/

#include <math.h>
#include "aaproto.h"
#include "satellite.h"

/***** global variables *****/

extern struct PCONSTANTS pcnsts;
extern struct MCONSTANTS mcnsts;

/* from oearth.c */

extern double T;

/* from ojupiter.c */

extern double f;

/* from manoms.c */

extern double M1;
extern double M2;
extern double M5;

/******************************************/
/* omercury				  */
/*					  */
/* Calculate orbital elements for Mercury */
/******************************************/

int    omercury (struct orbit * e, double J)
{

    /* Orbital elements referred to equinox of date: */

    e->epoch = J;

    /* calculate all the mean anomalies */

    manoms (J);
    e->M = M1;

    /* semimajor axis */

    e->a = 0.3870986;

    /* eccentricity */

    e->ecc = (-0.000000030 * T + 0.00002046) * T + 0.20561421;

    e->equinox = pcnsts.J2000;

    /* inclination */

    e->i = ((-3.5e-8 * T + 6.9e-7) * T - 0.0059556) * T + 7.010678;

    /* argument of the perihelion */

    f = ((4.3e-8 * T + 7.445e-5) * T + 0.2842765) * T + 28.839814;
    e->w = mod360 (f);

    /* longitude of the ascending node */

    f = ((-6.8e-8 * T - 8.844e-5) * T - 0.1254715) * T + 48.456876;
    e->W = mod360 (f);

    /* mean longitude */

    f = e->M + e->w + e->W;
    e->L = mod360 (f);

    return (0);
}

/********************************************************/
/* cmercury						*/
/*							*/
/* corrections due to perturbations			*/
/* These are added in after solving Kepler's equation.	*/
/********************************************************/

int    cmercury (struct orbit * e)
{
    double p;

    /* Mercury's perturbations in longitude: */

    f = (5.0 * M2 - 2.0 * M1 + 12.220) * mcnsts.de2ra;
    p = 0.00204 * cos (f);
    f = (2.0 * M2 - M1 - 160.692) * mcnsts.de2ra;
    p += 0.00103 * cos (f);
    f = (2.0 * M5 - M1 - 37.003) * mcnsts.de2ra;
    p += 0.00091 * cos (f);
    f = (5.0 * M2 - 3 * M1 + 10.137) * mcnsts.de2ra;
    p += 0.00078 * cos (f);
    e->L += p * mcnsts.de2ra;

    /* Mercury's perturbations in radius vector */

    f = (2.0 * M5 - M1 + 53.013) * mcnsts.de2ra;
    p = 0.000007525 * cos (f);
    f = (5.0 * M2 - 3.0 * M1 - 259.918) * mcnsts.de2ra;
    p += 0.000006802 * cos (f);
    f = (2.0 * M2 - 2.0 * M1 - 71.188) * mcnsts.de2ra;
    p += 0.000005457 * cos (f);
    f = (5.0 * M2 - M1 - 77.75) * mcnsts.de2ra;
    p += 0.000003569 * cos (f);
    e->r += p;

    return (0);
}
