/************************************************/
/* omars.c					*/
/*						*/
/* Orbital elements and perturbations for the	*/
/* planet Mars using formulas given by Meeus	*/
/************************************************/

/***** description
 *
 *	$Id: omars.c,v 1.3 1993/04/21 21:31:14 craig Exp $
 *
 */

/***** modification history
 *
 *	$Log: omars.c,v $
 * Revision 1.3  1993/04/21  21:31:14  craig
 * Changed the path of the satellite.h include.
 * Changed ecnsts to pcnsts.
 *
 * Revision 1.2  1993/04/21  15:25:18  craig
 * First working version.  Ran through indent and converted to ansi.
 * Added hooks for working with the satellite programs.
 *
 *
 */

/***** include files *****/

#include <math.h>
#include "aaproto.h"
#include "satellite.h"

/***** global variables *****/

extern struct PCONSTANTS pcnsts;
extern struct MCONSTANTS mcnsts;

/* from ojupiter.c */

extern double f;

/* from manoms.c */

extern double M2;
extern double M4;
extern double M5;

/* from oearth.c */

extern double M;
extern double T;


/*********/
/* omars */
/*********/

int    omars (struct orbit *e, double J)
{
    double p;

    e->epoch = J;
    manoms (J);

    e->M = M4;
    e->a = 1.5236883;
    e->ecc = (-0.000000077 * T + 0.000092064) * T + 0.09331290;

    e->equinox = pcnsts.J2000;
    e->i = ((-4.4e-8 * T - 0.00002304) * T - 0.0081565) * T + 1.857866;
    f = ((6.939e-6 * T + 0.00046556) * T + 0.7387251) * T + 285.762379;
    e->w = mod360 (f);
    f = ((-8.159e-6 * T - 0.00064344) * T - 0.2941821) * T + 49.852347;
    e->W = mod360 (f);
    f = e->M + e->w + e->W;
    e->L = mod360 (f);

 /* long period perturbation */

    f = (3.0 * M5 - 8.0 * M4 + 4.0 * M) * mcnsts.de2ra;
    p = -0.01133 * sin (f)
	- 0.00933 * cos (f);
    e->L += p;
    e->M += p;

    return (0);
}

/*********/
/* cmars */
/*********/

int    cmars (struct orbit *e)
{
    double f, p;

    f = (M5 - M4 - 48.958) * mcnsts.de2ra;
    p = 0.00705 * cos (f);
    f = (2.0 * M5 - M4 - 188.350) * mcnsts.de2ra;
    p += 0.00607 * cos (f);
    f = (2.0 * M5 - 2.0 * M4 - 191.897) * mcnsts.de2ra;
    p += 0.00445 * cos (f);
    f = (M - 2.0 * M4 + 20.495) * mcnsts.de2ra;
    p += 0.00388 * cos (f);
    f = (M - M4 + 35.097) * mcnsts.de2ra;
    p += 0.00238 * cos (f);
    f = (2.0 * M - 3.0 * M4 + 158.638) * mcnsts.de2ra;
    p += 0.00204 * cos (f);
    f = (3.0 * M4 - M2 - 57.602) * mcnsts.de2ra;
    p += 0.00177 * cos (f);
    f = (2.0 * M - 4.0 * M4 + 154.093) * mcnsts.de2ra;
    p += 0.00136 * cos (f);
    f = (M5 + 17.618) * mcnsts.de2ra;
    p += 0.00104 * cos (f);
    e->L += p * mcnsts.de2ra;

    f = (M5 - M4 + 41.1306) * mcnsts.de2ra;
    p = 0.000053227 * cos (f);
    f = (2.0 * M5 - 2.0 * M4 - 101.9847) * mcnsts.de2ra;
    p += 0.000050989 * cos (f);
    f = (2.0 * M5 - M4 - 98.3292) * mcnsts.de2ra;
    p += 0.000038278 * cos (f);
    f = (M - M4 - 55.555) * mcnsts.de2ra;
    p += 0.000015996 * cos (f);
    f = (2.0 * M - 3.0 * M4 + 68.622) * mcnsts.de2ra;
    p += 0.000014764 * cos (f);
    f = (M5 - 2.0 * M4 + 43.615) * mcnsts.de2ra;
    p += 0.000008966 * cos (f);
    f = (3.0 * M5 - 2.0 * M4 - 139.737) * mcnsts.de2ra;
    p += 0.000007914 * cos (f);
    f = (2.0 * M5 - 3.0 * M4 - 102.888) * mcnsts.de2ra;
    p += 0.000007004 * cos (f);
    f = (M - 2.0 * M4 + 113.202) * mcnsts.de2ra;
    p += 0.000006620 * cos (f);
    f = (3.0 * M5 - 3.0 * M4 - 76.243) * mcnsts.de2ra;
    p += 0.000004930 * cos (f);
    f = (3.0 * M - 5.0 * M4 + 190.603) * mcnsts.de2ra;
    p += 0.000004693 * cos (f);
    f = (2.0 * M - 4.0 * M4 + 244.702) * mcnsts.de2ra;
    p += 0.000004571 * cos (f);
    f = (3.0 * M5 - M4 - 115.828) * mcnsts.de2ra;
    p += 0.000004409 * cos (f);
    e->r += p;

    return (0);
}
