/********************************************************/
/* manoms.c						*/
/*							*/
/* Calculates mean anomalies of the planets.		*/
/*							*/
/* The mean anomalies of earth, uranus and neptune 	*/
/* are in oearth.c, ouranus.c, and oneptune.c.		*/
/********************************************************/

/***** description
 *
 *	$Id: manoms.c,v 1.3 1993/04/21 21:24:05 craig Exp $
 *
 */

/***** modification history
 *
 *	$Log: manoms.c,v $
 * Revision 1.3  1993/04/21  21:24:05  craig
 * Changed the path of the satellite.h include.
 * Changed ecnsts to pcnsts.
 *
 * Revision 1.2  1993/04/21  15:20:16  craig
 * First working version.  Ran through indent and converted to ansi.
 * Added hooks for working with the satellite programs.
 *
 *
 */

/***** include files *****/

#include "aaproto.h"
#include "satellite.h"

/***** global variables *****/

extern struct PCONSTANTS pcnsts;

/* from oearth.c */

extern double T;			/* centuries since 1900.0 */

double M1;				/* mean anomaly of mercury */
double M2;				/* mean anomaly of venus */
double M4;				/* mean anomaly of mars */
double M5;				/* mean anomaly of jupiter */
double M6;				/* mean anomaly of saturn */

/**********/
/* manoms */
/**********/

int    manoms (double J)
{

    T = (J - pcnsts.J1900) / pcnsts.dapcen;

    /* mean anomaly of Mercury */

    M1 = (0.000007 * T + 149472.51529) * T + 102.27938;
    M1 = mod360 (M1);

    /* Venus */

    M2 = (0.001286 * T + 58517.80387) * T + 212.60322;
    M2 = mod360 (M2);

    /* Mars */

    M4 = (0.000181 * T + 19139.85475) * T + 319.51913;
    M4 = mod360 (M4);

    /* Jupiter */

    M5 = (-0.000722 * T + 3034.69202) * T + 225.32833;
    M5 = mod360 (M5);

    /* Saturn */

    M6 = (-0.000502 * T + 1221.55147) * T + 175.46622;
    M6 = mod360 (M6);
    return (0);
}
