/********************************************************/
/* lonlat.c						*/
/*							*/
/* Display ecliptic longitude and latitude for		*/
/* equinox of date.  Input is equatorial rectangular	*/
/* coordinates for equinox J2000.			*/
/********************************************************/

/***** description
 *
 *	$Id: lonlat.c,v 1.4 1993/04/30 18:16:50 craig Exp $
 *
 */

/***** modification history
 *
 *	$Log: lonlat.c,v $
 * Revision 1.4  1993/04/30  18:16:50  craig
 * Changed the output calls from sending the output to stdout to
 * sending the output to the file outfile (which can be stdout).
 *
 * Revision 1.3  1993/04/22  19:47:32  craig
 * minor changes.
 *
 * Revision 1.2  1993/04/21  15:19:24  craig
 * First working version.  Ran through indent and converted to ansi.
 * Added hooks for working with the satellite programs.
 *
 *
 */

/***** include files *****/

#include <math.h>
#include "aaproto.h"

/***** global variables *****/

/* from cnstinit.c */

extern int prtflg;

extern FILE *outfile;

/* from epsiln.c */

extern double coseps;
extern double sineps;

/**********/
/* lonlat */
/**********/

int    lonlat (double *pp, double J, double *polar)
{
    int    i;
    double s[3], x, y, z, yy, zz, r;

    /* Make local copy of position vector and calculate radius. */

    r = 0.0;

    for (i = 0; i < 3; i++)
    {
	x = pp[i];
	s[i] = x;
	r += x * x;
    }

    r = sqrt (r);

    /* Precess to equinox of date J */

    precess (s, J, -1);

    /* Convert from equatorial to ecliptic coordinates */

    epsiln (J);
    yy = s[1];
    zz = s[2];
    x = s[0];
    y = coseps * yy + sineps * zz;
    z = -sineps * yy + coseps * zz;

    yy = matan2 (y, x);
    zz = asin (z / r);

    polar[0] = yy;
    polar[1] = zz;
    polar[2] = r;

    if (prtflg == 0)
    {
	return (0);
    }

    fprintf (outfile, "ecliptic long");
    dms (outfile, yy);
    fprintf (outfile, " lat");
    dms (outfile, zz);
    fprintf (outfile, " rad %.6E\n", r);

    return (0);
}
