/********************************/
/* diurpx.c			*/
/*				*/
/* Diurnal parallax, AA page D3	*/
/********************************/

/***** description
 *
 *	$Id: diurpx.c,v 1.3 1993/04/21 21:10:38 craig Exp $
 *
 */

/***** modification history
 *
 *	$Log: diurpx.c,v $
 * Revision 1.3  1993/04/21  21:10:38  craig
 * Changed the path for the satellite.h include file.
 * Changed ecnsts to pcnsts.
 *
 * Revision 1.2  1993/04/21  15:12:30  craig
 * First working version.  Ran through indent and converted to ansi.
 * Added hooks to work with the satellite programs.
 *
 *
 */

/***** include files *****/

#include <math.h>
#include "aaproto.h"
#include "satellite.h"

/***** global variables *****/

extern struct MCONSTANTS mcnsts;
extern struct PCONSTANTS pcnsts;

/* from kfiles.c */

extern double trho;			/* distance to center of Earth, in
					   Earth radii */
extern double tlat;			/* observer's geocentric latitude,
					   degrees */

/**********/
/* diurpx */
/**********/

/* last = local apparent sidereal time, radians */
/* ra = right ascension, radians		*/
/* dec = declination, radians			*/
/* dist	= Earth - object distance, au		*/

int    diurpx (double last, double *ra, double *dec, double dist)
{
    double cosdec, sindec, coslat, sinlat;
    double p[3], dp[3], x, y, z, D;

    /* Don't bother with this unless the equatorial horizontal parallax is
       at least 0.005" */

    if (dist > 1758.8)
    {
	return (-1);
    }

    cosdec = cos (*dec);
    sindec = sin (*dec);

    /* Observer's astronomical latitude */

    x = tlat * mcnsts.de2ra;
    coslat = cos (x);
    sinlat = sin (x);

    /* Convert to equatorial rectangular coordinates unit distance = earth
       radius */

    D = dist * pcnsts.rapau;
    p[0] = D * cosdec * cos (*ra);
    p[1] = D * cosdec * sin (*ra);
    p[2] = D * sindec;

    dp[0] = -trho * coslat * cos (last);
    dp[1] = -trho * coslat * sin (last);
    dp[2] = -trho * sinlat;

    x = p[0] + dp[0];
    y = p[1] + dp[1];
    z = p[2] + dp[2];
    D = x * x + y * y + z * z;
    D = sqrt (D);			/* topocentric distance */

    /* recompute ra and dec */

    *ra = matan2 (y, x);
    *dec = asin (z / D);

    showcor ("diurnal parallax", p, dp);

    return (0);
}
