/**********************************************************/
/* durab.c						  */
/*							  */
/* Diurnal aberration					  */
/*							  */
/* This formula is less rigorous than the method used for */
/* annual aberration.  However, the correction is small.  */
/**********************************************************/

/***** description
 *
 *	$Id: diurab.c,v 1.5 1993/04/30 18:23:04 craig Exp $
 *
 */

/***** modification history
 *
 *	$Log: diurab.c,v $
 * Revision 1.5  1993/04/30  18:23:04  craig
 * Changed the output call from sending the output to stdout to
 * sending the output to the file outfile (which can be stdout).
 *
 * Revision 1.4  1993/04/22  19:41:41  craig
 * minor changes.
 *
 * Revision 1.3  1993/04/21  21:08:55  craig
 * Changed path for the satellite.h include file.
 *
 * Revision 1.2  1993/04/21  15:11:51  craig
 * First working version.  Ran through indent and converted to ansi.
 * Added hooks to work with the satellite programs.
 *
 *
 */

/***** include files *****/

#include <math.h>
#include "aaproto.h"
#include "satellite.h"

/***** global variables *****/

/* from cnstinit.c */

extern int prtflg;

extern FILE *outfile;

extern struct MCONSTANTS mcnsts;

/* from kfiles.c */

extern double trho;			/* distance from observer to
					   center of Earth, in Earth
					   radii: */
extern double tlat;			/* geocentric latitude of
					   observer, degrees: */

/**********/
/* diurab */
/**********/

/* last =  local apparent sidereal time, radians */
/* ra =  right ascension, radians */
/* dec =  declination, radians */

int    diurab (double last, double *ra, double *dec)
{
    double lha, coslha, sinlha, cosdec, sindec;
    double coslat, N, D;

    lha = last - *ra;
    coslha = cos (lha);
    sinlha = sin (lha);
    cosdec = cos (*dec);
    sindec = sin (*dec);
    coslat = cos (mcnsts.de2ra * tlat);

    if (cosdec != 0.0)
    {
	N = 1.5472e-6 * trho * coslat * coslha / cosdec;
    }
    else
    {
	N = 0.0;
    }

    *ra += N;

    D = 1.5472e-6 * trho * coslat * sinlha * sindec;
    *dec += D;

    if (prtflg)
    {
	fprintf (outfile, "diurnal aberration dRA %.3fs dDec %.2f\"\n",
	    mcnsts.ra2sec * N / 15.0, mcnsts.ra2sec * D);
    }

    return (0);
}
