/***********************************************************/
/* deflec.c						   */
/*							   */
/* Correct for light deflection due to solar gravitation.  */
/* AA page B37						   */
/*							   */
/* SE, pq, etc. were computed earlier by angles.c.	   */
/***********************************************************/

/***** description
 *
 *	$Id: deflec.c,v 1.5 1993/04/30 18:23:54 craig Exp $
 *
 */

/***** modification history
 *
 *	$Log: deflec.c,v $
 * Revision 1.5  1993/04/30  18:23:54  craig
 * Changed the output call from sending the output to stdout to
 * sending the output to the file outfile (which can be stdout).
 *
 * Revision 1.4  1993/04/22  19:38:51  craig
 * minor changes.
 *
 * Revision 1.3  1993/04/21  21:04:59  craig
 * Changed the path of the satellite.h include.
 *
 * Revision 1.2  1993/04/21  15:10:12  craig
 * First working version. Ran through indent and converted to ansi.
 * Added hooks to work with the satellite programs.
 *
 *
 */

/***** include files *****/

#include <math.h>
#include "aaproto.h"
#include "satellite.h"

/***** global variables *****/

/* from cnstinit.c */

extern int prtflg;		/* display enable flag */

extern FILE *outfile;		/* the output file */

extern double dp[3];		/* correction vector, saved for display */

extern struct MCONSTANTS mcnsts;

/* from angles.c */

extern double SE;		/* earth-sun distance */
extern double SO;		/* object-sun distance */
extern double pq;		/* cos of sun-object-earth angle */
extern double ep;		/* -cos of sun-earth-object angle */
extern double qe;		/* cos of earth-sun-object angle */


/**************/
/* relativity */
/**************/

/* p = unit vector from earth to object */
/* q = heliocentric ecliptic retangular coordinates of earth */
/* e = heliocentric ecliptic retangular coordinates of object */

int    relativity (double *p, double *q, double *e)
{
    double C;
    int    i;

    C = 1.974e-8 / (SE * (1.0 + qe));

    for (i = 0; i < 3; i++)
    {
	dp[i] = C * (pq * e[i] / SE - ep * q[i] / SO);
	p[i] += dp[i];
    }

    if (prtflg)
    {
	fprintf (outfile, "elongation from sun %.2f degrees, ", 
	    acos (-ep) / mcnsts.de2ra);
    }

    showcor ("light defl.", p, dp);

    return (0);
}
