/*******************************************/
/* constel.c				   */
/*					   */
/* Expand constellation name abbreviations */
/*******************************************/

/***** description
 *
 *	$Id: constel.c,v 1.3 1993/04/30 18:25:03 craig Exp $
 *
 */

/***** modification history
 *
 *	$Log: constel.c,v $
 * Revision 1.3  1993/04/30  18:25:03  craig
 * Changed the output call from sending the output to stdout to
 * sending the output to the file outfile (which can be stdout).
 *
 * Revision 1.2  1993/04/21  15:03:04  craig
 * First working version.  Ran through indent and converted to ansi.
 * Added hooks to work with the satellite programs.
 *
 *
 */

#define NCON 89
#define NGREEK 24

/***** include files *****/

#include "aaproto.h"

/***** global variables *****/

/* from cnstinit.c */

extern FILE *outfile;

/***** local global variables *****/

static char  *constel[NCON] = {
    "And Andromedae",
    "Ant Antliae",
    "Aps Apodis",
    "Aql Aquilae",
    "Aqr Aquarii",
    "Ari Arietis",
    "Ara Arae",
    "Aur Aurigae",
    "Boo Bootis",
    "Cae Caeli",
    "Cam Camelopardalis",
    "Can Cancri",			/* also abbreviated Cnc */
    "Cap Capricorni",
    "Car Carinae",
    "Cas Cassiopeiae",
    "Cen Centauri",
    "Cep Cephei",
    "Cet Ceti",
    "Cha Chamaeleontis",
    "Cir Circini",
    "CMa Canis Majoris",
    "CMi Canis Minoris",
    "Cnc Cancri",
    "Col Columbae",
    "Com Comae Berenices",
    "CrA Coronae Austrinae",
    "CrB Coronae Borealis",
    "Crt Crateris",
    "Cru Crucis",
    "Crv Corvi",
    "CVn Canum Venaticorum",
    "Cyg Cygni",
    "Del Delphini",
    "Dor Doradus",
    "Dra Draconis",
    "Equ Equulei",
    "Eri Eridani",
    "For Fornacis",
    "Gem Geminorum",
    "Gru Gruis",
    "Her Herculis",
    "Hor Horologii",
    "Hya Hydrae",
    "Hyi Hydri",
    "Ind Indi",
    "Lac Lacertae",
    "Leo Leonis",
    "Lep Leporis",
    "Lib Librae",
    "LMi Leonis Minoris",
    "Lup Lupi",
    "Lyn Lyncis",
    "Lyr Lyrae",
    "Men Mensae",
    "Mic Microscopii",
    "Mon Monocerotis",
    "Mus Muscae",
    "Nor Normae",
    "Oct Octantis",
    "Oph Ophiuchi",
    "Ori Orionis",
    "Pav Pavonis",
    "Peg Pegasi",
    "Per Persei",
    "Phe Phoenicis",
    "Pic Pictoris",
    "PsA Piscis Austrini",
    "Psc Piscium",
    "Pup Puppis",
    "Pyx Pyxidis",
    "Ret Reticuli",
    "Scl Sculptoris",
    "Sco Scorpii",
    "Sct Scuti",
    "Ser Serpentis",
    "Sex Sextantis",
    "Sge Sagittae",
    "Sgr Sagittarii",
    "Tau Tauri",
    "Tel Telescopii",
    "TrA Trianguli Australis",
    "Tri Trianguli",
    "Tuc Tucanae",
    "UMa Ursae Majoris",
    "UMi Ursae Minoris",
    "Vel Velorum",
    "Vir Virginis",
    "Vol Volantis",
    "Vul Vulpeculae",
};

/* Greek letters */

static char  *greek[NGREEK] = {
    "alpha",
    "beta",
    "gamma",
    "delta",
    "epsilon",
    "zeta",
    "eta",
    "theta",
    "iota",
    "kappa",
    "lambda",
    "mu",
    "nu",
    "xi",
    "omicron",
    "pi",
    "rho",
    "sigma",
    "tau",
    "upsilon",
    "phi",
    "chi",
    "psi",
    "omega",
};

/***** local function prototypes *****/

static int isup (char *p);
static int islow (char *p);
static int skipwh (char *p);
static int isnumber (char *p);

/*************/
/* showcname */
/*************/

int    showcname (char *in)
{
    int    i;
    char  *g, *p, *q;
    char   ans[80];


    p = in;
    q = ans;


    skipwh (p);

    if (isnumber (p))
    {
	while (isnumber (p))
	{
	    *q++ = *p++;
	}
    }

    skipwh (p);
    *q++ = ' ';

    if (islow (p))
    {
	for (i = 0; i < NGREEK; i++)
	{
	    g = greek[i];

	    if ((*p == *g) && (*(p + 1) == *(g + 1)))
	    {
		break;
	    }
	}

	if (i < NGREEK)
	{
	    while (*g != '\0')
	    {
		*q++ = *g++;
	    }
	}

	while (islow (p))
	{
	    ++p;
	}
    }

    skipwh (p);

    /* copy things like "-a" until uppercase letter found */

    while ((*p != '\0') && !isup (p))
    {
	*q++ = *p++;
    }

    *q++ = ' ';

    if (isup (p))
    {
        /* Check the list of constellation names */

	for (i = 0; i < NCON; i++)
	{
	    g = constel[i];
	    if ((*p == *g) && (*(p + 1) == *(g + 1))
		&& (*(p + 2) == *(g + 2)))
	    {
		break;
	    }
	}

        /* Get the name found */

	if (i < NCON)
	{
	    g += 4;

	    while (*g != '\0')
	    {
		*q++ = *g++;
	    }

	    p += 3;
	}
    }

    skipwh (p);
    *q++ = ' ';

    while (*p)
    {
	*q++ = *p++;
    }

    *q++ = '\0';

    /* convert all '_' characters to spaces */

    q = ans;

    while (*q != '\0')
    {
	if (*q == '_')
	{
	    *q = ' ';
	}

	++q;
    }

    fprintf (outfile, "\n              %s\n", ans);

    return (0);
}

/*********/
/* islow */
/*********/

static int islow (char *p)
{
    if ((*p >= 'a') && (*p <= 'z'))
    {
	return (1);
    }
    else
    {
	return (0);
    }
}

/********/
/* isup */
/********/

static int isup (char *p)
{
    if ((*p >= 'A') && (*p <= 'Z'))
    {
	return (1);
    }
    else
    {
	return (0);
    }
}

/************/
/* isnumber */
/************/

static int isnumber (char *p)
{
    if ((*p >= '0') && (*p <= '9'))
    {
	return (1);
    }
    else
    {
	return (0);
    }
}

/**********/
/* skipwh */
/**********/

static int skipwh (char *p)
{
    while (((*p == ' ') || (*p == '\t') || (*p == '_'))
	&& (*p != '\0') && (*p != '\n') && (*p != '\r'))
    {
	++p;
    }

    return (0);
}
