/************************************************/
/* annuab.c					*/
/*						*/
/* Annual aberration - AA pages B17, B37, C24	*/
/************************************************/

/***** description
 *
 *	$Id: annuab.c,v 1.4 1993/04/23 18:58:29 craig Exp $
 *
 */

/***** modification history
 *
 *	$Log: annuab.c,v $
 * Revision 1.4  1993/04/23  18:58:29  craig
 * Changed assignment of C to new pcnsts.caupda value.
 *
 * Revision 1.3  1993/04/22  19:36:02  craig
 * minor changes.
 *
 * Revision 1.2  1993/04/21  15:00:38  craig
 * First working version.  Ran through indent and converted to ansi.  Added
 * hooks for working with the satellite programs.
 *
 *
 */

/***** include files *****/

#include <math.h>
#include "aaproto.h"
#include "satellite.h"

/***** global variables *****/

/* from cnstinit.c */

extern double TDT;
extern double dp[3];

extern struct PCONSTANTS pcnsts;

/* from vearth.c */

extern double vearth[3];

/**********/
/* annuab */
/**********/

int    annuab (double *p)	/* p is a unit vector 
				   pointing from earth to object */
{
    double A, B, C;
    double betai, pV;
    double x[3], V[3];
    int    i;

    /* Calculate the velocity of the earth (see vearth.c). */

    velearth (TDT);

    /* speed of light in au/day */

    C = pcnsts.caupda;

    betai = 0.0;
    pV = 0.0;

    for (i = 0; i < 3; i++)
    {
	A = vearth[i] / C;
	V[i] = A;
	betai += A * A;
	pV += p[i] * A;
    }

    /* Make the adjustment for aberration. */

    betai = sqrt (1.0 - betai);
    C = 1.0 + pV;
    A = betai / C;
    B = (1.0 + pV / (1.0 + betai)) / C;

    for (i = 0; i < 3; i++)
    {
	C = A * p[i] + B * V[i];
	x[i] = C;
	dp[i] = C - p[i];
    }

    showcor ("annual aberration", p, dp);

    for (i = 0; i < 3; i++)
    {
	p[i] = x[i];
    }

    return (0);
}
