;Written by J. D. McDonald
;This file is public domain.

  LARGE equ 1

ifdef SMALL
  NEARDATA equ 1
  NEARCODE equ 1
endif

ifdef COMPACT
   FARDATA equ 1
  NEARCODE equ 1
endif

ifdef MEDIUM
  NEARDATA equ 1
   FARCODE equ 1
endif

ifdef LARGE
   FARDATA equ 1
   FARCODE equ 1
endif


ifdef NEARCODE
  argbase equ 0
endif

ifdef FARCODE
  argbase equ 2
endif

cseg	macro moduleName
	ifdef FARCODE
	  moduleName&_TEXT segment byte public 'CODE'
	  assume cs: moduleName&_TEXT
	else
	  _TEXT segment byte public 'CODE'
	  assume cs: _TEXT
	endif
	endm

endcs	macro moduleName
	ifdef FARCODE
	  moduleName&_TEXT ends
	else
	  _TEXT ends
	endif
	endm

pBegin	macro pName
	ifdef FARCODE
	  pName proc far
	else
	  pName proc near
	endif
        public pName
	endm

pEnd	macro pName
	pName endp
	endm



_DATA   segment  word public 'DATA'
first8  dw       0
first14 dw       0
drawseg dw      0A000h
maxseg  dw      28000
maxline dw      350
xwidth  dw      80
maxscreen dw    640
mmaxscreen  dw  639
xwidthm dw      79
_DATA   ends
CONST   segment  word public 'CONST'
ate     dw       8
fourt   dw       14
eighty  dw       80
btab    db       80h,40h,20h,10h,8h,4h,2h,1h
left    db       255,127,63,31,15,7,3,1
right   db       128,192,224,240,248,252,254,255
CONST   ends
_BSS    segment  word public 'BSS'
es8       dw        ?
bp8       dw        ?
es14      dw        ?
bp14      dw        ?
leftbit   db        ?
rightbit  db        ?
lefttop   dw        ?
leftbot   dw        ?
righttop  dw        ?
rightbot  dw        ?
ysave     dw        ?
leftx     dw        ?
rightx    dw        ?
xx0       dw        ?
yy0       dw        ?
xx1       dw        ?
yy1       dw        ?
xc10      dw        ?
xc20      dw        ?
xc11      dw        ?
xc21      dw        ?
lowyb     dw        ?
del_y     dw        ?
del_x     dw        ?
_BSS      ends
DGROUP  GROUP    CONST, _BSS, _DATA
         assume   ds: DGROUP, ss: DGROUP, es:  DGROUP
cseg    _egagraf

pBegin  _symbol
;  symbol(ix,iy,height,icol,&isym) plots a single 8xheight character
;  matrix pointed to by isym at ix, iy in color icol.
;  ix, iy and icol are integers
        push    bp
        mov     bp,sp
        push    di
        push    si
ifdef NEARDATA
        mov     si, word ptr [bp+argbase+12]   ;pick up address of table
        mov     bx,ds                          ;containing symbol to plot
        mov     es,bx
endif
ifdef FARDATA
        les     si,[bp+argbase+12]
endif
        mov     bx,word ptr [bp+argbase+8]      ;height
        mov     ax,word ptr [bp+argbase+4]      ;this is x
        mov     dx,ax                ;break x into byte # and bit in byte
        and     dx,7
        mov     cl,3
        sar     ax,cl
        mov     [bp+argbase+8],ax    ;byte #
        mov     [bp+argbase+4],dx    ;leftmost bit used
        mov     dx,drawseg       ; segment of display buffer
        mov     cx,xwidth
        push    ds
        mov     ax,es
        mov     es,dx
        mov     ds,ax
        jmp     commonl

pEnd _symbol


pBegin _slettr
;  slettr(ix,iy,ichr,icol) plots a single 8-high IBM character ichr at x,y in
;  color icol.   all are integers
        push    bp
        mov     bp,sp
        push    di
        push    si
        cmp     first8,0        ;get address of bios table of characters
        jne     sec8
        inc     first8
        mov     ah, 011h
        mov     al, 030h
        mov     bh, 03
        push    bp
        int     010h
        mov     ax,es
        mov     es8,ax
        mov     bp8,bp
        pop     bp
sec8:
        xor     ax,ax
        mov     al,byte ptr [bp+argbase+8]   ;this is the character
        mov     cl,3
        shl     ax,cl
        add     ax,bp8
        mov     si,ax
        mov     ax,word ptr [bp+argbase+4]
        mov     dx,ax
        and     dx,7
        mov     cl,3
        sar     ax,cl
        mov     [bp+argbase+8],ax
        mov     [bp+argbase+4],dx
        mov     ax,drawseg
        mov     es,ax
        mov     cx,xwidth
        push    ds
        mov     ax,es8
        mov     ds,ax
        mov     bx,8
        jmp     commonl

pEnd _slettr


pBegin _llettr
; llettr(ix,iy,ichr,icol) plots a single IBM 14-high character ichr at x,y in
; color icol.   all are integers
        push    bp
        mov     bp,sp
        push    di
        push    si

        cmp     first14,0
        jne     sec14
        inc     first14
        mov     ah, 011h
        mov     al, 030h
        mov     bh, 02
        push    bp
        int     010h
        mov     ax,es
        mov     es14,ax
        mov     bp14,bp
        pop     bp
sec14:

        xor     ax,ax
        mov     al,byte ptr [bp+argbase+8]
        mul     fourt
        add     ax,bp14
        mov     si,ax
        mov     ax,word ptr [bp+argbase+4]
        mov     dx,ax
        and     dx,7
        mov     cl,3
        sar     ax,cl
        mov     [bp+argbase+8],ax
        mov     [bp+argbase+4],dx
        mov     cx,xwidth
        mov     ax,drawseg
        mov     es,ax
        push    ds
        mov     ax,es14
        mov     ds,ax
        mov     bx,14


commonl:

                              ; symbol, slettr, and llettr the same after this
                              ; compute location of byte to change
        mov     ax,word ptr [bp+argbase+6]         ;this is y
        mov     [bp+argbase+6],cx
        mul     word ptr [bp+argbase+6]
        add     ax,[bp+argbase+8]
        mov     di,ax

        mov     dx,3ceh         ; change SET/RESET register
        mov     al,00h          ; to contain the color to write.
        out     dx,al
        mov     dx,3cfh
        mov     ax,word ptr [bp+argbase+10]
        out     dx,al

        mov     dx,3ceh
        mov     al,08h
        out     dx,al
        mov     dx,3cfh
        cmp     word ptr [bp+argbase+8],0ffffh  ;special case:partially off
                                                ;left edge of screen
        je      loop2m1
        cmp     word ptr [bp+argbase+8],cx  ;totally off screen horizontally
        jae     commf
        dec     cx
        cmp     word ptr [bp+argbase+8],cx      ;Partially off right edge
        je      loop2p1
loop2:

        xor     ax,ax
        mov     ah,ds:[si+0]            ;get pattern of current row
        mov     cx,[bp+argbase+4]
        shr     ax,cl
        out     dx,al
        inc     byte ptr es:[di+1]
        mov     al,ah
        out     dx,al
        inc     byte ptr es:[di]
        add     di,[bp+argbase+6]
        inc     si
        dec     bx
        jg      loop2
        jmp     commf
loop2m1:

        xor     ax,ax
        mov     ah,ds:[si+0]
        mov     cx,[bp+argbase+4]
        shr     ax,cl
        out     dx,al
        inc     byte ptr es:[di+1]
        add     di,[bp+argbase+6]
        inc     si
        dec     bx
        jg      loop2m1
        jmp     commf
loop2p1:

        xor     ax,ax
        mov     ah,ds:[si+0]
        mov     cx,[bp+argbase+4]
        shr     ax,cl
        mov     al,ah
        out     dx,al
        inc     byte ptr es:[di]
        add     di,[bp+argbase+6]
        inc     si
        dec     bx
        jg      loop2p1

commf:
        pop     ds
        pop     si
        pop     di
        pop     bp
        ret

pEnd _llettr





pBegin _max_lin
        mov     ax,maxline
        ret
pEnd   _max_lin

; setmod.asm routine to be called from c to set mode n using
; call setmod(n) : n=3 set to cursor mode, n=16 set to color graphics mode
; 18 for VGA 480x640 color mode
; any number > 61 for 600x800 mode
; this version does not actually call the bios setmode routine -
; you have to do that
pBegin _setmod

        push    bp
        mov     bp,sp

        mov     ax, word ptr [bp+argbase+4]
        mov     bx,ax
        and     bx, 127
        cmp     bx, 60
        jl      setq7
        mov     xwidth,100
        mov     xwidthm,99
        mov     maxseg,60000
        mov     maxline,600
        mov     maxscreen,800
        mov     mmaxscreen,799
        jmp     setm1

setq7:
        mov     xwidth,80
        mov     xwidthm,79
        mov     maxseg,28000
        mov     maxline,350
        mov     maxscreen,640
        mov     mmaxscreen,639
        cmp     bx,18
        jz      qq44
        cmp     bx,17
        jnz     setm1
qq44:
        mov     maxseg,38400
        mov     maxline,480
setm1:
        pop     bp
        ret


pEnd _setmod

pBegin _zsetup
        push    dx
        push    ax

        mov     dx,3c4h
        mov     al,02h
        out     dx,al
        mov     dx,3c5h
        mov     al,0fh
        out     dx,al

        mov     dx,3ceh
        mov     al,01h
        out     dx,al
        mov     dx,3cfh
        mov     al,0fh
        out     dx,al
        pop     ax
        pop     dx
        ret
pEnd _zsetup

; ZLINE  :  SUBROUTINE TO DRAW LINE ON EGA BOARD
;this version has microsoft c calling convention
;      zline(ix0,iy0,ix1,iy1,icolor)
pBegin _zline
        push    bp
        mov     bp,sp
        mov     cx,word ptr [bp+argbase+6]
        cmp     cx,word ptr [bp+argbase+10]
        jne     nhoriz
        jmp     far ptr __horiz_
nhoriz:
        sub     sp,6
        push    di
        push    si
        mov     dx,3ceh
        mov     al,00h
        out     dx,al
        mov     dx,3cfh
        mov     ax,word ptr [bp+argbase+12]
        out     dx,al

        mov     dx,word ptr [bp+argbase+10]
        mov     ax,word ptr [bp+argbase+8]
        mov     di,ax
        mov     bx,word ptr [bp+argbase+4]
        mov     ax,di
        sub     ax,bx
        jge     store_x
        mov     bx,di
        mov     di,dx
        mov     dx,cx
        mov     cx,di
        neg     ax
store_x:
        mov     word ptr[bp+argbase+6],ax
        mov     word ptr[bp+argbase+4],bx
        mov     word ptr[bp+argbase+8],cx
        sub     dx,cx
        push    xwidth
        pop     word ptr [bp-2]
        jge     store_y
        neg     word ptr [bp-2]
        neg     dx
store_y:
        mov     word ptr[bp+argbase+10],dx
;initialize values
        mov     dx,3ceh
        mov     al,08h
        out     dx,al
        mov     ax,drawseg
        mov     es,ax
;calculate address in screen buffer of first point
        mov     ax,word ptr[bp+argbase+4]
        mov     dx,ax
        and     dx,7
        mov     cl,3
        sar     ax,cl
        mov     si,ax
        lea     bx,btab
        add     bx,dx
        mov     ax,word ptr[bp+argbase+8]
        mul     xwidth
        mov     dx,ax
        mov     al,[bx]
        mov     bx,dx
        mov     cx,0
;figure out if slope is greater or less than 1
        mov     dx,word ptr[bp+argbase+6]
        cmp     dx,word ptr[bp+argbase+10]
        jl      csteep
        call    slant
        jmp     finish
csteep:
        call    steep
finish:
        pop     si
        pop     di
        mov     sp,bp
        pop     bp
        ret

pEnd _zline
slant    proc    near
          ;slope<1
        cmp     si,xwidth      ;test for line off screen to right
        jge     quit1
        mov     di,word ptr[bp+argbase+10]
        mov     dx,word ptr[bp+argbase+6]
        mov     word ptr [bp-4],dx
        shr     dx,1
        mov     word ptr [bp-6],dx
        mov     dx,3cfh
newdot:
        cmp     si,0       ;test for line off screen to left
        jl      q1
        out     dx,al                   ;output bit in byte to mask register
        inc     byte ptr es:[bx][si]    ;insert byte in buffer ... note that
                        ;the inc instruction doesn't actually do the
                        ;work -- it;s done by the EGA's wierd hardware
q1:     ror     al,1
        jnc     nc1
        inc     si
        cmp     si,xwidth
        je      quit1
nc1:    add     cx,di
        cmp     cx,word ptr [bp-6]
        jle     dcount
        sub     cx,word ptr[bp+argbase+6]
        add     bx,word ptr [bp-2]
dcount: dec     word ptr [bp-4]
        jge     newdot
quit1:  ret


slant    endp
steep   proc    near
        ;slope>1     see comments in "slant"
        cmp     si,xwidth
        jge     quit2
        mov     di,word ptr[bp+argbase+6]
        or      di,di
        je      vertical
        mov     dx,word ptr[bp+argbase+10]
        mov     word ptr[bp-4],dx
        shr     dx,1
        mov     word ptr[bp-6],dx
        mov     dx,3cfh
        out     dx,al
newdot2:
        cmp     si,0
        jl      c3
        inc     byte ptr es:[bx][si]
c3:     add     bx,word ptr [bp-2]
        add     cx,di
        cmp     cx,word ptr[bp-6]
        jle     dcount2
        sub     cx,word ptr[bp+argbase+10]
        ror     al,1
        out     dx,al
        jnc     dcount2
        inc     si
        cmp     si,xwidth
        je      quit2
dcount2:
        dec     word ptr[bp-4]
        jge     newdot2
quit2:  ret
vertical:
        add     bx,si
        cmp     si,0               ;special case for vertical lines
        jl      quit2              ;which doesn't need fancy algorithm
        mov     cx,word ptr[bp+argbase+10]
        mov     dx,3cfh
        out     dx,al
loopy2:
        inc     byte ptr es:[bx]
c3v:
        add     bx,word ptr [bp-2]
        dec     cx
        jge     loopy2
        ret


steep   endp



;this routine resets the system to use ordinary bios or dos screen writes
;it has no parameters and may be called from any language
pBegin _curmod
        push    dx
        push    ax

        mov     dx,3ceh
        mov     al,01h
        out     dx,al
        mov     dx,3cfh
        mov     al,00h
        out     dx,al
        mov     dx,3ceh
        mov     al,08h
        out     dx,al
        mov     dx,3cfh
        mov     al,0ffh
        out     dx,al


        pop     ax
        pop     dx
        ret
pEnd _curmod

;         zpoint.asm plot point at xt,yt in color zpcol
pBegin _zpoint
        push    bp
        mov     bp,sp

        mov     dx,3ceh
        mov     al,00h
        out     dx,al
        mov     dx,3cfh
        mov     al,byte ptr [bp+argbase+8]
        out     dx,al
        mov     ax,drawseg
        mov     es,ax
        mov     cx,word ptr [bp+argbase+4]
        mov     bx,cx
        and     bx,7
        sar     cx,1
        sar     cx,1
        sar     cx,1
        or      cx,cx
        jl      ptquit
        cmp     cx,xwidthm
        jg      ptquit

        mov     dx,3ceh
        mov     al,08h
        out     dx,al
        mov     dx,3cfh
        mov     al,byte ptr btab[bx]
        out     dx,al

        mov     bx,cx
        mov     ax,word ptr [bp+argbase+6]
        mul     xwidth
        add     bx,ax
        inc     byte ptr es:[bx]

ptquit: pop     bp
        ret	

pEnd _zpoint



;_e_start start up ellipse plotter
; e_start(xleft,xright,y,color)
pBegin _e_start
        push    bp
        mov     bp,sp

        mov     dx,3ceh
        mov     al,00h
        out     dx,al
        mov     dx,3cfh
        mov     al,byte ptr [bp+argbase+10]
        out     dx,al
        mov     ax,drawseg
        mov     es,ax

        mov     cx,word ptr [bp+argbase+4]
        mov     bx,cx
        and     bx,7
        sar     cx,1
        sar     cx,1
        sar     cx,1
        mov     dx,3ceh
        mov     al,08h
        out     dx,al
        mov     dx,3cfh
        mov     al,byte ptr btab[bx]
        mov     leftbit,al

        out     dx,al

        mov     ax,word PTR [bp+argbase+8]
        mul     xwidth
        mov     bx,ax
        mov     ysave,bx
        mov     leftx,cx
        add     bx,cx
        mov     leftbot,bx
        mov     lefttop,bx
        cmp     cx,xwidth
        jae     s1
        inc     byte ptr es:[bx]

s1:     mov     cx,word ptr [bp+argbase+6]
        mov     bx,cx
        and     bx,7
        sar     cx,1
        sar     cx,1
        sar     cx,1

        mov     dx,3cfh
        mov     al,byte ptr btab[bx]
        mov     rightbit,al
        out     dx,al
        mov     bx,ysave
        mov     rightx,cx
        add     bx,cx
        mov     rightbot,bx
        mov     righttop,bx
        cmp     cx,xwidth
        jae     s2
        inc     byte ptr es:[bx]

s2:     pop     bp
        ret	

pEnd _e_start


pBegin _e_xd
        mov     ax,drawseg
        mov     es,ax
        rol     rightbit,1
        mov     al,rightbit
        jae     l1
        dec     rightx
        dec     rightbot
        dec     righttop
l1:     mov     dx,3cfh
        out     dx,al
        mov     bx,xwidth
        cmp     rightx,bx
        jae     s3
        mov     bx,righttop
        inc     byte ptr es:[bx]
        mov     bx,rightbot
        inc     byte ptr es:[bx]

s3:
        ror     leftbit,1
        mov     al,leftbit
        jae     l2
        inc     leftx
        inc     lefttop
        inc     leftbot
l2:     out     dx,al
        mov     bx,xwidth
        cmp     leftx,bx
        jae     s4
        mov     bx,lefttop
        inc     byte ptr es:[bx]
        mov     bx,leftbot
        inc     byte ptr es:[bx]
s4:     ret
pEnd _e_xd

pBegin _e_xdyu
        mov     ax,drawseg
        mov     es,ax
        rol     rightbit,1
        mov     al,rightbit
        jae     l3
        dec     rightx
        dec     rightbot
        dec     righttop
l3:     mov     dx,3cfh
        out     dx,al
        mov     cx,xwidth
        add     righttop,cx
        sub     rightbot,cx
        cmp     rightx,cx
        jae     s5
        mov     bx,righttop
        inc     byte ptr es:[bx]
        mov     bx,rightbot
        inc     byte ptr es:[bx]

s5:
        ror     leftbit,1
        mov     al,leftbit
        jae     l4
        inc     leftx
        inc     lefttop
        inc     leftbot
l4:     out     dx,al
        add     lefttop,cx
        sub     leftbot,cx
        cmp     leftx,cx
        jae     s6
        mov     bx,lefttop
        inc     byte ptr es:[bx]
        mov     bx,leftbot
        inc     byte ptr es:[bx]


s6:     ret
pEnd _e_xdyu

pBegin _e_yu
        mov     ax,drawseg
        mov     es,ax
        mov     al,leftbit
        mov     dx,3cfh
        out     dx,al
        mov     cx,xwidth
        add     lefttop,cx
        sub     leftbot,cx
        cmp     leftx,cx
        jae     s7
        mov     bx,lefttop
        inc     byte ptr es:[bx]
        mov     bx,leftbot
        inc     byte ptr es:[bx]
s7:     mov     al,rightbit
        out     dx,al
        add     righttop,cx
        sub     rightbot,cx
        cmp     rightx,cx
        jae     s8
        mov     bx,righttop
        inc     byte ptr es:[bx]
        mov     bx,rightbot
        inc     byte ptr es:[bx]

s8:     ret
pEnd _e_yu

pBegin _rectfill
;  rectfill(ix0,iy0,ix1,iy1,icol) plots a rectangle in
; color icol.   all are integers
        push    bp
        mov     bp,sp
        mov     bx,word PTR [bp+argbase+10]
        cmp     bx,word ptr [bp+argbase+6]
        jne     notflat
        jmp     far ptr __horiz_
notflat:
        push    di
        push    si
        nop

        mov     dx,3ceh
        mov     al,00h
        out     dx,al
        mov     dx,3cfh
        mov     al,byte ptr [bp+argbase+12]
        out     dx,al
        mov     cx,word PTR [bp+argbase+4]
        mov     dx,word PTR [bp+argbase+6]
        mov     ax,word PTR [bp+argbase+8]

        cmp     ax,cx
        jge     test2
        mov     si,ax
        mov     ax,cx
        mov     cx,si
test2:  or      ax,ax
        jge     test3
        jmp     rfinish
test3:  cmp     cx,maxscreen
        jl      test4
        jmp     rfinish
test4:  cmp     cx,0
        jge     test5
        sub     cx,cx
test5:  cmp     ax,maxscreen
        jl      test6
        mov     ax,mmaxscreen
test6:
        cmp     bx,dx
        jge     test7
        mov     si,bx
        mov     bx,dx
        mov     dx,si
test7:  or      bx,bx
        jge     test8
        jmp     rfinish
test8:  cmp     dx,maxline
        jl      test9
        jmp     rfinish
test9:  cmp     dx,0
        jge     testa
        sub     dx,dx
testa:  cmp     bx,maxline
        jl      testb
        mov     bx,maxline
        dec     bx
testb:

        mov     xx0,cx
        mov     yy0,dx
        mov     xx1,ax
        mov     yy1,bx

        mov     ax,cx
        mov     dx,ax
        and     dx,7
        mov     cl,3
        sar     ax,cl
        mov     xc10,ax
        mov     xc20,dx
        mov     di,ax
        mov     ax,xx1
        mov     dx,ax
        and     dx,7
        mov     cl,3
        sar     ax,cl
        mov     xc11,ax
        mov     xc21,dx
        sub     ax,di
        mov     del_x,ax
        mov     ax,drawseg
        mov     es,ax
        mov     dx,3ceh
        mov     al,08h
        out     dx,al

        mov     ax,yy0
        mul     xwidth
        add     ax,xc10
        mov     lowyb,ax

        mov     ax,yy1
        sub     ax,yy0
        inc     ax
        mov     del_y,ax
        mov     bx,xc20
        mov     dl,left[bx]
        or      del_x,0
        jnz     leftcol
        mov     bx,xc21
        and     dl,right[bx]
leftcol:
        mov     al,dl
        mov     dx,3cfh
        out     dx,al
        mov     bx,lowyb
        mov     cx,del_y
        mov     ax,xwidth
loopd:  inc     byte ptr es:[bx]
        add     bx,ax
        loop    loopd
        cmp     del_x,1
        jl      rfinish
        jz      lastcol
        mov     al,255
        out     dx,al
        mov     bx,del_y
        mov     ax,lowyb
        inc     ax
        mov     si,del_x
        dec     si
loope:  mov     cx,si
        mov     di,ax
        rep     stosb
        add     ax,xwidth
        dec     bx
        jnz     loope

lastcol:
        mov     bx,xc21
        mov     al,right[bx]
        out     dx,al
        mov     bx,lowyb
        add     bx,del_x
        mov     cx,del_y
        mov     ax,xwidth
loopf:  inc     byte ptr es:[bx]
        add     bx,ax
        loop    loopf

rfinish:
        pop     si
        pop     di
        pop     bp
        ret


pEnd _rectfill

pBegin __horiz_             ;stripped down version of rectfill
        push    di
        push    si

        mov     dx,word PTR [bp+argbase+6]
        cmp     dx,maxline
        jae     rfinish
        mov     dx,3ceh
        mov     al,00h
        out     dx,al
        mov     dx,3cfh
        mov     al,byte ptr [bp+argbase+12]
        out     dx,al
        mov     cx,word PTR [bp+argbase+4]
        mov     bx,word PTR [bp+argbase+8]

        cmp     bx,cx
        jge     test2h
        mov     si,bx
        mov     bx,cx
        mov     cx,si
test2h: or      bx,bx
        jge     test3h
        jmp     hfinish
test3h: cmp     cx,maxscreen
        jl      test4h
        jmp     hfinish
test4h: cmp     cx,0
        jge     test5h
        sub     cx,cx
test5h: cmp     bx,maxscreen
        jl      test6h
        mov     bx,mmaxscreen
test6h:

        xor     dx,dx
        mov     ax,cx
        div     ate
        mov     xc10,ax
        mov     xc20,dx
        mov     cx,ax
        xor     dx,dx
        mov     ax,bx
        div     ate
        mov     xc11,ax
        mov     xc21,dx
        sub     ax,cx
        mov     cx,ax
        mov     ax,drawseg
        mov     es,ax
        mov     dx,3ceh
        mov     al,08h
        out     dx,al

        mov     ax,word ptr [bp+argbase+6]
        mov     dx,ax
        mul     xwidth
        add     ax,xc10
        mov     di,ax

        mov     bx,xc20
        mov     al,left[bx]
        or      cx,cx
        jnz     leftcoh
        mov     bx,xc21
        and     al,right[bx]
leftcoh:
        mov     dx,3cfh
        out     dx,al
        inc     byte ptr es:[di]
        inc     di
        cmp     cx,1
        jl      hfinish
        jz      lastcoh
        mov     al,255
        out     dx,al
        dec     cx
        rep     stosb

lastcoh:
        mov     bx,xc21
        mov     al,right[bx]
        out     dx,al
        inc     byte ptr es:[di]

hfinish:
        pop     si
        pop     di
        pop     bp
        ret

pEnd __horiz_

endcs _egagraf
      end



