int sw(argc,argv,let,val)
int argc;
char *argv[];
char *let;
long int *val;
{
/*
	this subroutine parses switches on the command line.
	switches are of the form -<letter><value>.  If one is
	found, a pointer to the letter is returned in let 
	and a pointer to the value in val as a long integer. 


	parameters argc and argv are passed in from the main
	calling program.
	Note that if argc = 1 then only the command is left and
	the line is empty.
	if a switch is decoded, the value of the function is 1
	otherwise it is zero.
	
	a number following the letter is decoded as
	a decimal value unless it has a leading x in which case
	it is decoded as hexadecimal.

	This software was developed with US Government support
	and it may not be sold, restricted or licensed.  You 
	may duplicate this program provided that this notice
	remains in all of the copies, and you may give it to
	others provided they understand and agree to this
	condition.

	For questions or additional information, contact:

	Judah Levine
	Time and Frequency Division
	NIST/847
	325 Broadway
	Boulder, Colorado 80303
	(303) 492 7785
	jlevine@time_a.timefreq.bldrdoc.gov
*/
	long int atol();
	int sscanf();
/*
	either nothing is left or what is left is not
	a switch
*/
	if( (argc == 1)  ||  (*argv[1] != '-') )
	  {
	  *let='\0';
	  *val=0;
	  return(0);
	}
	*let= *++argv[1];   /*get the letter after the - character*/
	if( *++argv[1]  != 'x')   /*if next char is not x, decode number*/
	  *val=atol(argv[1]);
	else
	  {
	  argv[1]++;    /*skip over x and decode value in hex */
	  sscanf(argv[1]," %lx ",val);
	}
	return(1);
}
