/******************************************************************************/
/*                                                                            */
/*  Title       : fixchecksum.c                                               */
/*  Author      : Manfred Bester                                              */
/*  Date        : 07Feb93                                                     */
/*  Last change : 01Jan95                                                     */
/*                                                                            */
/*  Synopsis    : This program reads a file with Keplerian elements in the    */
/*                NORAD 2-line format and fixes the checksum for use with     */
/*                InstantTrack V1.0.                                          */
/*                                                                            */
/*  Input file  : tle.dat or sts-47.dat (for example)                         */
/*  Output file : tle.chk or sts-47.chk (for example)                         */
/*                                                                            */
/*                                                                            */
/*  Copyright (c) 1992-1995 Manfred Bester. All Rights Reserved.              */
/*                                                                            */
/*  Permission to use, copy, modify, and distribute this software and its     */
/*  documentation for educational, research and non-profit purposes, without  */
/*  fee, and without a written agreement is hereby granted, provided that the */
/*  above copyright notice and the following three paragraphs appear in all   */
/*  copies.                                                                   */
/*                                                                            */
/*  Permission to incorporate this software into commercial products may be   */
/*  obtained from the author, Dr. Manfred Bester, 1636 M. L. King Jr. Way,    */
/*  Berkeley, CA 94709, USA.                                                  */
/*                                                                            */
/*  IN NO EVENT SHALL THE AUTHOR BE LIABLE TO ANY PARTY FOR DIRECT, INDIRECT, */
/*  SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES ARISING OUT OF THE USE OF   */
/*  THIS SOFTWARE AND ITS DOCUMENTATION, EVEN IF THE AUTHOR HAS BEEN ADVISED  */
/*  OF THE POSSIBILITY OF SUCH DAMAGE.                                        */
/*                                                                            */
/*  THE AUTHOR SPECIFICALLY DISCLAIMS ANY WARRANTIES, INCLUDING, BUT NOT      */
/*  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A   */
/*  PARTICULAR PURPOSE. THE SOFTWARE PROVIDED HEREUNDER IS ON AN "AS IS"      */
/*  BASIS, AND THE AUTHOR HAS NO OBLIGATIONS TO PROVIDE MAINTENANCE, SUPPORT, */
/*  UPDATES, ENHANCEMENTS, OR MODIFICATIONS.                                  */
/*                                                                            */
/******************************************************************************/

#include <stdio.h>
#include <math.h>

#ifndef STDLIB
#include <stdlib.h>
#endif

#include "sattrack.h"

#ifdef HPTERM
#include "hpterm.h"
#else
#include "vt100.h"
#endif

extern void mGets();

int main()

{
    int  i, lineNum, lineNum1, lineNum2, nSat, checkValue, checkSum;

    char satName[100], line1[100], line2[100], data[100];
    char inputData[20], inputFile[100], outputFile[100], str[80], strng[10];
    char *strpHome, *getenv();

    FILE *InputFile, *OutputFile;

#ifdef HOMEDIR
    strpHome = getenv("HOME");
#else
    strpHome = SATDIR;
#endif

    sprintf(data,"%s/%s",strpHome,TLE);
    printf("\nenter TLE input data file (e.g. tlex, tles or sts-55): ");
    mGets(inputData);
    sprintf(inputFile,"%s/%s.dat",data,inputData);

    if ((InputFile = fopen(inputFile,"r")) == 0)
    {
        nl(); alarm(); reverseBlink();
        printf("%s not found\n",inputFile);
        normal(); nl();
        exit(-1);
    }

    sprintf(outputFile,"%s/%s.chk",data,inputData);

    if ((OutputFile = fopen(outputFile,"w")) == 0)
    {
        alarm(); nl(); reverseBlink();
        printf("can't write %s\n",outputFile);
        normal(); nl();
        exit(-1);
    }

    printf("\ncreating %s ....\n",outputFile);
    nSat = 0;

    while (fgets(satName,80,InputFile))
    {
        if (!strncmp(satName,TLEHEADER,10))
            fgets(satName,80,InputFile);

        fgets(line1,80,InputFile);
        fgets(line2,80,InputFile);

        sscanf(line1,"%1d",&lineNum1);
        sscanf(line2,"%1d",&lineNum2);

        if (lineNum1 != 1)
            printf("Line 1 not available for satellite %s",satName);

        if (lineNum2 != 2)
            printf("Line 2 not available for satellite %s",satName);

/******************************************************************************/
/*                                                                            */
/* calculate checksum                                                         */
/*                                                                            */
/******************************************************************************/

        fprintf(OutputFile,"%s",satName);

        if (lineNum1 == 1 && lineNum2 == 2)
        {
            for (lineNum = 1; lineNum <=2; lineNum++)
            {
                checkSum = 0;

                if (lineNum == 1)
                    sprintf(str,"%s",line1);
                if (lineNum == 2)
                    sprintf(str,"%s",line2);

                for (i = 0; i < 68; i++)
                {
                    strng[0]   = str[i];
                    strng[1]   = '\0';
                    checkValue = atoi(strng);

                    if (!strcmp(strng,"+"))
                        checkValue = 2;      /* assign check sum value to '+' */

                    if (!strcmp(strng,"-"))
                        checkValue = 1;      /* assign check sum value to '-' */

                    checkSum += checkValue;
                }

                str[68] = '\0';

                fprintf(OutputFile,"%s%d\n",str,checkSum%10);
            }

            nSat++;
        }
    }

    fclose(InputFile);
    fclose(OutputFile);
    printf("output file contains data for %d satellite",nSat);
    if (nSat > 1) printf("s");
    nl();
    nl();
}

/******************************************************************************/
/*                                                                            */
/* mGets: Manfred's version of fgets (wipes out newline character)            */
/*                                                                            */
/******************************************************************************/

void mGets(string)

char *string;

{
    int i;
    fgets(string,80,stdin);
    i = (int) strlen(string);

    if (i > 0)
        string[i-1] = '\0';
    else
        string[0]   = '\0';

    return;
}

/******************************************************************************/
/*                                                                            */
/* End of program fixchecksum.c                                               */
/*                                                                            */
/******************************************************************************/
