/*
 * SACDRT Version 3.1 SAC-Database-Reader for DeepSky Objects
 * Header TYPE_DATA.H is designed by Lars Hagen for the SACDRT.
 *                       modified by Sven van der Meer
 *
 *  Copyright (C) 1994 Lars Hagen & Sven van der Meer
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *  Problem or comments to hagenl@cs.tu-berlin.de
 *                                                                         
 */

struct type_name{
    char *short_type;
    char *long_type;
    int marked;
};
#ifndef LAYOUT
  struct type_name type_data[]={
    { "",     "",0                                     },
    { "ASTER", "Asterism",0                            },
    { "BRTNB", "Bright Nebula",0                       },
    { "CL+NB", "Cluster with Nebulosity",0             },
    { "G+C+N", "Cluster with Nebulosity in a Galaxy",0 },
    { "LMCCN", "Cluster with Nebulosity in the LMC",0  },
    { "SMCCN", "Cluster with Nebulosity in the SMC",0  },
    { "DRKNB", "Dark Nebula",0                         },
    { "GX+DN", "Diffuse Nebula in a Galaxy",0          },
    { "LMCDN", "Diffuse Nebula in the LMC",0           },
    { "SMCDN", "Diffuse Nebula in the SMC",0           },
    { "GALXY", "Galaxy",0                              },
    { "GALCL", "Galaxy cluster",0                      },
    { "GLOCL", "Globular Cluster",0                    },
    { "GX+GC", "Globular Cluster in a Galaxy",0        },
    { "LMCGC", "Globular Cluster in the LMC",0         },
    { "SMCGC", "Globular Cluster in the SMC",0         },
    { "NONEX", "Nonexistent in RNGC",0                 },
    { "OPNCL", "Open Cluster",0                        },
    { "LMCOC", "Open cluster in the LMC",0             },
    { "SMCOC", "Open cluster in the SMC",0             },
    { "PLNNB", "Planetary Nebula",0                    },
    { "QUASR", "Quasar",0                              },
    { "#STAR", "Stars",0                               },
    { "UVSOB", "Unverified Southern Object",0          },
    { "*",     "unknown type",0                        }
  };
  int max_type=(sizeof type_data/sizeof(struct type_name));
#else
  extern struct type_name type_data[];
  extern int max_type;
#endif
