/*
 * SACDRT Version 3.1 SAC-Database-Reader for DeepSky Objects
 * Header SACDRT.H is written by Lars Hagen for the SACDRT.
 *                    newwritten by Sven van der Meer
 *
 *  Copyright (C) 1994 Lars Hagen & Sven van der Meer
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *  Problems or comments to hagenl@cs.tu-berlin.de
 *
 */

#include <stdio.h>

extern int          input(int ,int);                /* input.c        */
extern void         pressed_key();
extern void         open_file();
extern void         sac_end();
extern void         initialize();

extern parse_name   (char *, char *);               /* p_name         */
extern parse_type   (char *);                       /* p_type         */
extern parse_con    (char *);                       /* p_con          */
extern parse_ra     (char *);                       /* p_cord.c       */
extern parse_dec    (char *);
extern parse_mag    (char *, int);
extern parse_size   (char *);
extern parse_brstr  (char *);
extern parse_nsts   (char *);
extern void is_empty(char *);
extern parse_descr  (char *);                       /* p_desc         */
extern parse_source (char *);                       /* p_source       */
extern parse_class  (char *);                       /* p_class        */
extern parse_notes  (char *);                       /* p_notes        */

extern void findinput(char *);                      /* find.c         */
extern find(char *);

extern void command_line(int argc, char *argv[]);   /* commandline.c  */
extern void usage();

extern void read_rc_file();                         /* initrc.c       */
extern int  write_rc_file();

extern void insert_marked(int);                     /* marked_objects */
extern void delete_one_marked(int);
extern void delete_all_marked();
extern void delete_core_list();
extern int  cs_do_search();
extern char *parse_core(char *,int);
extern void sort_marked();

extern int  handle_objects(int,int,int,char *);     /* handle_objects */

extern void do_printing();                          /* print.c        */
