/*
 * SACDRT Version 3.1 SAC-Database-Reader for DeepSky Objects
 * Module PRINT.C is written by Sven van der Meer for the SACDRT.
 *
 *  Copyright (C) 1994 Lars Hagen & Sven van der Meer
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *  Problems or comments to hagenl@cs.tu-berlin.de
 *
 */

#include <stdlib.h>
#include <string.h>
#include <time.h>
#include "sacdrt.h"
#include "database.h"
#include "layout.h"

void print_long(char *string1,int max_col);
void print_line(int i,char s);
void itoa(int,char []);
FILE *fp;


/*
 * void PRINT_PAGE(...)  this function will print the object givven from input
 *                       to a file (next version will spool to a printer, too)
 *
 */
void print_page(char *name, char *name_info, char *other, char *type, char *con,
                char *ra, char *dec, char *mag, char *u2000, char *tirion,
	        char *descr, char *size, char *clas, char *nsts, char *brstr, 
                char *notes, char *source, char *subr, int pof)
{
char *enviroment,tmp[20];
time_t date;

 switch (pof){
   case file_current:  if (config.output!=NULL)
                         fp=fopen(config.output,"a");
                       else if (config.rc_output!=NULL)
                         fp=fopen(config.rc_output,"a");
                       else if ((enviroment=getenv("SACDRT_OUTPUT"))!=NULL)
                         fp=fopen(enviroment,"a");
                       else
                         fp=fopen(SAC_DEFAULT_OUTPUT,"a");
                       if (!fp){
                         delete_all_marked();
                         delete_core_list();
                         sac_exit(5,"- please check the permissions of the directory");
                       }
                       break;
   case print_current: fp=fopen("SAC_PRINT","a");
                       break;
 }

 if (config.current_page==1){
   if (time(&date)==-1)
     sac_exit(6,"");
   strcpy(status.time,ctime(&date));
 }
 if ((config.current_line==1)&&(config.current_page>1))
   fprintf(fp,"\n");
 if (config.current_line==1){
   switch (pof){
     case print_current: fprintf(fp," (%.6s %.4s %.8s)  SACDRT V%s Output for Deep Sky-Objects  (Page: %i)\n",status.time+4,status.time+20,status.time+11,VERSION,config.current_page);
                         break;
     case file_current : fprintf(fp," (%.6s %.4s %.8s)  SACDRT V%s Output for Deep Sky-Objects\n",status.time+4,status.time+20,status.time+11,VERSION);
                         break;
   }
 }
 if ((config.current_line==1)&&!config.print_mode){
   fprintf(fp,"\n  NR   | Name             | CON | R.A.    | DEC     | Mag.     |\n");
   fprintf(fp,  "-------+------------------+-----+---------+---------+----------+----------------\n");
   fprintf(fp,  "       |                  |     |         |         |          |\n");
   config.current_line=4;
 }

 if(config.print_mode){ 
   fprintf(fp,"\n     %c",SAC_PR_VLEFT);print_line(70,SAC_PR_HLINE);fprintf(fp,"%c\n",SAC_PR_VRIGHT);
   fprintf(fp,"     %c     %s",SAC_PR_VLINE,name);

   if(*other != '\0'){
     fprintf(fp,"    (");
     fprintf(fp, other);
     fprintf(fp,")");
     print_line(59-(strlen(name)+strlen(other)),' ');
   }
   else{
     print_line(65-(strlen(name)),' ');
   }
   fprintf(fp,"%c\n",SAC_PR_VLINE);
   fprintf(fp,"     %c",SAC_PR_VLINE);print_line(70,SAC_PR_HLINE);
   fprintf(fp,"%c\n",SAC_PR_VRIGHT);

   fprintf(fp,"     %c  Info  :  ",SAC_PR_VLINE); print_long(name_info,10);

   fprintf(fp,"     %c  Type  :  %s",SAC_PR_VLINE,type);
   print_line(59-strlen(type),' ');fprintf(fp,"%c\n",SAC_PR_VLINE);

   fprintf(fp,"     %c  Const.:  %s",SAC_PR_VLINE,con);
   print_line(59-strlen(con),' ');fprintf(fp,"%c\n",SAC_PR_VLINE);

   fprintf(fp,"     %c",SAC_PR_VLINE);print_line(70,SAC_PR_HLINE);
   fprintf(fp,"%c\n",SAC_PR_VRIGHT);

   fprintf(fp,"     %c  R.A.  :  %s    DEC:  %s    Bright:  %s",SAC_PR_VLINE,ra,dec,mag);
   print_line(36-strlen(ra)-strlen(dec)-strlen(mag),' ');fprintf(fp,"%c\n",SAC_PR_VLINE);

   fprintf(fp,"     %c",SAC_PR_VLINE);print_line(70,SAC_PR_HLINE);
   fprintf(fp,"%c\n",SAC_PR_VRIGHT);

   if(config.base_version==v52){
     fprintf(fp,"     %c  Tirion:  %s",SAC_PR_VLINE,tirion);
     print_line(23-strlen(tirion),' ');
     fprintf(fp,"Bright.Star:  %s",brstr);
     print_line(22-strlen(brstr),' ');fprintf(fp,"%c\n",SAC_PR_VLINE);
  
     fprintf(fp,"     %c  U2000 :  %s",SAC_PR_VLINE,u2000);
     print_line(23-strlen(u2000),' ');
     fprintf(fp,"No. of Star:  %s",nsts);
     print_line(22-strlen(nsts),' ');fprintf(fp,"%c\n",SAC_PR_VLINE);

     fprintf(fp,"     %c  Size  :  %s",SAC_PR_VLINE,size);
     print_line(59-strlen(size),' ');fprintf(fp,"%c\n",SAC_PR_VLINE);

     fprintf(fp,"     %c  Source:  ",SAC_PR_VLINE); print_long(source,10);
   }
   else{
     fprintf(fp,"     %c  Tirion:  %s",SAC_PR_VLINE,tirion);
     print_line(23-strlen(tirion),' ');
     fprintf(fp,"Surf.Bright:  %s",subr);
     print_line(22-strlen(subr),' ');fprintf(fp,"%c\n",SAC_PR_VLINE);

     fprintf(fp,"     %c  U2000 :  %s",SAC_PR_VLINE,u2000);
     print_line(23-strlen(u2000),' ');
     fprintf(fp,"Bright.Star:  %s",brstr);
     print_line(22-strlen(brstr),' ');fprintf(fp,"%c\n",SAC_PR_VLINE);

     fprintf(fp,"     %c  Size  :  %s",SAC_PR_VLINE,size);
     print_line(23-strlen(size),' ');
     fprintf(fp,"No. of Star:  %s",nsts);
     print_line(22-strlen(nsts),' ');fprintf(fp,"%c\n",SAC_PR_VLINE);
   }

   fprintf(fp,"     %c",SAC_PR_VLINE);print_line(70,SAC_PR_HLINE);
   fprintf(fp,"%c\n",SAC_PR_VRIGHT);

   fprintf(fp,"     %c  Class :  ",SAC_PR_VLINE); print_long(clas,10);
   fprintf(fp,"     %c  Notes :  ",SAC_PR_VLINE); print_long(notes,10);
   fprintf(fp,"     %c  Descr.:  ",SAC_PR_VLINE); print_long(descr,10);

   fprintf(fp,"     %c",SAC_PR_VLEFT);print_line(70,SAC_PR_HLINE);fprintf(fp,"%c",SAC_PR_VRIGHT);

   config.current_line+=20;
   switch (pof){
     case print_current: if ((config.max_lines-config.current_line)<20){
                           fprintf(fp,"\f");
                           config.current_line=1;
                           config.current_page+=1;
                         }
                         else{
                           fprintf(fp,"\n\n");
                           config.current_line+=2;
                         }
                         break;
     case file_current:  fprintf(fp,"\n\n");
                         break;
   }
 }
 else{
   itoa(status.mark_current,tmp);
   print_line(5-strlen(tmp),' ');
   fprintf(fp,"%i. %c ",status.mark_current,SAC_PR_VLINE);

   if(status.next_core->mark_flag==use_name)
     strcpy(tmp,parse_core(status.next_core->sac_line,8));
   else
     strcpy(tmp,parse_core(status.next_core->sac_line,9));
   fprintf(fp,"%s",tmp);     print_line(16-strlen(tmp),' ');
   fprintf(fp," %c ",SAC_PR_VLINE);

   strcpy(tmp,parse_core(status.next_core->sac_line,3));
   fprintf(fp,"%s",tmp);      print_line(3-strlen(tmp),' '); 
   fprintf(fp," %c ",SAC_PR_VLINE);

   fprintf(fp,"%s",ra);       print_line(7-strlen(ra),' ');
   fprintf(fp," %c ",SAC_PR_VLINE);

   fprintf(fp,"%s",dec);      print_line(7-strlen(dec),' ');
   fprintf(fp," %c ",SAC_PR_VLINE);

   fprintf(fp,"%s",mag);      print_line(8-strlen(mag),' ');
   fprintf(fp," %c ",SAC_PR_VLINE);

   fprintf(fp,"\n");
   config.current_line++;
   if(pof==print_current){
     if(config.max_lines-1==config.current_line){
       fprintf(fp,"\f");
       config.current_line=1;
       config.current_page+=1;
     }
   }
 }

 fclose (fp);
return;
}



/*
 * PRINT_LONG(..)  similar to break_line() in layout.c
 *
 */
void print_long(char *string2,int max_col)
{
int i,c;

 for (i=1;i<max_col;i++){
   c=0;
   while (((c++<48)&&(*string2!='\0'))||((*string2!='\0')&&(*string2!=' ')&&(*string2!=',')))
     fprintf(fp,"%c",*string2++);
   switch(*string2){
     case ',' :
     case ' ' : fprintf(fp,"%c",*string2++);c++;
                while (c++<60)
                  fprintf(fp,"%c",' ');
                fprintf(fp,"%c",SAC_PR_VLINE);
                fprintf(fp,"%c",'\n');
                fprintf(fp,"     %c           ",SAC_PR_VLINE);
                break;
     case '\0': while (c++<60)
                  fprintf(fp,"%c",' ');
                fprintf(fp,"%c",SAC_PR_VLINE);
                fprintf(fp,"%c",'\n');
                i+=max_col;
                break;
   }
 }
return;
}



/*
 *  PRINT_LINE  the same as line(int) in layout.c 
 *
 */
void print_line(int lenght,char s)
{
int i;
  for (i=0;i<lenght;i++)
   fprintf(fp,"%c",s);
return;
}


/*
 *  void DO_PRINTING()  we still use 'system' to print, this will be done by
 *                      this function
 *
 */
void do_printing()
{
char *tmp_string=NULL;
 tmp_string=(char *)malloc(100);

#ifdef MSDOS
 strcpy(tmp_string,"copy ");
 strcat(tmp_string,"SAC_PRINT ");
 if(config.printer!=NULL)
   strcat(tmp_string,config.printer);
 else
   strcat(tmp_string,config.rc_printer);
#else
 if (config.ps_print){
   strcpy(tmp_string,"a2ps -p -nn -nh -ns ");
   strcat(tmp_string,"SAC_PRINT|");
   strcat(tmp_string,"lpr -P");
   if(config.printer!=NULL)
     strcat(tmp_string,config.printer);
   else
     strcat(tmp_string,config.rc_printer);
 }

 if (config.asc_print){
   strcpy(tmp_string,"lpr -P");
   if(config.printer!=NULL)
     strcat(tmp_string,config.printer);
   else
     strcat(tmp_string,config.rc_printer);
   strcat(tmp_string," ");
   strcat(tmp_string,"SAC_PRINT");
 }

 system(tmp_string);
#endif

 remove("SAC_PRINT");
 config.current_line=1;
 config.current_page=1;
 free(tmp_string);
return;
}



/*
 *
 * ITOA(...) K&R's integer to str function without reverse(...)
 *
 */
void itoa(int n, char s[])
{
int i, sign;

 if((sign=n)<0)
   n=-n;
 i=0;
 do{
   s[i++]=n%10+'0';
   }while((n/=10)>0);
 if(sign<0)
   s[i++]='-';
 s[i]='\0';
return;
}
