/*
 * SACDRT Version 3.1 SAC-Database-Reader for DeepSky Objects
 * Module P_TYPE.C is written by Lars Hagen for the SACDRT.
 *
 *  Copyright (C) 1994 Lars Hagen & Sven van der Meer
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *  Problems or comments to hagenl@cs.tu-berlin.de
 *                                                                   
 */

#include <string.h>
#include <stdlib.h>
#include <ctype.h>
#include "type_data.h"
#include "sacdrt.h"

int parse_type(char *string)
{
  static int i;
  i=0;

  if(isdigit(*string))
    {
      char *number;                                          /* create a (char *)       */
      number = (char *)malloc(10+sizeof(string));            /* mem for number          */
      strncpy(number,string,1);                              /* copy 1st to number      */
      sprintf(string,"%c %s", *number, type_data[0].long_type);   /* copy number & 1st of    */
      free(number);                                          /* structure to string     */
    }
  else
    {
      while(strcmp(string, type_data[i].short_type) != 0 &&       /* else compare string     */
	                    type_data[i].short_type != "*")       /* with short entries of   */
	i++;                                                 /* structure               */
      strcpy(string, type_data[i].long_type);                     /* copy the found          */
    }
  return 0;
}
