/*
 * SACDRT Version 3.1 SAC-Database-Reader for DeepSky Objects
 * Module P_SOURCE.C is written by Lars Hagen for the SACDRT.
 *
 *  Copyright (C) 1994 Lars Hagen & Sven van der Meer
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *  Problems or comments to hagenl@cs.tu-berlin.de
 *                                                                   
 */
 
#include <string.h>
#include <stdlib.h>
#include "source_data.h"
#include "sacdrt.h"

int parse_source(char *string)
{
  static char *helpstring;
  static char *oldstringbegin;
  static int i;
  i=0;
  oldstringbegin = string;
  helpstring = (char *)malloc(100+sizeof(string));
  helpstring[0]='\0';

  while(*string != '\0')
    {
      while(s_name[i].short_s_name != '*')
	{
	  if(*string == s_name[i].short_s_name)
	      strcat(helpstring,s_name[i].long_s_name);
	  i++;
	}
      string++;
      i=0;
    }

  string = oldstringbegin;
  strcpy(string,helpstring);
  if(*string == '\0')
    is_empty(string);
  free(helpstring);
  return 0;
}
