/*
 * SACDRT Version 3.1 SAC-Database-Reader for DeepSky Objects
 * Module P_NOTES.C is written by Lars Hagen for the SACDRT.
 *
 *  Copyright (C) 1994 Lars Hagen & Sven van der Meer
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *  Problems or comments to hagenl@cs.tu-berlin.de
 *                                                                   
 */

#include <string.h>
#include <ctype.h>
#include <stdlib.h>
#include "sacdrt.h"

static default_notes(char *s, char *helpstring, char *helpchar);
int compare_small(char *short_string, char *long_string, char *s, char *helpstring);

int parse_notes(char *s)
{
  static int PA_flag;
  char *helpstring; 
  char *helpchar;
  char *oldstringbegin;
 
  helpstring = (char *)malloc(200+sizeof(s));
  *helpstring = '\0';
  oldstringbegin = s;
  PA_flag = 0;
  
  while(*s != '\0')
    {
      helpchar = (char *)malloc(100+sizeof(s));
      *helpchar = *s;
      *++helpchar = '\0';
      helpchar--;
      
      switch(*s)
	{
	case ' ':  strcat(helpstring, " "); break;
	case '@':
	  if(*--s == ' ')
	    {
	      strcat(helpstring, " ");
	    }
	  s++;
	  strcat(helpstring, "is at"); break;
	case 'P':
	  s++;
	  if(*++s == 'w')
	    strcat(helpstring, "paired with");
	  else
	    {
	      if(*--s == 'A')
		{
		  s++;
		  strcat(helpstring, "position angel of elongation of ");
		  while((isdigit(*s) || *s == ' ' || *s == '.') && *s != '\0')
		    {
		      if(*s != ' ')
			default_notes(s, helpstring, helpchar);
		      else
			*helpchar = *s;
		      s++;
		    }
		  strcat(helpstring," degrees");
		  if(*s != '\0')
		    {
		      strcat(helpstring,",");
		    }
		  else
		    *--s = '\0';
		}
	      else 
		default_notes(--s, helpstring, helpchar);
	    }
	  break;

	case 'w':
	  if(*--s == ' ')
	    {
	      s++;
	      if(*++s == ' ')
		strcat(helpstring, "with ");
	      else
		default_notes(--s, helpstring, helpchar);
	    }
	  else
	    default_notes(++s, helpstring, helpchar);
	  break;

	case 'B':
	  if(*++s == ' ')
	    strcat(helpstring, "bright ");
	  else
	    default_notes(--s, helpstring, helpchar);
	  break;

	case 'F':
	  if(*++s == '*')
	    strcat(helpstring,"faint star");
	  else
	    s--;
	  break;
	  
	case '*':  strcat(helpstring,"star");
	           break;

	case 'v':
	  if(*++s == 'B')
	    strcat(helpstring, "very bright");
	  else
	    if(*s == 'F')
	      strcat(helpstring, "very faint");
	    else
	      if(*s == 'S')
		strcat(helpstring, "very small");
	      else
		if(*s == 'L')
		  strcat(helpstring, "very large");
		else
		  if(*s == ' ')
		    {
		      --s;
		      if(*--s == ',')
			{
			  strcat(helpstring, "very");
       			}
		      s++;
		    }
		  else
		    s--;
	  break;
	  
	case 'C':
	  if(*++s == 'l')
	    strcat(helpstring, "Cluster");
	  else
	    {
	      strcat(helpstring, helpchar);
	      s--;
	    }
	  break;
	  
	case 'c':
	  {
	    char *sec;
	    sec = s;
	    (int)s=compare_small("comps@", "complex is at", s, helpstring);
	    (int)s=compare_small("comp@", "complex is at", s, helpstring);
	    (int)s=compare_small("comps", "complex", s, helpstring);
	    (int)s=compare_small("comp", "complex", s, helpstring);
	    if(s == sec)
	      strcat(helpstring, "c");
	  }
	  break;

	default:
	  default_notes(s, helpstring, helpchar);
	    }
      s++;
      free(helpchar);
    }
  
  s = oldstringbegin;
  strcpy(s, helpstring);
  if (*s == '\0')
    is_empty(s);
  free(helpstring);
  return 0;
}

static int default_notes(char *s, char *helpstring, char *helpchar)
{
  *helpchar = *s;
  strcat(helpstring,helpchar);
  return 0;
}

int compare_small(char *short_string, char *long_string, char *s, char *helpstring)
{
  char *short_help;
  char *secure_help;
  char *secure_s;
  
  short_help = (char *)malloc(30+sizeof(short_help));
  secure_help = short_help;
  secure_s = s;
  
  while (*s != '\0' && *s != ' ' && *s != ',')
    {
      *short_help++ = *s;
      s++;
    }
  short_help = secure_help;
  s = secure_s;
  
  if(strcmp(short_help, short_string) == 0)
    {
      strcat(helpstring, long_string);
      (int) s = s + strlen(short_help)-1;
      return (int) s;
    }
  else
    {
      return (int)s;
    }
  free(short_help);
}
