/*
 * SACDRT Version 3.1 SAC-Database-Reader for DeepSky Objects
 * Module P_NAME.C is written by Lars Hagen for the SACDRT.
 *
 *  Copyright (C) 1994 Lars Hagen & Sven van der Meer
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *  Problems or comments to hagenl@cs.tu-berlin.de
 *                                                                   
 */

#include <string.h>
#include <stdlib.h>
#include <stdio.h>
#include <ctype.h>
#include "object_data.h"                             /* include structure  */


int parse_name(char *string1, char *string)   
{
  static char *helpstring;                           /* like the name      */
  static char *secure_helpstring, *secure_string;    
  static int i;
  i=0;

  helpstring = (char *) malloc(1000+sizeof(string)); /* mem for helpstring */
  secure_helpstring = helpstring;                    /* secure helpstring  */
  secure_string = string;                            /* secure string      */

  do
    {
      *helpstring++ = *string++;
    }
  while(*string != ' ' && *string != '\0' && !isdigit(*string));

  *helpstring = '\0';                                /* mark end             */
  helpstring = secure_helpstring;                    /* get old startpos     */
  string = secure_string;                            /* of these strings     */
  
  while(strcmp(helpstring,object_data[i].short_name) != 0 &&  /* compare helpstring */
	                  object_data[i].short_name  != "*")  /* with first short   */
    i++;                                               /* entries of the     */                                                                                                      /* structure          */
  
  strcpy(string1,object_data[i].long_name);      /* copy found long entry to string */

  free(helpstring);                       
  return 0;
}


