/*
 * SACDRT Version 3.1 SAC-Database-Reader for DeepSky Objects
 * Module P_DESCR.C is written by Lars Hagen for the SACDRT.
 *
 *  Copyright (C) 1994 Lars Hagen & Sven van der Meer
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *  Problems or comments to hagenl@cs.tu-berlin.de
 *                                                                   
 */

#include <string.h>
#include <stdlib.h>
#include <ctype.h>
#include "sacdrt.h"

#define   YES	       1
#define   NO 	       0
#define   NOT_SET      1
#define   KOMMA_SET    0

/* use this function later in this module */

void parse_descr_string(char *short_string, char *helpstring);
int  numbers(char *short_string, char *helpstring);
int  default_descr(char *s,char *oldhelpstringend,char *old_s,int oldhelpstringlenght, char *helpstring);
int  cat_2_helpstring(char *short_string, char *long_string, char *helpstring, char *s);

int komma           = NOT_SET;
int star_FLAG       = NO;
int elogated_FLAG   = NO;
int paired_FLAG     = NO;
int degree_FLAG     = NO;
int klammer_op_FLAG = NO;
int klammer_cl_FLAG = NO;
int EOS_FLAG        = NO;
int mag_FLAG        = NO;

int parse_descr(char *string)
{
  static int i;
  static char *helpstring;
  static char *short_string;
  static char *oldstringbegin;

  i = 0;
  star_FLAG      = NO;
  elogated_FLAG  = NO;
  oldstringbegin = string;
  
  short_string = (char *) malloc(100+sizeof(string));
  helpstring   = (char *) malloc(500+sizeof(string));
  *short_string = '\0';
  *helpstring   = '\0';
  
  while(*string != '\0')                                                /* cat the string to many shorter */
    {
      while(*string != ',' && *string != '\0' && *string != ' ' &&
	    *string != '(' && *string != ')')
	{
	  short_string[i] = *string++;
	  i++;
	}
      short_string[i] = '\0';                                            /* mark end                       */
      i = 0;
      
      if (*string == ',')                                                /* set FLAG's                     */
	komma = 1;           
      else                   
	komma = 0;
      if (*string == '(')
	klammer_op_FLAG = YES;
      if (*string == ')')
	klammer_cl_FLAG = YES;
      
      if (*string != '\0')
	string++;
      else
	EOS_FLAG = 1;
      
      parse_descr_string(short_string,helpstring);                        /* call parser for these shorter */
    }
  string = oldstringbegin;
  strcpy(string, helpstring);
    
  if (*string == '\0')
    is_empty(string);
  free(short_string);
  free(helpstring);
  return 0; 
}

void parse_descr_string(char *s, char *helpstring)
{
  static int getorginal;
  int oldhelpstringlenght;
  char *oldhelpstringend;
  char *old_s;  
  old_s = s;
  getorginal = 0;

  oldhelpstringlenght = strlen(helpstring);
  oldhelpstringend = helpstring + oldhelpstringlenght;
  
  if(elogated_FLAG == YES && (isdigit(*s)))
    {
      strcat(helpstring,"in position angel of ");
      (int)s = numbers(s, helpstring);
      s++;
      strcat(helpstring, " degrees");
      elogated_FLAG = NO;
      degree_FLAG = YES;
    }
  if(paired_FLAG == YES && *s == 'w')
    {
      s++;
      strcat(helpstring,"paired with");
    }
  paired_FLAG = NO;
  if((degree_FLAG == YES) && ((strcmp(s, "deg") == 0) || ((strcmp(s, "degrees") == 0))))
     {
       degree_FLAG = NO;
       *s = '\0';
     }

  /* parse for each character the string and find the correct contens els take the orginalstring  */
  
  while (*s != '\0')                  
    {
      switch(*s)
	{
	case 'a':
	  if(strcmp(s,"am") == 0)
	    (int)s = cat_2_helpstring("am", "among", helpstring, s);
	  else
	    if(strcmp(s,"att") == 0)
	      (int)s = cat_2_helpstring("att", "attached", helpstring, s);
	    else
	      if(strcmp(s,"alm") == 0)
		(int)s = cat_2_helpstring("alm", "almost", helpstring, s);
	      else
		if(strcmp(s,"approx") == 0)
		  (int)s = cat_2_helpstring("approx", "approximately", helpstring, s);
		else
		  {
		    getorginal = 1;
		    default_descr(s,oldhelpstringend,old_s,oldhelpstringlenght,helpstring);
		  }
	  break;
	case 'b':
	  if(strcmp(s,"bet") == 0)
	    (int)s = cat_2_helpstring("bet", "between", helpstring, s);
	  else
	    strcat(helpstring, "brighter");
	  break;
	case 'c':
	  if(strcmp(s,"cent") == 0)
	    (int)s = cat_2_helpstring("cent", "center", helpstring, s);
	  else
	    if(strcmp(s,"centre") == 0)
	      (int)s = cat_2_helpstring("centre", "center", helpstring, s);
	    else
	      if(strcmp(s,"centri") == 0)
		(int)s = cat_2_helpstring("centri", "center", helpstring, s);
	      else
		if(strcmp(s,"comp") == 0)
		  (int)s = cat_2_helpstring("comp", "complex", helpstring, s);
		else
		  if(strcmp(s,"cont") == 0)
		    (int)s = cat_2_helpstring("cont", "contact", helpstring, s);
		  else
		    strcat(helpstring, "considerably");
	  break;
	case 'd':
	  if(strcmp(s,"def") == 0)
	    (int)s = cat_2_helpstring("def", "defined", helpstring, s);
	  else
	    if(strcmp(s,"diam") == 0)
	      (int)s = cat_2_helpstring("diam", "diameter", helpstring, s);
	    else
	      if(strcmp(s,"dif") == 0)
		(int)s = cat_2_helpstring("dif", "diffuse", helpstring, s);
	      else
		if(strcmp(s,"diffic") == 0)
		  (int)s = cat_2_helpstring("diffic", "difficult", helpstring, s);
		else
		  if(strcmp(s,"diff") == 0)
		    (int)s = cat_2_helpstring("diff", "diffuse", helpstring, s);
		  else
		    if(strcmp(s,"decl") == 0)
		      (int)s = cat_2_helpstring("decl", "declination", helpstring, s);
		    else
		      if((strcmp(s,"deg") == 0) && degree_FLAG == NO)
			(int)s = cat_2_helpstring("deg", "degrees", helpstring, s);
		      else
			if(strcmp(s,"degrees") == 0)
			  (int)s = cat_2_helpstring("degrees", "degrees", helpstring, s);
			else
			  {
			    getorginal = 1;
			    default_descr(s,oldhelpstringend,old_s,oldhelpstringlenght,helpstring);
			  }
	  break;
	case 'e':
	  if(strcmp(s,"end") == 0)
	    (int)s = cat_2_helpstring("end", "end", helpstring, s);
	  else
	    {
	      if(*++s == 'r')
		strcat(helpstring, "easily resolved");
	      else
		{
		  if(*s == 'e')
		    strcat(helpstring, "very extremely");
		  else
		    {
		      strcat(helpstring, "extremely");
		      s--;
		    }
		}
	    }
	  break;
	case 'f':
	  strcat(helpstring, "following");
	  break;
	case 'g':
	  strcat(helpstring, "gradually");
	  break;
	  
	case 'I':
	case 'i':
	  if(strcmp(s,"inv") == 0)
	    (int)s = cat_2_helpstring("inv", "involved", helpstring, s);
	  else
	    if(strcmp(s,"irr") == 0)
	      (int)s = cat_2_helpstring("irr", "irregular", helpstring, s);
	    else
	      if(strcmp(s,"in") == 0)
		(int)s = cat_2_helpstring("in", "in", helpstring, s);
	      else
		{
		  if(*++s == 'F')
		    strcat(helpstring, "irregular figure");
		  else
		    {
		      s--;
		      strcat(helpstring, "irregular");
		    }
		}
	  break;
	case 'l':
	  if(strcmp(s,"line") == 0)
	    (int)s = cat_2_helpstring("line", "line", helpstring, s);
	  else
	    strcat(helpstring, "little");
	  break;
	case 'm':
	  if(mag_FLAG == NO)
	    if(strcmp(s,"mag") == 0)
	      (int)s = cat_2_helpstring("mag", "mag", helpstring, s);
	    else
	      strcat(helpstring, "much");
	  break;
	case 'n':
	  if(strcmp(s,"neb") == 0)
	    (int)s = cat_2_helpstring("neb", "nebulosity", helpstring, s);
	  else
	    if(strcmp(s,"neb?") == 0)
	      (int)s = cat_2_helpstring("neb?", "nebulous ?", helpstring, s);
	    else
	      if(strcmp(s,"neby") == 0)
		(int)s = cat_2_helpstring("neby", "nebulosity", helpstring, s);
	      else
		if(strcmp(s,"nebulous?") == 0)
		  (int)s = cat_2_helpstring("nebulous?", "nebulous ?", helpstring, s);
		else
		  if(strcmp(s,"nebs?") == 0)
		    (int)s = cat_2_helpstring("nebs?", "nebulous ?", helpstring, s);
		  else
		    if(strcmp(s,"nr") == 0)
		      (int)s = cat_2_helpstring("nr", "near", helpstring, s);
		    else
		      strcat(helpstring, "north");
	  break;
	case 'p':
	  if(strcmp(s,"pts") == 0)
	    (int)s = cat_2_helpstring("pts", "points", helpstring, s);
	  else
	    s++;                             
	  if(*s == 'F' || *s == 'S' ||    
	     *s == 'L' || *s == 'B')      
	    strcat(helpstring, "pretty");
	  else
	    strcat(helpstring, "preceding");
	  s--;
	  break;
	case 'r':
	  s++;s++;
	  if(*s == 'r')
	    strcat(helpstring, "well resolved");
	  else
	    {
	      if (*--s == 'r')
		strcat(helpstring, "partially resolved");
	      else
		{
		  s--;
		  strcat(helpstring, "not well resolved");
		}
	    }
	  break;
	case 's':
	  if(strcmp(s,"struct") == 0)
	    (int)s = cat_2_helpstring("struct", "structure", helpstring, s);
	  else
	    if(strcmp(s,"susp") == 0)
	      (int)s = cat_2_helpstring("susp", "suspected", helpstring, s);
	    else
	      if(strcmp(s,"stell") == 0)
		(int)s = cat_2_helpstring("stell", "stellar", helpstring, s);
	      else
		if(strcmp(s,"stellar") == 0)
		  (int)s = cat_2_helpstring("stellar", "stellar", helpstring, s);
		else
		  if(strcmp(s,"sev") == 0)
		    (int)s = cat_2_helpstring("sev", "several", helpstring, s);
		  else
		    if(strcmp(s,"several") == 0)
		      (int)s = cat_2_helpstring("several", "several", helpstring, s);
		    else
		      {
			s++;
			if(*s == 'c')
			  {
			    strcat(helpstring, "scattered");
			    s++;
			  }
			else
			  if(*s == 't')
			    {
			      strcat(helpstring, "star or stellar");
			      star_FLAG = YES;
			      s++;
			    }
			  else
			    {
			      char *secure_s;
			      secure_s = s;
			      while(*s != '\0' && *s != 'b')
				s++;
			      if(*s == 'b')
				strcat(helpstring,"suddenly");
			      else
				strcat(helpstring, "south");
			      s = secure_s;
			    }
			s--;
		      }
	  break;
	case 't':
	  if(strcmp(s,"tri") == 0)
	    (int)s = cat_2_helpstring("tri", "triple", helpstring, s);
	  else
	    {
	      getorginal = 1;
	      default_descr(s,oldhelpstringend,old_s,oldhelpstringlenght,helpstring);
	    }
	  break;
	case 'v':
	  if(strcmp(s,"var") == 0)
	    (int)s = cat_2_helpstring("var", "variable", helpstring, s);
	  else
	    strcat(helpstring, "very");
	  break;
	case 'w':
	  strcat(helpstring, "with");
	  break;
	case 'B':
	  strcat(helpstring, "bright");
	  break;
	case 'C':
	  if(*++s == 'l')
	    strcat(helpstring, "cluster");
	  else
	    {
	      strcat(helpstring, "compressed");
	      s--;
	    }
	  break;
	case 'D':
	  strcat(helpstring, "double");
	  break;
	case 'E':
	  strcat(helpstring, "elongated");
	  switch(*++s)
	    {
	    case '1':
	    case '2':
	    case '3':
	    case '4':
	    case '5':
	    case '6':
	    case '7':
	    case '8':
	    case '9':
	    case '0':
	      {
		strcat(helpstring," in position angel of ");
		(int)s = numbers(s,helpstring);
		strcat(helpstring, " degrees");
		s++;
	      }
	    default:
	      if(komma == KOMMA_SET)
		elogated_FLAG = YES;
	      s--;
	    }
	  break;
     case 'F':	strcat(helpstring, "faint");
		break;
     case 'L':	strcat(helpstring, "large");
		break;
     case 'M':	strcat(helpstring, "middle");
		break;
     case 'N':	strcat(helpstring, "nucleus");
		break;
     case 'P':	strcat(helpstring, "poor");
		paired_FLAG = YES;
		break;
	case 'R':
	  if(*++s == 'i' || *s == 'I')
	    strcat(helpstring, "rich");
	  else
	    {
	      strcat(helpstring, "round");
	      s--;
	    }
	  break;
     case 'S':	strcat(helpstring, "small");
		break;
     case '-':	strcat(helpstring, "to");
		break;
	case '*':
	  if(*++s == '*')
	    strcat(helpstring, "double");
	  else
	    s--;
	  strcat(helpstring, "star");
	  star_FLAG = YES;
	  break;
     case '=':	strcat(helpstring, "equal");
		break;
     case '&':	strcat(helpstring, "and");
		break;
     case '?':	strcat(helpstring,"(it's uncertain)");
		break;
     case '+':	strcat(helpstring,"+");
		break;
     case '(':  strcat(helpstring,"(");
	        break;
     case ')':	strcat(helpstring,")");
		break;
     case ';':	strcat(helpstring,";");
		break;
     case '!':  s++;
		 if(*++s == '!')
		  strcat(helpstring, "well remarkable object");
		 else
		   {
		     if (*--s == '!')
		       strcat(helpstring, "very remarkable object");
		     else
		       {
			 s--;
			 strcat(helpstring, "remarkable object");
		       }
		   }
	  break;
     case '1':
     case '2':
     case '3':
     case '4':
     case '5':
     case '6':
     case '7':
     case '8':
     case '9':
     case '0':
     case '.':
     case 0x27:
	  {
	    (int)s = numbers(s, helpstring);
	    break;
	  }
     default :  {
	    default_descr(s,oldhelpstringend,old_s,oldhelpstringlenght,helpstring);
	    getorginal = 1;
	  }
	}
    if (getorginal == 1)
      {
	if (komma == 0) strcat(helpstring, " ");
	*s = '\0';
      }
    else
      {
	s++;
	if (*s != '\0' || komma == 0) strcat(helpstring," ");
      }
  }

  if(klammer_op_FLAG == YES)                        /* check the flag settings and action then */
    {
      strcat(helpstring, "(");
      klammer_op_FLAG = NO;
    }
  if(klammer_cl_FLAG == YES)
    {
      char *old_help_secure;
      old_help_secure = helpstring;
      while(*helpstring++ != '\0');
      --helpstring;
      *--helpstring = ')';
      *++helpstring = '\0';
      helpstring = old_help_secure;
      klammer_cl_FLAG = NO;
    }  
  if (komma == NOT_SET)
    {
      strcat(helpstring,",");      /* if komma-flag is set  */
      degree_FLAG = NO;
    }
  if (star_FLAG == YES && komma == NOT_SET)
    star_FLAG = NO;
  
}

/* spezial parser for numbers and to correct the mistakes from the database    */

int numbers(char *s, char *helpstring)        
{
  static int i;
  int counter;
  counter = 0;
  i = 0;

  while (*s != '\0' && (isdigit(*s) || *s == '.' || *s == 0x27 || *s == 'm'))
    {
      char *numhelp;
      numhelp = (char *)malloc(sizeof(s)+10);

      *numhelp = *s;
      *++numhelp = '\0';
      numhelp--;

      switch(*s)
	{
       case '.':

	  while((*s == '.') && (*s != '\0')) {s++; counter++; }
	  if(counter == 1)
	    {
	      strcat(helpstring, ".");
	      if (*s != '\0') s--;
	    }
	  else
	    if(*s != '\0' && (isdigit(*s)))
	      {
		strcat(helpstring, "th to ");
		while(*s != '\0' && (isdigit(*s)))
		  {
		    *numhelp = *s; *++numhelp = '\0'; numhelp--;
		    strcat(helpstring, numhelp);
		    if (*s != '\0') s++;
		  }
		strcat(helpstring, "th magnitude");
		star_FLAG = NO;
	      }
	    else
	      {
		strcat(helpstring, "th magnitude and fainther");
		star_FLAG = NO;
	      }
	  break;

	case 'm':
	  if(star_FLAG == YES)
	    star_FLAG = NO;
	  strcat(helpstring, "th magnitude");
	  break;
	  
	case 0x27:
	  if(star_FLAG == YES)
	    star_FLAG = NO;
	  if(*++s == 0x27)
	    {
	      strcat(helpstring, " seconds");
	    }
	  else
	    {
	      strcat(helpstring," minutes");
	      s--;
	    }
	  break;
	  
	default:      strcat(helpstring,numhelp);
	}
      if(*s != '\0')
	s++;
      free(numhelp);
    }
  if (star_FLAG == YES)
    {
      strcat(helpstring, "th magnitude");
      mag_FLAG = YES;
      star_FLAG = NO;
    }
  (int)s = s-1;
  return (int)s;
}

/* if parsing not possible write the orginal to the helpstring  */

int default_descr(char *s,char *oldhelpstringend,char *old_s,int oldhelpstringlenght, char *helpstring)
{
  helpstring = oldhelpstringend;
  *helpstring = '\0';
  s = old_s;
  strcat(helpstring, s);
  return 0;
}

/* append to helpstring   */

int cat_2_helpstring(char *short_string, char *long_string, char *helpstring, char *s)
{
  strcat(helpstring, long_string);
  s = s+strlen(short_string)-1;
  return (int)s;
}
