/*
 * SACDRT Version 3.1 SAC-Database-Reader for DeepSky Objects
 * Module P_CORD.C is written by Lars Hagen for the SACDRT.
 *
 *  Copyright (C) 1994 Lars Hagen & Sven van der Meer
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *  Problems or comments to hagenl@cs.tu-berlin.de
 *                                                                   
 */

/* BUG:    DEGREE CHARACTER NOT POSSIBLE !!!                               */

#include <string.h>
#include <stdlib.h>
#include <ctype.h>
#include "sacdrt.h"
void is_empty(char *s);

int parse_ra(char *string)                    /* PARSE RA              */
{
  int i=0;
  while (string[i] != '\0')               /* if not EndOfString    */
    {                                     /* compare of " ", when  */
      if (string[i] == ' ')               /* found change          */
	string[i] = 'h';                  /* " " -> "h"            */
      i++;
    }
  return 0;
}

/***************************************************************************/

int parse_dec(char *string)               /* PARSE DEC             */
{                                         /* if not EndOfString    */
  int i=0;                                /* compare of " ", when  */
  while (string[i] != '\0')               /* found change          */
    {                                     /* " " -> "o"            */
      if (string[i] == ' ')
	string[i] = 'o';                  /* DEGREE CHARACTER      */
      i++;
    }
  strcat(string,"'");                     /* append to string "'"  */
  return 0;
}

/***************************************************************************/

int parse_mag(char *string,int call)              /* PARSE MAG             */
{                                                 /* append to value of mag*/
  char *dark     = "Dark nebula hasn't a magnitude";  /* " mag".               */
  char *likedark = "(see brightness)";
  char *unknown  = "unknown";                      
                                                                    
  if (*string == '0')
   {
    string++;
    if (*string != '.')
     {
      string--;
      *string =  ' ';
     }
    else
     string--;
   }


  if (strcmp(string,"79.9") == 0)
    {
      if(call == 1)
	strcpy(string, likedark);
      else
	strcpy(string,dark);
    }
  else
    if (strcmp(string,"99.9") == 0)
      strcpy(string,unknown);
    else
      strcat(string," mag");
  return 0;
}

/***************************************************************************/

int parse_brstr(char *string)                     /* PARSE BRSTR           */
{                                                 /* if 1st char in string */
  if (*string != '\0')                            /* not EndOfString append*/
    strcat(string," mag");                        /* " mag" to string      */
  else
    is_empty(string);
  return 0;
}

/***************************************************************************/

int parse_size(char *string)          /* PARSE SIZE                        */
{
  static char *helpstring;
  static char *oldstringbegin;

  oldstringbegin = string;            /* secure string-pointer to begin    */
  helpstring = (char *)malloc(30+sizeof(string));
  helpstring[0] = '\0';
  
  while (*string != '\0')             /* if not EndOfString check string   */
    {                                 /* "X". When found change this to    */
      switch(*string)
	{
	case 'X':
	  strcat(helpstring," x ");
	  break;
	case '.':
	  string--;
	  if(isdigit(*string++))
	    strcat(helpstring,".");
	  else
	    strcat(helpstring,"0.");
	  break;
	default:
	  {
	    static char helpchar[1];
	    helpchar[1] = '\0';
	    helpchar[0] = *string;
	    strcat(helpstring,helpchar);
	  }
	}
      string++;
    }
  string = oldstringbegin;            /* rewrite orginal string-pointer    */
  strcpy(string, helpstring);         /* copy Sizehelp string to string    */
  
  if (*string == '\0')
    is_empty(string);
  free(helpstring);
  return 0;
}

/****************************************************************************/

int parse_nsts(char *string)
{
  if (*string == '\0')
    is_empty(string);
  return 0;
}

/****************************************************************************/

void is_empty(char *s)
{
  if(*s == '\0')
    strcpy(s, "N/A");
}








