/*
 * SACDRT Version 3.1 SAC-Database-Reader for DeepSky Objects
 * Module P_CON.C is written by Lars Hagen for the SACDRT.
 *
 *  Copyright (C) 1994 Lars Hagen & Sven van der Meer
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *  Problems or comments to hagenl@cs.tu-berlin.de
 *                                                                   
 */

#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include "const_data.h"
/*#include "sacdrt.h"*/

int parse_con (char *string)
{
  static int i;
  static char *helpstring;                                       /* create a helpstring  */
  i=0;
  helpstring = (char *)malloc(50+sizeof(struct constellation));  /* mem for helpstring   */
  while(strcmp(string, const_data[i].short_con) != 0)                 /* compare with entries */
    i++;                                                         /* of struct            */

  sprintf(helpstring,"%s - %s", string, const_data[i].long_con);      /* append to helpstring */
  strcpy(string, helpstring);                                    /* copy helpstr 2 str   */
  free(helpstring);
  return 0;
}
