/*
 * SACDRT Version 3.1 SAC-Database-Reader for DeepSky Objects
 * Module P_CLASS.C is written by Lars Hagen for the SACDRT.
 *
 *  Copyright (C) 1994 Lars Hagen & Sven van der Meer
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *  Problems or comments to hagenl@cs.tu-berlin.de
 *                                                                   
 */

#include <string.h>
#include <stdlib.h>
#include "sacdrt.h"
#include "database.h"

void trumpler_type(char *s, char *helpstring);
void hubble_type(char *s, char *helpstring);
void nebulae_type(char *s, char *helpstring);
void misc_symbols(char *s, char *helpstring);

int parse_class(char *s)
{
  char *helpstring;
  char *oldstringbegin;
  oldstringbegin = s;
  helpstring = (char *)malloc(100+sizeof(s));
  *helpstring = '\0';
  status.clas = strlen(s)+3;
   switch(*s)
    {
     case 'P':	if((strcmp(s,"Pec")==0) || (strcmp(s,"P")==0)) strcat(helpstring, "peculiar galaxy"); break;
     case 'd':
     case 'c':
     case 'E':
     case 'S':  hubble_type(s,helpstring); break;
     case 'I':
       if(*++s == 'r')
	 {
	   s--;
	   hubble_type(s,helpstring);
	 }
       else
	 {
	   s--;
	   trumpler_type(s,helpstring);
	 }
       break;
     case '1':
     case '2':
     case '3':
     case '4':
     case '5':
     case '6':	nebulae_type(s,helpstring); break;
     default :	trumpler_type(s,helpstring);
     }
  
  s = oldstringbegin;
  /*  strcpy(s, helpstring); */
   if (*s == '\0')
     is_empty(s);
   else
     {
       strcat(s, " - ");
       strcat(s, helpstring);
     }

  free(helpstring);
  return 0;
}

/***************************************************************************************/

void nebulae_type(char *s, char *helpstring)
{
 while(*s != '\0')
  {
   switch(*s)
    {
     case '1':	strcat(helpstring, "stellar"); break;
     case '2':
       strcat(helpstring, "smooth disk");
       while(*s != '\0' && *s != ' ')
	 {
	   switch(*++s)
	     {
	     case 'a':	strcat(helpstring, " brigther center"); break;
	     case 'b':	strcat(helpstring, " uniform brightness"); break;
	     case 'c': 	strcat(helpstring, " traces of ring structure"); break;
	     }
	 }
       break;
     case '3':
       strcat(helpstring, "irregular disk");
       while(*s != '\0' && *s != ' ')
	 {
	   switch(*++s)
	     {
	     case 'a':	strcat(helpstring, " very irregular brightness distribution"); break;
	     case 'b':	strcat(helpstring, " traces in ring structure"); break;
	     }
	 }
       break;
     case '4':	strcat(helpstring, "ring structure"); break;
     case '5':	strcat(helpstring, "irregular form similar to diffuse nebula");	break;
     case '6':	strcat(helpstring, "anomalous form, no regular structure"); break;
     }
   s++;
 }
}

/********************************************************************************/

void trumpler_type(char *s,char *helpstring)
{
 while(*s != '\0')
  {
   switch(*s)
    {
     case ' ':	strcat(helpstring, ","); break;
     case '1':	strcat(helpstring, "small range"); break;
     case '2':	strcat(helpstring, "moderate range"); break;
     case '3':	strcat(helpstring, "large range"); break;
     case 'p':	strcat(helpstring, "poor (<50 stars)"); break;
     case 'm':	strcat(helpstring, "moderately rich (50-100 stars)"); break;
     case 'r':	strcat(helpstring, "rich (>100 stars)"); break;
     case 'n':	strcat(helpstring, "nebulosity in cluster"); break;
     case 'I':
       s++;
       if(*++s == 'I')
	 strcat(helpstring, "Detached, no concentration toward the center");
       else
	 {
	   if(*--s == 'I')
	     strcat(helpstring, "Detached, weak concentration toward the center");
	   else
	     if(*s == 'V')
	       strcat(helpstring, "Not well detached from surrounding star field");
	     else
	       {
		 s--;
		 strcat(helpstring, "Detached, strong concentration toward the center");
	       }
	 }
       break;
     }
   s++;
 }
}

/**********************************************************************************/

void hubble_type(char *s, char *helpstring)
{
  switch(*s)
    {
    case 'S':
      strcat(helpstring, "spiral galaxy ");
      while(*++s != '\0')
	{
	  switch(*s)
	    {
	    case ' ':	break;
	    case 'p':
	      strcat(helpstring, ",peculiar ");
	      if(*++s == 'e')
		s++;
	      else
		s--;
	      break;
	    case 'd':  strcat(helpstring, ",dimension is known "); break;
	    case 'm':  strcat(helpstring, ",total size and magnitude are known "); break;
	    case 'B':  strcat(helpstring, "with central bar "); break;
	    case '(':  strcat(helpstring, ",presence of bar is uncertain ");
                       s++;s++;
	               break;
	    case 'a':  strcat(helpstring, "with tightly-wound arms "); break;
	    case 'c':  strcat(helpstring, "with loosely-wound arms "); break;
	    case '+':  strcat(helpstring, "is resolvable into stars ");  break;
	    case '-':  strcat(helpstring, "isn't resolvable into stars ");  break;
	    case '0':
	    case 'O':  strcat(helpstring, ",lenticular type ");  break;
	    case 'b':
	      if(*++s == '+')
		strcat(helpstring,"with moderately- to loosely-wound arms ");
	      else
		if(*s == '-')
		  strcat(helpstring,"with tightly- to moderately-wound arms ");
		else
		  {
		    s--;
		    strcat(helpstring, "with moderately-wound arms ");
		  }
	      break;
	    default:  misc_symbols(s,helpstring); break;
	    }
	}
      break;
    case 'd':
    case 'c':
    case 'D':
    case 'E':
      while(*s != '\0')
	{
	  switch(*s)
	    {
	    case 'E':
	      if(*++s == '+')
		{
		  strcat(helpstring, "emision and reflaction are together in nebula");
		  *++s = '\0';
		  s--;
		}
	      else
		{
		  strcat(helpstring, "elliptical galaxy ");
		  s--;
		}
	      break;
	    case '0':  strcat(helpstring, "most round "); break;
	    case '1':  strcat(helpstring, "very round "); break;
	    case '2':  strcat(helpstring, "round ");      break;
	    case '3':  strcat(helpstring, "few round ");  break;
	    case '4':  strcat(helpstring, "few flat ");   break;
	    case '5':  strcat(helpstring, "flat ");       break;
	    case '6':  strcat(helpstring, "very flat ");  break;
	    case '7':  strcat(helpstring, "most flat ");  break;
	    case 'd':  strcat(helpstring, "dwarf system "); break;
	    case 'c':  strcat(helpstring, "supergigant system "); break;
	    case 'D':  strcat(helpstring, "diffuse halo ");  break;
	    default:  misc_symbols(s,helpstring); break;
	    }
	  s++;
	}
      break;
    case 'I': 
      strcat(helpstring, "irregular galaxy ");
      s++;
      if(*++s == '+')
	strcat(helpstring, "resolvable into individual stars and nebulae ");
      else
	if(*s == '-') strcat(helpstring, "completely amorphous ");
	else
	  s--;
      break;
    default:	misc_symbols(s,helpstring);
      break;
    }
}

/***********************************************************************************/

void misc_symbols(char *s, char *helpstring)
{
  char *littlehelpstring;
  
  littlehelpstring = (char *)malloc(sizeof(s)+1);
  *littlehelpstring = *s;
  *++littlehelpstring = '\0';
  littlehelpstring--;
  
  strcat(helpstring, littlehelpstring);
  free(littlehelpstring);
}







