/*
 * SACDRT Version 3.1 SAC-Database-Reader for DeepSky Objects
 * Header OBJECT_DATA.H is designed by Lars Hagen for the SACDRT.
 *                         modified by Sven van der Meer
 *
 *  Copyright (C) 1994 Lars Hagen & Sven van der Meer
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *  Problem or comments to hagenl@cs.tu-berlin.de
 *
 */

  struct objectnames {
    char *short_name;
    char *middle_name;
    char *long_name;
    int  marked;
  };
#ifndef LAYOUT
  struct objectnames object_data[] = {
    { "",          "",           "",0                                                                  },
    { "Abell",     "Abell",      "George Abell (planetary nebulae and galaxy clusters)",0              },
    { "ADS",       "AitDblSt",   "Aitken Double Star catalog",0                                        },
    { "AM",        "Arp-Mad.",   "Arp-Madore (globular clusters)",0                                    },
    { "Antalova",  "Antalova",   "(open clusters)",0                                                   },
    { "Ap",        "Apriama.",   "Apriamasvili (planetary nebulae)",0                                  }, 
    { "Arp",       "Halt.Arp",   "Halton Arp (interacting galaxies)",0                                 },
    { "Bark",      "Bark",       "Barkhatova (open clusters)",0                                        },
    { "B",         "Barnard",    "Barnard (dark nebulae)",0                                            },
    { "Basel",     "Basel",      "(open clusters)",0                                                   },
    { "BD",        "Bonn. DM",   "Bonner Durchmusterung (stars)",0                                     },
    { "Berk",      "Berkeley",   "Berkeley (open clusters)",0                                          },
    { "Be",        "Bernes",     "Bernes (dark nebulae)",0                                             },
    { "Biur",      "Biurakan",   "Biurakan (open clusters)",0                                          },
    { "Blanco",    "Blanco",     "(open clusters)",0                                                   },
    { "Bochum",    "Bochum",     "(open clusters)",0                                                   },
    { "Ced",       "Cederbl.",   "Cederblad (bright nebulae)",0                                        },
    { "Cr",        "Collind.",   "Collinder (open clusters)",0                                         },
    { "Czernik",   "Czernik",    "(open clusters)",0                                                   },
    { "DDO",       "DavDunl.",   "David Dunlap Observatory (dwarf galaxies)",0                         },
    { "Do",        "Dolidze",    "Dolidze (open clusters)",0                                           },
    { "DoDz",      "DoliDzim",   "Dolidze-Dzimselejsvili (open clusters)",0                            },
    { "Dun",       "Dunlop",     "Dunlop (globular clusters)",0                                        },
    { "Fein",      "Feinst.",    "Feinstein (open clusters)",0                                         },
    { "Frolov",    "Frolov",     "(open clusters)",0                                                   },
    { "Gum",       "Gum",        "(bright nebulae)",0                                                  },
    { "H",         "Hersch.",    "William Herschel (globular clusters)",0                              },
    { "Haffner",   "Haffner",    "(open clusters)",0                                                   },
    { "Harvard",   "Harvard",    "(open clusters)",0                                                   },
    { "He",        "Henize",     "Henize (planetary nebulae)",0                                        },
    { "Hogg",      "Hogg",       "(open clusters)",0                                                   },
    { "HP",        "HautProv",   "Haute Provence (globular clusters)",0                                },
    { "Hu",        "Humason",    "Humason (planetary nebulae)",0                                       },
    { "IC",        "Ind.Cat.",   "1st & 2nd Index Catal. in NGC (types of objects except dark neb.)",0 },
    { "Isk",       "Iskudar.",   "Iskudarian (open clusters)",0                                        },
    { "J",         "Jonckhe.",   "Jonckheere (planetary nebulae)",0                                    },
    { "K",         "Kohoutek",   "Kohoutek (planetary nebulae)",0                                      },
    { "King",      "King",       "(open clusters)",0                                                   },
    { "Kr",        "Krasnog.",   "Krasnogorskaja (planetary nebulae)",0                                },
    { "Lac",       "Lacaille",   "Lacaille (globular clusters)",0                                      },
    { "Loden",     "Loden",      "(open clusters)",0                                                   },
    { "LDN",       "Lynds",      "Lynds (dark nebulae)",0                                              },
    { "Lynga",     "Lynga",      "(open clusters)",0                                                   },
    { "M",         "Messier",    "Messier (all types of objects except dark nebula)",0                 },
    { "MCG",       "MorphCG",    "Morphological Catalog of Galaxies",0                                 },
    { "Mrk",       "Markari.",   "Markarian (open clusters and galaxies)",0                            },
    { "Me",        "Merrill",    "Merrill (plantary nebulae)",0                                        },
    { "Mel",       "Melotte",    "Melotte (open clusters)",0                                           },
    { "M1",        "Minkows.",   "Minkowski (planetary nebulae)",0                                     },
    { "NGC",       "NGC",        "New General Catalog of Nebulae & Clusters of Stars.",0               },
    { "Pal",       "Palomar",    "Palomar (globular clusters)",0                                       },
    { "PC",        "PeimCost",   "Peimbert and Costero (planetary nebulae)",0                          },
    { "Pismis",    "Pismis",     "(open clusters)",0                                                   },
    { "PK",        "Per&Koho",   "Perek & Kohoutek (planetary nebulae)",0                              },
    { "RCW",       "RCW",        "Rodgers, Campbell, & Whiteoak (bright nebulae)",0                    },
    { "Roslund",   "Roslund",    "(open clusters)",0                                                   },
    { "Ru",        "Ruprecht",   "Ruprecht (open clusters)",0                                          },
    { "Sa",        "Sandqvi.",   "Sandqvist (dark nebulae)",0                                          },
    { "Sher",      "Sher",       "(open clusters)",0                                                   },
    { "Sh",        "Sharple.",   "Sharpless (bright nebulae)",0                                        },
    { "SL",        "SandLind",   "Sandqvist & Lindroos (dark nebulae)",0                               },
    { "Steph",     "Stephen.",   "Stephenson (open clusters)",0                                        },
    { "Stock",     "Stock",      "(open clusters)",0                                                   },
    { "Ter",       "Terzan",     "Terzan (globular clusters)",0                                        },
    { "Tombaugh",  "Tombaugh",   "(open clusters)",0                                                   },
    { "Ton",       "Tonantz.",   "Tonantzintla (globular clusters)",0                                  },
    { "Tr",        "Trumpler",   "Trumpler (open clusters)",0                                          },
    { "UGC",       "UGC",        "Uppsala General Catalog (galaxies)",0                                },
    { "UKS",       "UKS",        "United Kingdom Schmidt (globular clusters)",0                        },
    { "UA",        "Non-UGC",    "Catalog of selected Non-UGC galaxies",0                              },
    { "Upgren",    "Upgren",     "(open clusters)",0                                                   },
    { "vdB",       "vd Bergh",   "van den Bergh (open clusters, bright nebulae)",0                     },
    { "vdBH",      "vdB&Herb",   "van den Bergh & Herbst (bright nebulae)",0                           },
    { "vdB-Ha",    "vdB&Hage",   "van den Bergh-Hagen (open clusters)",0                               },
    { "VV",        "VoroVely",   "Vorontsov-Velyaminov (interacting galaxies)",0                       },
    { "Vy",        "Vyssots.",   "Vyssotsky (planetary nebulae)",0                                     },
    { "Waterloo",  "Waterloo",   "(open clusters)",0                                                   },
    { "Westr",     "Westerl.",   "Westerlund (open clusters)",0                                        },
    { "Zw",        "Zwicky",     "Zwicky (galaxies)",0                                                 },
    { "*",         "unknown",    "unknown catalog",0                                                   }
  };
  int max_name=(sizeof object_data/sizeof(struct objectnames));
#else
  extern struct objectnames object_data[];
  extern int max_name;
#endif






