/*
 * SACDRT Version 3.1 SAC-Database-Reader for DeepSky Objects
 * Module MARKED_OBJECTS.C is written by Sven van der Meer for SACDRT.
 *
 *  Copyright (C) 1994 Lars Hagen & Sven van der Meer
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *  Problems or comments to hagenl@cs.tu-berlin.de
 *
 */

#include <string.h>
#include <stdlib.h>
#include <ctype.h>
#include <math.h>
#include "database.h"
#include "sacdrt.h"
#include "layout.h"


void sacdrt_qsort(struct core_list *v[],int,int);
void sacdrt_swap(struct core_list *v[],int,int);
int  sacdrt_cmp(struct core_list *,struct core_list *);
void sacdrt_shell(struct core_list *v[],int);

/*
 * void INSERT_MARKED (int)  will insert a marked object in the marked list
 *			     using status.next_core
 *
 */
void insert_marked(int todo)
{
struct core_list *sac_core=&head_core;
struct mark_list *tmp_mark;
char tmp_ptr[MAXPATHLEN];

 tmp_mark=(struct mark_list *)malloc(sizeof(struct mark_list));
 if (tmp_mark==NULL)
   sac_exit(7," in function insert_object");

 sac_core=status.next_core;

 sac_core->mark_flag=todo;
 switch(todo){
   case use_name:  strcpy((char *)tmp_ptr,(const char *)(parse_core(sac_core->sac_line,8)));
		   break;
   case use_other: strcpy((char *)tmp_ptr,(const char *)(parse_core(sac_core->sac_line,9)));
                   break;
 }
 tmp_mark->mark_name=(char *)malloc(strlen(tmp_ptr)+1);
 strcpy((char *)tmp_mark->mark_name,tmp_ptr);
 tmp_mark->mark_core=sac_core->core_count;
 tmp_mark->mark_count=status.max_mark;
 tmp_mark->next_core=sac_core;

 tail_mark.next_mark->next_mark=tmp_mark;
 tmp_mark->next_mark=&tail_mark;
 tail_mark.next_mark=tmp_mark;

 status.max_mark++;
return;
}



/*
 *  void DELETE_ONE_MARKED (int) delete one marked object from the marked list
 *                               called from show_marked (layout.c) with the
 *                               count from the object to delete
 *
 */
void delete_one_marked(int delete)
{
struct mark_list *tmp_mark=&head_mark;
struct mark_list *del=&head_mark;
struct core_list *fil=&head_core;
int i;

 while((delete!=del->mark_count)&&(del!=&tail_mark))
   del=del->next_mark;

 while((tmp_mark!=&tail_mark)&&(tmp_mark->next_mark!=del))
   tmp_mark=tmp_mark->next_mark;

 if (tmp_mark->next_mark!=del)
   return;

 tmp_mark->next_mark=del->next_mark;
 while (fil->core_count!=del->mark_core)
   fil=fil->next;
 fil->mark_flag=FALSE;
 free(del->mark_name);
 free(del);
 status.max_mark--;
 if (status.max_mark<2){
   status.max_mark=1;
   sac_filter(OFF);
   head_mark.next_mark=&tail_mark;
   tail_mark.next_mark=&head_mark;
 }
 else{
   tmp_mark=head_mark.next_mark;
   for(i=1;tmp_mark!=&tail_mark;i++){
     tmp_mark->mark_count=i;
     tmp_mark=tmp_mark->next_mark;
   }
   status.max_mark=i;
 }

return;
}


/*
 *  void DELETE_ALL_MARKED()  will delete all marked objects and free up the
 *                            memory allocated for the marked list
 *
 */
void delete_all_marked()
{
struct mark_list *tmp_mark;
struct mark_list *tmp_swap;
struct core_list *tmp_core=&head_core;

 for (tmp_mark=head_mark.next_mark;tmp_mark!=&tail_mark;tmp_mark=tmp_swap){
   tmp_swap=tmp_mark->next_mark;
   free(tmp_mark->mark_name);
   free(tmp_mark);
 }
 head_mark.next_mark=&tail_mark;
 tail_mark.next_mark=&head_mark;

 if(tmp_core!=&tail_core){
   while((tmp_core=tmp_core->next)!=&tail_core)
     tmp_core->mark_flag=FALSE;
 }

 status.max_mark=1;
 sac_filter(OFF);
return;
}



/*
 *  void DELETE_CORE_LIST()  free up all allocated memory for the core list
 *  			     and delete the core list. called when sacdrt
 *			     terminates
 *
 */
void delete_core_list()
{
struct core_list *tmp_core;
struct core_list *tmp_swap;

 for (tmp_core=head_core.next;tmp_core!=&tail_core;tmp_core=tmp_swap){
   tmp_swap=tmp_core->next;
   free(tmp_core->sac_line);
   free(tmp_core);
 }

return;
}



/* 
 * int CS_DO_SEARCH(int)  called from cs_search to search for the requested
 *                        objects. i hope this will not need a lot of time
 *                        (on my computer about 10 seconds for all marked).
 *
 */
int cs_do_search()
{
int ret=FALSE,i,test,cs_count=1;
double mag_db,ra_db,decl_db;
double min_mag_cmp,max_mag_cmp,min_ra_cmp,max_ra_cmp,min_decl_cmp,max_decl_cmp;
double min_mag_default,max_mag_default;
struct core_list *sac_core=&head_core;
char tmp[10];

 min_mag_cmp=atof(cs_values.min_mag)-0.1;
 max_mag_cmp=atof(cs_values.max_mag)+0.1;
 min_ra_cmp=atof(cs_values.min_ra)-0.1;
 max_ra_cmp=atof(cs_values.max_ra)+0.1;
 min_decl_cmp=atof(cs_values.min_decl)-0.1;
 max_decl_cmp=atof(cs_values.max_decl)+0.1;

 min_mag_default=atof(CS_MIN_MAG);
 max_mag_default=atof(CS_MAX_MAG);

 delete_all_marked();
 sac_core=sac_core->next;

 while(sac_core!=&tail_core){
   if((config.curses)&&(fmod((double)cs_count,(double)100)==0)){
     mvwprintw(message_win,1,13,"%i",cs_count);
     wrefresh(message_win);
   }

   strcpy((char *)cs_tmp.tmp_ptr,(const char *)sac_core->sac_line);

   strcpy(tmp,parse_core(cs_tmp.tmp_ptr,6));
   mag_db=atof(tmp);
   strcpy(tmp,parse_core(cs_tmp.tmp_ptr,4));
   ra_db=atof(tmp);
   strcpy(tmp,parse_core(cs_tmp.tmp_ptr,5));
   decl_db=atof(tmp);

   strcpy((char *)cs_tmp.name_ptr,(const char *)parse_core(cs_tmp.tmp_ptr,0));
   strcpy((char *)cs_tmp.type_ptr,(const char *)parse_core(cs_tmp.tmp_ptr,2));
   strcpy((char *)cs_tmp.con_ptr,(const char *)parse_core(cs_tmp.tmp_ptr,3));
   strcpy((char *)cs_tmp.other_ptr,(const char *)parse_core(cs_tmp.tmp_ptr,1));

   if((min_mag_cmp==min_mag_default)&&(max_mag_cmp==max_mag_default))
     sac_core->mark_flag=use_name;
   else{
     if((mag_db<max_mag_cmp)&&(mag_db>min_mag_cmp))
       sac_core->mark_flag=use_name;
     else
       sac_core->mark_flag=FALSE;
   }

   if((ra_db<max_ra_cmp)&&(ra_db>min_ra_cmp)&&(sac_core->mark_flag))
     sac_core->mark_flag=use_name;
   else
     sac_core->mark_flag=FALSE;

   if((decl_db<max_decl_cmp)&&(decl_db>min_decl_cmp)&&(sac_core->mark_flag))
     sac_core->mark_flag=use_name;
   else
     sac_core->mark_flag=FALSE;

   test=FALSE;
   if ((cs_values.mark_name)&&(sac_core->mark_flag)){
     for (i=1;i<max_name;i++){
       if((object_data[i].marked)&&(strcmp(cs_tmp.name_ptr,object_data[i].short_name)==0))
         test=use_name;
       else if((object_data[i].marked)&&(strcmp(cs_tmp.other_ptr,object_data[i].short_name)==0))
         test=use_other;
       else if((object_data[i].marked)&&(strcmp(object_data[i].short_name,"M1")==0)&&(strcmp(cs_tmp.other_ptr,"M1")==0))
         test=use_other;
       else if((object_data[i].marked)&&(strcmp(object_data[i].short_name,"M1")==0)&&(strcmp(cs_tmp.name_ptr,"M1")==0))
         test=use_other;
       if(test)
         break;
     }
     sac_core->mark_flag=test;
   }

   test=FALSE;
   if ((cs_values.mark_type)&&(sac_core->mark_flag)){
     for (i=1;i<max_type;i++){
       if((type_data[i].marked)&&(strcmp(cs_tmp.type_ptr,type_data[i].short_type)==0)){
         test=sac_core->mark_flag;
         break;
       }
     }
     sac_core->mark_flag=test;
   }

   test=FALSE;
   if ((cs_values.mark_con)&&(sac_core->mark_flag)){
     for (i=1;i<max_con;i++){
       if((const_data[i].marked)&&(strcmp(cs_tmp.con_ptr,const_data[i].short_con)==0)){
         test=sac_core->mark_flag;
         break;
       }
     }
     sac_core->mark_flag=test;
   }

   if (sac_core->mark_flag){
     status.next_core=sac_core;
     insert_marked(sac_core->mark_flag);
   }
   sac_core=sac_core->next;
   cs_count++;
 }
 if (status.max_mark==1)
   ret=FALSE;
 else{
   sac_filter(ON);
   ret=TRUE;
 }
return ret;
}



/* 
 *  char *PARSE_CORE(char *,int)  input is sac_line and this function will
 *                                return the reqeusted value (name,type,const,
 *                                decl,mag,ra or other). to save time, the
 *				  returned pointers will be not parsed
 *
 */
char *parse_core(char *tmp_ptr,int ret)
{
char return_ptr[80];
int i=0,j=0;
char help_ptr[MAXPATHLEN];
char c;

 while(i<7){
   c=*tmp_ptr++;
   if (c=='"'||c=='\0'){
     help_ptr[j++]='\0';
     if (i==ret){
       strcpy((char *)return_ptr,(const char *)help_ptr);
       break;
     }
     if ((ret==8)&&(i==0)){
       strcpy((char *)return_ptr,(const char *)help_ptr);
       break;
     }
     if ((ret==9)&&(i==1)){
       strcpy((char *)return_ptr,(const char *)help_ptr);
       break;
     }
     i++; j=0;
   }
   else{
     help_ptr[j++]=c;
   }
 }

 if(ret==0){
   if((return_ptr[0]=='M')&&(return_ptr[2]=='-'))
     return "M1";
   else
     i=0;
   while(return_ptr[i]!='\0'){
     if((!isspace(return_ptr[i]))&&!(isdigit(return_ptr[i]))&&(return_ptr[i]!='\''))
         i++;
     else{
       return_ptr[i]='\0';
       break;
     }
   }
 }
 if(ret==1){
   if((return_ptr[0]=='M')&&(return_ptr[2]=='-'))
     return "M1";
   else
   i=0;
   while(return_ptr[i]!='\0'){
     if(!isspace(return_ptr[i]))
       i++;
     else{
       return_ptr[i]='\0';
       break;
     }
   }
 }
return return_ptr;
}



/*
 *
 *
 *
 */
void sort_marked()
{
int i=0,n=status.max_mark;
struct mark_list *test_mark=head_mark.next_mark;
struct mark_list *tmp_mark;
struct core_list *sac_core;
char tmp_ptr[MAXPATHLEN];
struct core_list *sort_tmp[status.max_mark+1];

 while(test_mark!=&tail_mark){
   sort_tmp[i]=test_mark->next_core;
   tmp_mark=test_mark;
   test_mark=test_mark->next_mark;
   free(tmp_mark->mark_name);
   free(tmp_mark);
   i++;
 }
 head_mark.next_mark=&tail_mark;
 tail_mark.next_mark=&head_mark;
 status.max_mark=1;

 if(config.sort_mode)
   sacdrt_shell(sort_tmp,n-1);
 else{
   /*qsort((void *)sort_tmp,n-2,sizeof(head_core.next),
          (int(*)(const void *,const void *))sacdrt_cmp);*/
   /*qsort((void **)sort_tmp,n-1,sizeof(struct core_list *),
             (int(*)(const void *,const void *))sacdrt_cmp);*/
   sacdrt_qsort(sort_tmp,0,n-2);
 }

 if(sort.up_down)
   i=0;
 else{
   i=n-2;
   n=0;
 }

 while(i!=n-1){
   tmp_mark=(struct mark_list *)malloc(sizeof(struct mark_list));
   if (tmp_mark==NULL)
     sac_exit(7," in function sort_marked");

   sac_core=sort_tmp[i];
   switch(sac_core->mark_flag){
     case use_name:  strcpy((char *)tmp_ptr,(const char *)(parse_core(sac_core->sac_line,8)));
                     break;
     case use_other: strcpy((char *)tmp_ptr,(const char *)(parse_core(sac_core->sac_line,9)));
                     break;
   }

   tmp_mark->mark_name=(char *)malloc(strlen(tmp_ptr)+1);
   strcpy((char *)tmp_mark->mark_name,tmp_ptr);
   tmp_mark->mark_core=sac_core->core_count;
   tmp_mark->mark_count=status.max_mark;
   tmp_mark->next_core=sac_core;

   tail_mark.next_mark->next_mark=tmp_mark;
   tmp_mark->next_mark=&tail_mark;
   tail_mark.next_mark=tmp_mark;

   status.max_mark++;
   if(sort.up_down)
     i++;
   else
     i--;
 }
return;
}



/*
 *
 *  void SACDRT_QSORT(...)
 *  void SACDRT_SHELL(...)
 *  void SACDRT_CMP(...)
 *  void SACDRT_SWAP(...)  these are the functions for sorting an existing
 *                         list of marked objects. the shell sort will need
 *                         about 25sec for 10600 objects on a slow computer 
 *                         (386DX25) the quick sort works only faster up to
 *                         2000 objects. then it is abnormally slow (still
 *                         don't know why, may be sacdrt_cmp is the reaseon).
 *                         you can switch between the 2 sorting functions be-
 *                         fore you start a sort. when you save your config
 *                         to the init file, the current sort-function is 
 *                         saved, too.
 *                         The following functions are from K&R (with some
 *                         small changes).
 *
 */
void sacdrt_qsort(struct core_list *v[],int left,int right)
{
int i,last;

 if(left>=right)
   return;
 sacdrt_swap(v,left,(left+right)/2);
 last=left;
 for(i=left+1;i<=right;i++)
    if(sacdrt_cmp(v[i],v[left])<0)
      sacdrt_swap(v,++last,i);
 sacdrt_swap(v,left,last);
 sacdrt_qsort(v,left,last-1);
 sacdrt_qsort(v,last+1,right);
return;
}



void sacdrt_swap(struct core_list *v[],int i,int j)
{
struct core_list *tmp;
 tmp=v[i];
 v[i]=v[j];
 v[j]=tmp;
return;
}



int sacdrt_cmp(struct core_list *s1,struct core_list *s2)
{
char ptr1[MAXPATHLEN];
char ptr2[MAXPATHLEN];

 switch(sort.sort_to){
   case sort_name: if(s1->mark_flag==use_name)
                     strcpy(ptr1,parse_core(s1->sac_line,8));
                   else
                     strcpy(ptr1,parse_core(s1->sac_line,9));
                   if(s2->mark_flag==use_name)
                     strcpy(ptr2,parse_core(s2->sac_line,8));
                   else
                     strcpy(ptr2,parse_core(s2->sac_line,9));
                   break;
   case sort_ra:   strcpy(ptr1,parse_core(s1->sac_line,4));
                   strcpy(ptr2,parse_core(s2->sac_line,4));
                   break;
   case sort_mag:  strcpy(ptr1,parse_core(s1->sac_line,6));
                   strcpy(ptr2,parse_core(s2->sac_line,6));
                   break;
   case sort_decl: strcpy(ptr1,parse_core(s1->sac_line,5));
                   strcpy(ptr2,parse_core(s2->sac_line,5));
                   break;
   case sort_type: strcpy(ptr1,parse_core(s1->sac_line,2));
                   strcpy(ptr2,parse_core(s2->sac_line,2));
                   break;
   case sort_con:  strcpy(ptr1,parse_core(s1->sac_line,3));
                   strcpy(ptr2,parse_core(s2->sac_line,3));
                   break;
 }
return (strcmp(ptr1,ptr2));
}



void sacdrt_shell(struct core_list *v[],int n)
{
int gap,i,j;
struct core_list *tmp;

 for(gap=n/2;gap>0;gap/=2){
   if(config.curses){
      mvwprintw(message_win,1,13,"%i  ",gap);
      wrefresh(message_win);
   }
   for(i=gap;i<n;i++)
     for(j=i-gap;j>=0&&(sacdrt_cmp(v[j],v[j+gap])>0);j-=gap){
       tmp=v[j];
       v[j]=v[j+gap];
       v[j+gap]=tmp;
     }
 }
return;
}
