/*
 * SACDRT Version 3.1 SAC-Database-Reader for DeepSky Objects
 * Module MAIN.C is written by Sven van der Meer for SACDRT.
 *
 *  Copyright (C) 1994 Lars Hagen & Sven van der Meer
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *  Problems or comments to hagenl@cs.tu-berlin.de
 *
 */

#include <stdlib.h>
#include <signal.h>
#include "sacdrt.h"
#include "database.h"
#include "layout.h"
#ifdef XSAC
  #include <X11/Xlib.h>
#endif
#ifdef MSW_SAC
  #include <windows.h>
#endif

enum loop okloop;	  /* flags for while		  		     */

void main(int argc, char *argv[])
{
char tmp_ptr[30];
int ret=TRUE,ret2=FALSE;
struct mark_list *tmp_mark;

#ifdef XSAC
  Display     *dpy;      /* for the test, if there is a X-Server running     */
#endif

 head_core.next=&tail_core;       /* initialize the main datas               */
 tail_core.next=&head_core;
 status.next_core=&tail_core;
 cs_values.name_to_use=use_short;

 head_mark.next_mark=&tail_mark;
 tail_mark.next_mark=&head_mark;

 config.current_line=1;
 config.current_page=1;
 config.parse=TRUE;
 config.print_to_use=commandline;
 config.term=FALSE;
 config.sort_mode=TRUE;
 config.base_version=v52;
 config.print_fop=FALSE;
 config.print_mode=TRUE;

 status.core_current=1;
 status.mark_current=1;
 status.max_core=1;
 status.max_mark=1;
 status.clas=FALSE;

 cs_values.cs_default_val=TRUE;
 cs_values.mark_con=0;
 cs_values.mark_name=0;
 cs_values.mark_type=0;

 strcpy(cs_values.min_mag,CS_MIN_MAG);
 strcpy(cs_values.max_mag,CS_MAX_MAG);
 strcpy(cs_values.min_ra,CS_MIN_RA_VAL);
 strcpy(cs_values.max_ra,CS_MAX_RA_VAL);
 strcpy(cs_values.min_decl,CS_MIN_DECL_VAL);
 strcpy(cs_values.max_decl,CS_MAX_DECL_VAL);
 status.time=(char *)malloc(40);

 sort.ra=TRUE;
 sort.up_down=TRUE;

 read_rc_file();		     /* check .sacdrtrc file for entries    */
 command_line(argc,argv);            /* check commandline for entries       */
 open_file();                        /* try to open the database file       */

#ifndef MSDOS
 signal(SIGINT, SIG_IGN);	     /* if there is a real operating system */
 signal(SIGHUP,SIG_IGN);	     /* we use signal handlers              */
 signal(SIGQUIT, SIG_IGN);
 signal(SIGTSTP, SIG_IGN);
 signal(SIGSTOP, SIG_IGN);
 signal(SIGTERM, sac_end);
#endif

#ifdef XSAC
 if (((dpy=XOpenDisplay(NULL))==NULL)||!config.term){
#endif
#ifdef MSW_SAC
					   /* we still don't like this      */
#endif

   config.curses=TRUE;			   /* now defenitily in term mode   */
   open_layout();                          /* layout to the screen          */

   message_window("   Initializing",normal);
   initialize();                           /* initialize the data strucures */
   close_message_window(normal);

   input(0,output_first);                  /* first object on screen        */

   okloop=YES;
   while(okloop){                          /* now check the keyboard        */
     switch (getch()){                     /* loop up to end                */
       case 'u':
       case 'U':
       case KEY_UP:    input(1,output_prev);
                       break;
       case 'd':
       case 'D':
       case KEY_DOWN:  input(1,output_next);
                       break;
       case KEY_A1:
       case 'b':
       case 'B':
       case KEY_HOME:  input(status.max_core,output_prev);
                       break;
       case KEY_C1:
       case 'e':
       case 'E':
       case KEY_END:   input(status.max_core,output_next);
                       break;
       case KEY_A3:
       case '-':
       case KEY_PPAGE: input(100,output_prev);
                       break;
       case KEY_C3:
       case '+':
       case KEY_NPAGE: input(100,output_next);
                       break;
       case 'Q':
       case 'q':       okloop=NO;
                       break;
       case 'H':
       case 'h':       help();
                       break;
       case 'I':
       case 'i':       info();
                       break;


       case 'S':
       case 's':       str2lower(tmp_ptr,findwindow());
                       if (strlen(tmp_ptr)<1)
                         break;
                       message_window("   searching...",normal);
                       ret2=FALSE;
		       if ((ret=handle_objects(search_name,nothing,nothing,tmp_ptr))>0){
                         if(config.filter){
                           tmp_mark=&head_mark;
                           while(tmp_mark!=&tail_mark){
                             if (tmp_mark->mark_core==ret){
                               input(ret,search_found);
                               ret2=TRUE;
                               if (ret)
                                 status.mark_current=tmp_mark->mark_count;
                               break;
                             }
                             tmp_mark=tmp_mark->next_mark;
                           }
                         }
                         else{
			   input(ret,search_found);
			   ret2=TRUE;
                         }
		       }
		       if(!ret||!ret2){
                         message_window(" Object not found",normal);
                         getch();
                         close_message_window(normal);
		       }
		       close_message_window(normal);
                       break;
       case 'T':
       case 't':       if(status.max_mark<2){
                         message_window("No Objects marked!",normal);
                         getch();
                         close_message_window(normal);
                       }
                       else
                         ret=show_marked();
                         if(!ret)
                           input(status.max_core,output_prev);
                       break;
       case 'M' :
       case 'm':       if(!config.filter){
                         message_window("  Object marked",normal);
                         napms(300);
                         close_message_window(normal);
		         insert_marked(use_name);
		         input(1,output_next);
                       }
                       break;
       case 'W':
       case 'w':       if ((ret=write_rc_file()))
                         message_window("   Config saved",normal);
		       else
			 message_window("ERROR-not saved",normal);
                       napms(300);
                       close_message_window(normal);
                       break;
	case 'C':
	case 'c':      ret=complex_search();
                       if(ret)
                         input(status.max_core,output_prev);
	    	       break;
        case 'f':
        case 'F':      if(status.max_mark<2){
                         message_window("No Objects marked!",normal);
                         getch();
                         close_message_window(normal);
                       }
                       else{ 
                         if(config.filter)
                           sac_filter(OFF);
                         else
                           sac_filter(ON);
                         input(status.max_core,output_prev);
                       }
                       break;
	case 'O':
	case 'o':      if(config.parse)
                         config.parse=FALSE;
                       else
                         config.parse=TRUE;
		       status.clas=FALSE;
		       input(status.core_current,search_found); 
       default :       break;
     }
   }
   sac_end();
#ifdef XSAC
 }
 else{
   XCloseDisplay(dpy);                  /* if there is a X-Server running and */
                                        /* wx compiled in, start the X-App-   */
                                        /* liction instead of the shell       */
   fprintf(stderr,"sacdrt: no X-version compiled ... exit\n");
   exit(1);
 }
#endif
#ifdef MSW_SAC
 }
 else{
   fprintf(stderr,"sacdrt: no MS-Windows version compiled ... exit\n");
   exit(1);
 }
#endif
}
