/*
 * SACDRT Version 3.1 SAC-Database-Reader for DeepSky Objects
 * Header LAYOUT.H is written by Sven van der Meer for the SACDRT.
 *
 *  Copyright (C) 1994 Lars Hagen & Sven van der Meer
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *  Problems or comments to hagenl@cs.tu-berlin.de
 *
 */

#define LAYOUT
  #include "object_data.h"           /* for complex_search and cs_do_search */
  #include "const_data.h"            /* for complex_search and cs_do_search */
  #include "type_data.h"             /* for complex_search and cs_do_search */
#undef LAYOUT


WINDOW *stdscr;                    /* standrt screen for ncurses            */
WINDOW *screen_win;                /* window for border colormanipulations  */
WINDOW *sac_win;                   /* main window in sac                    */
WINDOW *message_win;               /* message window (not_found etc)        */
WINDOW *find_win;                  /* find window                           */
WINDOW *sac_sub_win;               /* sub win for *descr, *notes and *class */

#define SAC_START_ROW (int) ((LINES-28)/2) /* for center the sacdrt in the  */
#define SAC_START_COL (int) ((COLS-80)/2)  /* middle of the screen          */

#if TERMINFO_COMPILED
  #define SAC_VLINE     ACS_VLINE
  #define SAC_HLINE     ACS_HLINE
  #define SAC_VRIGHT    ACS_RTEE
  #define SAC_VLEFT     ACS_LTEE
  #define SAC_ULCORNER  ACS_ULCORNER
  #define SAC_LLCORNER  ACS_LLCORNER
  #define SAC_URCORNER  ACS_URCORNER
  #define SAC_LRCORNER  ACS_LRCORNER
#else
  #define SAC_VLINE    '|'
  #define SAC_HLINE    '-'
  #define SAC_VRIGHT   '+'
  #define SAC_VLEFT    '+'
  #define SAC_ULCORNER '+'
  #define SAC_LLCORNER '+'
  #define SAC_URCORNER '+'
  #define SAC_LRCORNER '+'
#endif

#define SAC_PR_VLINE   '|'                 /* vert box ch for printing      */
#define SAC_PR_HLINE   '-'                 /* hor  box ch for printing      */
#define SAC_PR_VRIGHT  '+'                 /* right vert box for printing   */
#define SAC_PR_VLEFT   '+'                 /* left  vert box for printing   */


#define FG_COLOR          COLOR_BLUE       /* STD Foreground Color          */
#define BG_COLOR          COLOR_WHITE      /* STD Background Color          */
#define INFO_FG_COLOR     COLOR_WHITE      /* Info Win Foreground Color     */
#define INFO_BG_COLOR     COLOR_RED        /* Info Win Background Color     */
#define DATA_FG_COLOR     COLOR_BLACK      /* Data Forground Color          */
#define DATA_BG_COLOR     COLOR_WHITE      /* Data Backgroundcolor          */
#define INPUT_FG_COLOR    COLOR_BLUE       /* Input Foreground Color        */
#define INPUT_BG_COLOR    COLOR_WHITE      /* Input Background COLOR        */
#define SCREEN_FG_COLOR   COLOR_WHITE      /* White labels in the Red frame */
#define SCREEN_BG_COLOR   COLOR_RED        /* Red Frame around sac_win      */
#define CS_FG_COLOR       COLOR_BLUE       /* Blue chars for complex search */
#define CS_BG_COLOR       COLOR_RED        /* Red background for the same   */ 
					   /* b&w definitions are in        */
                                           /* cs_set_color() from layout.c  */
#define BW_EDIT           A_NORMAL
#define BW_ACTIVE         A_UNDERLINE|A_REVERSE
#define BW_NORMAL         A_REVERSE
#define BW_SCROLL_MARK    A_NORMAL|A_BOLD
#define BW_SCROLL_NORMAL  A_NORMAL


unsigned int scale;                        /* 4 counter for scroll region   */
unsigned int mcount;                       /* in marked window, cs_search   */
unsigned int current;                      /* and sort_window               */
unsigned int ende;
         
enum cs_show {cs_type,cs_con,cs_name,cs_mag_min,cs_mag_max,
              cs_ra_min,cs_ra_max,cs_decl_min,cs_decl_max,cs_search,
              cs_invert,cs_default};




  /* functions in layout.c */

extern void open_layout();
extern void close_layout();
extern void info();
extern void ending_message();
extern void output(char *, char *, char *, char *, char *, char *, char *,
                   char *, char *, char *, char *, char *, char *, char *,
                   char *,char *,char *,char *);
extern void print_page(char *, char *, char *, char *, char *, char *, char *,
                       char *, char *, char *, char *, char *, char *, char *,
                       char *, char *, char *, char *, int);
extern void message_window(char *,int);
extern void close_message_window(int);
extern char *findwindow();
extern void sac_exit(int, char *);
extern void help();
extern int  show_marked();
extern void close_window();
extern void usleep(int);
extern void line(WINDOW *,int);
extern void clear_line (int, int, int, WINDOW *);
extern int  scroll_marked(int);
extern int  display_marked(WINDOW *);
extern int  str2lower(char *,char *);
extern void break_line(char *);
extern int  complex_search();
extern void cs_show(WINDOW*,int);
extern void cs_set_color(int,WINDOW*);
extern void cs_help();
extern char *cs_input(int,int,int,int,int,WINDOW*,int);
extern void sac_filter(int);
extern void sort_window();
extern void sort_show(WINDOW*,int);
extern void print_window();
extern void print_show(WINDOW*,int);
extern void sacdrt_werase(WINDOW*);
