/*
 * SACDRT Version 3.1 SAC-Database-Reader for DeepSky Objects
 * Module INPUT.C is written by Sven van der Meer for the SACDRT.
 *
 *  Copyright (C) 1994 Lars Hagen & Sven van der Meer
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *  Problems or comments to hagenl@cs.tu-berlin.de
 *
 */

#include <string.h>
#include <stdlib.h>
#include "sacdrt.h"
#include "database.h"
#include "layout.h"


FILE *file_ptr;                 /* pointer to the input file  */
void insert_sac(char *,int);
void delete_waste(char *,char *);


/*
 *  int INPUT(int, int) input works for all other function, which need
 *                      parsed information from the database.
 *                      NEW_CURRENT indicates the new offset, if there it is
 *                      new needed (searching and printing will call this)
 *                      TO_DO tells input what todo. see the switch for
 *                      possible calls
 *
 */
int input(int new_current, int to_do)
{
static char name[80], name_info[80], other[80], type[80], con[80], ra[10],
      dec[10], mag[80], u2000[30], tirion[30], descr[500], size[20],
      clas[200], nsts[20], brstr[10], notes[200], source[100], subr[5];

int i=0, j=0, ret=TRUE;
char *tmp_ptr;
char help_ptr[MAXPATHLEN];
struct core_list *sac_core=&head_core;
struct mark_list *tmp_mark=&head_mark;
char c;

 switch(to_do){
   case output_first:	     sac_core=sac_core->next;
			     status.core_current=sac_core->core_count;
	                     break;
   case output_next: 	     if(!config.filter){
                               if (status.core_current+new_current<status.max_core)
                                 i=status.core_current+new_current;
                               else
                                 i=status.max_core;
                             }
                             else{
                               if (status.mark_current+new_current<status.max_mark-1)
                                 i=status.mark_current+new_current;
                               else
                                 i=status.max_mark-1;
			       while (tmp_mark->mark_count!=i)
				 tmp_mark=tmp_mark->next_mark;
			       i=tmp_mark->mark_core;
			       status.mark_current=tmp_mark->mark_count;
                             }
                             while (sac_core->core_count!=i)
                               sac_core=sac_core->next;
                             status.core_current=sac_core->core_count;
                             break;
   case output_prev:         if(!config.filter){
                               if (status.core_current-new_current>0)
	                         i=status.core_current-new_current;
		 	       else
			         i=1;
                             }
                             else{
                               if (status.mark_current-new_current>0)
                                 i=status.mark_current-new_current;
                               else
                                 i=1;
                               while (tmp_mark->mark_count!=i)
                                 tmp_mark=tmp_mark->next_mark;
                               i=tmp_mark->mark_core;
                               status.mark_current=tmp_mark->mark_count;
                             }
			     while (sac_core->core_count!=i)
                               sac_core=sac_core->next;
                             status.core_current=sac_core->core_count;
                             break;
   case file_current:
   case print_current:       sac_core=status.next_core;
                             break;
   case search_found:        while (sac_core->core_count!=new_current)
                               sac_core=sac_core->next;
                             status.core_current=sac_core->core_count;
			     break;
   default:                  break;
 }
 status.next_core=sac_core;

 i=0;
 tmp_ptr=sac_core->sac_line;

 while(i<16){
   c=*tmp_ptr++;
   if (c=='"'||c=='\0'||c==0x0a||c==0x0d){
     help_ptr[j++]='\0';
     if(config.base_version==v52){
       switch(i){
         case  0: strcpy((char *)name,(const char *)help_ptr);
                  break;
         case  1: strcpy((char *)other,(const char *)help_ptr);
                  break;
         case  2: strcpy((char *)type,(const char *)help_ptr);
                  break;
         case  3: strcpy((char *)con,(const char *)help_ptr);
                  break;
         case  4: strcpy((char *)ra,(const char *)help_ptr);
                  break;
         case  5: strcpy((char *)dec,(const char *)help_ptr);
                  break;
         case  6: strcpy((char *)mag,(const char *)help_ptr);
                  break;
         case  7: strcpy((char *)u2000,(const char *)help_ptr);
                  break;
         case  8: strcpy((char *)tirion,(const char *)help_ptr);
                  break;
         case  9: strcpy((char *)descr,(const char *)help_ptr);
                  break;
         case 10: strcpy((char *)size,(const char *)help_ptr);
                  break;
         case 11: strcpy((char *)clas,(const char *)help_ptr);
                  break;
         case 12: strcpy((char *)nsts,(const char *)help_ptr);
                  break;
         case 13: strcpy((char *)brstr,(const char *)help_ptr);
                  break;
         case 14: strcpy((char *)notes,(const char *)help_ptr);
                  break;
         case 15: strcpy((char *)source,(const char *)help_ptr);
                  break;
       }
     }
     else{
       switch(i){
         case  0: strcpy((char *)name,(const char *)help_ptr);
                  break;
         case  1: strcpy((char *)other,(const char *)help_ptr);
                  break;
         case  2: strcpy((char *)type,(const char *)help_ptr);
                  break;
         case  3: strcpy((char *)con,(const char *)help_ptr);
                  break;
         case  4: strcpy((char *)ra,(const char *)help_ptr);
                  break;
         case  5: strcpy((char *)dec,(const char *)help_ptr);
                  break;
         case  6: strcpy((char *)mag,(const char *)help_ptr);
                  break;
         case  7: strcpy((char *)subr,(const char *)help_ptr);
                  break;
         case  8: strcpy((char *)u2000,(const char *)help_ptr);
                  break;
         case  9: strcpy((char *)tirion,(const char *)help_ptr);
                  break;
         case 10: strcpy((char *)descr,(const char *)help_ptr);
                  break;
         case 11: strcpy((char *)size,(const char *)help_ptr);
                  break;
         case 12: strcpy((char *)clas,(const char *)help_ptr);
                  break;
         case 13: strcpy((char *)nsts,(const char *)help_ptr);
                  break;
         case 14: strcpy((char *)brstr,(const char *)help_ptr);
                  break;
         case 15: strcpy((char *)notes,(const char *)help_ptr);
                  break;
       }
     }
     i++; j=0;
   }
   else{
     help_ptr[j++]=c;
   }
 } 

 parse_name(name_info, name);
 if (config.parse){
   parse_type(type); 
   parse_con(con); 
   parse_ra (ra);
   parse_dec(dec);
   parse_mag(mag,FALSE);
   parse_class(clas);
   parse_descr(descr);
   parse_brstr(brstr);
   parse_nsts(nsts);
   parse_notes(notes);
   parse_size(size);
   if(config.base_version==v52)
     parse_source(source);
   if(config.base_version==v6)
     parse_mag(subr,TRUE);
 }

 if ((to_do==output_first) || (to_do==output_next) || 
     (to_do==output_prev)  || (to_do==search_found)){
   output(name, name_info, other, type, con,
          ra, dec, mag, u2000, tirion,
          descr, size, clas, nsts,
          brstr, notes, source, subr);
 }

 if (to_do==print_current){
   print_page(name, name_info, other, type, con,
              ra, dec, mag, u2000, tirion,
              descr, size, clas, nsts,
              brstr, notes, source, subr, print_current);
 }

 if (to_do==file_current){
   print_page(name, name_info, other, type, con,
              ra, dec, mag, u2000, tirion,
              descr, size, clas, nsts,
              brstr, notes, source, subr, file_current);
 }
return ret;
}



/*
 * void SAC_END()  is called from main when the user wants to leave the program
 *                 close the files, end curses end then exit 0
 *
 */ 
void sac_end()
{
 message_window("   Cleaning up",normal);
 delete_all_marked();
 delete_core_list();
 if(config.rc_input!=NULL)   free(config.rc_input);
 if(config.rc_output!=NULL)  free(config.rc_output);
 if(config.rc_printer!=NULL) free(config.rc_printer);
 free(status.time);
 close_message_window(normal);
 close_layout();
 ending_message();
 exit (0);
}



/*
 * void OPEN_FILE()  opens the input file for function input(..). at first
 *                   the file given from the init file will be used, then
 *                   the file given from command-line will be used, then
 *                   the file specified in the environment SACBASE_INPUT
 *                   and at last the file SAC.TXT in the current working
 *                   directory. When there are errors, a aproporiate message
 *                   will be printed to stderr and the sacdrt terminates
 *
 */
void open_file()
{
char *enviroment=NULL;

 if (config.input!=NULL)
   file_ptr = fopen(config.input, "r");
 else if (config.rc_input!=NULL)
   file_ptr = fopen(config.rc_input, "r");
 else if ((enviroment = getenv(SAC_DEFAULT_ENV_INPUT)) != NULL)
   file_ptr = fopen(enviroment, "r");
 else
   file_ptr = fopen(SAC_DEFAULT_INPUT, "r");
  
 if (!file_ptr){
   fprintf(stderr,"sac: unable to open file -> ");
   if (config.input!=NULL)
     fprintf(stderr,"%s given from command-line\n",config.input);
   if (config.rc_input!=NULL)
     fprintf(stderr,"%s given from .sacdrt file\n",config.rc_input);
   else if (enviroment!=NULL)
     fprintf(stderr,"%s given from environment\n",enviroment);
   else
     fprintf(stderr,"%s no such file in current directory\n",SAC_DEFAULT_INPUT);
   exit (1);
 }
 if (getc(file_ptr)=='"')
   config.base_version=v6;
 else
   config.base_version=v52;
 fseek(file_ptr,0,SEEK_SET);
return;
}



/*
 * void INITIALIZE()       when a file opened, this function will build the
 *			   structure core_list.
 *			   Every entry in core_list is one line from the 
 *			   database. So we have the whole database as core
 *			   in the memory (this saves a lot of time when 
 *			   searching, but needs about 2meg for running the
 *			   sacdrt).
 *
 */
void initialize()
{
char *tmp_ptr=(char *)malloc(MAXPATHLEN); 
int i=0;

 head_core.mark_flag=FALSE;
 while(fgets(tmp_ptr,MAXPATHLEN,file_ptr)&&++i)
   insert_sac(tmp_ptr,i);

 status.max_core=i;

 free(tmp_ptr);
 fclose(file_ptr);
return;
}



/*
 *  void INSERT_SAC(char*,int)  called from initialize to insert the new object
 *                              in the existing list
 *                              DELETE_WASTE is used to delete '",' from
 *                              version 6.
 *
 */
void insert_sac(char *tmp_ptr,int count)
{
struct core_list *tmp_core;
char *tmp_line;

 tmp_core=(struct core_list *)malloc(sizeof(struct core_list));
 tmp_line=(char *)malloc(strlen(tmp_ptr)+1);
 delete_waste(tmp_line,tmp_ptr);

 tmp_core->sac_line=(char *)malloc(strlen(tmp_line)+1);
  if (tmp_core==NULL)
   sac_exit(7," in function insert_sac");
 strcpy((char *)tmp_core->sac_line,(const char *)tmp_line);

 tmp_core->core_count=count;
 tmp_core->mark_flag=FALSE;

 tail_core.next->next=tmp_core;
 tmp_core->next=&tail_core;
 tail_core.next=tmp_core;

 free(tmp_line);
return;
}



void delete_waste(char *ptr1,char *ptr2)
{
 if(config.base_version==v6)
   ptr2++;
 while (*ptr2!='\0'){
   if(*ptr2=='"'){
     ptr2++;
     if(*ptr2==',')
       ptr2++;
     else
       ptr2--;
   }
   *ptr1++=*ptr2++;
 }
return;
}
