/*
 * SACDRT Version 3.1 SAC-Database-Reader for DeepSky Objects
 * Header INITRC.H is written by Hellmuth Michaelis for CWISH
 *                    (tnx for the permissions his code)
 *                    newwritten by Sven van der Meer for the SACDRT.
 *
 *  Copyright (C) 1994 Lars Hagen & Sven van der Meer
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *  Problems or comments to hagenl@cs.tu-berlin.de
 *
 */

#include <string.h>
#include <stdlib.h>
#include <stdio.h>
#include <ctype.h>
#include "database.h"

#ifndef MSDOS
  #define SACDRTRC	".sacdrtrc"	/* sacdrt config file */
  #define ENVHOME	getenv("HOME")  /* in a real os       */
#else
  #define SACDRTRC	"sacdrt.ini"    /* and in msdos       */
  #define ENVHOME	".\\"
#endif


#define RC_TERM_MODE	"term_mode"	/* on or off */
#define RC_PRINT_ASCII  "print_ascii"
#define RC_PRINT_PS	"print_ps"
#define RC_DO_PARSING	"parsing"
#define RC_SORT_MODE    "shell_sort"    /* on=shell sort, off=quick sort  */
#define RC_PRINT_MODE   "print_mode"    /* on=all, off=array only         */
#define RC_PRINT_FOP    "file_or_printer" /* on =write to file            */
                                          /* off=spool to printer         */

#define	RC_OUTPUT_FILE	"output_file"   /* string values used instead of  */
#define	RC_INPUT_FILE	"input_file"    /* default. when there are values */
#define RC_PRINTER	"printer"       /* in the command line, they will */
#define RC_MAX_LINES	"max_lines"     /* be used instead of this        */

#define RC_ON  "on"
#define RC_OFF "off"

extern void onoff2int(char *string, int *var);
extern char *int2onoff(int *var);
extern void optstr(char *string, char dest[]);
