/*
 * SACDRT Version 3.1 SAC-Database-Reader for DeepSky Objects
 * Module INITRC.C is written by Hellmuth Michaelis for CWISH
 *                    (tnx for the permissions his code)
 *                    modified by Sven van der Meer for the SACDRT.
 *
 *  Copyright (C) 1994 Lars Hagen & Sven van der Meer
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *  Problems or comments to hagenl@cs.tu-berlin.de
 *
 */

#include "initrc.h"



/*
 * void READ_RC_FILE()  get the entries in $HOME/.sacdrtrc file and use
 *			these entries instead of other parameters.
 *			if there are arguments in the commandline, these
 *			arguments will be used!!!
 *
 */
void read_rc_file()
{
 char buffer[MAXPATHLEN+1];
 FILE *fp;
 char *tmpstr;

 sprintf(buffer,"%s/%s",ENVHOME,SACDRTRC);

 if ((fp=fopen(buffer,"r"))==NULL)
   return;

 while ((fgets(buffer,MAXPATHLEN,fp))!=NULL){
   if (buffer[0]=='#'||buffer[0] ==' '||buffer[0]=='\t'){ 
     continue;
   }
   else if (!strncmp(buffer,RC_TERM_MODE,strlen(RC_TERM_MODE))){
     onoff2int(buffer,&config.term);
   }
   else if (!strncmp(buffer,RC_PRINT_ASCII,strlen(RC_PRINT_ASCII))){ 
     onoff2int(buffer,&config.rc_asc_print);
     config.print_to_use=rc_file;
   }
   else if (!strncmp(buffer,RC_DO_PARSING,strlen(RC_DO_PARSING))){
     onoff2int(buffer,&config.parse);
   }
   else if (!strncmp(buffer,RC_SORT_MODE,strlen(RC_SORT_MODE))){
     onoff2int(buffer,&config.sort_mode);
   }

   else if (!strncmp(buffer,RC_PRINT_MODE,strlen(RC_PRINT_MODE))){
     onoff2int(buffer,&config.print_mode);
   }
   else if (!strncmp(buffer,RC_PRINT_FOP,strlen(RC_PRINT_FOP))){
     onoff2int(buffer,&config.print_fop);
   }

   else if (!strncmp(buffer,RC_PRINT_PS,strlen(RC_PRINT_PS))){
     onoff2int(buffer,&config.rc_ps_print);
     config.print_to_use=rc_file;
   }
   else if (!strncmp(buffer,RC_INPUT_FILE,strlen(RC_INPUT_FILE))){ 
     config.rc_input=(char *)malloc(MAXPATHLEN);
     optstr((char *)buffer,config.rc_input);			
   }
   else if (!strncmp(buffer,RC_OUTPUT_FILE,strlen(RC_OUTPUT_FILE))){
     config.rc_output=(char *)malloc(MAXPATHLEN);
     optstr((char *)buffer,config.rc_output);
   }
   else if (!strncmp(buffer,RC_MAX_LINES,strlen(RC_MAX_LINES))){
     tmpstr=(char *)malloc(MAXPATHLEN);
     optstr((char *)buffer,tmpstr);
     config.max_lines=atoi(tmpstr);
     free(tmpstr);
   }
   else if (!strncmp(buffer,RC_PRINTER,strlen(RC_PRINTER))){
     config.rc_printer=(char *)malloc(MAXPATHLEN);
     optstr((char *)buffer,config.rc_printer);
   }
 }
 if (config.rc_asc_print==config.rc_ps_print){
   fprintf(stderr,"sac: do we like to print ascii or ps? (-a or -p)\n");
   fprintf(stderr,"     you have said both in $HOME/.sacdrtrc\n");
   exit (1);
 }
return;
}



/*
 * void ONOFF2INT(char *,char *)  set the values wich are only on ore off
 *
 */
void onoff2int(char *string, int *var)
{
char *ptr;
	
 if ((ptr=strchr(string,'='))==NULL)
   return;
 ptr++;

 if (!strncmp(ptr,RC_ON,strlen(RC_ON))){
   *var=TRUE;
 }
 else if (!strncmp(ptr,RC_OFF,strlen(RC_OFF))){
   *var=FALSE;
 }
}



/*
 * void OPTSTR (char *,char *)  optimize a string. delete all spaces and 
 *                              hashmarks
 *
 */
void optstr(char *string, char *dest)
{
  if ((string=strchr(string,'='))==NULL)
    return;
  string++;
  while(*string&&(*string!='#')&&(isprint(*string))&&(!isspace(*string)))
    *dest++=*string++;
  *dest++='\0';
}



/*
 * void WRITE_RC_FILE()  use runtime values to write it in the file in 
 *                       $HOME/.sacdrtrc file and use
 *
 */
int write_rc_file()
{
char buffer[MAXPATHLEN+1];
FILE *fp;

 sprintf(buffer,"%s/%s",ENVHOME,SACDRTRC);

 if ((fp=fopen(buffer,"w"))==NULL)
   return FALSE;

 fprintf(fp,"# %s config file (vdmeer@cs.tu-berlin.de)\n# automatically generated\n\n",config.binary_name);

 fprintf(fp,"%s=%s\t\t\t#same as -t in commandline\n",RC_TERM_MODE,int2onoff(&config.term));
 fprintf(fp,"%s=%s\t\t\t#same as -a in commandline\n",RC_PRINT_ASCII,int2onoff(&config.asc_print));
 fprintf(fp,"%s=%s\t\t\t#same as -p in commandline\n",RC_PRINT_PS,int2onoff(&config.ps_print));
 fprintf(fp,"%s=%s\t\t\t#same as -O in commandline\n",RC_DO_PARSING,int2onoff(&config.parse));
 fprintf(fp,"%s=%s\t\t\t#specifies the sort_mode to use\n",RC_SORT_MODE,int2onoff(&config.sort_mode));
 fprintf(fp,"\t\t\t\t#on=shell sort, off=quick sort\n");
 fprintf(fp,"%s=%s\t\t\t#specifies the print_mode to use\n",RC_PRINT_MODE,int2onoff(&config.print_mode));
 fprintf(fp,"\t\t\t\t#on=print all, off=print array only\n");
 fprintf(fp,"%s=%s\t\t#specifies where to write to\n",RC_PRINT_FOP,int2onoff(&config.print_fop));
 fprintf(fp,"\t\t\t\t#on=write to file, off=spool to printer\n\n");


 if(config.input!=NULL)
   fprintf(fp,"%s=%s\n",RC_INPUT_FILE,config.input); 
 else if(config.rc_input!=NULL)
   fprintf(fp,"%s=%s\n",RC_INPUT_FILE,config.rc_input);
 else
   fprintf(fp,"%s=%s\n",RC_INPUT_FILE,getenv(SAC_DEFAULT_ENV_INPUT));
 if(config.output!=NULL)
   fprintf(fp,"%s=%s\n",RC_OUTPUT_FILE,config.output);
 else if(config.rc_output!=NULL)
   fprintf(fp,"%s=%s\n",RC_OUTPUT_FILE,config.rc_output);
 else
   fprintf(fp,"%s=%s\n",RC_OUTPUT_FILE,getenv(SAC_DEFAULT_ENV_OUTPUT));
 fprintf(fp,"%s=%i\t\t\t#specifies the MAX LINES per page for printing\n",RC_MAX_LINES,config.max_lines);
 if(config.printer!=NULL)
   fprintf(fp,"%s=%s\t\t\t#specifies the printer to use\n",RC_PRINTER,config.printer);
 else
   fprintf(fp,"%s=%s\t\t\t#specifies the printer to use\n",RC_PRINTER,config.rc_printer);
 fprintf(fp,"\t\t\t\t#for additional help, see the manual page.");

 fclose (fp);
return TRUE;
}



/*
 * void INT2ONOFF(char *,char *)  set the values wich are only on ore off
 *
 */
char *int2onoff(int *var)
{
 if (*var==TRUE){
   return(RC_ON);
 }
 else if (*var==0){
   return(RC_OFF);
 }
return "ERROR";
}
