/*
 * SACDRT Version 3.1 SAC-Database-Reader for DeepSky Objects
 * Module HANDLE_OBJECTS.C is written by Sven van der Meer for the SACDRT.
 *
 *  Copyright (C) 1994 Lars Hagen & Sven van der Meer
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *  Problems or comments to hagenl@cs.tu-berlin.de
 *
 */

#include <stdlib.h>
#include <string.h>
#include <ctype.h>
#include "sacdrt.h"     /* includes stdio.h   */
#include "database.h"   /* includes ncurses.h */
#include "layout.h"


/*
 *
 *  HANDLE_OBJECTS (int,int,char *, int)  function to handle with the objects
 *                                        calls input with the needed parameters
 *			   	          is called from main, layout, 
 *				          designed to make these functions
 *				          independent from changes in the data
 *				          structures.
 *
 */
int handle_objects(int todo,int search,int todo2,char *search_core)
{
int print,ret=TRUE,tmp_cur;
struct mark_list *tmp_mark;
struct core_list *tmp_core;
struct core_list *old_core;
char *name_ptr;
char *other_ptr;
char tmp_ptr[MAXPATHLEN];

 switch(todo){
   case file_current:   tmp_mark=head_mark.next_mark;
                        old_core=status.next_core;
                        tmp_cur=status.mark_current;
                        while(tmp_mark!=&tail_mark){
                          status.next_core=tmp_mark->next_core;
                          status.mark_current=tmp_mark->mark_count;
                          input(tmp_mark->mark_core,file_current);
                          if ((getch()=='q')||(getch()=='Q'))
                            break;
                          tmp_mark=tmp_mark->next_mark;
                        }
                        status.next_core=old_core;
                        status.mark_current=tmp_cur;
                        config.current_line=1;
                        config.current_page=1;
                        break;
   case print_current:  old_core=status.next_core;
                        tmp_cur=status.mark_current;
                        print=1;
                        tmp_mark=head_mark.next_mark;
                        while(tmp_mark!=&tail_mark){
			  status.next_core=tmp_mark->next_core;
                          status.mark_current=tmp_mark->mark_count;
                          input(tmp_mark->mark_core,print_current);
                          if ((getch()=='q')||(getch()=='Q')){
                            print=0;
                            break;
                          }
                          tmp_mark=tmp_mark->next_mark;
                        }
                        status.next_core=old_core;
                        status.mark_current=tmp_cur;

                        if (print==1)
                          do_printing();
                        else
                          remove("SAC_PRINT");
                        break;
   case search_mark:    tmp_mark=head_mark.next_mark;
                        while((search!=tmp_mark->mark_count)&&(tmp_mark!=&tail_mark))
                          tmp_mark=tmp_mark->next_mark;
                        status.mark_current=tmp_mark->mark_count;
                        switch (todo2){
                          case search_found:   input(tmp_mark->mark_core,search_found);
                		               break;
                        }
                        break;

   case search_name:    name_ptr=(char *)malloc(22);
		        other_ptr=(char *)malloc(22);
			tmp_core=head_core.next;
			while(tmp_core!=&tail_core){
			  strcpy((char *)tmp_ptr,(const char *)tmp_core->sac_line);
			  strcpy((char *)name_ptr,(const char *)parse_core(tmp_ptr,8));
			  strcpy((char *)other_ptr,(const char *)parse_core(tmp_ptr,9));
			  str2lower(name_ptr,name_ptr);
			  str2lower(other_ptr,other_ptr);
			  if ((strcmp((const char *)name_ptr,(const char *)search_core))==0){
			    ret=tmp_core->core_count;
			    break;
			  }
			  if ((strcmp((const char *)other_ptr,(const char *)search_core))==0){
                            ret=tmp_core->core_count;
                            break;
                          }
			  tmp_core=tmp_core->next;
			}
			if (tmp_core==&tail_core)
			  ret=0; 
			free(name_ptr);
			free(other_ptr);
			break;
 }
return ret;
}
