/*
 * SACDRT Version 3.1 SAC-Database-Reader for DeepSky Objects
 * Header DATABASE.H is written by Sven van der Meer for the SACDRT.
 *
 *  Copyright (C) 1994 Lars Hagen & Sven van der Meer
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *  Problems or comments to hagenl@cs.tu-berlin.de
 *
 */

#ifndef TRUE
  #define TRUE    1               /* ncurses should have defined this, when  */
#endif                            /* not we do this here                     */
#ifndef FALSE
  #define FALSE   0
#endif

#ifndef MSDOS
  #include <ncurses.h>
#endif

#ifdef MSDOS
  #include <dos.h>                /* definitions for interrupts              */
  #include <curses.h>             /* use pdcurses package for dos            */
  union REGS Register;            /* for interrupts in init_screen()         */
#endif

#if defined(wx_x)                 /* when the wx version is running (vsn)    */
  #define XSAC                    /* we check XSAC in main                   */
#endif

#if defined (wx_msw)              /* when the wx version is running (vsn)    */
  #define MSW_SAC                 /* we check MSW_SAC                        */
#endif

#ifndef SEEK_SET
  #define SEEK_SET 0              /* for sun os (there seems it not defined  */
#endif

#ifndef MAXPATHLEN                /* when not defined we use the default of  */
  #define MAXPATHLEN 255          /* 255                                     */
#endif

#define VERSION     "3.1"         /* current version                         */
#define YEAR        "1994"        /* and year given to the net               */

#define SORT_YES    "YES"         /* for sort_window (use 's' in print mode  */
#define SORT_NO     "NO "         /* to see it)                              */

#define SAC_DEFAULT_INPUT      "SAC.TXT"        /* default input file        */
#define SAC_DEFAULT_OUTPUT     "SAC.OUTPUT"     /* default output file       */
#define SAC_DEFAULT_ENV_INPUT  "SACDRT_INPUT"   /* env variable for input    */
#define SAC_DEFAULT_ENV_OUTPUT "SACDRT_OUTPUT"  /* env varable for output    */

#define CS_MIN_RA     "00h00.0"   /* default value for cs_search (printing)  */
#define CS_MAX_RA     "23h59.6"   /* default value for cs_search (printing)  */
#define CS_MIN_RA_VAL "00 00.0"   /* default value for cs_search (searching) */
#define CS_MAX_RA_VAL "23 59.6"   /* default value for cs_search (searching) */

#define CS_MIN_MAG  "-26.9"       /* default value for cs_search (both)      */
#define CS_MAX_MAG  "+99.9"       /* default value for cs_search (both)      */

#define CS_MAX_DECL "+90"         /* default value for cs_search (printing)  */
#define CS_MIN_DECL "-90"         /* default value for cs_search (printing)  */
#define CS_NOR_DECL "00"          /* default value for cs_search (printing)  */
#define CS_MAX_DECL_VAL "+90 00"  /* default value for cs_search (searching) */
#define CS_MIN_DECL_VAL "-90 00"  /* default value for cs_search (searching) */

#define CR      0x0d
#define LF      0x0a
#define BS      0x08
#define DEL     0x7f
#define ESC     0x1b

struct core_list{                 /* holds the whole input file              */
     char *sac_line;              /* one line from input file                */
     int  core_count;             /* count for the line                      */
     int  mark_flag;              /* flag for complex search / filter        */
     struct core_list *next;      /* ptr to next line                        */
}head_core,tail_core;             /* one for begin and one for end (dummy's) */

struct mark_list{                 /* holds names of all marked objects       */
     char *mark_name;             /* name of the marked object (parsed!)     */
     int  mark_core;              /* count from core_list                    */
     int  mark_count;             /* count for mark_list                     */
     struct mark_list *next_mark; /* ptr to next marked object               */
     struct core_list *next_core; /* ptr to the original object in core_list */
}head_mark,tail_mark;

struct sac_config{                /* structure to make the values not global */
     char *input;                 /* -f option in commandline                */
     char *rc_input;              /* input file from rc file    	     */
     char *output;                /* -o option in commandline   	     */
     char *rc_output;             /* outputfile from rc file      	     */
     int  max_lines;              /* -L option in commandline   	     */
     int  asc_print;              /* -a option in commandline   	     */
     int  ps_print;               /* -p option in commandline   	     */
     int  rc_asc_print;           /* print_ascii from .sacdrt file           */
     int  rc_ps_print;            /* print_ps from .sacdrt file              */
     int  print_to_use;           /* use rc or commandline for ascii/ps      */
     char *printer;               /* -P option in commandline   	     */
     char *rc_printer;            /* Printer from rc file       	     */
     int  term;                   /* -t option in commandline   	     */
     int  current_line;           /* for printing/writing       	     */
     int  current_page;           /* for printing       	             */
     int  parse;                  /* turns parsing on/off       	     */
     int  filter;                 /* turns filter on/off        	     */
     int  sort_mode;		  /* -s in command line                      */
     int  print_mode;             /* print all or array only                 */
     int  print_fop;              /* write to file or spool to printer       */
     int  base_version;		  /* version of sac.txt (5.1 or 6.0)         */
     int  curses;                 /* we are in curses mode or in X ?         */
     char *binary_name;           /* whats the name of our program ?         */
}config;

struct sac_status{                /* structure for status when running       */
     int  core_current;           /* current record in core_list             */
     int  max_core;               /* counter for records in core_list        */
     int  max_mark;               /* counter for records in mark_list        */
     int  mark_current;           /* current record when filter on           */
     char *time;                  /* time for print status line              */
     char colors;		  /* return for has_colors()                 */
     int  clas;			  /* for breakline by clas pointer           */
     struct core_list *next_core; /* ptr to current object in core_list      */
}status;

struct complex_search{		  /* struct for values used in cs_search     */
     char min_mag[7];             /* input for min Magnitude		     */
     char max_mag[7];		  /* input for max Magnitude		     */
     char min_ra[9];		  /* input for min Rektaszension	     */
     char max_ra[9];		  /* input for max Rektaszension	     */
     char min_decl[7];		  /* input for min Declination		     */
     char max_decl[7];		  /* input for max Declination		     */
     int  cs_default_val;	  /* use default or user specific values?    */
     int  mark_con;		  /* counter for marked const in cs_search   */
     int  mark_name;		  /* counter for marked name in cs_search    */
     int  mark_type;		  /* counter for marked type in cs_search    */
     int  name_to_use;		  /* use short or middle name? in cs_search  */
}cs_values;

struct cs_do_values{		  /* struct for values in cs_do_search       */
     char tmp_ptr[MAXPATHLEN];    /* hold the char *sac_line from core_list  */
     char name_ptr[100];          /* hold name from *sac_line                */
     char type_ptr[100];          /* hold type from *sac_line                */
     char con_ptr[100];           /* hold con from *sac_line                 */
     char other_ptr[100];         /* hold other from *sac_line               */
}cs_tmp;

struct sac_sort{                  /* structure for checking in sort_window   */
     bool ra;                     /* the bool values describe the mode we    */
     bool mag;                    /* currently in (for keyboard check and    */
     bool decl;                   /* active color mapping)                   */
     bool name;                   /*                                         */
     bool type;                   /*                                         */
     bool con;                    /*                                         */
     int  sort_to;                /* value for sort_marked (enum sort_mark)  */
     int  up_down;                /* value for sort_marked (enum sort_mark)  */
}sort;



/*
 *
 * we use enums instead of int as parameter for functions and values for
 * the members of the structures above. 
 *
 * enum sort_mark:   used in sort_window and sort_marked to tell the functions
 *                   what to sort for
 * enum shell:       used in input and from all functions wich call something
 *                   in input. 'nothing' is a dummy when the parameter is not
 *                   needed.
 * enum loop:        for loops (see K&R)
 * enum color:       for cs_set_color. this function will set colors for ncurses
 * enum on_off:      for sac_filter (filter ON or OFF) and maybe somewhere else
 * enum cs_inp:      for cs_search and the keyloop there (input only)
 * enum to_mark:     for cs_search and the display function for name, type and
 *                   const
 * enum print_use:   for command_line. if there are parameters in comandline
 *                   they will overwrite the .sacdrtrc entries.
 * enum sac_version: tell the sacdrt which sac version we have (we have tested
 *                   only 5.2 and 6.0, the results for older versions are not
 *                   tested!!!) 
 *
 * enum cs_show:     (defined in layout.c) for cs_search and the keyloop there
 *                   to determine what is active
 *
 */

enum sort_mark{sort_name,sort_type,sort_con,sort_mag,sort_ra,sort_decl,
               sort_ascending,sort_descending,sort_shell,sort_quick};
enum print_mark{print_printer,print_file,print_all,print_tab};

enum shell {init_database, output_first, output_next, output_prev, file_current,
            print_current, search_for, search_found, search_mark, search_name,
            nothing};
                                            /* used in input and the calling */
                                            /* functions to tell input what  */
                                            /* todo                          */

enum loop        {NO,YES};
enum color       {normal,inverse,active,edit,scroll_mark,scroll_normal};
enum on_off      {OFF,ON};
enum cs_inp      {cs_inp_mag,cs_inp_ra,cs_inp_decl,cs_inp_search};
enum to_mark     {use_middle,use_name,use_other,use_short};
enum print_use   {rc_file,commandline};
enum sac_version {v52,v6};
extern enum loop okloop;

