/*
 * SACDRT Version 3.1 SAC-Database-Reader for DeepSky Objects
 * Header CONST_DATA.H is designed by Lars Hagen for the SACDRT.
 *                        modified by Sven van der Meer
 *
 *  Copyright (C) 1994 Lars Hagen & Sven van der Meer
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *  Problem or comments to hagenl@cs.tu-berlin.de
 *                                                                         
 */

  struct constellation {
    char *short_con;
    char *long_con;
    int  marked;
  };
#ifndef LAYOUT
  struct constellation const_data[] = {
    { "",    "",0                    },
    { "AND", "Andromeda",0           },
    { "ANT", "Antilia",0             },
    { "APS", "Apus",0                },
    { "AQR", "Aquarius",0            },
    { "AQL", "Aquila",0              },
    { "ARA", "Ara",0                 },
    { "ARI", "Aries",0               },
    { "AUR", "Auriga",0              },
    { "BOO", "Bootes",0              },
    { "CAE", "Caelum",0              },
    { "CAM", "Camelopardalis",0      },
    { "CNC", "Cancer",0              },
    { "CVN", "Canes Venatici",0      },
    { "CMA", "Canis Major",0         },
    { "CMI", "Canis Minor",0         },
    { "CAP", "Capricornus",0         },
    { "CAR", "Carina",0              },
    { "CAS", "Cassiopeia",0          },
    { "CEN", "Centaurus",0           },
    { "CEP", "Cepheus",0             },
    { "CET", "Cetus",0               },
    { "CHA", "Chamaeleon",0          },
    { "CIR", "Circinus",0            },
    { "COL", "Columba",0,            },
    { "COM", "Coma Berenices",0      },
    { "CRA", "Corona Australis",0    },
    { "CRB", "Corona Borealis",0     },
    { "CRV", "Corvus",0              },
    { "CRT", "Crater",0              },
    { "CRU", "Crux",0                },
    { "CYG", "Cygnus",0              },
    { "DEL", "Delphinus",0           },
    { "DOR", "Dorado",0              },
    { "DRA", "Draco",0               },
    { "EQU", "Equuleus",0            },
    { "ERI", "Eridanus",0            },
    { "FOR", "Fornax",0              },
    { "GEM", "Gemini",0              },
    { "GRU", "Grus",0                },
    { "HER", "Hercules",0            },
    { "HOR", "Horologium",0          },
    { "HYA", "Hydra",0               },
    { "HYI", "Hydrus",0              },
    { "IND", "Indus",0               },
    { "LAC", "Lacerta",0             },
    { "LEO", "Leo",0                 },
    { "LMI", "Leo Minor",0           },
    { "LEP", "Lephus",0              },
    { "LIB", "Libra",0               },
    { "LUP", "Lupus",0               },
    { "LYN", "Lynx",0                },
    { "LYR", "Lyra",0                },
    { "MEN", "Mensa",0               },
    { "MIC", "Microscopium",0        },
    { "MON", "Monoceros",0           },
    { "MUS", "Musca",0               },
    { "NOR", "Norma",0               },
    { "OCT", "Octans",0              },
    { "OPH", "Ophiuchus",0           },
    { "ORI", "Orion",0               },
    { "PAV", "Pavo",0                },
    { "PEG", "Pegasus",0             },
    { "PER", "Perseus",0             },
    { "PHE", "Phoenix",0             },
    { "PIC", "Pictor",0              },
    { "PSC", "Pisces",0              },
    { "PSA", "Pisces Austrinus",0    },
    { "PUP", "Puppis",0              },
    { "PYX", "Pyxis",0               },
    { "RET", "Reticulum",0           },
    { "SGE", "Sagitta",0             },
    { "SGR", "Sagittarius",0         },
    { "SCO", "Scorpius",0            },
    { "SCL", "Sculptor",0            },
    { "SCT", "Scutum",0              },
    { "SER", "Serpens",0             },
    { "SEX", "Sextans",0             },
    { "TAU", "Taurus",0              },
    { "TEL", "Telescopium",0         },
    { "TRA", "Triangulum Australe",0 },
    { "TRI", "Triangulum",0          },
    { "TUC", "Tucana",0              },
    { "UMA", "Ursa Major",0          },
    { "UMI", "Ursa Minor",0          },
    { "VEL", "Vela",0                },
    { "VIR", "Virgo",0               },
    { "VOL", "Volans",0              },
    { "VUL", "Vulpecula",0           }
  };
  int max_con=(sizeof const_data/sizeof(struct constellation));
#else
  extern struct constellation const_data[];
  extern int max_con;
#endif
