/*
 * SACDRT Version 3.1 SAC-Database-Reader for DeepSky Objects
 * Module COMMANDLINE.C is written by Sven van der Meer for SACDRT.
 *
 *  Copyright (C) 1994 Lars Hagen & Sven van der Meer 
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *  Problems or comments to hagenl@cs.tu-berlin.de
 *
 */

#include <stdlib.h>
#include "sacdrt.h"
#include "database.h"



/*
 *  void COMMAND_LINE(int char [])  will parse the commandline for information
 *                                  if there are things we don't expect, sacdrt
 *                                  will terminate with a usage info
 *
 */
void command_line(int argc, char *argv[])
{
int count;

 config.binary_name=argv[0];
 for (count=1;count<argc&&(argv[count][0]=='-');count++){  /* now we test the */
   if (argv[count][0]=='-'){                               /* command-line    */
     switch (argv[count][1]) {
       case 'f': if (argv[count][2]!='\0')
                   config.input=&(argv[count][2]);
                 else if(count<(argc-1)){
                   count+=1;
                   config.input=argv[count];
                 }
                 else
                   usage();
                 break;
       case 'o': if (argv[count][2]!='\0')
                   config.output=&(argv[count][2]);
                 else if(count<(argc-1)){
                   count+=1;
                   config.output=argv[count];
                 } 
                 else
                     usage();
                 break;
       case 't': if (argv[count][2]=='\0')
                   config.term=1;
                 else
                   usage();
                 break;
       case 'L': if (argv[count][2]!='\0')
                   config.max_lines=atoi(&(argv[count][2]));
                 else if(count<(argc-1)){
                   count+=1;
                   config.max_lines=atoi(argv[count]);
                 } 
                 else
                   usage();
                 break;
       case 'P': if (argv[count][2]!='\0')
                   config.printer = &(argv[count][2]);
                 else if (count<(argc-1)){
                   count+=1;
                   config.printer=argv[count];
                 } 
                 else
                   usage();
                 break;
       case 'O': if (argv[count][2]=='\0')
                   config.parse=FALSE;
                 else
                   usage();
                 break;
#ifndef MSDOS
       case 'a': if (argv[count][2]=='\0'){
                   config.asc_print=TRUE;
                   config.print_to_use=commandline;
                 }
                 else
                   usage();
                 break;
       case 'p': if (argv[count][2]=='\0'){
                   config.ps_print=TRUE;
                   config.print_to_use=commandline;
                 }
                 else
                   usage();
                 break;
#endif
        default: 
                 usage();
     }
   }
 }
 if ((argc-count)>0)
   usage();
 if (!config.max_lines)
   config.max_lines=65;
 if ((config.printer==NULL)&&((config.printer=getenv("PRINTER"))==NULL)&&(config.rc_printer==NULL)){
   printf("\n%s: no printer specified (neither -P from commandline or $PRINTER",config.binary_name);
   printf("\n        from environment) or ini-file");
   printf("\n\n        Try '%s -h' for help\n\n",config.binary_name);
   exit (1);
 }
#ifndef MSDOS
 if (config.print_to_use==rc_file){
   config.asc_print=config.rc_asc_print;
   config.ps_print=config.rc_ps_print;
 }
 else if (config.asc_print==config.ps_print){
   printf("\n%s: do we like to print ascii or ps? (-a or -p)",config.binary_name);
   printf("\n        you have said both (or nothing) in the commandline");
   printf("\n\n        Try '%s -h' for help\n\n",config.binary_name);
   exit (1);
 }
#endif
return;
}



/*
 *  USAGE()  is called, when during the check of the command-line an error
 *           was found. This function will print a usage info to stderr
 *           and then terminate the sacdrt
 *
 */
void usage()
{
 printf("\nSACDRT Version %s SAC-Database-Reader for DeepSky Objects",VERSION);
 printf("\nCopyright (C) 1994 by Lars Hagen & Sven van der Meer");
#ifdef MSDOS
 printf("\n\nUsage: %s [-f database] [-o output_file] [-L maxlines] [-O]",config.binary_name);
#else
 printf("\n\nUsage: %s [-f database] [-o output_file] [-P printer] [-L maxlines]",config.binary_name);
 printf("\n              [-t] [-a|-p]  [-O]");
#endif
 printf("\n\n  -f <database>    = full path to the sac database (including the filename)");
 printf("\n  -o <output_file> = full path to the file where marked objects are should");
 printf("\n                     be written to (including the filename)");
 printf("\n  -P <printer>     = your favorite printer instead of PRINTER from environment");
 printf("\n  -L <maxlines>    = maximum lines to be used for printing (default=65)");
 printf("\n  -O               = invoke no-parsing mode");
#ifndef MSDOS
 printf("\n\n  -t = when you have compiled the whole program and running a X-Server, but"); 
 printf("\n       nevertheless want sacdrt running in in a xterm instead of it's X-Window");
 printf("\n  -a = print plain ascii, without any filter");
 printf("\n  -p = use 'a2ps -p -nn -nh -ns' as filter befor printing");
 printf("\n\n  %s comes with ABSOLUTELY NO WARRANTY; for details see the file",config.binary_name);
 printf("\n  COPYING, which should have come with the source for this program.");
 printf("\n  This program is free software; you can redistribute it and/or modify");
 printf("\n  it under the terms of the GNU General Public License as published by");
 printf("\n  the Free Software Foundation; either version 2 of the License, or");
 printf("\n  (at your option) any later version; see file COPYING for details.");
#endif
 printf("\n\n");
 exit (1);
}
