/* NIGHTFALL Light Curve Synthesis Program                                 */
/* Copyright (C) 1998 Rainer Wichmann                                      */
/*                                                                         */
/*  This program is free software; you can redistribute it                 */
/*  and/or modify                                                          */
/*  it under the terms of the GNU General Public License as                */
/*  published by                                                           */
/*  the Free Software Foundation; either version 2 of the License, or      */
/*  (at your option) any later version.                                    */
/*                                                                         */
/*  This program is distributed in the hope that it will be useful,        */
/*  but WITHOUT ANY WARRANTY; without even the implied warranty of         */
/*  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the          */
/*  GNU General Public License for more details.                           */
/*                                                                         */
/*  You should have received a copy of the GNU General Public License      */
/*  along with this program; if not, write to the Free Software            */
/*  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.              */

/* ANSI C forbids an empty source file, so put this outside                */

#include <math.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <float.h>

#include "Light.h"

#ifdef _WITH_GTK

static   char  my_full_data[1024] = "\0";    /* path to datafile             */
static   int   first_datafile = OFF;         /* flag                         */
static   char  my_full_cfg[1024] = "\0";     /* path to cfgfile              */
static   int   first_cfgfile = OFF;          /* flag                         */
static   char  my_full_out[1024] = "./Nightfall.cfg"; /* path to out cfgfile */

static   GtkWidget   *dialog;                 /* error dialog box            */
static   gint PopErr = OFF;                   /* flag error dialog active    */

/******************************************************************
 @package   nightfall
 @author    Rainer Wichmann (rwichman@lsw.uni-heidelberg.de)
 @version   1.0
 @short     Destroy error dialog window
 @tip       function arguments are not used
 @param     (GtkWidget) *widget     Discarded
 @param     (gpointer)  *data       Discarded
 @return    (void)   
 @heading   Graphical User Interface
*******************************************************************/
void delete_dialog (GtkWidget *widget, gpointer *data)
{
    gtk_widget_destroy (dialog);
    PopErr = OFF;
    return;
}

/******************************************************************
 @package   nightfall
 @author    Rainer Wichmann (rwichman@lsw.uni-heidelberg.de)
 @version   1.0
 @short     Error handler
 @param     (char) *message     The error message
 @return    (void)   
 @heading   Graphical User Interface
*******************************************************************/
void make_dialog (char *message)
{

#ifdef HAVE_GNOME

  dialog = gnome_message_box_new(_(message), GNOME_MESSAGE_BOX_WARNING,  
                            GNOME_STOCK_BUTTON_OK, NULL); 
  gnome_dialog_set_close(GNOME_DIALOG(dialog), TRUE);
  gtk_window_set_modal (GTK_WINDOW(dialog), TRUE);
  gtk_widget_show(dialog);

#else

  GtkWidget   *label;
  GtkWidget   *button;
  GtkWidget   *box1;
  GtkWidget   *separator;
  char         newmsg[128+12] = "**ERROR**: ";

  strncat(newmsg, message, 128);
  dialog = gtk_window_new (GTK_WINDOW_DIALOG);
  /* gtk_window_position(GTK_WINDOW(dialog), GTK_WIN_POS_MOUSE); */ 
  gtk_signal_connect (GTK_OBJECT (dialog), "destroy",
		      GTK_SIGNAL_FUNC (delete_dialog), NULL);

  box1 = gtk_vbox_new (FALSE, 0);
  gtk_container_add (GTK_CONTAINER (dialog), box1);
  gtk_container_border_width (GTK_CONTAINER (box1), 5);

  label = gtk_label_new (message);
  gtk_box_pack_start (GTK_BOX (box1), label, FALSE, TRUE, 5);
  gtk_widget_show (label);
   
  separator = gtk_hseparator_new ();
  gtk_box_pack_start (GTK_BOX (box1), separator, FALSE, TRUE, 5);
  gtk_widget_show (separator);    

  button = gtk_button_new_with_label ("OK");
  gtk_signal_connect (GTK_OBJECT (button), "clicked",
                      GTK_SIGNAL_FUNC (delete_dialog), NULL);
  gtk_box_pack_start (GTK_BOX (box1), button, FALSE, TRUE, 5);
  (GTK_WIDGET_FLAGS (button)  |= (GTK_CAN_DEFAULT));
  gtk_widget_grab_default (button); 
  gtk_widget_show (button);

  gtk_widget_show (box1);

  gtk_widget_show (dialog);

  PopErr = ON;

  /* avoid second error dialog PopUp while first still active */

  while (PopErr == ON) {
    while (gtk_events_pending()) gtk_main_iteration(); 
  }

#endif

  return;
}

/******************************************************************
 @package   nightfall
 @author    Rainer Wichmann (rwichman@lsw.uni-heidelberg.de)
 @version   1.0
 @short     Read data file
 @param     (GtkWidget) *w          Discarded
 @param     (GtkFileSelection)  *fs File selection 
 @return    (void)   
 @heading   Graphical User Interface
*******************************************************************/
void file_ok_sel (GtkWidget *w, GtkFileSelection *fs)
{
  char *file_ptr;         /* filename                             */

  file_ptr = gtk_file_selection_get_filename (GTK_FILE_SELECTION (fs));

  if (strlen(file_ptr) < sizeof(my_full_data) -1) 
    strcpy(my_full_data,file_ptr); 

  /* read in the data                                             */
  Read(file_ptr);

  updatepage3 ();

  gtk_widget_destroy (GTK_WIDGET (fs)); 

  return;
}

/******************************************************************
 @package   nightfall
 @author    Rainer Wichmann (rwichman@lsw.uni-heidelberg.de)
 @version   1.0
 @short     Callback function for 'Read Data'
 @param     (GtkWidget) *widget     Discarded
 @param     (gpointer)  *data       Discarded
 @return    (void)   
 @heading   Graphical User Interface
*******************************************************************/
void select_file (GtkWidget *widget, gpointer *data)
{
    GtkWidget *filew;                     /* file selector        */
    char      *pwd;                       /* present working dir  */
    char       my_data[] = "/ty_booV.dat"; /* filename            */
    FILE      *test;                      /* filehandle           */

    /* set default filename, but only at first call               */

    if (first_datafile == OFF) {

      strncpy(my_full_data, data_data_fls(), 
	      (sizeof(my_full_data)-sizeof(my_data)-1));
      strcat(my_full_data, my_data);

      /* check if file exist, otherwise fall back on PWD/data     */

      test = fopen(my_full_data, "r");

      if (test != NULL) {
	fclose(test);
      } else {
	pwd = getenv("PWD");
	if (pwd != NULL) {
	  if (strlen(pwd) < (sizeof(my_full_data)-strlen(my_data)-1))
	    strcpy(my_full_data, pwd);
	  strcat(my_full_data, my_data);
	}
      }
      first_datafile = ON;

    }
    

    /* Create a new file selection widget                         */
    filew = gtk_file_selection_new ("Data file selection");
    
    gtk_signal_connect (GTK_OBJECT (filew), "destroy",
                        (GtkSignalFunc) gtk_widget_destroy, 
                         GTK_OBJECT (filew));

    /* Connect the ok_button to file_ok_sel function              */
    gtk_signal_connect (GTK_OBJECT (GTK_FILE_SELECTION (filew)->ok_button),
                        "clicked", (GtkSignalFunc) file_ok_sel, filew );
    
    /* Connect the cancel_button to destroy the widget            */
    gtk_signal_connect_object 
               (GTK_OBJECT (GTK_FILE_SELECTION (filew)->cancel_button),
                 "clicked", (GtkSignalFunc) gtk_widget_destroy,
                  GTK_OBJECT (filew));
    
    /* set the default filename                                   */
    gtk_file_selection_set_filename (GTK_FILE_SELECTION(filew), 
                                     my_full_data);
    
    gtk_widget_show(filew);

    return;
}


/******************************************************************
 @package   nightfall
 @author    Rainer Wichmann (rwichman@lsw.uni-heidelberg.de)
 @version   1.0
 @short     Read configuration file
 @param     (GtkWidget) *w          Discarded
 @param     (GtkFileSelection)  *fs File selection 
 @return    (void)   
 @heading   Graphical User Interface
*******************************************************************/
void config_ok_sel (GtkWidget *w, GtkFileSelection *fs)
{
    char *file_ptr;         /* filename                           */
    int  blah;              /* mandatory args, discarded          */

    file_ptr = gtk_file_selection_get_filename (GTK_FILE_SELECTION (fs));

    if (strlen(file_ptr) < sizeof(my_full_cfg) -1 && strlen(file_ptr) > 1) 
      strcpy(my_full_cfg, file_ptr); 

    ParseConfig(file_ptr, &blah);

    UpdateGui();

    updatepage3 ();

    gtk_widget_destroy (GTK_WIDGET (fs));

    return; 
}

/******************************************************************
 @package   nightfall
 @author    Rainer Wichmann (rwichman@lsw.uni-heidelberg.de)
 @version   1.0
 @short     Callback function for 'Read Config'
 @param     (GtkWidget) *widget     Discarded
 @param     (gpointer)  *data       Discarded
 @return    (void)   
 @heading   Graphical User Interface
*******************************************************************/
void select_config (GtkWidget *widget, gpointer *data)
{
    GtkWidget *filew;                     /* file selector        */
    char      *pwd;                       /* present working dir  */
    char       my_cfg[] = "/ty_boo.cfg";  /* filename             */
    FILE      *test;                      /* filehandle           */
    
    /* set default filename, but only at first call               */

    if (first_cfgfile == OFF) {

      strncpy(my_full_cfg, data_cfg_fls(), 
	      (sizeof(my_full_cfg)-sizeof(my_cfg)-1));
      strcat(my_full_cfg, my_cfg);

      /* check if file exist, otherwise fall back on PWD/cfg      */

      test = fopen(my_full_cfg, "r");

      if (test != NULL) {
	fclose(test);
      } else {
	pwd = getenv("PWD");
	if (pwd != NULL) {
	  if (strlen(pwd) < (sizeof(my_full_cfg)-strlen(my_cfg)-1))
	    strcpy(my_full_cfg, pwd);
	  strcat(my_full_cfg, my_cfg);
	}
      }
      first_cfgfile = ON;

    }

    /* Create a new file selection widget                         */
    filew = gtk_file_selection_new ("File selection");
    
    gtk_signal_connect (GTK_OBJECT (filew), "destroy",
                        (GtkSignalFunc) gtk_widget_destroy, 
                         GTK_OBJECT (filew));

    /* Connect the ok_button to file_ok_sel function              */
    gtk_signal_connect (GTK_OBJECT (GTK_FILE_SELECTION (filew)->ok_button),
                        "clicked", (GtkSignalFunc) config_ok_sel, filew );
    
    /* Connect the cancel_button to destroy the widget            */
    gtk_signal_connect_object 
               (GTK_OBJECT (GTK_FILE_SELECTION (filew)->cancel_button),
                 "clicked", (GtkSignalFunc) gtk_widget_destroy,
                  GTK_OBJECT (filew));
    
    /* set the default filename                                   */
    gtk_file_selection_set_filename (GTK_FILE_SELECTION(filew), 
                                     my_full_cfg);
    
    gtk_widget_show(filew);

    return;
}


/******************************************************************
 @package   nightfall
 @author    Rainer Wichmann (rwichman@lsw.uni-heidelberg.de)
 @version   1.0
 @short     Write output configuration filename
 @param     (GtkWidget) *w          Discarded
 @param     (GtkFileSelection)  *fs File selection 
 @return    (void)   
 @heading   Graphical User Interface
*******************************************************************/
void config_ok_out (GtkWidget *w, GtkFileSelection *fs)
{

    char *file_ptr;         /* filename                           */

    file_ptr = gtk_file_selection_get_filename (GTK_FILE_SELECTION (fs));

    if (strlen(file_ptr) < sizeof(my_full_out) -1 && strlen(file_ptr) > 1) 
      strcpy(my_full_out, file_ptr); 

    WriteConfig(file_ptr); 

    gtk_widget_destroy (GTK_WIDGET (fs)); 
}


/******************************************************************
 @package   nightfall
 @author    Rainer Wichmann (rwichman@lsw.uni-heidelberg.de)
 @version   1.0
 @short     Callback function for 'Write Config'
 @param     (GtkWidget) *widget     Discarded
 @param     (gpointer)  *data       Discarded
 @return    (void)   
 @heading   Graphical User Interface
*******************************************************************/
void out_config (GtkWidget *widget, gpointer *data)
{
    GtkWidget *filew;                     /* file selector        */
    
    /* Create a new file selection widget                         */
    filew = gtk_file_selection_new ("File selection");
    
    gtk_signal_connect (GTK_OBJECT (filew), "destroy",
                        (GtkSignalFunc) gtk_widget_destroy, 
                         GTK_OBJECT (filew));

    /* Connect the ok_button to file_ok_sel function              */
    gtk_signal_connect (GTK_OBJECT (GTK_FILE_SELECTION (filew)->ok_button),
                        "clicked", (GtkSignalFunc) config_ok_out, filew );
    
    /* Connect the cancel_button to destroy the widget            */
    gtk_signal_connect_object 
               (GTK_OBJECT (GTK_FILE_SELECTION (filew)->cancel_button),
                 "clicked", (GtkSignalFunc) gtk_widget_destroy,
                  GTK_OBJECT (filew));
    
    /* set the default filename                                   */
    gtk_file_selection_set_filename (GTK_FILE_SELECTION(filew), 
                                     my_full_out);
    
    gtk_widget_show(filew);

    return;
}

/******************************************************************
 @package   nightfall
 @author    David Bryant <d_bryant@lincoln.college.adelaide.edu.au>
 @version   original version without any modifications
 @short     Convenience function to create a pixmap widget from data
 @long      This function is taken from the 'geg' program,
            version 0.15.0, without any modifications except for
	    error handling. Copyright is
            with the author of 'geg', David Bryant. 
	    ('geg' is distributed under the 
            terms of the GNU General Public License). 
 @param     (GtkWidget) *widget     The top window
 @param     (gchar)  **data         The data, a .xpm array
 @return    (GtkWidget *)           The pixmap widget  
 @heading   Graphical User Interface
*******************************************************************/
GtkWidget *
create_pixmap(GtkWidget *widget, gchar **data)
{
  GtkStyle *style;
  GdkBitmap *mask;
  GdkPixmap *gdk_pixmap;
  GtkWidget *gtk_pixmap;
  
  style = gtk_widget_get_style(widget);
  if (style == NULL) nf_error(_(errmsg[21]));

  gdk_pixmap = 
    gdk_pixmap_create_from_xpm_d(widget->window, 
				 &mask, &style->bg[GTK_STATE_NORMAL],
				 data);

  if (gdk_pixmap == NULL) nf_error(_(errmsg[22]));

  gtk_pixmap = gtk_pixmap_new(gdk_pixmap, mask);

  if (gtk_pixmap == NULL) nf_error(_(errmsg[22]));

  gtk_widget_show(gtk_pixmap);

  return(gtk_pixmap);
}


#endif
