/* NIGHTFALL Light Curve Synthesis Program                                 */
/* Copyright (C) 1999 Rainer Wichmann                                      */
/*                                                                         */
/*  This program is free software; you can redistribute it                 */
/*  and/or modify                                                          */
/*  it under the terms of the GNU General Public License as                */
/*  published by                                                           */
/*  the Free Software Foundation; either version 2 of the License, or      */
/*  (at your option) any later version.                                    */
/*                                                                         */
/*  This program is distributed in the hope that it will be useful,        */
/*  but WITHOUT ANY WARRANTY; without even the implied warranty of         */
/*  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the          */
/*  GNU General Public License for more details.                           */
/*                                                                         */
/*  You should have received a copy of the GNU General Public License      */
/*  along with this program; if not, write to the Free Software            */
/*  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.              */


/* ANSI C forbids an empty source file, so put this outside                */

#include <math.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "Light.h"

#ifdef _WITH_GTK

static int         hidestate[NUM_MAG+1];   /* which button is hidden ? */
static GtkWidget   *buttmag[NUM_MAG+1][2]; /* filter buttons           */

static GtkWidget   *xpm_button (GSList *group, GtkWidget *parent, 
			     char **xpm_data, 
			     gchar *label_text);

static void        showhidepage3 ();

/* XPM data  */
static char * xpm_data_yes[] = {
  "14 10 3 1",
  "       c None",
  ".      c #000000000000",
  "X      c #FFFFFFFFFFFF",
  "              ",
  "   .......    ",
  "   ..XXX..    ",
  "   .X.X.X.    ",
  "   .XX.XX.    ",
  "   .X.X.X.    ",
  "   ..XXX..    ",
  "   .......    ",
  "              ",
  "              "};

/* XPM data  */
static char * xpm_data_no[] = {
  "14 10 3 1",
  "       c None",
  ".      c #000000000000",
  "X      c #FFFFFFFFFFFF",
  "              ",
  "   .......    ",
  "   .XXXXX.    ",
  "   .XXXXX.    ",
  "   .XXXXX.    ",
  "   .XXXXX.    ",
  "   .XXXXX.    ",
  "   .......    ",
  "              ",
  "              "};


/******************************************************************
 @package   nightfall
 @author    Rainer Wichmann (rwichman@lsw.uni-heidelberg.de)
 @version   1.0
 @short     Update plot flag on third notebook page (the plot data)
 @param     (void) 
 @return    (void)   
 @heading   Graphical User Interface
*******************************************************************/
void updateplotflagpage3 ()
{

  int j;  /* loop variable */

  if (Flags.PlotBand < 0)       Flags.PlotBand = Vmag;
  if (Flags.PlotBand > NUM_MAG) Flags.PlotBand = NUM_MAG;

  /* set all to FALSE      */
  for (j = 0; j <= NUM_MAG; ++j) {
    gtk_toggle_button_set_state(GTK_TOGGLE_BUTTON (buttmag[NUM_MAG][ON]), 
				FALSE);
    gtk_toggle_button_set_state(GTK_TOGGLE_BUTTON (buttmag[NUM_MAG][OFF]), 
				FALSE);
  }

  /* set all to ALL        */
  if (hidestate[Flags.PlotBand] == OFF)
    gtk_toggle_button_set_state(GTK_TOGGLE_BUTTON (buttmag[NUM_MAG][ON]), 
				TRUE);
  else
    gtk_toggle_button_set_state(GTK_TOGGLE_BUTTON (buttmag[NUM_MAG][OFF]), 
				TRUE);

  return;
    
}

/******************************************************************
 @package   nightfall
 @author    Rainer Wichmann (rwichman@lsw.uni-heidelberg.de)
 @version   1.0
 @short     Show/Hide buttons on third notebook page (the plot data)
 @param     (void) 
 @return    (void)   
 @heading   Graphical User Interface
*******************************************************************/
void showhidepage3 ()
{
  int j;  /* loop variable */

  if (Flags.Passbands[NUM_MAG] > 0 || Flags.Passbands[NUM_MAG+1] > 0) {
    gtk_widget_hide (buttmag[NUM_MAG][OFF]);
    hidestate[NUM_MAG] = OFF;
  }  else {
    if (GTK_TOGGLE_BUTTON (buttmag[NUM_MAG][ON])->active) {
      gtk_toggle_button_set_state(GTK_TOGGLE_BUTTON (buttmag[NUM_MAG][ON]), 
				     FALSE);
      gtk_toggle_button_set_state(GTK_TOGGLE_BUTTON (buttmag[NUM_MAG][OFF]), 
				     TRUE);
    }
    gtk_widget_hide (buttmag[NUM_MAG][ON]);
    hidestate[NUM_MAG] = ON;
  }

  for (j = 0; j < NUM_MAG; ++j) {
    if (Flags.Passbands[j] > 0) {
      gtk_widget_hide (buttmag[j][OFF]);
      hidestate[j] = OFF;
    } else {
      if (GTK_TOGGLE_BUTTON (buttmag[j][ON])->active) {
	gtk_toggle_button_set_state(GTK_TOGGLE_BUTTON (buttmag[j][ON]), 
				    FALSE);
	gtk_toggle_button_set_state(GTK_TOGGLE_BUTTON (buttmag[j][OFF]), 
				    TRUE);
      }
      gtk_widget_hide (buttmag[j][ON]);
      hidestate[j] = ON;
    }
  }

  return;

}

/******************************************************************
 @package   nightfall
 @author    Rainer Wichmann (rwichman@lsw.uni-heidelberg.de)
 @version   1.0
 @short     Update buttons on third notebook page (the plot data)
 @param     (void) 
 @return    (void)   
 @heading   Graphical User Interface
*******************************************************************/
void updatepage3 ()
{
  int j;  /* loop variable */

  if (Flags.Passbands[NUM_MAG] > 0 || Flags.Passbands[NUM_MAG+1] > 0) {

    if (hidestate[NUM_MAG] == ON) {
      if (GTK_TOGGLE_BUTTON (buttmag[NUM_MAG][OFF])->active) {
	gtk_toggle_button_set_state(GTK_TOGGLE_BUTTON (buttmag[NUM_MAG][OFF]), 
				    FALSE);
	gtk_toggle_button_set_state(GTK_TOGGLE_BUTTON (buttmag[NUM_MAG][ON]), 
				    TRUE);
      }
      gtk_widget_show (buttmag[NUM_MAG][ON]);
      gtk_widget_hide (buttmag[NUM_MAG][OFF]);
      hidestate[NUM_MAG] = OFF;
    } 
      
  }  else {

    if (hidestate[NUM_MAG] == OFF) {
      if (GTK_TOGGLE_BUTTON (buttmag[NUM_MAG][ON])->active) {
	gtk_toggle_button_set_state(GTK_TOGGLE_BUTTON (buttmag[NUM_MAG][ON]), 
				    FALSE);
	gtk_toggle_button_set_state(GTK_TOGGLE_BUTTON (buttmag[NUM_MAG][OFF]), 
				    TRUE);
      }
      gtk_widget_show (buttmag[NUM_MAG][OFF]);
      gtk_widget_hide (buttmag[NUM_MAG][ON]);
      hidestate[NUM_MAG] = ON;
    }
  }

  for (j = 0; j < NUM_MAG; ++j) {

    if (Flags.Passbands[j] > 0) {
      if (hidestate[j] == ON) {
	if (GTK_TOGGLE_BUTTON (buttmag[j][OFF])->active) {
	  gtk_toggle_button_set_state(GTK_TOGGLE_BUTTON (buttmag[j][OFF]), 
				      FALSE);
	  gtk_toggle_button_set_state(GTK_TOGGLE_BUTTON (buttmag[j][ON]), 
				      TRUE);
	}
	gtk_widget_show (buttmag[j][ON]);
	gtk_widget_hide (buttmag[j][OFF]);
	hidestate[j] = OFF;
      }
    } else {
      if (hidestate[j] == OFF) {
	if (GTK_TOGGLE_BUTTON (buttmag[j][ON])->active) {
	  gtk_toggle_button_set_state(GTK_TOGGLE_BUTTON (buttmag[j][ON]), 
				      FALSE);
	  gtk_toggle_button_set_state(GTK_TOGGLE_BUTTON (buttmag[j][OFF]), 
				      TRUE);
	}
	gtk_widget_show (buttmag[j][OFF]);
	gtk_widget_hide (buttmag[j][ON]);
	hidestate[j] = ON;
      }
    }

  }

  return;

}

/******************************************************************
 @package   nightfall
 @author    Rainer Wichmann (rwichman@lsw.uni-heidelberg.de)
 @version   1.0
 @short     Make third notebook page
 @param     (void) 
 @return    (void)   
 @heading   Graphical User Interface
*******************************************************************/
void makepage3 ()
{
  GtkWidget   *box11;
  GtkWidget   *inbox;
  GtkWidget   *label;
  GtkWidget   *button;
  GtkWidget   *table;
  GSList      *group;

#ifdef HAVE_GNOME
  GtkWidget   *pixy;
  GtkWidget   *boxpix;
#endif


  label = gtk_label_new (_("Plot Options"));
  box11 = gtk_hbox_new (TRUE, 0);
  gtk_notebook_append_page (GTK_NOTEBOOK (notebook), box11, label);
  gtk_widget_show (label);
  gtk_widget_show (box11);



  inbox = gtk_vbox_new (FALSE, 0);
  gtk_container_border_width (GTK_CONTAINER (inbox), 0);
  gtk_box_pack_start (GTK_BOX (box11), inbox, TRUE, TRUE, 0);
  gtk_widget_show (inbox);

  table = gtk_table_new (7, 4, TRUE); 

    label = gtk_label_new (_("PlotCurve Options")); 
    gtk_table_attach (GTK_TABLE(table), label, 0, 2, 0, 1,
          GTK_FILL|GTK_EXPAND, GTK_FILL|GTK_EXPAND, 2, 2);
    gtk_widget_show (label);

  /* --------------- Plot options   --------------------------------- */

      button = gtk_radio_button_new_with_label (NULL, _("Single Phase"));
      gtk_signal_connect (GTK_OBJECT (button), "toggled",
                      GTK_SIGNAL_FUNC (radio_graph), (gpointer) "1");
      if (Flags.plot < 2) 
        gtk_toggle_button_set_state (GTK_TOGGLE_BUTTON (button), TRUE);
      gtk_table_attach (GTK_TABLE(table), button, 0, 1, 1, 2,
          GTK_FILL|GTK_EXPAND, GTK_FILL|GTK_EXPAND, 2, 2); 
      gtk_widget_show (button);

      group  = gtk_radio_button_group (GTK_RADIO_BUTTON (button));
      button = gtk_radio_button_new_with_label (group, _("Double Phase"));
      gtk_signal_connect (GTK_OBJECT (button), "toggled",
                      GTK_SIGNAL_FUNC (radio_graph), (gpointer) "2");
      if (Flags.plot == 2)
        gtk_toggle_button_set_state (GTK_TOGGLE_BUTTON (button), TRUE);
      gtk_table_attach (GTK_TABLE(table), button, 1, 2, 1, 2,
          GTK_FILL|GTK_EXPAND, GTK_FILL|GTK_EXPAND, 2, 2); 
      gtk_widget_show (button);

      group  = gtk_radio_button_group (GTK_RADIO_BUTTON (button));
      button = gtk_radio_button_new_with_label (group, _("Zoom Eclipse (S)"));
      gtk_signal_connect (GTK_OBJECT (button), "toggled",
                      GTK_SIGNAL_FUNC (radio_graph), (gpointer) "S");
      if (Flags.plot == 4)
        gtk_toggle_button_set_state (GTK_TOGGLE_BUTTON (button), TRUE);
      gtk_table_attach (GTK_TABLE(table), button, 1, 2, 2, 3,
          GTK_FILL|GTK_EXPAND, GTK_FILL|GTK_EXPAND, 2, 2); 
      gtk_widget_show (button);

      group  = gtk_radio_button_group (GTK_RADIO_BUTTON (button));
      button = gtk_radio_button_new_with_label (group, _("Zoom Eclipse (P)"));
      gtk_signal_connect (GTK_OBJECT (button), "toggled",
                      GTK_SIGNAL_FUNC (radio_graph), (gpointer) "P");
      if (Flags.plot == 3)
        gtk_toggle_button_set_state (GTK_TOGGLE_BUTTON (button), TRUE);
      gtk_table_attach (GTK_TABLE(table), button, 0, 1, 2, 3,
          GTK_FILL|GTK_EXPAND, GTK_FILL|GTK_EXPAND, 2, 2); 
      gtk_widget_show (button);

  /* --------------- Passband  -------------------------------------- */


      gtk_widget_realize(top_window); /* needed for style             */

      buttmag[NUM_MAG][ON] = 
	  xpm_button (NULL, top_window, xpm_data_yes, _("Radial Velocity"));

      if (Flags.PlotBand == mag1 || Flags.PlotBand == mag2)
        gtk_toggle_button_set_state (GTK_TOGGLE_BUTTON (buttmag[NUM_MAG][ON]), 
				     TRUE);
      gtk_signal_connect (GTK_OBJECT (buttmag[NUM_MAG][ON]), "toggled",
                      GTK_SIGNAL_FUNC (radio_band), (gpointer) "1");
      gtk_tooltips_set_tip (tooltips, buttmag[NUM_MAG][ON], 
                     "Plot Radial Velocities",NULL);
      gtk_table_attach (GTK_TABLE(table), buttmag[NUM_MAG][ON], 2, 4, 0, 1,
          GTK_FILL|GTK_EXPAND, GTK_FILL|GTK_EXPAND, 2, 2);
      gtk_widget_show (buttmag[NUM_MAG][ON]); 

      group = gtk_radio_button_group(GTK_RADIO_BUTTON (buttmag[NUM_MAG][ON]));

      buttmag[NUM_MAG][OFF] = 
	  xpm_button (group, top_window, xpm_data_no, _("Radial Velocity"));
      gtk_signal_connect (GTK_OBJECT (buttmag[NUM_MAG][OFF]), "toggled",
                      GTK_SIGNAL_FUNC (radio_band), (gpointer) "1");
      gtk_tooltips_set_tip (tooltips, buttmag[NUM_MAG][OFF], 
                     "Plot Radial Velocities",NULL);
      gtk_table_attach (GTK_TABLE(table), buttmag[NUM_MAG][OFF], 2, 4, 0, 1,
          GTK_FILL|GTK_EXPAND, GTK_FILL|GTK_EXPAND, 2, 2); 
      gtk_widget_show (buttmag[NUM_MAG][OFF]);


      group = gtk_radio_button_group(GTK_RADIO_BUTTON (buttmag[NUM_MAG][OFF]));

      buttmag[Umag][ON] = 
	  xpm_button (group, top_window, xpm_data_yes, _("U Band"));
      if (Flags.PlotBand == Umag)
        gtk_toggle_button_set_state (GTK_TOGGLE_BUTTON (buttmag[Umag][ON]), 
				     TRUE);
      gtk_signal_connect (GTK_OBJECT (buttmag[Umag][ON]), "toggled",
                      GTK_SIGNAL_FUNC (radio_band), (gpointer) "U");
      gtk_table_attach (GTK_TABLE(table), buttmag[Umag][ON], 2, 3, 1, 2,
          GTK_FILL|GTK_EXPAND, GTK_FILL|GTK_EXPAND, 2, 2); 
      gtk_widget_show (buttmag[Umag][ON]);

      group = gtk_radio_button_group (GTK_RADIO_BUTTON (buttmag[Umag][ON]));

      buttmag[Umag][OFF] = 
	  xpm_button (group, top_window, xpm_data_no, _("U Band"));
      gtk_signal_connect (GTK_OBJECT (buttmag[Umag][OFF]), "toggled",
                      GTK_SIGNAL_FUNC (radio_band), (gpointer) "U");
      gtk_table_attach (GTK_TABLE(table), buttmag[Umag][OFF], 2, 3, 1, 2,
          GTK_FILL|GTK_EXPAND, GTK_FILL|GTK_EXPAND, 2, 2); 
      gtk_widget_show (buttmag[Umag][OFF]);

      group = gtk_radio_button_group (GTK_RADIO_BUTTON (buttmag[Umag][OFF]));

      buttmag[Bmag][ON] = 
	  xpm_button (group, top_window, xpm_data_yes, _("B Band"));
      if (Flags.PlotBand == Bmag)
        gtk_toggle_button_set_state (GTK_TOGGLE_BUTTON (buttmag[Bmag][ON]), 
				     TRUE);
      gtk_signal_connect (GTK_OBJECT (buttmag[Bmag][ON]), "toggled",
                      GTK_SIGNAL_FUNC (radio_band), (gpointer) "B");
      gtk_table_attach (GTK_TABLE(table), buttmag[Bmag][ON], 3, 4, 1, 2,
          GTK_FILL|GTK_EXPAND, GTK_FILL|GTK_EXPAND, 2, 2); 
      gtk_widget_show (buttmag[Bmag][ON]);

      group = gtk_radio_button_group (GTK_RADIO_BUTTON (buttmag[Bmag][ON]));

      buttmag[Bmag][OFF] = 
	  xpm_button (group, top_window, xpm_data_no, _("B Band"));
      gtk_signal_connect (GTK_OBJECT (buttmag[Bmag][OFF]), "toggled",
                      GTK_SIGNAL_FUNC (radio_band), (gpointer) "B");
      gtk_table_attach (GTK_TABLE(table), buttmag[Bmag][OFF], 3, 4, 1, 2,
          GTK_FILL|GTK_EXPAND, GTK_FILL|GTK_EXPAND, 2, 2); 
      gtk_widget_show (buttmag[Bmag][OFF]);

      group = gtk_radio_button_group (GTK_RADIO_BUTTON (buttmag[Bmag][OFF]));

      buttmag[Vmag][ON] = 
	  xpm_button (group, top_window, xpm_data_yes, _("V Band"));
      if (Flags.PlotBand == Vmag)
        gtk_toggle_button_set_state (GTK_TOGGLE_BUTTON (buttmag[Vmag][ON]), 
				     TRUE);
      gtk_signal_connect (GTK_OBJECT (buttmag[Vmag][ON]), "toggled",
                      GTK_SIGNAL_FUNC (radio_band), (gpointer) "V");
      gtk_table_attach (GTK_TABLE(table), buttmag[Vmag][ON], 2, 3, 2, 3,
          GTK_FILL|GTK_EXPAND, GTK_FILL|GTK_EXPAND, 2, 2); 
      gtk_widget_show (buttmag[Vmag][ON]);

      group = gtk_radio_button_group (GTK_RADIO_BUTTON (buttmag[Vmag][ON]));

      buttmag[Vmag][OFF] = 
	  xpm_button (group, top_window, xpm_data_no, _("V Band"));
      gtk_signal_connect (GTK_OBJECT (buttmag[Vmag][OFF]), "toggled",
                      GTK_SIGNAL_FUNC (radio_band), (gpointer) "V");
      gtk_table_attach (GTK_TABLE(table), buttmag[Vmag][OFF], 2, 3, 2, 3,
          GTK_FILL|GTK_EXPAND, GTK_FILL|GTK_EXPAND, 2, 2); 
      gtk_widget_show (buttmag[Vmag][OFF]);

      group = gtk_radio_button_group (GTK_RADIO_BUTTON (buttmag[Vmag][OFF]));

      buttmag[Rmag][ON] = 
	  xpm_button (group, top_window, xpm_data_yes, _("R Band"));
      if (Flags.PlotBand == Rmag)
        gtk_toggle_button_set_state (GTK_TOGGLE_BUTTON (buttmag[Rmag][ON]), 
				     TRUE);
      gtk_signal_connect (GTK_OBJECT (buttmag[Rmag][ON]), "toggled",
                      GTK_SIGNAL_FUNC (radio_band), (gpointer) "R");
      gtk_table_attach (GTK_TABLE(table), buttmag[Rmag][ON], 3, 4, 2, 3,
          GTK_FILL|GTK_EXPAND, GTK_FILL|GTK_EXPAND, 2, 2); 
      gtk_widget_show (buttmag[Rmag][ON]);

      group = gtk_radio_button_group (GTK_RADIO_BUTTON (buttmag[Rmag][ON]));

      buttmag[Rmag][OFF] = 
	  xpm_button (group, top_window, xpm_data_no, _("R Band"));
      gtk_signal_connect (GTK_OBJECT (buttmag[Rmag][OFF]), "toggled",
                      GTK_SIGNAL_FUNC (radio_band), (gpointer) "R");
      gtk_table_attach (GTK_TABLE(table), buttmag[Rmag][OFF], 3, 4, 2, 3,
          GTK_FILL|GTK_EXPAND, GTK_FILL|GTK_EXPAND, 2, 2); 
      gtk_widget_show (buttmag[Rmag][OFF]);

      group = gtk_radio_button_group (GTK_RADIO_BUTTON (buttmag[Rmag][OFF]));


      buttmag[Imag][ON] = 
	  xpm_button (group, top_window, xpm_data_yes, _("I Band"));
      if (Flags.PlotBand == Imag)
        gtk_toggle_button_set_state (GTK_TOGGLE_BUTTON (buttmag[Imag][ON]), 
				     TRUE);
      gtk_signal_connect (GTK_OBJECT (buttmag[Imag][ON]), "toggled",
                      GTK_SIGNAL_FUNC (radio_band), (gpointer) "I");
      gtk_table_attach (GTK_TABLE(table), buttmag[Imag][ON], 2, 3, 3, 4,
          GTK_FILL|GTK_EXPAND, GTK_FILL|GTK_EXPAND, 2, 2); 
      gtk_widget_show (buttmag[Imag][ON]);

      group = gtk_radio_button_group (GTK_RADIO_BUTTON (buttmag[Imag][ON]));

      buttmag[Imag][OFF] = 
	  xpm_button (group, top_window, xpm_data_no, _("I Band"));
      gtk_signal_connect (GTK_OBJECT (buttmag[Imag][OFF]), "toggled",
                      GTK_SIGNAL_FUNC (radio_band), (gpointer) "I");
      gtk_table_attach (GTK_TABLE(table), buttmag[Imag][OFF], 2, 3, 3, 4,
          GTK_FILL|GTK_EXPAND, GTK_FILL|GTK_EXPAND, 2, 2); 
      gtk_widget_show (buttmag[Imag][OFF]);

      group = gtk_radio_button_group (GTK_RADIO_BUTTON (buttmag[Imag][OFF]));


      buttmag[Jmag][ON] = 
	  xpm_button (group, top_window, xpm_data_yes, _("J Band"));
      if (Flags.PlotBand == Jmag)
        gtk_toggle_button_set_state (GTK_TOGGLE_BUTTON (buttmag[Jmag][ON]), 
				     TRUE);
      gtk_signal_connect (GTK_OBJECT (buttmag[Jmag][ON]), "toggled",
                      GTK_SIGNAL_FUNC (radio_band), (gpointer) "J");
      gtk_table_attach (GTK_TABLE(table), buttmag[Jmag][ON], 3, 4, 3, 4,
          GTK_FILL|GTK_EXPAND, GTK_FILL|GTK_EXPAND, 2, 2); 
      gtk_widget_show (buttmag[Jmag][ON]);

      group = gtk_radio_button_group (GTK_RADIO_BUTTON (buttmag[Jmag][ON]));

      buttmag[Jmag][OFF] = 
	  xpm_button (group, top_window, xpm_data_no, _("J Band"));
      gtk_signal_connect (GTK_OBJECT (buttmag[Jmag][OFF]), "toggled",
                      GTK_SIGNAL_FUNC (radio_band), (gpointer) "J");
      gtk_table_attach (GTK_TABLE(table), buttmag[Jmag][OFF], 3, 4, 3, 4,
          GTK_FILL|GTK_EXPAND, GTK_FILL|GTK_EXPAND, 2, 2); 
      gtk_widget_show (buttmag[Jmag][OFF]);

      group = gtk_radio_button_group (GTK_RADIO_BUTTON (buttmag[Jmag][OFF]));

 
      buttmag[Hmag][ON] = 
	  xpm_button (group, top_window, xpm_data_yes, _("H Band"));
      if (Flags.PlotBand == Hmag)
        gtk_toggle_button_set_state (GTK_TOGGLE_BUTTON (buttmag[Hmag][ON]), 
				     TRUE);
      gtk_signal_connect (GTK_OBJECT (buttmag[Hmag][ON]), "toggled",
                      GTK_SIGNAL_FUNC (radio_band), (gpointer) "H");
      gtk_table_attach (GTK_TABLE(table), buttmag[Hmag][ON], 2, 3, 4, 5,
          GTK_FILL|GTK_EXPAND, GTK_FILL|GTK_EXPAND, 2, 2); 
      gtk_widget_show (buttmag[Hmag][ON]);

      group = gtk_radio_button_group (GTK_RADIO_BUTTON (buttmag[Hmag][ON]));

      buttmag[Hmag][OFF] = 
	  xpm_button (group, top_window, xpm_data_no, _("H Band"));
      gtk_signal_connect (GTK_OBJECT (buttmag[Hmag][OFF]), "toggled",
                      GTK_SIGNAL_FUNC (radio_band), (gpointer) "H");
      gtk_table_attach (GTK_TABLE(table), buttmag[Hmag][OFF], 2, 3, 4, 5,
          GTK_FILL|GTK_EXPAND, GTK_FILL|GTK_EXPAND, 2, 2); 
      gtk_widget_show (buttmag[Hmag][OFF]);

      group = gtk_radio_button_group (GTK_RADIO_BUTTON (buttmag[Hmag][OFF]));



      buttmag[Kmag][ON] = 
	  xpm_button (group, top_window, xpm_data_yes, _("K Band"));
      if (Flags.PlotBand == Kmag)
        gtk_toggle_button_set_state (GTK_TOGGLE_BUTTON (buttmag[Kmag][ON]), 
				     TRUE);
      gtk_signal_connect (GTK_OBJECT (buttmag[Kmag][ON]), "toggled",
                      GTK_SIGNAL_FUNC (radio_band), (gpointer) "K");
      gtk_table_attach (GTK_TABLE(table), buttmag[Kmag][ON], 3, 4, 4, 5,
          GTK_FILL|GTK_EXPAND, GTK_FILL|GTK_EXPAND, 2, 2); 
      gtk_widget_show (buttmag[Kmag][ON]);

      group = gtk_radio_button_group (GTK_RADIO_BUTTON (buttmag[Kmag][ON]));

      buttmag[Kmag][OFF] = 
	  xpm_button (group, top_window, xpm_data_no, _("K Band"));
      gtk_signal_connect (GTK_OBJECT (buttmag[Kmag][OFF]), "toggled",
                      GTK_SIGNAL_FUNC (radio_band), (gpointer) "K");
      gtk_table_attach (GTK_TABLE(table), buttmag[Kmag][OFF], 3, 4, 4, 5,
          GTK_FILL|GTK_EXPAND, GTK_FILL|GTK_EXPAND, 2, 2); 
      gtk_widget_show (buttmag[Kmag][OFF]);

      group = gtk_radio_button_group (GTK_RADIO_BUTTON (buttmag[Kmag][OFF]));


      buttmag[umag][ON] = 
	  xpm_button (group, top_window, xpm_data_yes, _("Stroemgren u"));
      if (Flags.PlotBand == umag)
        gtk_toggle_button_set_state (GTK_TOGGLE_BUTTON (buttmag[umag][ON]), 
				     TRUE);
      gtk_signal_connect (GTK_OBJECT (buttmag[umag][ON]), "toggled",
                      GTK_SIGNAL_FUNC (radio_band), (gpointer) "u");
      gtk_table_attach (GTK_TABLE(table), buttmag[umag][ON], 2, 3, 5, 6,
          GTK_FILL|GTK_EXPAND, GTK_FILL|GTK_EXPAND, 2, 2); 
      gtk_widget_show (buttmag[umag][ON]);

      group = gtk_radio_button_group (GTK_RADIO_BUTTON (buttmag[umag][ON]));

      buttmag[umag][OFF] = 
	  xpm_button (group, top_window, xpm_data_no, _("Stroemgren u"));
      gtk_signal_connect (GTK_OBJECT (buttmag[umag][OFF]), "toggled",
                      GTK_SIGNAL_FUNC (radio_band), (gpointer) "u");
      gtk_table_attach (GTK_TABLE(table), buttmag[umag][OFF], 2, 3, 5, 6,
          GTK_FILL|GTK_EXPAND, GTK_FILL|GTK_EXPAND, 2, 2); 
      gtk_widget_show (buttmag[umag][OFF]);

      group = gtk_radio_button_group (GTK_RADIO_BUTTON (buttmag[umag][OFF]));


      buttmag[vmag][ON] = 
	  xpm_button (group, top_window, xpm_data_yes, _("Stroemgren v"));
      if (Flags.PlotBand == vmag)
        gtk_toggle_button_set_state (GTK_TOGGLE_BUTTON (buttmag[vmag][ON]), 
				     TRUE);
      gtk_signal_connect (GTK_OBJECT (buttmag[vmag][ON]), "toggled",
                      GTK_SIGNAL_FUNC (radio_band), (gpointer) "v");
      gtk_table_attach (GTK_TABLE(table), buttmag[vmag][ON], 3, 4, 5, 6,
          GTK_FILL|GTK_EXPAND, GTK_FILL|GTK_EXPAND, 2, 2); 
      gtk_widget_show (buttmag[vmag][ON]);

      group = gtk_radio_button_group (GTK_RADIO_BUTTON (buttmag[vmag][ON]));

      buttmag[vmag][OFF] = 
	  xpm_button (group, top_window, xpm_data_no, _("Stroemgren v"));
      gtk_signal_connect (GTK_OBJECT (buttmag[vmag][OFF]), "toggled",
                      GTK_SIGNAL_FUNC (radio_band), (gpointer) "v");
      gtk_table_attach (GTK_TABLE(table), buttmag[vmag][OFF], 3, 4, 5, 6,
          GTK_FILL|GTK_EXPAND, GTK_FILL|GTK_EXPAND, 2, 2); 
      gtk_widget_show (buttmag[vmag][OFF]);

      group = gtk_radio_button_group (GTK_RADIO_BUTTON (buttmag[vmag][OFF]));


      buttmag[bmag][ON] = 
	  xpm_button (group, top_window, xpm_data_yes, _("Stroemgren b"));
      if (Flags.PlotBand == bmag)
        gtk_toggle_button_set_state (GTK_TOGGLE_BUTTON (buttmag[bmag][ON]), 
				     TRUE);
      gtk_signal_connect (GTK_OBJECT (buttmag[bmag][ON]), "toggled",
                      GTK_SIGNAL_FUNC (radio_band), (gpointer) "b");
      gtk_table_attach (GTK_TABLE(table), buttmag[bmag][ON], 2, 3, 6, 7,
          GTK_FILL|GTK_EXPAND, GTK_FILL|GTK_EXPAND, 2, 2); 
      gtk_widget_show (buttmag[bmag][ON]);

      group = gtk_radio_button_group (GTK_RADIO_BUTTON (buttmag[bmag][ON]));

      buttmag[bmag][OFF] = 
	  xpm_button (group, top_window, xpm_data_no, _("Stroemgren b"));
      gtk_signal_connect (GTK_OBJECT (buttmag[bmag][OFF]), "toggled",
                      GTK_SIGNAL_FUNC (radio_band), (gpointer) "b");
      gtk_table_attach (GTK_TABLE(table), buttmag[bmag][OFF], 2, 3, 6, 7,
          GTK_FILL|GTK_EXPAND, GTK_FILL|GTK_EXPAND, 2, 2); 
      gtk_widget_show (buttmag[bmag][OFF]);

      group = gtk_radio_button_group (GTK_RADIO_BUTTON (buttmag[bmag][OFF]));


      buttmag[ymag][ON] = 
	  xpm_button (group, top_window, xpm_data_yes, _("Stroemgren y"));
      if (Flags.PlotBand == ymag)
        gtk_toggle_button_set_state (GTK_TOGGLE_BUTTON (buttmag[ymag][ON]), 
				     TRUE);
      gtk_signal_connect (GTK_OBJECT (buttmag[ymag][ON]), "toggled",
                      GTK_SIGNAL_FUNC (radio_band), (gpointer) "y");
      gtk_table_attach (GTK_TABLE(table), buttmag[ymag][ON], 3, 4, 6, 7,
          GTK_FILL|GTK_EXPAND, GTK_FILL|GTK_EXPAND, 2, 2); 
      gtk_widget_show (buttmag[ymag][ON]);

      group = gtk_radio_button_group (GTK_RADIO_BUTTON (buttmag[ymag][ON]));

      buttmag[ymag][OFF] = 
	  xpm_button (group, top_window, xpm_data_no, _("Stroemgren y"));
      gtk_signal_connect (GTK_OBJECT (buttmag[ymag][OFF]), "toggled",
                      GTK_SIGNAL_FUNC (radio_band), (gpointer) "y");
      gtk_table_attach (GTK_TABLE(table), buttmag[ymag][OFF], 3, 4, 6, 7,
          GTK_FILL|GTK_EXPAND, GTK_FILL|GTK_EXPAND, 2, 2); 
      gtk_widget_show (buttmag[ymag][OFF]);

      showhidepage3 ();   /* set initial show/hide state              */

      gtk_widget_unrealize(top_window); 

  /* --------------- View Geometry Options -------------------------- */


    label = gtk_label_new (_("ViewGeometry Options"));
 
    gtk_table_attach (GTK_TABLE(table), label, 0, 2, 3, 4,
          GTK_FILL|GTK_EXPAND, GTK_FILL|GTK_EXPAND, 2, 2);
    gtk_widget_show (label);

      button = gtk_radio_button_new_with_label (NULL, _("Stars"));
      gtk_signal_connect (GTK_OBJECT (button), "toggled",
                      GTK_SIGNAL_FUNC (radio_visual), (gpointer) "v");
#ifndef _WITH_GNUPLOT
      if (Flags.visualize == ON) {
        gtk_toggle_button_set_state (GTK_TOGGLE_BUTTON (button), TRUE);
#else
      if (Flags.visualize == ON || Flags.visualize == 2
                                || Flags.visualize == 4) {
        gtk_toggle_button_set_state (GTK_TOGGLE_BUTTON (button), TRUE);
#endif
        /* TG_visualstore = Flags.visualize; */
        Flags.visualize = OFF;
      }
      gtk_table_attach (GTK_TABLE(table), button, 0, 1, 4, 5,
          GTK_FILL|GTK_EXPAND, GTK_FILL|GTK_EXPAND, 2, 2); 
      gtk_widget_show (button);

      group = gtk_radio_button_group (GTK_RADIO_BUTTON (button));
      button = gtk_radio_button_new_with_label (group, 
						_("Potential Contours"));
      gtk_signal_connect (GTK_OBJECT (button), "toggled",
                      GTK_SIGNAL_FUNC (radio_visual), (gpointer) "c");
      if (Flags.visualize == 3 || Flags.visualize == OFF) {
        gtk_toggle_button_set_state (GTK_TOGGLE_BUTTON (button), TRUE);
        Flags.visualize = OFF;
      }
      gtk_table_attach (GTK_TABLE(table), button, 0, 1, 5, 6,
          GTK_FILL|GTK_EXPAND, GTK_FILL|GTK_EXPAND, 2, 2); 
      gtk_widget_show (button);  


#ifndef _WITH_GNUPLOT

      group = gtk_radio_button_group (GTK_RADIO_BUTTON (button));
      button = gtk_radio_button_new_with_label (group, _("View Potential"));
      gtk_signal_connect (GTK_OBJECT (button), "toggled",
                      GTK_SIGNAL_FUNC (radio_visual), (gpointer) "i");
      if (Flags.visualize == 2) {
        gtk_toggle_button_set_state (GTK_TOGGLE_BUTTON (button), TRUE);
        Flags.visualize = OFF;
      }      
      gtk_table_attach (GTK_TABLE(table), button, 1, 2, 4, 5,
          GTK_FILL|GTK_EXPAND, GTK_FILL|GTK_EXPAND, 2, 2); 
      gtk_widget_show (button);  

      group = gtk_radio_button_group (GTK_RADIO_BUTTON (button));
      button = gtk_radio_button_new_with_label (group, _("All Three"));
      gtk_signal_connect (GTK_OBJECT (button), "toggled",
                      GTK_SIGNAL_FUNC (radio_visual), (gpointer) "a");
      if (Flags.visualize == 4 ) {
        gtk_toggle_button_set_state (GTK_TOGGLE_BUTTON (button), TRUE);
        Flags.visualize = OFF;
      }      
      gtk_table_attach (GTK_TABLE(table), button, 1, 2, 5, 6,
          GTK_FILL|GTK_EXPAND, GTK_FILL|GTK_EXPAND, 2, 2); 
      gtk_widget_show (button);  

#endif

  /* --------------- Hardcopy  -------------------------------------- */

#ifndef HAVE_GNOME
      button = gtk_check_button_new_with_label (_("postscript"));
#else
      button = gtk_check_button_new ();
      boxpix = gtk_hbox_new (FALSE, 0);
      gtk_container_set_border_width (GTK_CONTAINER (boxpix), 0);

      pixy = gnome_stock_pixmap_widget_at_size(top_window, 
					       GNOME_STOCK_PIXMAP_PRINT,
					       12, 12);
      label = gtk_label_new (_("postscript"));
      gtk_box_pack_start (GTK_BOX (boxpix),
                               pixy, TRUE, TRUE, 0);
      gtk_box_pack_start (GTK_BOX (boxpix), label, TRUE, TRUE, 0); 
      gtk_container_add (GTK_CONTAINER (button), boxpix);
      gtk_widget_show (label);
      gtk_widget_show (pixy);
      gtk_widget_show (boxpix);
#endif

      if (Flags.eps == ON ) 
        gtk_toggle_button_set_state (GTK_TOGGLE_BUTTON (button), TRUE);
      gtk_signal_connect (GTK_OBJECT (button), "toggled",
			  GTK_SIGNAL_FUNC (toggle_psfile), NULL );
      gtk_tooltips_set_tip (tooltips, button, 
			    _("Send graphic output to PS file"),NULL);
      gtk_table_attach (GTK_TABLE(table), button, 0, 2, 6, 7,
			GTK_FILL|GTK_EXPAND, GTK_FILL|GTK_EXPAND, 2, 2);
      gtk_widget_show (button);


  gtk_widget_show (table);
  gtk_box_pack_start (GTK_BOX (inbox), table, FALSE, FALSE, 0);

  return;
}

/******************************************************************
 @package   nightfall
 @author    Rainer Wichmann (rwichman@lsw.uni-heidelberg.de)
 @version   1.0
 @short     Convenience function, creates radio button with image+label
 @tip       Original: Ian Main <imain@gtk.org>, Tony Gale <gale@gtk.org>
 @param     (GSList)    *group          The button group
 @param     (GtkWidget) *parent         The parent window
 @param     (gchar)     *xpm_data       The xpm data
 @param     (gchar)     *label_text     The label
 @return    (GtkWidget) *button   
 @heading   Graphical User Interface
*******************************************************************/
GtkWidget *xpm_button (GSList *group, GtkWidget *parent, 
			     char **xpm_data, 
			     gchar *label_text)
{
  GtkWidget *button;           /* the button to return            */
  GtkWidget *hbox;             /* the hbox for label + image      */
  GtkWidget *label;            /* the label                       */ 
  GtkWidget *pixmapwid;        /* the pixmap widget               */
  GdkPixmap *pixmap;           /* the pixmap                      */
  GdkBitmap *mask;             /* the mask for pixmap             */
  GtkStyle  *style;            /* parent window style             */

  /* create a hbox for xpm and label                              */
  hbox = gtk_hbox_new (FALSE, 0);
  gtk_container_border_width (GTK_CONTAINER (hbox), 2);

  /* the label                                                    */
  label = gtk_label_new (label_text);
  
  /* the xpm                                                      */
  style = gtk_widget_get_style(parent);
    
  /* - load the xpm data                                          */
  pixmap = gdk_pixmap_create_from_xpm_d (parent->window, &mask,
				       &style->bg[GTK_STATE_NORMAL],
				       xpm_data);
  pixmapwid = gtk_pixmap_new (pixmap, mask);

  /* pack the pixmap and label into the hbox                      */
  gtk_box_pack_start (GTK_BOX (hbox),
		      pixmapwid, FALSE, FALSE, 2);
  gtk_box_pack_start (GTK_BOX (hbox), label, FALSE, FALSE, 3);

  gtk_widget_show(pixmapwid);
  gtk_widget_show(label);

  /* create and return the button                                 */
  gtk_widget_show(hbox);

  button = gtk_radio_button_new (group);
  gtk_container_add (GTK_CONTAINER (button), hbox);

  return (button);
}

#endif
