/* NIGHTFALL Light Curve Synthesis Program                                 */
/* Copyright (C) 1998 Rainer Wichmann                                      */
/*                                                                         */
/*  This program is free software; you can redistribute it                 */
/*  and/or modify                                                          */
/*  it under the terms of the GNU General Public License as                */
/*  published by                                                           */
/*  the Free Software Foundation; either version 2 of the License, or      */
/*  (at your option) any later version.                                    */
/*                                                                         */
/*  This program is distributed in the hope that it will be useful,        */
/*  but WITHOUT ANY WARRANTY; without even the implied warranty of         */
/*  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the          */
/*  GNU General Public License for more details.                           */
/*                                                                         */
/*  You should have received a copy of the GNU General Public License      */
/*  along with this program; if not, write to the Free Software            */
/*  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.              */


/* ANSI C forbids an empty source file, so put this outside                */

#include <math.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "Light.h"

#ifdef _WITH_GTK

#ifdef HAVE_GNOME

/******************************************************************
 @package   nightfall
 @author    Rainer Wichmann (rwichman@lsw.uni-heidelberg.de)
 @version   1.0
 @short     About
 @param     (void) 
 @return    (void)   
 @heading   Graphical User Interface
*******************************************************************/
void about_cb ()
{
  GtkWidget *about;
  const gchar *author[]={"Rainer Wichmann <rwichman@lsw.uni-heidelberg.de>", 
			 NULL};

  about=gnome_about_new( _("Nightfall"), VERSION,
                         _("(c) 1998, 1999 Rainer Wichmann"),
                         author,
                         _("Eclipsing Binary Star Program\nFeatures: animated views, synthetic lightcurves, nifty plots ;-)\nBased on a detailed physical model that includes proximity effects such as the nonspherical shape of close binary stars and reflection."),
                         NULL);
  gtk_widget_show(about);
  return;
}

/******************************************************************
 @package   nightfall
 @author    Rainer Wichmann (rwichman@lsw.uni-heidelberg.de)
 @version   1.0
 @short     Configuration
 @param     (void) 
 @return    (void)   
 @heading   Graphical User Interface
*******************************************************************/
void options_configuration_callback(GtkWidget *widget, gpointer data)
{
  show_properties_dialog(); 
  return;
}


GnomeUIInfo filemenu[] = {
  {GNOME_APP_UI_ITEM, 
   N_("Clear memory"), NULL,
   reset_event, NULL, NULL, 
   GNOME_APP_PIXMAP_STOCK, GNOME_STOCK_MENU_BLANK,
   'K', GDK_CONTROL_MASK, NULL},
  {GNOME_APP_UI_ITEM, 
   N_("Open data file..."), NULL,
   select_file, NULL, NULL, 
   GNOME_APP_PIXMAP_STOCK, GNOME_STOCK_MENU_OPEN,
   'D', GDK_CONTROL_MASK, NULL},
  {GNOME_APP_UI_ITEM, 
   N_("Open config file..."), NULL,
   select_config, NULL, NULL, 
   GNOME_APP_PIXMAP_STOCK, GNOME_STOCK_MENU_OPEN,
   'O', GDK_CONTROL_MASK, NULL},
  {GNOME_APP_UI_ITEM, 
   N_("Save configuration..."), NULL,
   out_config, NULL, NULL, 
   GNOME_APP_PIXMAP_STOCK, GNOME_STOCK_MENU_SAVE_AS,
   'S', GDK_CONTROL_MASK, NULL},
  GNOMEUIINFO_SEPARATOR,
  {GNOME_APP_UI_ITEM, 
   N_("Exit"), NULL,
   delete_event, NULL, NULL, 
   GNOME_APP_PIXMAP_STOCK, GNOME_STOCK_MENU_QUIT,
   'Q', GDK_CONTROL_MASK, NULL},
  GNOMEUIINFO_END
};

GnomeUIInfo outputmenu[] = {
  {GNOME_APP_UI_ITEM, 
   N_("PlotCurve"), NULL,
   lightcurveplot_event, NULL, NULL, 
   GNOME_APP_PIXMAP_STOCK, GNOME_STOCK_MENU_BLANK,
   'p', (GdkModifierType)0, NULL},
  {GNOME_APP_UI_ITEM, 
   N_("ViewGeometry"), NULL,
   lightgeometry_event, NULL, NULL, 
   GNOME_APP_PIXMAP_STOCK, GNOME_STOCK_MENU_BLANK,
   'v', (GdkModifierType)0, NULL},
  {GNOME_APP_UI_ITEM, 
   N_("StarView..."), NULL,
   lightstarview_event, NULL, NULL, 
   GNOME_APP_PIXMAP_STOCK, GNOME_STOCK_MENU_BLANK,
   's', (GdkModifierType)0, NULL},
  {GNOME_APP_UI_ITEM, 
   N_("RocheSlicer..."), NULL,
   lightslice_event, NULL, NULL, 
   GNOME_APP_PIXMAP_STOCK, GNOME_STOCK_MENU_BLANK,
   'r', (GdkModifierType)0, NULL},
  {GNOME_APP_UI_ITEM, 
   N_("Profiler..."), NULL,
   profiler_event, NULL, NULL, 
   GNOME_APP_PIXMAP_STOCK, GNOME_STOCK_MENU_BLANK,
   'P', (GdkModifierType)0, NULL},
  {GNOME_APP_UI_ITEM, 
   N_("DataSheet..."), NULL,
   showdata_event, NULL, NULL, 
   GNOME_APP_PIXMAP_STOCK, GNOME_STOCK_MENU_BLANK,
   'd', (GdkModifierType)0, NULL},
  GNOMEUIINFO_END
};

static GnomeUIInfo options_menu[]=
{
  {
    GNOME_APP_UI_ITEM,
    N_("_Preferences"), N_("Application Preferences"),
    options_configuration_callback, NULL, NULL,
    GNOME_APP_PIXMAP_STOCK, GNOME_STOCK_MENU_PREF,
    0, (GdkModifierType)0, NULL
  }, 
  GNOMEUIINFO_END
};



GnomeUIInfo helpmenu[] = {
  {GNOME_APP_UI_ITEM, 
   N_("About..."), N_("Info about this program"),
   about_cb, NULL, NULL, 
   GNOME_APP_PIXMAP_STOCK, GNOME_STOCK_MENU_ABOUT,
   0, (GdkModifierType) 0, NULL},
  GNOMEUIINFO_SEPARATOR,
  GNOMEUIINFO_HELP("nightfall"),
  GNOMEUIINFO_END
};

GnomeUIInfo mainmenu[] = {
  GNOMEUIINFO_SUBTREE(N_("_File"), filemenu),
  GNOMEUIINFO_SUBTREE(N_("_Output"), outputmenu),
  GNOMEUIINFO_SUBTREE(N_("_Options"), options_menu),
  GNOMEUIINFO_SUBTREE(N_("_Help"), helpmenu),
  GNOMEUIINFO_END
};


#endif

/******************************************************************
 @package   nightfall
 @author    Rainer Wichmann (rwichman@lsw.uni-heidelberg.de)
 @version   1.0
 @short     Menu Creation
 @param     (GtkWidget) *menu_bar   The menu bar
 @return    (void)   
 @heading   Graphical User Interface
*******************************************************************/
#ifdef HAVE_GNOME
void MakeMenu()
{

  gnome_app_create_menus(GNOME_APP(top_window), mainmenu);

  menu_plot    = outputmenu[0].widget;
  menu_profile = outputmenu[4].widget;

#else
void MakeMenu(GtkWidget *menu_bar)
{


  GtkWidget   *menu;
  GtkWidget   *root_menu;
  GtkWidget   *menu_items;


  /* -------------- first menu  (File) ---------------------------    */

    menu = gtk_menu_new();

    menu_items = gtk_menu_item_new_with_label(_("Clear memory"));
    gtk_menu_append(GTK_MENU (menu), menu_items);
    gtk_signal_connect (GTK_OBJECT(menu_items), "activate",
			      GTK_SIGNAL_FUNC (reset_event), NULL);
    gtk_widget_show(menu_items);

    menu_items = gtk_menu_item_new_with_label(_("Open data file..."));
    gtk_menu_append(GTK_MENU (menu), menu_items);
    gtk_signal_connect (GTK_OBJECT(menu_items), "activate",
			      GTK_SIGNAL_FUNC (select_file), NULL);
    gtk_widget_show(menu_items);

    menu_items = gtk_menu_item_new_with_label(_("Open config file..."));
    gtk_menu_append(GTK_MENU (menu), menu_items);
    gtk_signal_connect (GTK_OBJECT(menu_items), "activate",
			      GTK_SIGNAL_FUNC (select_config), NULL);
    gtk_widget_show(menu_items);

    menu_items = gtk_menu_item_new_with_label(_("Save configuration..."));
    gtk_menu_append(GTK_MENU (menu), menu_items);
    gtk_signal_connect (GTK_OBJECT(menu_items), "activate",
			      GTK_SIGNAL_FUNC (out_config), NULL);
    gtk_widget_show(menu_items);

    menu_items = gtk_menu_item_new ();
    gtk_menu_append(GTK_MENU (menu),  menu_items);
    gtk_widget_show(menu_items);

    menu_items = gtk_menu_item_new_with_label(_("Exit"));
    gtk_menu_append(GTK_MENU (menu), menu_items);
    gtk_signal_connect (GTK_OBJECT(menu_items), "activate",
			      GTK_SIGNAL_FUNC (delete_event), NULL);
    gtk_widget_show(menu_items);

    root_menu = gtk_menu_item_new_with_label(_("File"));
    gtk_widget_show(root_menu);
    gtk_menu_item_set_submenu(GTK_MENU_ITEM (root_menu), menu);
    gtk_menu_bar_append(GTK_MENU_BAR (menu_bar), root_menu);

  /* -------------- second menu  (Output) ------------------------    */

    menu = gtk_menu_new();

    menu_plot = gtk_menu_item_new_with_label(_("PlotCurve"));
    gtk_menu_append(GTK_MENU (menu), menu_plot);
    gtk_signal_connect (GTK_OBJECT(menu_plot), "activate",
			      GTK_SIGNAL_FUNC (lightcurveplot_event), NULL);
    gtk_widget_show(menu_plot);

    menu_items = gtk_menu_item_new_with_label(_("ViewGeometry"));
    gtk_menu_append(GTK_MENU (menu), menu_items);
    gtk_signal_connect (GTK_OBJECT(menu_items), "activate",
			      GTK_SIGNAL_FUNC (lightgeometry_event), NULL);
    gtk_widget_show(menu_items);

    menu_items = gtk_menu_item_new_with_label(_("StarView..."));
    gtk_menu_append(GTK_MENU (menu), menu_items);
    gtk_signal_connect (GTK_OBJECT(menu_items), "activate",
			      GTK_SIGNAL_FUNC (lightstarview_event), NULL);
    gtk_widget_show(menu_items);

    menu_items = gtk_menu_item_new_with_label(_("RocheSlicer..."));
    gtk_menu_append(GTK_MENU (menu), menu_items);
    gtk_signal_connect (GTK_OBJECT(menu_items), "activate",
			      GTK_SIGNAL_FUNC (lightslice_event), NULL);
    gtk_widget_show(menu_items);

    menu_profile = gtk_menu_item_new_with_label(_("Profiler..."));
    gtk_menu_append(GTK_MENU (menu), menu_profile);
    gtk_signal_connect (GTK_OBJECT(menu_profile), "activate",
			      GTK_SIGNAL_FUNC (profiler_event), NULL);
    gtk_widget_show(menu_profile);

    menu_items = gtk_menu_item_new_with_label(_("DataSheet..."));
    gtk_menu_append(GTK_MENU (menu), menu_items);
    gtk_signal_connect (GTK_OBJECT(menu_items), "activate",
			      GTK_SIGNAL_FUNC (showdata_event), NULL);
    gtk_widget_show(menu_items);

    root_menu = gtk_menu_item_new_with_label(_("Output"));
    gtk_widget_show(root_menu);
    gtk_menu_item_set_submenu(GTK_MENU_ITEM (root_menu), menu);
    gtk_menu_bar_append(GTK_MENU_BAR (menu_bar), root_menu);

  /* -------------- last menu  (Help)  ---------------------------    */

    menu = gtk_menu_new();

    menu_items = gtk_menu_item_new_with_label(_("Menu Bar"));
    gtk_menu_append(GTK_MENU (menu), menu_items);
    gtk_signal_connect (GTK_OBJECT(menu_items), "activate",
			      GTK_SIGNAL_FUNC (help_event), (gpointer) "0");
    gtk_widget_show(menu_items);

    menu_items = gtk_menu_item_new_with_label(_("Basic"));
    gtk_menu_append(GTK_MENU (menu), menu_items);
    gtk_signal_connect (GTK_OBJECT(menu_items), "activate",
			      GTK_SIGNAL_FUNC (help_event), (gpointer) "1");
    gtk_widget_show(menu_items);

    menu_items = gtk_menu_item_new_with_label(_("Advanced"));
    gtk_menu_append(GTK_MENU (menu), menu_items);
    gtk_signal_connect (GTK_OBJECT(menu_items), "activate",
			      GTK_SIGNAL_FUNC (help_event), (gpointer) "2");
    gtk_widget_show(menu_items);

    menu_items = gtk_menu_item_new_with_label(_("Plot Options"));
    gtk_menu_append(GTK_MENU (menu), menu_items);
    gtk_signal_connect (GTK_OBJECT(menu_items), "activate",
			      GTK_SIGNAL_FUNC (help_event), (gpointer) "3");
    gtk_widget_show(menu_items);

    menu_items = gtk_menu_item_new_with_label(_("Data Fitting"));
    gtk_menu_append(GTK_MENU (menu), menu_items);
    gtk_signal_connect (GTK_OBJECT(menu_items), "activate",
			      GTK_SIGNAL_FUNC (help_event), (gpointer) "4");
    gtk_widget_show(menu_items);

    menu_items = gtk_menu_item_new_with_label(_("Spots Primary"));
    gtk_menu_append(GTK_MENU (menu), menu_items);
    gtk_signal_connect (GTK_OBJECT(menu_items), "activate",
			      GTK_SIGNAL_FUNC (help_event), (gpointer) "5");
    gtk_widget_show(menu_items);

    menu_items = gtk_menu_item_new_with_label(_("Spots Secondary"));
    gtk_menu_append(GTK_MENU (menu), menu_items);
    gtk_signal_connect (GTK_OBJECT(menu_items), "activate",
			      GTK_SIGNAL_FUNC (help_event), (gpointer) "6");
    gtk_widget_show(menu_items);

    menu_items = gtk_menu_item_new_with_label(_("Third Light"));
    gtk_menu_append(GTK_MENU (menu), menu_items);
    gtk_signal_connect (GTK_OBJECT(menu_items), "activate",
			      GTK_SIGNAL_FUNC (help_event), (gpointer) "7");
    gtk_widget_show(menu_items);


    root_menu = gtk_menu_item_new_with_label(_("Help"));
    gtk_widget_show(root_menu);
    gtk_menu_item_set_submenu(GTK_MENU_ITEM (root_menu), menu);
    gtk_menu_bar_append(GTK_MENU_BAR (menu_bar), root_menu);
    gtk_menu_item_right_justify( GTK_MENU_ITEM (root_menu) );

  /* -------------- show menu bar  -------------------------------    */

  gtk_widget_show(menu_bar);

#endif

  gtk_widget_set_sensitive(menu_plot,    FALSE);
  gtk_widget_set_sensitive(menu_profile, FALSE);

  return;

}

#endif
