/* NIGHTFALL Light Curve Synthesis Program                                 */
/* Copyright (C) 1998 Rainer Wichmann                                      */
/*                                                                         */
/*  This program is free software; you can redistribute it                 */
/*  and/or modify                                                          */
/*  it under the terms of the GNU General Public License as                */
/*  published by                                                           */
/*  the Free Software Foundation; either version 2 of the License, or      */
/*  (at your option) any later version.                                    */
/*                                                                         */
/*  This program is distributed in the hope that it will be useful,        */
/*  but WITHOUT ANY WARRANTY; without even the implied warranty of         */
/*  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the          */
/*  GNU General Public License for more details.                           */
/*                                                                         */
/*  You should have received a copy of the GNU General Public License      */
/*  along with this program; if not, write to the Free Software            */
/*  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.              */

/* ANSI C forbids an empty source file, so put this outside                */

#include <math.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "Light.h"

#ifdef _WITH_GTK

/* ------------------- text entry fields ------------------------ */

/******************************************************************
 @package   nightfall
 @author    Rainer Wichmann (rwichman@lsw.uni-heidelberg.de)
 @version   1.0
 @short     Callback function for name entry
 @param     (GtkWidget) *widget     Discarded
 @param     (GtkWidget) *entry      The entry text
 @return    (void)   
 @heading   Graphical User Interface
*******************************************************************/
void enter_name(GtkWidget *widget, GtkWidget *entry)
{ 
  int   test;  gchar *entry_text;
  entry_text = gtk_entry_get_text(GTK_ENTRY(entry));
  test = sscanf(entry_text, "%128s", Orbit.Name);
 
}

/******************************************************************
 @package   nightfall
 @author    Rainer Wichmann (rwichman@lsw.uni-heidelberg.de)
 @version   1.0
 @short     Callback function for period entry
 @param     (GtkWidget) *widget     Discarded
 @param     (GtkWidget) *entry      The entry text
 @return    (void)   
 @heading   Graphical User Interface
*******************************************************************/
void enter_abs_period(GtkWidget *widget, GtkWidget *entry)
{ 
  float f;  int   test;  gchar *entry_text;
  entry_text = gtk_entry_get_text(GTK_ENTRY(entry));
  test = sscanf(entry_text, "%f", &f);
  if (test == 1 && f >= 0.0) {
    Orbit.TruePeriod = f;
    /* convert days to seconds */
    Orbit.TruePeriod = Orbit.TruePeriod * 86400.;
  }  else {
    Orbit.TruePeriod = 0.0;
  }
  return;
}

/******************************************************************
 @package   nightfall
 @author    Rainer Wichmann (rwichman@lsw.uni-heidelberg.de)
 @version   1.0
 @short     Callback function for mass entry
 @param     (GtkWidget) *widget     Discarded
 @param     (GtkWidget) *entry      The entry text
 @return    (void)   
 @heading   Graphical User Interface
*******************************************************************/
void enter_abs_mass(GtkWidget *widget, GtkWidget *entry)
{ 
  float f;  int   test;  gchar *entry_text;
  entry_text = gtk_entry_get_text(GTK_ENTRY(entry));
  test = sscanf(entry_text, "%f", &f);
  if (test == 1 && f >= 0.0) { 
    Orbit.TrueMass = f;
    /* convert solar masses to KG */
    Orbit.TrueMass = Orbit.TrueMass * 1.989E30;
  } else {
    Orbit.TrueMass = 0.0;
  }
  return;
}

/******************************************************************
 @package   nightfall
 @author    Rainer Wichmann (rwichman@lsw.uni-heidelberg.de)
 @version   1.0
 @short     Callback function for separation entry
 @param     (GtkWidget) *widget     Discarded
 @param     (GtkWidget) *entry      The entry text
 @return    (void)   
 @heading   Graphical User Interface
*******************************************************************/
void enter_abs_distance(GtkWidget *widget, GtkWidget *entry)
{ 
  float f;  int   test;  gchar *entry_text;
  entry_text = gtk_entry_get_text(GTK_ENTRY(entry));
  test = sscanf(entry_text, "%f", &f);
  if (test == 1 && f >= 0.0) {
    Orbit.TrueDistance = f;
    /* convert solar radius to meter */
    Orbit.TrueDistance = Orbit.TrueDistance * 6.960E8;
  } else {
    Orbit.TrueDistance = 0.0;
  }
  return;
}

/******************************************************************
 @package   nightfall
 @author    Rainer Wichmann (rwichman@lsw.uni-heidelberg.de)
 @version   1.0
 @short     Callback function for step 1 entry
 @param     (GtkWidget) *widget     Discarded
 @param     (GtkWidget) *entry      The entry text
 @return    (void)   
 @heading   Graphical User Interface
*******************************************************************/
void enter_step1(GtkWidget *widget, GtkWidget *entry)
{ 
  float f;  int   test;  gchar *entry_text;
  entry_text = gtk_entry_get_text(GTK_ENTRY(entry));
  test = sscanf(entry_text, "%f", &f);
  if (test == 1 && f >= FLT_EPSILON) Flags.Step[0] = f; 
}

/******************************************************************
 @package   nightfall
 @author    Rainer Wichmann (rwichman@lsw.uni-heidelberg.de)
 @version   1.0
 @short     Callback function for step 2 entry
 @param     (GtkWidget) *widget     Discarded
 @param     (GtkWidget) *entry      The entry text
 @return    (void)   
 @heading   Graphical User Interface
*******************************************************************/
void enter_step2(GtkWidget *widget, GtkWidget *entry)
{ 
  float f;  int   test;  gchar *entry_text;
  entry_text = gtk_entry_get_text(GTK_ENTRY(entry));
  test = sscanf(entry_text, "%f", &f);
  if (test == 1 && f >= FLT_EPSILON) Flags.Step[1] = f; 
}

/******************************************************************
 @package   nightfall
 @author    Rainer Wichmann (rwichman@lsw.uni-heidelberg.de)
 @version   1.0
 @short     Callback function for third light U entry
 @param     (GtkWidget) *widget     Discarded
 @param     (GtkWidget) *entry      The entry text
 @return    (void)   
 @heading   Graphical User Interface
*******************************************************************/
void enter_thirdU(GtkWidget *widget, GtkWidget *entry)
{ 
  float f;  int   test;  gchar *entry_text;
  entry_text = gtk_entry_get_text(GTK_ENTRY(entry));
  test = sscanf(entry_text, "%f", &f);
  if (test == 1) Orbit.Third[Umag] = f; 
}

/******************************************************************
 @package   nightfall
 @author    Rainer Wichmann (rwichman@lsw.uni-heidelberg.de)
 @version   1.0
 @short     Callback function for third light B entry
 @param     (GtkWidget) *widget     Discarded
 @param     (GtkWidget) *entry      The entry text
 @return    (void)   
 @heading   Graphical User Interface
*******************************************************************/
void enter_thirdB(GtkWidget *widget, GtkWidget *entry)
{ 
  float f;  int   test;  gchar *entry_text;
  entry_text = gtk_entry_get_text(GTK_ENTRY(entry));
  test = sscanf(entry_text, "%f", &f);
  if (test == 1) Orbit.Third[Bmag] = f; 
}

/******************************************************************
 @package   nightfall
 @author    Rainer Wichmann (rwichman@lsw.uni-heidelberg.de)
 @version   1.0
 @short     Callback function for third light V entry
 @param     (GtkWidget) *widget     Discarded
 @param     (GtkWidget) *entry      The entry text
 @return    (void)   
 @heading   Graphical User Interface
*******************************************************************/
void enter_thirdV(GtkWidget *widget, GtkWidget *entry)
{ 
  float f;  int   test;  gchar *entry_text;
  entry_text = gtk_entry_get_text(GTK_ENTRY(entry));
  test = sscanf(entry_text, "%f", &f);
  if (test == 1) Orbit.Third[Vmag] = f; 
}

/******************************************************************
 @package   nightfall
 @author    Rainer Wichmann (rwichman@lsw.uni-heidelberg.de)
 @version   1.0
 @short     Callback function for third light R entry
 @param     (GtkWidget) *widget     Discarded
 @param     (GtkWidget) *entry      The entry text
 @return    (void)   
 @heading   Graphical User Interface
*******************************************************************/
void enter_thirdR(GtkWidget *widget, GtkWidget *entry)
{ 
  float f;  int   test;  gchar *entry_text;
  entry_text = gtk_entry_get_text(GTK_ENTRY(entry));
  test = sscanf(entry_text, "%f", &f);
  if (test == 1) Orbit.Third[Rmag] = f; 
}

/******************************************************************
 @package   nightfall
 @author    Rainer Wichmann (rwichman@lsw.uni-heidelberg.de)
 @version   1.0
 @short     Callback function for third light I entry
 @param     (GtkWidget) *widget     Discarded
 @param     (GtkWidget) *entry      The entry text
 @return    (void)   
 @heading   Graphical User Interface
*******************************************************************/
void enter_thirdI(GtkWidget *widget, GtkWidget *entry)
{ 
  float f;  int   test;  gchar *entry_text;
  entry_text = gtk_entry_get_text(GTK_ENTRY(entry));
  test = sscanf(entry_text, "%f", &f);
  if (test == 1) Orbit.Third[Imag] = f; 
}

/******************************************************************
 @package   nightfall
 @author    Rainer Wichmann (rwichman@lsw.uni-heidelberg.de)
 @version   1.0
 @short     Callback function for third light J entry
 @param     (GtkWidget) *widget     Discarded
 @param     (GtkWidget) *entry      The entry text
 @return    (void)   
 @heading   Graphical User Interface
*******************************************************************/
void enter_thirdJ(GtkWidget *widget, GtkWidget *entry)
{ 
  float f;  int   test;  gchar *entry_text;
  entry_text = gtk_entry_get_text(GTK_ENTRY(entry));
  test = sscanf(entry_text, "%f", &f);
  if (test == 1) Orbit.Third[Jmag] = f; 
}

/******************************************************************
 @package   nightfall
 @author    Rainer Wichmann (rwichman@lsw.uni-heidelberg.de)
 @version   1.0
 @short     Callback function for third light H entry
 @param     (GtkWidget) *widget     Discarded
 @param     (GtkWidget) *entry      The entry text
 @return    (void)   
 @heading   Graphical User Interface
*******************************************************************/
void enter_thirdH(GtkWidget *widget, GtkWidget *entry)
{ 
  float f;  int   test;  gchar *entry_text;
  entry_text = gtk_entry_get_text(GTK_ENTRY(entry));
  test = sscanf(entry_text, "%f", &f);
  if (test == 1) Orbit.Third[Hmag] = f; 
}

/******************************************************************
 @package   nightfall
 @author    Rainer Wichmann (rwichman@lsw.uni-heidelberg.de)
 @version   1.0
 @short     Callback function for third light K entry
 @param     (GtkWidget) *widget     Discarded
 @param     (GtkWidget) *entry      The entry text
 @return    (void)   
 @heading   Graphical User Interface
*******************************************************************/
void enter_thirdK(GtkWidget *widget, GtkWidget *entry)
{ 
  float f;  int   test;  gchar *entry_text;
  entry_text = gtk_entry_get_text(GTK_ENTRY(entry));
  test = sscanf(entry_text, "%f", &f);
  if (test == 1) Orbit.Third[Kmag] = f; 
}

/******************************************************************
 @package   nightfall
 @author    Rainer Wichmann (rwichman@lsw.uni-heidelberg.de)
 @version   1.0
 @short     Callback function for third light u entry
 @param     (GtkWidget) *widget     Discarded
 @param     (GtkWidget) *entry      The entry text
 @return    (void)   
 @heading   Graphical User Interface
*******************************************************************/
void enter_thirdu(GtkWidget *widget, GtkWidget *entry)
{ 
  float f;  int   test;  gchar *entry_text;
  entry_text = gtk_entry_get_text(GTK_ENTRY(entry));
  test = sscanf(entry_text, "%f", &f);
  if (test == 1) Orbit.Third[umag] = f; 
}

/******************************************************************
 @package   nightfall
 @author    Rainer Wichmann (rwichman@lsw.uni-heidelberg.de)
 @version   1.0
 @short     Callback function for third light v entry
 @param     (GtkWidget) *widget     Discarded
 @param     (GtkWidget) *entry      The entry text
 @return    (void)   
 @heading   Graphical User Interface
*******************************************************************/
void enter_thirdv(GtkWidget *widget, GtkWidget *entry)
{ 
  float f;  int   test;  gchar *entry_text;
  entry_text = gtk_entry_get_text(GTK_ENTRY(entry));
  test = sscanf(entry_text, "%f", &f);
  if (test == 1) Orbit.Third[vmag] = f; 
}

/******************************************************************
 @package   nightfall
 @author    Rainer Wichmann (rwichman@lsw.uni-heidelberg.de)
 @version   1.0
 @short     Callback function for third light b entry
 @param     (GtkWidget) *widget     Discarded
 @param     (GtkWidget) *entry      The entry text
 @return    (void)   
 @heading   Graphical User Interface
*******************************************************************/
void enter_thirdb(GtkWidget *widget, GtkWidget *entry)
{ 
  float f;  int   test;  gchar *entry_text;
  entry_text = gtk_entry_get_text(GTK_ENTRY(entry));
  test = sscanf(entry_text, "%f", &f);
  if (test == 1) Orbit.Third[bmag] = f; 
}

/******************************************************************
 @package   nightfall
 @author    Rainer Wichmann (rwichman@lsw.uni-heidelberg.de)
 @version   1.0
 @short     Callback function for third light y entry
 @param     (GtkWidget) *widget     Discarded
 @param     (GtkWidget) *entry      The entry text
 @return    (void)   
 @heading   Graphical User Interface
*******************************************************************/
void enter_thirdy(GtkWidget *widget, GtkWidget *entry)
{ 
  float f;  int   test;  gchar *entry_text;
  entry_text = gtk_entry_get_text(GTK_ENTRY(entry));
  test = sscanf(entry_text, "%f", &f);
  if (test == 1) Orbit.Third[ymag] = f; 
}

/******************************************************************
 @package   nightfall
 @author    Rainer Wichmann (rwichman@lsw.uni-heidelberg.de)
 @version   1.0
 @short     Callback function for longitude entry of first Primary spot 
 @param     (GtkWidget) *widget     Discarded
 @param     (GtkWidget) *entry      The entry text
 @return    (void)   
 @heading   Graphical User Interface
*******************************************************************/
void enter_longitude_p_spot1(GtkWidget *widget, GtkWidget *entry)
{
  float f;    int   test;      gchar *entry_text;
  entry_text = gtk_entry_get_text(GTK_ENTRY(entry));
  test = sscanf(entry_text, "%f", &f);  
  if (test == 1) { SpotStore[Primary][0].longitude = f;
                   if (SpotActive[0] == ON) Spot[Primary][0].longitude = f; }
}
/******************************************************************
 @package   nightfall
 @author    Rainer Wichmann (rwichman@lsw.uni-heidelberg.de)
 @version   1.0
 @short     Callback function for longitude entry of second Primary spot
 @param     (GtkWidget) *widget     Discarded
 @param     (GtkWidget) *entry      The entry text
 @return    (void)   
 @heading   Graphical User Interface
*******************************************************************/
void enter_longitude_p_spot2(GtkWidget *widget, GtkWidget *entry)
{
  float f;    int   test;      gchar *entry_text;
  entry_text = gtk_entry_get_text(GTK_ENTRY(entry));
  test = sscanf(entry_text, "%f", &f);  
  if (test == 1) { SpotStore[Primary][1].longitude = f;
                   if (SpotActive[1] == ON && SpotActive[0] == ON) 
                             Spot[Primary][1].longitude = f; 
                   if (SpotActive[1] == ON && SpotActive[0] == OFF) 
                             Spot[Primary][0].longitude = f; }
}
/******************************************************************
 @package   nightfall
 @author    Rainer Wichmann (rwichman@lsw.uni-heidelberg.de)
 @version   1.0
 @short     Callback function for longitude entry of first Secondary spot
 @param     (GtkWidget) *widget     Discarded
 @param     (GtkWidget) *entry      The entry text
 @return    (void)   
 @heading   Graphical User Interface
*******************************************************************/
void enter_longitude_s_spot1(GtkWidget *widget, GtkWidget *entry)
{
  float f;    int   test;      gchar *entry_text;
  entry_text = gtk_entry_get_text(GTK_ENTRY(entry));
  test = sscanf(entry_text, "%f", &f);  
  if (test == 1) { SpotStore[Secondary][0].longitude = f;
                   if (SpotActive[2] == ON) Spot[Secondary][0].longitude = f; }
}
/******************************************************************
 @package   nightfall
 @author    Rainer Wichmann (rwichman@lsw.uni-heidelberg.de)
 @version   1.0
 @short     Callback function for longitude entry of second Secondary spot
 @param     (GtkWidget) *widget     Discarded
 @param     (GtkWidget) *entry      The entry text
 @return    (void)   
 @heading   Graphical User Interface
*******************************************************************/
void enter_longitude_s_spot2(GtkWidget *widget, GtkWidget *entry)
{
  float f;    int   test;      gchar *entry_text;
  entry_text = gtk_entry_get_text(GTK_ENTRY(entry));
  test = sscanf(entry_text, "%f", &f);  
  if (test == 1) { SpotStore[Secondary][1].longitude = f;
                   if (SpotActive[3] == ON && SpotActive[2]== ON) 
                       Spot[Secondary][1].longitude = f;  
                   if (SpotActive[3] == ON && SpotActive[2]== OFF) 
                       Spot[Secondary][0].longitude = f; }
}
/******************************************************************
 @package   nightfall
 @author    Rainer Wichmann (rwichman@lsw.uni-heidelberg.de)
 @version   1.0
 @short     Callback function for latitude entry of first Primary spot
 @param     (GtkWidget) *widget     Discarded
 @param     (GtkWidget) *entry      The entry text
 @return    (void)   
 @heading   Graphical User Interface
*******************************************************************/
void enter_latitude_p_spot1(GtkWidget *widget, GtkWidget *entry)
{
  float f;    int   test;      gchar *entry_text;
  entry_text = gtk_entry_get_text(GTK_ENTRY(entry));
  test = sscanf(entry_text, "%f", &f);  
  if (test == 1) { SpotStore[Primary][0].latitude = f;
                   if (SpotActive[0] == ON) Spot[Primary][0].latitude = f; }
}
/******************************************************************
 @package   nightfall
 @author    Rainer Wichmann (rwichman@lsw.uni-heidelberg.de)
 @version   1.0
 @short     Callback function for latitude entry of second Primary spot
 @param     (GtkWidget) *widget     Discarded
 @param     (GtkWidget) *entry      The entry text
 @return    (void)   
 @heading   Graphical User Interface
*******************************************************************/
void enter_latitude_p_spot2(GtkWidget *widget, GtkWidget *entry)
{
  float f;    int   test;      gchar *entry_text;
  entry_text = gtk_entry_get_text(GTK_ENTRY(entry));
  test = sscanf(entry_text, "%f", &f);  
  if (test == 1) { SpotStore[Primary][1].latitude = f;
                   if (SpotActive[1] == ON && SpotActive[0] == ON) 
                             Spot[Primary][1].latitude = f; 
                   if (SpotActive[1] == ON && SpotActive[0] == OFF) 
                             Spot[Primary][0].latitude = f; }
}
/******************************************************************
 @package   nightfall
 @author    Rainer Wichmann (rwichman@lsw.uni-heidelberg.de)
 @version   1.0
 @short     Callback function for latitude entry of first Secondary spot
 @param     (GtkWidget) *widget     Discarded
 @param     (GtkWidget) *entry      The entry text
 @return    (void)   
 @heading   Graphical User Interface
*******************************************************************/
void enter_latitude_s_spot1(GtkWidget *widget, GtkWidget *entry)
{
  float f;    int   test;      gchar *entry_text;
  entry_text = gtk_entry_get_text(GTK_ENTRY(entry));
  test = sscanf(entry_text, "%f", &f);  
  if (test == 1) { SpotStore[Secondary][0].latitude = f;
                   if (SpotActive[2] == ON) Spot[Secondary][0].latitude = f; }
}
/******************************************************************
 @package   nightfall
 @author    Rainer Wichmann (rwichman@lsw.uni-heidelberg.de)
 @version   1.0
 @short     Callback function for latitude entry of second Secondary spot
 @param     (GtkWidget) *widget     Discarded
 @param     (GtkWidget) *entry      The entry text
 @return    (void)   
 @heading   Graphical User Interface
*******************************************************************/
void enter_latitude_s_spot2(GtkWidget *widget, GtkWidget *entry)
{
  float f;    int   test;      gchar *entry_text;
  entry_text = gtk_entry_get_text(GTK_ENTRY(entry));
  test = sscanf(entry_text, "%f", &f);  
  if (test == 1) { SpotStore[Secondary][1].latitude = f;
                   if (SpotActive[3] == ON && SpotActive[2]== ON) 
                       Spot[Secondary][1].latitude = f;  
                   if (SpotActive[3] == ON && SpotActive[2]== OFF) 
                       Spot[Secondary][0].latitude = f; }
}

/******************************************************************
 @package   nightfall
 @author    Rainer Wichmann (rwichman@lsw.uni-heidelberg.de)
 @version   1.0
 @short     Callback function for radius entry of first Primary spot 
 @param     (GtkWidget) *widget     Discarded
 @param     (GtkWidget) *entry      The entry text
 @return    (void)   
 @heading   Graphical User Interface
*******************************************************************/
void enter_radius_p_spot1(GtkWidget *widget, GtkWidget *entry)
{
  float f;    int   test;      gchar *entry_text;
  entry_text = gtk_entry_get_text(GTK_ENTRY(entry));
  test = sscanf(entry_text, "%f", &f);  
  if (test == 1) { SpotStore[Primary][0].radius = f;
                   if (SpotActive[0] == ON) Spot[Primary][0].radius = f; }
}
/******************************************************************
 @package   nightfall
 @author    Rainer Wichmann (rwichman@lsw.uni-heidelberg.de)
 @version   1.0
 @short     Callback function for radius entry of second Primary spot 
 @param     (GtkWidget) *widget     Discarded
 @param     (GtkWidget) *entry      The entry text
 @return    (void)   
 @heading   Graphical User Interface
*******************************************************************/
void enter_radius_p_spot2(GtkWidget *widget, GtkWidget *entry)
{
  float f;    int   test;      gchar *entry_text;
  entry_text = gtk_entry_get_text(GTK_ENTRY(entry));
  test = sscanf(entry_text, "%f", &f);  
  if (test == 1) { SpotStore[Primary][1].radius = f;
                   if (SpotActive[1] == ON && SpotActive[0] == ON) 
                             Spot[Primary][1].radius = f; 
                   if (SpotActive[1] == ON && SpotActive[0] == OFF) 
                             Spot[Primary][0].radius = f; }
}
/******************************************************************
 @package   nightfall
 @author    Rainer Wichmann (rwichman@lsw.uni-heidelberg.de)
 @version   1.0
 @short     Callback function for radius entry of first Secondary spot 
 @param     (GtkWidget) *widget     Discarded
 @param     (GtkWidget) *entry      The entry text
 @return    (void)   
 @heading   Graphical User Interface
*******************************************************************/
void enter_radius_s_spot1(GtkWidget *widget, GtkWidget *entry)
{
  float f;    int   test;      gchar *entry_text;
  entry_text = gtk_entry_get_text(GTK_ENTRY(entry));
  test = sscanf(entry_text, "%f", &f);  
  if (test == 1) { SpotStore[Secondary][0].radius = f;
                   if (SpotActive[2] == ON) Spot[Secondary][0].radius = f; }
}
/******************************************************************
 @package   nightfall
 @author    Rainer Wichmann (rwichman@lsw.uni-heidelberg.de)
 @version   1.0
 @short     Callback function for radius entry of second Secondary spot 
 @param     (GtkWidget) *widget     Discarded
 @param     (GtkWidget) *entry      The entry text
 @return    (void)   
 @heading   Graphical User Interface
*******************************************************************/
void enter_radius_s_spot2(GtkWidget *widget, GtkWidget *entry)
{
  float f;    int   test;      gchar *entry_text;
  entry_text = gtk_entry_get_text(GTK_ENTRY(entry));
  test = sscanf(entry_text, "%f", &f);  
  if (test == 1) { 
    SpotStore[Secondary][1].radius = f;
    if (SpotActive[3] == ON && SpotActive[2]== ON) 
      Spot[Secondary][1].radius = f;  
    if (SpotActive[3] == ON && SpotActive[2]== OFF) 
      Spot[Secondary][0].radius = f; 
  }
}

/******************************************************************
 @package   nightfall
 @author    Rainer Wichmann (rwichman@lsw.uni-heidelberg.de)
 @version   1.0
 @short     Callback function for dimfactor entry of first Primary spot 
 @param     (GtkWidget) *widget     Discarded
 @param     (GtkWidget) *entry      The entry text
 @return    (void)   
 @heading   Graphical User Interface
*******************************************************************/
void enter_dimfactor_p_spot1(GtkWidget *widget, GtkWidget *entry)
{
  float f;    int   test;      gchar *entry_text;
  entry_text = gtk_entry_get_text(GTK_ENTRY(entry));
  test = sscanf(entry_text, "%f", &f);  
  if (test == 1) { 
    SpotStore[Primary][0].dimfactor = f;
    if (SpotActive[0] == ON) 
      Spot[Primary][0].dimfactor = f; 
  }
}
/******************************************************************
 @package   nightfall
 @author    Rainer Wichmann (rwichman@lsw.uni-heidelberg.de)
 @version   1.0
 @short     Callback function for dimfactor entry of second Primary spot 
 @param     (GtkWidget) *widget     Discarded
 @param     (GtkWidget) *entry      The entry text
 @return    (void)   
 @heading   Graphical User Interface
*******************************************************************/
void enter_dimfactor_p_spot2(GtkWidget *widget, GtkWidget *entry)
{
  float f;    int   test;      gchar *entry_text;
  entry_text = gtk_entry_get_text(GTK_ENTRY(entry));
  test = sscanf(entry_text, "%f", &f);  
  if (test == 1) { SpotStore[Primary][1].dimfactor = f;
                   if (SpotActive[1] == ON && SpotActive[0] == ON) 
                             Spot[Primary][1].dimfactor = f; 
                   if (SpotActive[1] == ON && SpotActive[0] == OFF) 
                             Spot[Primary][0].dimfactor = f; }
}
/******************************************************************
 @package   nightfall
 @author    Rainer Wichmann (rwichman@lsw.uni-heidelberg.de)
 @version   1.0
 @short     Callback function for dimfactor entry of first Secondary spot 
 @param     (GtkWidget) *widget     Discarded
 @param     (GtkWidget) *entry      The entry text
 @return    (void)   
 @heading   Graphical User Interface
*******************************************************************/
void enter_dimfactor_s_spot1(GtkWidget *widget, GtkWidget *entry)
{
  float f;    int   test;      gchar *entry_text;
  entry_text = gtk_entry_get_text(GTK_ENTRY(entry));
  test = sscanf(entry_text, "%f", &f);  
  if (test == 1) { SpotStore[Secondary][0].dimfactor = f;
                   if (SpotActive[2] == ON) Spot[Secondary][0].dimfactor = f; }
}
/******************************************************************
 @package   nightfall
 @author    Rainer Wichmann (rwichman@lsw.uni-heidelberg.de)
 @version   1.0
 @short     Callback function for dimfactor entry of second Secondary spot 
 @param     (GtkWidget) *widget     Discarded
 @param     (GtkWidget) *entry      The entry text
 @return    (void)   
 @heading   Graphical User Interface
*******************************************************************/
void enter_dimfactor_s_spot2(GtkWidget *widget, GtkWidget *entry)
{
  float f;    int   test;      gchar *entry_text;
  entry_text = gtk_entry_get_text(GTK_ENTRY(entry));
  test = sscanf(entry_text, "%f", &f);  
  if (test == 1) { SpotStore[Secondary][1].dimfactor = f;
                   if (SpotActive[3] == ON && SpotActive[2]== ON) 
                       Spot[Secondary][1].dimfactor = f;  
                   if (SpotActive[3] == ON && SpotActive[2]== OFF) 
                       Spot[Secondary][0].dimfactor = f; }
}

/******************************************************************
 @package   nightfall
 @author    Rainer Wichmann (rwichman@lsw.uni-heidelberg.de)
 @version   1.0
 @short     Callback function for mass ratio entry 
 @param     (GtkWidget) *widget     Discarded
 @param     (GtkWidget) *entry      The entry text
 @return    (void)   
 @heading   Graphical User Interface
*******************************************************************/
void enter_massratio(GtkWidget *widget, GtkWidget *entry)
{
  float f;
  int   test;
  gchar *entry_text;

  entry_text = gtk_entry_get_text(GTK_ENTRY(entry));
  test = sscanf(entry_text, "%f", &f);
  if (test == 1 && f > FLT_EPSILON)
    { 
      Binary[Primary].Mq   = f; 
      Binary[Secondary].Mq = 1.0/f;
    }
}

/******************************************************************
 @package   nightfall
 @author    Rainer Wichmann (rwichman@lsw.uni-heidelberg.de)
 @version   1.0
 @short     Callback function for inclination entry 
 @param     (GtkWidget) *widget     Discarded
 @param     (GtkWidget) *entry      The entry text
 @return    (void)   
 @heading   Graphical User Interface
*******************************************************************/
void enter_inclination(GtkWidget *widget, GtkWidget *entry)
{
  float f;
  int   test;
  gchar *entry_text;

  entry_text = gtk_entry_get_text(GTK_ENTRY(entry));
  test = sscanf(entry_text, "%f", &f);
  if (test == 1) Orbit.Inclination = DTOR * f; 
}

/******************************************************************
 @package   nightfall
 @author    Rainer Wichmann (rwichman@lsw.uni-heidelberg.de)
 @version   1.0
 @short     Callback function for Primary Roche fill factor entry 
 @param     (GtkWidget) *widget     Discarded
 @param     (GtkWidget) *entry      The entry text
 @return    (void)   
 @heading   Graphical User Interface
*******************************************************************/
void enter_rochefill1(GtkWidget *widget, GtkWidget *entry)
{
  float f;
  int   test;
  gchar *entry_text;

  entry_text = gtk_entry_get_text(GTK_ENTRY(entry));
  test = sscanf(entry_text, "%f", &f);
  if (test == 1) Binary[Primary].RocheFill = f; 
}

/******************************************************************
 @package   nightfall
 @author    Rainer Wichmann (rwichman@lsw.uni-heidelberg.de)
 @version   1.0
 @short     Callback function for Secondary Roche fill factor entry 
 @param     (GtkWidget) *widget     Discarded
 @param     (GtkWidget) *entry      The entry text
 @return    (void)   
 @heading   Graphical User Interface
*******************************************************************/
void enter_rochefill2(GtkWidget *widget, GtkWidget *entry)
{
  float f;
  int   test;
  gchar *entry_text;

  entry_text = gtk_entry_get_text(GTK_ENTRY(entry));
  test = sscanf(entry_text, "%f", &f);
  if (test == 1) Binary[Secondary].RocheFill = f; 
}

/******************************************************************
 @package   nightfall
 @author    Rainer Wichmann (rwichman@lsw.uni-heidelberg.de)
 @version   1.0
 @short     Callback function for Primary temperature entry 
 @param     (GtkWidget) *widget     Discarded
 @param     (GtkWidget) *entry      The entry text
 @return    (void)   
 @heading   Graphical User Interface
*******************************************************************/
void enter_temp1(GtkWidget *widget, GtkWidget *entry)
{
  float f;
  int   test;
  gchar *entry_text;

  entry_text = gtk_entry_get_text(GTK_ENTRY(entry));
  test = sscanf(entry_text, "%f", &f);
  if (test == 1) Binary[Primary].Temperature = f; 
}

/******************************************************************
 @package   nightfall
 @author    Rainer Wichmann (rwichman@lsw.uni-heidelberg.de)
 @version   1.0
 @short     Callback function for Secondary temperature entry 
 @param     (GtkWidget) *widget     Discarded
 @param     (GtkWidget) *entry      The entry text
 @return    (void)   
 @heading   Graphical User Interface
*******************************************************************/
void enter_temp2(GtkWidget *widget, GtkWidget *entry)
{
  float f;
  int   test;
  gchar *entry_text;

  entry_text = gtk_entry_get_text(GTK_ENTRY(entry));
  test = sscanf(entry_text, "%f", &f);
  if (test == 1) Binary[Secondary].Temperature = f; 
}

/******************************************************************
 @package   nightfall
 @author    Rainer Wichmann (rwichman@lsw.uni-heidelberg.de)
 @version   1.0
 @short     Callback function for eccentricity entry 
 @param     (GtkWidget) *widget     Discarded
 @param     (GtkWidget) *entry      The entry text
 @return    (void)   
 @heading   Graphical User Interface
*******************************************************************/
void enter_excentricity(GtkWidget *widget, GtkWidget *entry)
{
  float f;
  int   test;
  gchar *entry_text;

  entry_text = gtk_entry_get_text(GTK_ENTRY(entry));
  test = sscanf(entry_text, "%f", &f);
  if (test == 1) Orbit.Excentricity = f; 
}

/******************************************************************
 @package   nightfall
 @author    Rainer Wichmann (rwichman@lsw.uni-heidelberg.de)
 @version   1.0
 @short     Callback function for periastron length entry 
 @param     (GtkWidget) *widget     Discarded
 @param     (GtkWidget) *entry      The entry text
 @return    (void)   
 @heading   Graphical User Interface
*******************************************************************/
void enter_omega(GtkWidget *widget, GtkWidget *entry)
{
  float f;
  int   test;
  gchar *entry_text;

  entry_text = gtk_entry_get_text(GTK_ENTRY(entry));
  test = sscanf(entry_text, "%f", &f);
  if (test == 1) Orbit.Omega = f; 
}

/******************************************************************
 @package   nightfall
 @author    Rainer Wichmann (rwichman@lsw.uni-heidelberg.de)
 @version   1.0
 @short     Callback function for asynchroneous rotation ratio Primary entry 
 @param     (GtkWidget) *widget     Discarded
 @param     (GtkWidget) *entry      The entry text
 @return    (void)   
 @heading   Graphical User Interface
*******************************************************************/
void enter_fratio1(GtkWidget *widget, GtkWidget *entry)
{
  float f;
  int   test;
  gchar *entry_text;

  entry_text = gtk_entry_get_text(GTK_ENTRY(entry));
  test = sscanf(entry_text, "%f", &f);
  if (test == 1) Binary[Primary].Fratio = f; 
}

/******************************************************************
 @package   nightfall
 @author    Rainer Wichmann (rwichman@lsw.uni-heidelberg.de)
 @version   1.0
 @short     Callback function for asynchroneous rotation ratio Secondary entry 
 @param     (GtkWidget) *widget     Discarded
 @param     (GtkWidget) *entry      The entry text
 @return    (void)   
 @heading   Graphical User Interface
*******************************************************************/
void enter_fratio2(GtkWidget *widget, GtkWidget *entry)
{
  float f;
  int   test;
  gchar *entry_text;

  entry_text = gtk_entry_get_text(GTK_ENTRY(entry));
  test = sscanf(entry_text, "%f", &f);
  if (test == 1) Binary[Secondary].Fratio = f; 
}

/******************************************************************
 @package   nightfall
 @author    Rainer Wichmann (rwichman@lsw.uni-heidelberg.de)
 @version   1.0
 @short     Callback function for line profile rest wavelength entry 
 @param     (GtkWidget) *widget     Discarded
 @param     (GtkWidget) *entry      The entry text
 @return    (void)   
 @heading   Graphical User Interface
*******************************************************************/
void enter_linewave (GtkWidget *widget, GtkWidget *entry)
{
  float f;
  int   test;
  gchar *entry_text;

  entry_text = gtk_entry_get_text(GTK_ENTRY(entry));
  test = sscanf(entry_text, "%f", &f);
  if (test == 1) Orbit.LambdaZero = f; 
}

/******************************************************************
 @package   nightfall
 @author    Rainer Wichmann (rwichman@lsw.uni-heidelberg.de)
 @version   1.0
 @short     Callback function for reflection iterations entry 
 @param     (GtkWidget) *widget     Discarded
 @param     (GtkWidget) *entry      The entry text
 @return    (void)   
 @heading   Graphical User Interface
*******************************************************************/
void enter_reflect_iterations (GtkWidget *widget, GtkWidget *entry)
{
  int   i;
  int   test;
  gchar *entry_text;

  entry_text = gtk_entry_get_text(GTK_ENTRY(entry));
  test = sscanf(entry_text, "%d", &i);
  if (test == 1) {
       TG_reflectstore = i; 
       if (Flags.reflect > 0 && i > 0) Flags.reflect = i;
  }
}

/******************************************************************
 @package   nightfall
 @author    Rainer Wichmann (rwichman@lsw.uni-heidelberg.de)
 @version   1.0
 @short     Callback function for 'number of steps' entry 
 @param     (GtkWidget) *widget     Discarded
 @param     (GtkWidget) *entry      The entry text
 @return    (void)   
 @heading   Graphical User Interface
*******************************************************************/
void enter_phasesteps (GtkWidget *widget, GtkWidget *entry)
{
  int   i;
  int   test;
  gchar *entry_text;

  entry_text = gtk_entry_get_text(GTK_ENTRY(entry));
  test = sscanf(entry_text, "%d", &i);
  if (test == 1) PhaseSteps = i; 
}

/******************************************************************
 @package   nightfall
 @author    Rainer Wichmann (rwichman@lsw.uni-heidelberg.de)
 @version   1.0
 @short     Callback function for fit tolerance entry 
 @param     (GtkWidget) *widget     Discarded
 @param     (GtkWidget) *entry      The entry text
 @return    (void)   
 @heading   Graphical User Interface
*******************************************************************/
void enter_simplextol (GtkWidget *widget, GtkWidget *entry)
{
  float   i;
  int     test;
  gchar   *entry_text;

  entry_text = gtk_entry_get_text(GTK_ENTRY(entry));
  test = sscanf(entry_text, "%f", &i);
  if (test == 1) { 
    Flags.SimplexTol = i;
    
  } 
}



/* --------------------- radio buttons  ------------------------- */




/******************************************************************
 @package   nightfall
 @author    Rainer Wichmann (rwichman@lsw.uni-heidelberg.de)
 @version   1.0
 @short     Callback function for limb darkening radio buttons 
 @param     (GtkWidget) *widget     Discarded
 @param     (GtkWidget) *entry      The entry text
 @return    (void)   
 @heading   Graphical User Interface
*******************************************************************/
void radio_limb (GtkWidget *widget, gpointer *data)
{
  
  int   i;

  sscanf ((char *) data, "%d", &i);
  if(GTK_TOGGLE_BUTTON (widget)->active) {
    /* button is down */
    Flags.limb = i;
  } 
}

/******************************************************************
 @package   nightfall
 @author    Rainer Wichmann (rwichman@lsw.uni-heidelberg.de)
 @version   1.0
 @short     Callback function for passband selection radio buttons 
 @param     (GtkWidget) *widget     Discarded
 @param     (GtkWidget) *entry      The entry text
 @return    (void)   
 @heading   Graphical User Interface
*******************************************************************/
void radio_band (GtkWidget *widget, gpointer *data)
{
  char   i;

  sscanf ((char *) data, "%c", &i);
  if(GTK_TOGGLE_BUTTON (widget)->active) {
    /* button is down */
        switch (i) {
        case '1':
           Flags.PlotBand = mag1;
           break; 
        case 'U':
           Flags.PlotBand = Umag;
           break; 
        case 'B':
           Flags.PlotBand = Bmag;
           break; 
        case 'V':
           Flags.PlotBand = Vmag;
           break;
        case 'R':
           Flags.PlotBand = Rmag;
           break;
        case 'I':
           Flags.PlotBand = Imag;
           break;
        case 'u':
           Flags.PlotBand = umag;
           break;
        case 'v':
           Flags.PlotBand = vmag;
           break;
        case 'b':
           Flags.PlotBand = bmag;
           break;
        case 'y':
           Flags.PlotBand = ymag;
           break;
        case 'J':
           Flags.PlotBand = Jmag;
           break;
        case 'H':
           Flags.PlotBand = Hmag;
           break;
        case 'K':
           Flags.PlotBand = Kmag;
           break;
        default:
           break;    
	 }
  }
}

/******************************************************************
 @package   nightfall
 @author    Rainer Wichmann (rwichman@lsw.uni-heidelberg.de)
 @version   1.0
 @short     Callback function for plot region radio buttons 
 @param     (GtkWidget) *widget     Discarded
 @param     (GtkWidget) *entry      The entry text
 @return    (void)   
 @heading   Graphical User Interface
*******************************************************************/
void radio_graph (GtkWidget *widget, gpointer *data)
{
  char   i;

  sscanf ((char *) data, "%c", &i);
  if(GTK_TOGGLE_BUTTON (widget)->active) {
    /* button is down */
    if (i == 'P') { Flags.plot = 3; } 
    else if (i == '2') { Flags.plot = 2; } 
    else if (i  == 'S') { Flags.plot = 4; }
    else if (i  == '1') { Flags.plot = ON; } 

    TG_graphstore = Flags.plot;
    Flags.plot = OFF;
  } 
}

/******************************************************************
 @package   nightfall
 @author    Rainer Wichmann (rwichman@lsw.uni-heidelberg.de)
 @version   1.0
 @short     Callback function for ViewGeometry type radio buttons 
 @param     (GtkWidget) *widget     Discarded
 @param     (GtkWidget) *entry      The entry text
 @return    (void)   
 @heading   Graphical User Interface
*******************************************************************/
void radio_visual (GtkWidget *widget, gpointer *data)
{
  char   i;

  sscanf ((char *) data, "%c", &i);
  if(GTK_TOGGLE_BUTTON (widget)->active) {
    /* button is down */
        switch (i) {
        case 'v':
           Flags.visualize = ON;
           break;
        case 'i':
           Flags.visualize = 2;
           break;
        case 'c':
           Flags.visualize = 3;
           break;
        case 'a':
           Flags.visualize = 4;
           break;
        default:
           Flags.visualize = ON;
           break;
        }

    TG_visualstore = Flags.visualize;
    Flags.visualize = OFF;
  } 
}

#endif













