/************************************************
  
   Variables for temporary storage of data

*************************************************/

extern int        TG_reflectstore;
extern int        TG_graphstore;
extern int        TG_visualstore;
extern int        TG_P1spot, TG_P2spot;
extern int        TG_S1spot, TG_S2spot;
extern int        SpotActive[4];
extern int        TG_1spots, TG_2spots;
extern int        FitSpotS[16];
extern SpotLight  SpotStore[2][2];            /* surface spots             */

/************************************************
  
   Global widgets

*************************************************/


/* -------------------  entry fields (basic)  --------------------- */

extern   GtkWidget   *e_101;         /* mass ratio                  */
extern   GtkWidget   *e_102;         /* inclination                 */
extern   GtkWidget   *e_103;         /* primary rochefill           */
extern   GtkWidget   *e_104;         /* secondary rochefill         */
extern   GtkWidget   *e_105;         /* primary temperature         */
extern   GtkWidget   *e_106;         /* secondary temperature       */

/* ----------------  entry fields (advanced)  --------------------- */

extern   GtkWidget   *e_107;         /* eccentricity                */
extern   GtkWidget   *e_108;         /* periastron length           */
extern   GtkWidget   *e_109;         /* primary F ratio             */
extern   GtkWidget   *e_110;         /* secondary F ratio           */
extern   GtkWidget   *e_111;         /* line rest wavelength        */
extern   GtkWidget   *e_112;         /* # of lightcurve steps       */
extern   GtkWidget   *e_113;         /* # of reflection iterations  */
 		       
/* ------------------  entry fields (fit)  ------------------------ */

extern   GtkWidget   *e_name;        /* system name                 */
extern   GtkWidget   *e_301;         /* fit tolerance               */
extern   GtkWidget   *e_302;         /* period                      */
extern   GtkWidget   *e_303;         /* mass                        */
extern   GtkWidget   *e_304;         /* separation                  */
extern   GtkWidget   *e_305;         /* step1                       */
extern   GtkWidget   *e_306;         /* step2                       */
		
/* -----------------------  entry fields (spots)  ----------------- */

extern   GtkWidget   *e_401;         /* spot1 primary   longitude   */
extern   GtkWidget   *e_402;         /* spot1 primary   latitude    */
extern   GtkWidget   *e_403;         /* spot1 primary   radius      */
extern   GtkWidget   *e_404;         /* spot1 primary   dimfactor   */
extern   GtkWidget   *e_405;         /* spot2 primary   longitude   */
extern   GtkWidget   *e_406;         /* spot2 primary   latitude    */
extern   GtkWidget   *e_407;         /* spot2 primary   radius      */
extern   GtkWidget   *e_408;         /* spot2 primary   dimfactor   */
extern   GtkWidget   *e_409;         /* spot1 secondary longitude   */
extern   GtkWidget   *e_410;         /* spot1 secondary latitude    */
extern   GtkWidget   *e_411;         /* spot1 secondary radius      */
extern   GtkWidget   *e_412;         /* spot1 secondary dimfactor   */
extern   GtkWidget   *e_413;         /* spot2 secondary longitude   */
extern   GtkWidget   *e_414;         /* spot2 secondary latitude    */
extern   GtkWidget   *e_415;         /* spot2 secondary radius      */
extern   GtkWidget   *e_416;         /* spot2 secondary dimfactor   */
		
/* ----------------------  entry fields (third light)  ------------ */

extern   GtkWidget   *e_501;         /* third light U               */
extern   GtkWidget   *e_502;         /* third light B               */
extern   GtkWidget   *e_503;         /* third light V               */
extern   GtkWidget   *e_504;         /* third light R               */
extern   GtkWidget   *e_505;         /* third light I               */
extern   GtkWidget   *e_506;         /* third light J               */
extern   GtkWidget   *e_507;         /* third light H               */
extern   GtkWidget   *e_508;         /* third light K               */
extern   GtkWidget   *e_509;         /* third light u               */
extern   GtkWidget   *e_510;         /* third light v               */
extern   GtkWidget   *e_511;         /* third light b               */
extern   GtkWidget   *e_512;         /* third light y               */

/* ------------------------  toggle buttons  ---------------------- */

extern   GtkWidget   *t_anim_button;       /* toggle animated       */
extern   GtkWidget   *t_eccentric_button;  /* toggle eccentric      */
extern   GtkWidget   *t_fpri_button;	   /* toggle asynchron pri. */
extern   GtkWidget   *t_fsec_button;	   /* toggle asynchron sec. */
extern   GtkWidget   *t_ssp1_button;       /* toggle spot1 sec.     */
extern   GtkWidget   *t_ssp2_button;       /* toggle spot2 sec.     */
extern   GtkWidget   *t_psp1_button;       /* toggle spot1 pri.     */
extern   GtkWidget   *t_psp2_button;       /* toggle spot2 pri.     */

/* ------------------------  menu items (to grey out)  ------------ */

extern   GtkWidget   *menu_plot;           /* plot lightcurve       */
extern   GtkWidget   *menu_profile;        /* line profiles         */
extern   GtkWidget   *ome_button;          /* fit omega             */
extern   GtkWidget   *ecc_button;          /* fit eccentricity      */
extern   GtkWidget   *as1_button;          /* fit async primary     */
extern   GtkWidget   *as2_button;          /* fit async secondary   */
extern   GtkWidget   *ref_label;           /* reflection label      */


/* --------------------------  misc            -------------------- */

extern   GtkWidget   *progress_bar;        /* progress bar          */
extern   GtkWidget   *top_window;          /* the top window        */
extern   GtkWidget   *notebook;            /* the notebook          */
extern   GtkTooltips *tooltips;            /* the tooltips          */


/************************************************
  
   PROTOTYPES

*************************************************/

/* --- main window ---------------------------- */

#ifdef HAVE_GNOME
void MakeMenu();
#else
void MakeMenu(GtkWidget *menu_bar);
#endif


/* --- session manager ------------------------ */

void doQuit();

/* --- configuration -------------------------- */

void show_properties_dialog();

/* --- convenience function  ------------------ */

GtkWidget * create_pixmap(GtkWidget *widget, 
				  gchar **data);

/* --- interactive plotting ------------------- */

void Profiler();

void MakeSliceBox();

void MakeVbox();

/* --- error handling       ------------------- */

void make_dialog (char *message);

void delete_dialog (GtkWidget *widget, gpointer *data);

void check_data ();

void my_appbar_push(char *message);

/* --- toggle buttons     --------------------  */

void toggle_fit_spot (GtkWidget *widget, gpointer *data);
void toggle_p_spot1 (GtkWidget *widget, gpointer *data);
void toggle_p_spot2 (GtkWidget *widget, gpointer *data);
void toggle_s_spot1 (GtkWidget *widget, gpointer *data);
void toggle_s_spot2 (GtkWidget *widget, gpointer *data);
void toggle_anneal (GtkWidget *widget, gpointer *data);
void toggle_elliptic (GtkWidget *widget, gpointer *data);
void toggle_fratio1 (GtkWidget *widget, gpointer *data);
void toggle_fratio2 (GtkWidget *widget, gpointer *data);
void toggle_blackbody (GtkWidget *widget, gpointer *data);
void toggle_fractional (GtkWidget *widget, gpointer *data);
void toggle_reflect (GtkWidget *widget, gpointer *data);
void toggle_lineprofile (GtkWidget *widget, gpointer *data);
void toggle_animate (GtkWidget *widget, gpointer *data);
void toggle_psfile (GtkWidget *widget, gpointer *data);
void toggle_fit (GtkWidget *widget, gpointer *data);
void toggle_debug (GtkWidget *widget, gpointer *data);

/* --- entry fields       --------------------  */

void enter_name(GtkWidget *widget, GtkWidget *entry);
void enter_abs_period(GtkWidget *widget, GtkWidget *entry);
void enter_abs_mass(GtkWidget *widget, GtkWidget *entry);
void enter_abs_distance(GtkWidget *widget, GtkWidget *entry);
void enter_step1(GtkWidget *widget, GtkWidget *entry);
void enter_step2(GtkWidget *widget, GtkWidget *entry);
void enter_thirdU(GtkWidget *widget, GtkWidget *entry);
void enter_thirdB(GtkWidget *widget, GtkWidget *entry);
void enter_thirdV(GtkWidget *widget, GtkWidget *entry);
void enter_thirdR(GtkWidget *widget, GtkWidget *entry);
void enter_thirdI(GtkWidget *widget, GtkWidget *entry);
void enter_thirdJ(GtkWidget *widget, GtkWidget *entry);
void enter_thirdH(GtkWidget *widget, GtkWidget *entry);
void enter_thirdK(GtkWidget *widget, GtkWidget *entry);
void enter_thirdu(GtkWidget *widget, GtkWidget *entry);
void enter_thirdb(GtkWidget *widget, GtkWidget *entry);
void enter_thirdv(GtkWidget *widget, GtkWidget *entry);
void enter_thirdy(GtkWidget *widget, GtkWidget *entry);
void enter_longitude_p_spot1(GtkWidget *widget, GtkWidget *entry);
void enter_longitude_p_spot2(GtkWidget *widget, GtkWidget *entry);
void enter_longitude_s_spot1(GtkWidget *widget, GtkWidget *entry);
void enter_longitude_s_spot2(GtkWidget *widget, GtkWidget *entry);
void enter_latitude_p_spot1(GtkWidget *widget, GtkWidget *entry);
void enter_latitude_p_spot2(GtkWidget *widget, GtkWidget *entry);
void enter_latitude_s_spot1(GtkWidget *widget, GtkWidget *entry);
void enter_latitude_s_spot2(GtkWidget *widget, GtkWidget *entry);
void enter_radius_p_spot1(GtkWidget *widget, GtkWidget *entry);
void enter_radius_p_spot2(GtkWidget *widget, GtkWidget *entry);
void enter_radius_s_spot1(GtkWidget *widget, GtkWidget *entry);
void enter_radius_s_spot2(GtkWidget *widget, GtkWidget *entry);
void enter_dimfactor_p_spot1(GtkWidget *widget, GtkWidget *entry);
void enter_dimfactor_p_spot2(GtkWidget *widget, GtkWidget *entry);
void enter_dimfactor_s_spot1(GtkWidget *widget, GtkWidget *entry);
void enter_dimfactor_s_spot2(GtkWidget *widget, GtkWidget *entry);
void enter_massratio(GtkWidget *widget, GtkWidget *entry);
void enter_inclination(GtkWidget *widget, GtkWidget *entry);
void enter_rochefill1(GtkWidget *widget, GtkWidget *entry);
void enter_rochefill2(GtkWidget *widget, GtkWidget *entry);
void enter_temp1(GtkWidget *widget, GtkWidget *entry);
void enter_temp2(GtkWidget *widget, GtkWidget *entry);
void enter_excentricity(GtkWidget *widget, GtkWidget *entry);
void enter_omega(GtkWidget *widget, GtkWidget *entry);
void enter_fratio1(GtkWidget *widget, GtkWidget *entry);
void enter_fratio2(GtkWidget *widget, GtkWidget *entry);
void enter_linewave (GtkWidget *widget, GtkWidget *entry);
void enter_reflect_iterations (GtkWidget *widget, GtkWidget *entry);
void enter_phasesteps (GtkWidget *widget, GtkWidget *entry);
void enter_simplextol (GtkWidget *widget, GtkWidget *entry);

/* --- radio buttons      -----------------------  */

void radio_limb (GtkWidget *widget, gpointer *data);
void radio_band (GtkWidget *widget, gpointer *data);
void radio_graph (GtkWidget *widget, gpointer *data);
void radio_visual (GtkWidget *widget, gpointer *data);

/* --- applications       -----------------------  */

void delete_event (GtkWidget *widget, gpointer *data);
void lightcurve_event (GtkWidget *widget, gpointer *data);
void lightfit_event (GtkWidget *widget, gpointer *data);
void lightcurveplot_event (GtkWidget *widget, gpointer *data);
void reset_event (GtkWidget *widget, gpointer *data);
void lightgeometry_event (GtkWidget *widget, gpointer *data);
void help_event (GtkWidget *widget, gpointer *data);
void lightstarview_event (GtkWidget *widget, gpointer *data);
void lightslice_event (GtkWidget *widget, gpointer *data);
void showdata_event (GtkWidget *widget, gpointer *data);
void profiler_event (GtkWidget *widget, gpointer *data);
void lightmap_event (GtkWidget *widget, gpointer *data);

/* --- file readin        ----------------------  */

void select_file (GtkWidget *widget, gpointer *data);
void file_ok_sel (GtkWidget *w, GtkFileSelection *fs);

void select_config (GtkWidget *widget, gpointer *data);
void config_ok_sel (GtkWidget *w, GtkFileSelection *fs);

void out_config (GtkWidget *widget, gpointer *data);
void config_ok_out (GtkWidget *w, GtkFileSelection *fs);

/* --- MAIN               ----------------------  */

int  the_gui (int argc, char *argv[]);
void makepage3 ();
void updatepage3 ();
void updateplotflagpage3 ();

/* ------ LightConfig.c ------------------------- */

/* update the entry fields in the GUI             */
void UpdateGui();

void WriteConfig(char *OutputFile);





