/* NIGHTFALL Light Curve Synthesis Program                                 */
/* Copyright (C) 1999 Rainer Wichmann                                      */
/*                                                                         */
/*  This program is free software; you can redistribute it                 */
/*  and/or modify                                                          */
/*  it under the terms of the GNU General Public License as                */
/*  published by                                                           */
/*  the Free Software Foundation; either version 2 of the License, or      */
/*  (at your option) any later version.                                    */
/*                                                                         */
/*  This program is distributed in the hope that it will be useful,        */
/*  but WITHOUT ANY WARRANTY; without even the implied warranty of         */
/*  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the          */
/*  GNU General Public License for more details.                           */
/*                                                                         */
/*  You should have received a copy of the GNU General Public License      */
/*  along with this program; if not, write to the Free Software            */
/*  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.              */


/* ANSI C forbids an empty source file, so put this outside                */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "Light.h"

#ifdef HAVE_GNOME

static GtkWidget *propbox = NULL;   /* preferences window         */
static int TmpPromptOnExit;         /* temp store                 */
static int TmpRememberPosition;     /* temp store                 */
static int TmpHaveTooltips;         /* temp store                 */

extern int        TG_P1spot, TG_P2spot; 
extern int        TG_S1spot, TG_S2spot;
extern int        SpotActive[4];
extern int        FitSpotS[16];
extern SpotLight  SpotStore[2][2];            

/******************************************************************
 @package   nightfall
 @author    Rainer Wichmann
 @version   1.0
 @short     Callback for exit confirmation
 @param     (GtkWidget) *w  Discarded
 @param     (gint) pagenum  Notebook page
 @param     (gpointer) data Discarded
 @return    (void)    
 @heading   Gnome
*******************************************************************/
static void promptonexit_cb( GtkWidget *widget, gpointer data)
{
  TmpPromptOnExit = GTK_TOGGLE_BUTTON(widget)->active;
  gnome_property_box_changed(GNOME_PROPERTY_BOX(propbox));
  return;
}

/******************************************************************
 @package   nightfall
 @author    Rainer Wichmann
 @version   1.0
 @short     Callback for exit confirmation
 @param     (GtkWidget) *w  Discarded
 @param     (gint) pagenum  Notebook page
 @param     (gpointer) data Discarded
 @return    (void)    
 @heading   Gnome
*******************************************************************/
static void havetooltips_cb( GtkWidget *widget, gpointer data)
{
  TmpHaveTooltips = GTK_TOGGLE_BUTTON(widget)->active;
  gnome_property_box_changed(GNOME_PROPERTY_BOX(propbox));
  return;
}

/******************************************************************
 @package   nightfall
 @author    Rainer Wichmann
 @version   1.0
 @short     Callback for exit confirmation
 @param     (GtkWidget) *w  Discarded
 @param     (gint) pagenum  Notebook page
 @param     (gpointer) data Discarded
 @return    (void)    
 @heading   Gnome
*******************************************************************/
static void rememberpos_cb( GtkWidget *widget, gpointer data)
{
  TmpRememberPosition = GTK_TOGGLE_BUTTON(widget)->active;
  gnome_property_box_changed(GNOME_PROPERTY_BOX(propbox));
  return;
}

/******************************************************************
 @package   nightfall
 @author    Rainer Wichmann
 @version   1.0
 @short     Callback for preferences box destroy
 @param     (GtkWidget) *w  Discarded
 @param     (gint) pagenum  Notebook page
 @param     (gpointer) data Discarded
 @return    (void)    
 @heading   Gnome
*******************************************************************/
static void destroy_cb( GtkWidget   *w, gpointer data)
{
  gtk_widget_destroy (propbox);
  propbox = NULL;
  return;
}

/******************************************************************
 @package   nightfall
 @author    Rainer Wichmann
 @version   1.0
 @short     Callback for help
 @param     (GtkWidget) *w  Discarded
 @param     (gpointer) data Discarded
 @return    (void)    
 @heading   Gnome
*******************************************************************/
static void help_cb( GtkWidget   *w, gpointer data)
{
  GtkWidget *woosh;
  woosh = gnome_message_box_new(_("Set your preferences"), 
				 GNOME_MESSAGE_BOX_INFO,  
				 GNOME_STOCK_BUTTON_OK, NULL); 
  gnome_dialog_set_close(GNOME_DIALOG(woosh), TRUE);
  gtk_window_set_modal(GTK_WINDOW(woosh), TRUE);
  gtk_widget_show(woosh);
  return;
}

/******************************************************************
 @package   nightfall
 @author    Rainer Wichmann
 @version   1.0
 @short     Callback for apply config changes
 @param     (GtkWidget) *w  Discarded
 @param     (gint) pagenum  Notebook page
 @param     (gpointer) data Discarded
 @return    (void)    
 @heading   Gnome
*******************************************************************/
static void apply_cb( GtkWidget   *w, gint pagenum, gpointer data)
{
    Flags.GN_rempos      = TmpRememberPosition;
    Flags.GN_exitconfirm = TmpPromptOnExit;
    Flags.GN_tooltips    = TmpHaveTooltips;

    /* now write these values back to the config */

    gnome_config_push_prefix ("nightfall/");

    gnome_config_set_int("Options/PromptOnQuit",     Flags.GN_exitconfirm);
    gnome_config_set_int("Options/RememberPosition", Flags.GN_rempos);
    gnome_config_set_int("Options/HaveTooltips",     Flags.GN_tooltips);

    gnome_config_sync();

    gnome_config_pop_prefix();

    if (! Flags.GN_tooltips) 
      gtk_tooltips_disable( tooltips );
    else
      gtk_tooltips_enable( tooltips );

    return;
}

/******************************************************************
 @package   nightfall
 @author    Rainer Wichmann
 @version   1.0
 @short     Preferences dialog
 @param     (GtkWidget) *w  Discarded
 @param     (gint) pagenum  Notebook page
 @param     (gpointer) data Discarded
 @return    (void)    
 @heading   Gnome
*******************************************************************/
void show_properties_dialog() {
  GtkWidget *cpage;
  GtkWidget *hbox;
  GtkWidget *chkbox;
  GtkWidget *label;
 
  if(propbox) return;

  /* Copy current setting into temporary */
  TmpRememberPosition = Flags.GN_rempos;
  TmpPromptOnExit     = Flags.GN_exitconfirm;
  TmpHaveTooltips     = Flags.GN_tooltips;

  propbox = gnome_property_box_new();
  gtk_window_set_modal(GTK_WINDOW(propbox), TRUE);
  gtk_window_set_title(GTK_WINDOW(&GNOME_PROPERTY_BOX(propbox)->dialog.window),
		       _("Nightfall Preferences"));
  
  cpage = gtk_vbox_new(FALSE, 0);
  gtk_container_set_border_width(GTK_CONTAINER(cpage), GNOME_PAD_SMALL);
  
  hbox = gtk_hbox_new(TRUE, 0);
  gtk_box_pack_start(GTK_BOX(cpage), hbox, FALSE, TRUE, GNOME_PAD_SMALL);
  chkbox = gtk_check_button_new_with_label(_("Remember Position"));
  GTK_TOGGLE_BUTTON(chkbox)->active = TmpRememberPosition;
  gtk_signal_connect(GTK_OBJECT(chkbox), "clicked",
                     (GtkSignalFunc)rememberpos_cb, NULL);
  gtk_box_pack_start(GTK_BOX(hbox), chkbox, TRUE, TRUE, GNOME_PAD_SMALL);
  gtk_widget_show (chkbox);
  gtk_widget_show(hbox);

  hbox = gtk_hbox_new(TRUE, 0);
  gtk_box_pack_start(GTK_BOX(cpage), hbox, FALSE, TRUE, GNOME_PAD_SMALL);
  chkbox = gtk_check_button_new_with_label(_("Prompt On Exit"));
  GTK_TOGGLE_BUTTON(chkbox)->active = TmpPromptOnExit;
  gtk_signal_connect(GTK_OBJECT(chkbox), "clicked",
                     (GtkSignalFunc)promptonexit_cb, NULL);
  gtk_box_pack_start(GTK_BOX(hbox), chkbox, TRUE, TRUE, GNOME_PAD_SMALL);
  gtk_widget_show (chkbox);
  gtk_widget_show(hbox);

  hbox = gtk_hbox_new(TRUE, 0);
  gtk_box_pack_start(GTK_BOX(cpage), hbox, FALSE, TRUE, GNOME_PAD_SMALL);
  chkbox = gtk_check_button_new_with_label(_("Enable Tooltips"));
  GTK_TOGGLE_BUTTON(chkbox)->active = TmpHaveTooltips;
  gtk_signal_connect(GTK_OBJECT(chkbox), "clicked",
                     (GtkSignalFunc)havetooltips_cb, NULL);
  gtk_box_pack_start(GTK_BOX(hbox), chkbox, TRUE, TRUE, GNOME_PAD_SMALL);
  gtk_widget_show (chkbox);
  gtk_widget_show(hbox);

  gtk_widget_show(cpage);
  label = gtk_label_new(_("Configuration"));
  gtk_notebook_append_page(GTK_NOTEBOOK(GNOME_PROPERTY_BOX(propbox)->notebook),
                           cpage, label);

  gtk_signal_connect (GTK_OBJECT (propbox), "destroy",
                      GTK_SIGNAL_FUNC (destroy_cb), NULL);
  gtk_signal_connect (GTK_OBJECT (propbox), "help",
                      GTK_SIGNAL_FUNC (help_cb), NULL);
  gtk_signal_connect (GTK_OBJECT (propbox), "apply",
                      GTK_SIGNAL_FUNC (apply_cb), NULL);
  gtk_widget_show(propbox);
}
 

/******************************************************************
 @package   nightfall
 @author    ? ripped from Gnome website
 @version   1.0
 @short     Exit
 @param     (GnomeClient) *client
 @param     (gpointer) client_data
 @return    (gint)    Exit status
 @heading   Gnome
*******************************************************************/
gint
 die (GnomeClient *client, gpointer client_data)
 {
#ifdef _WITH_GNUPLOT
  if (Flags.plotOpened == ON) 
    { 
      Flags.plotOpened = OFF; 
      cpgend(); 
    }
#endif
  gtk_exit (0);

  return FALSE;
 }

/******************************************************************
 @package   nightfall
 @author    ? ripped from Gnome website
 @version   1.0
 @short     Exit
 @param     (GnomeClient)       *client
 @param     (gint)               phase
 @param     (GnomeRestartStyle)  restart_style
 @param     (gint)               shutdown
 @param     (GnomeInteractStyle) interact_style
 @param     (gint)               fast
 @param     (gpointer)           client_data                
 @return    (gint)    Exit status
 @heading   Gnome
*******************************************************************/
gint
 save_yourself (GnomeClient        *client,
                gint                phase,
                GnomeSaveStyle      save_style,
                gint                shutdown,
                GnomeInteractStyle  interact_style,
                gint                fast,
                gpointer            client_data)
 {

   gchar *discard_argv[] = {"rm", "-r", NULL, NULL };
   gchar *argv[3];
   gint x, y, w, h, lo;
   gint dataIndex = 0;
   FileType       *dataFile = FileList;
   char   path[256];

   argv[0] = program_invocation_name;
   argv[1] = "-U";
   argv[2] = NULL;

   gdk_window_get_geometry (top_window->window, &x, &y, &w, &h, NULL);

   /* Save the state using gnome-config stuff. 
    */
   gnome_config_push_prefix (gnome_client_get_config_prefix (client));

   gnome_config_set_int ("Geometry/x", x);
   gnome_config_set_int ("Geometry/y", y);
   gnome_config_set_int ("Geometry/w", w);
   gnome_config_set_int ("Geometry/h", h);

   gnome_config_set_int("Options/PromptOnQuit",     Flags.GN_exitconfirm);
   gnome_config_set_int("Options/RememberPosition", Flags.GN_rempos);
   gnome_config_set_int("Options/HaveTooltips",     Flags.GN_tooltips);

   while ((dataFile != NULL) && (dataIndex < 12)) {
     snprintf(path,  255, "Data/File%02d", dataIndex);
     gnome_config_set_string(path, dataFile->DataFile );
     dataFile = dataFile->nextFile;
     ++dataIndex;
   }

   if (strlen(Flags.ConfFile) > 2) {
     snprintf(path,  255, "Configuration/File");
     gnome_config_set_string(path, Flags.ConfFile);
   }


   gnome_config_set_int("Flags/fill",         Flags.fill);
   gnome_config_set_int("Flags/elliptic",     Flags.elliptic);
   gnome_config_set_int("Flags/asynchron1",   Flags.asynchron1);
   gnome_config_set_int("Flags/asynchron2",   Flags.asynchron2);
   gnome_config_set_int("Flags/animate",      Flags.animate);
   gnome_config_set_int("Flags/plot",         Flags.plot);
   gnome_config_set_int("Flags/eps",          Flags.eps);
   gnome_config_set_int("Flags/lineprofile",  Flags.lineprofile);
   gnome_config_set_int("Flags/blackbody",    Flags.blackbody);
   gnome_config_set_int("Flags/fractional",   Flags.fractional);
   gnome_config_set_int("Flags/limb",         Flags.limb); 
   gnome_config_set_int("Flags/reflect",      Flags.reflect); 
   gnome_config_set_int("Flags/anneal",       Flags.anneal);      
   gnome_config_set_int("Flags/PlotBand",     Flags.PlotBand);

   gnome_config_set_float("Flags/STol",       Flags.SimplexTol);
   gnome_config_set_float("Flags/Step0",      Flags.Step[0]);
   gnome_config_set_float("Flags/Step1",      Flags.Step[1]);

   for (lo = 0; lo <  12; ++lo) 
     {
       snprintf(path,  255, "Flags/Dbg%02d", lo);
       gnome_config_set_int (path, Flags.debug[lo] );
   }


   gnome_config_set_int("Flags/reflectstore", TG_reflectstore);
   gnome_config_set_int("Flags/graphstore",   TG_graphstore);
   gnome_config_set_int("Flags/visualstore",  TG_visualstore);

   gnome_config_set_int("Misc/NoteBookPage", 
		     gtk_notebook_current_page( GTK_NOTEBOOK(notebook)) );
   gnome_config_set_float("Misc/PhaseSteps",  PhaseSteps);

   gnome_config_set_string("Orbit/Name",      Orbit.Name);
   gnome_config_set_float("Orbit/LambdaZero", Orbit.LambdaZero);
   gnome_config_set_float("Orbit/ThirdU",     Orbit.Third[Umag]);
   gnome_config_set_float("Orbit/ThirdB",     Orbit.Third[Bmag]);
   gnome_config_set_float("Orbit/ThirdV",     Orbit.Third[Vmag]);
   gnome_config_set_float("Orbit/ThirdR",     Orbit.Third[Rmag]);
   gnome_config_set_float("Orbit/ThirdI",     Orbit.Third[Imag]);
   gnome_config_set_float("Orbit/ThirdJ",     Orbit.Third[Jmag]);
   gnome_config_set_float("Orbit/ThirdH",     Orbit.Third[Hmag]);
   gnome_config_set_float("Orbit/ThirdK",     Orbit.Third[Kmag]);
   gnome_config_set_float("Orbit/Thirdu",     Orbit.Third[umag]);
   gnome_config_set_float("Orbit/Thirdv",     Orbit.Third[vmag]);
   gnome_config_set_float("Orbit/Thirdb",     Orbit.Third[bmag]);
   gnome_config_set_float("Orbit/Thirdy",     Orbit.Third[ymag]);
   gnome_config_set_float("Orbit/Period",     Orbit.TruePeriod);
   gnome_config_set_float("Orbit/Mass",       Orbit.TrueMass);
   gnome_config_set_float("Orbit/Distance",   Orbit.TrueDistance);
   gnome_config_set_float("Orbit/Excentr",    Orbit.Excentricity);
   gnome_config_set_float("Orbit/Omega",      Orbit.Omega);
   gnome_config_set_float("Orbit/Inclination",Orbit.Inclination);

   gnome_config_set_float("Binary/FR1",       Binary[Primary].Fratio);
   gnome_config_set_float("Binary/FR2",       Binary[Secondary].Fratio);
   gnome_config_set_float("Binary/MQ1",       Binary[Primary].Mq);
   gnome_config_set_float("Binary/MQ2",       Binary[Secondary].Mq);
   gnome_config_set_float("Binary/RocheFill1",Binary[Primary].RocheFill);
   gnome_config_set_float("Binary/RocheFill2",Binary[Secondary].RocheFill);
   gnome_config_set_float("Binary/Temp1",     Binary[Primary].Temperature);
   gnome_config_set_float("Binary/Temp2",     Binary[Secondary].Temperature);

   /* the spots ...
    */
   gnome_config_set_int  ("Flags/Spots1",     Flags.Spots1);
   gnome_config_set_int  ("Flags/Spots2",     Flags.Spots2);

   gnome_config_set_int  ("Flags/TGP1",       TG_P1spot);
   gnome_config_set_int  ("Flags/TGP2",       TG_P2spot);
   gnome_config_set_int  ("Flags/TGS1",       TG_S1spot);
   gnome_config_set_int  ("Flags/TGS2",       TG_S2spot);

   gnome_config_set_float("SpotP1/logitude",  SpotStore[Primary][0].longitude);
   gnome_config_set_float("SpotP1/latitude",  SpotStore[Primary][0].latitude);
   gnome_config_set_float("SpotP1/radius",    SpotStore[Primary][0].radius);
   gnome_config_set_float("SpotP1/dimfactor", SpotStore[Primary][0].dimfactor);

   gnome_config_set_float("SpotP2/logitude",  SpotStore[Primary][1].longitude);
   gnome_config_set_float("SpotP2/latitude",  SpotStore[Primary][1].latitude);
   gnome_config_set_float("SpotP2/radius",    SpotStore[Primary][1].radius);
   gnome_config_set_float("SpotP2/dimfactor", SpotStore[Primary][1].dimfactor);
  
   gnome_config_set_float("SpotS1/logitude",  SpotStore[Secondary][0].longitude);
   gnome_config_set_float("SpotS1/latitude",  SpotStore[Secondary][0].latitude);
   gnome_config_set_float("SpotS1/radius",    SpotStore[Secondary][0].radius);
   gnome_config_set_float("SpotS1/dimfactor", SpotStore[Secondary][0].dimfactor);

   gnome_config_set_float("SpotS2/logitude",  SpotStore[Secondary][1].longitude);
   gnome_config_set_float("SpotS2/latitude",  SpotStore[Secondary][1].latitude);
   gnome_config_set_float("SpotS2/radius",    SpotStore[Secondary][1].radius);
   gnome_config_set_float("SpotS2/dimfactor", SpotStore[Secondary][1].dimfactor);
  
   for (lo = 0; lo <  4; ++lo) 
     {
       snprintf(path,  255, "SpotActive/%02d", lo);
       gnome_config_set_int (path, SpotActive[lo] );
   }

   for (lo = 0; lo <  16; ++lo) 
     {
       snprintf(path,  255, "SpotFit/%02d", lo);
       gnome_config_set_int (path, FitSpotS[lo] );
   }

   for (lo = 0; lo <  Flags.Spots1; ++lo) 
     {
       snprintf(path,  255, "Spot_P%02d/longitude", lo);
       gnome_config_set_float (path, Spot[Primary][lo].longitude );
       snprintf(path,  255, "Spot_P%02d/latitude", lo);
       gnome_config_set_float (path, Spot[Primary][lo].latitude );
       snprintf(path,  255, "Spot_P%02d/radius", lo);
       gnome_config_set_float (path, Spot[Primary][lo].radius );
       snprintf(path,  255, "Spot_P%02d/dimfactor", lo);
       gnome_config_set_float (path, Spot[Primary][lo].dimfactor );

   }

   for (lo = 0; lo <  Flags.Spots2; ++lo) 
     {
       snprintf(path,  255, "Spot_S%02d/longitude", lo);
       gnome_config_set_float (path, Spot[Secondary][lo].longitude );
       snprintf(path,  255, "Spot_S%02d/latitude", lo);
       gnome_config_set_float (path, Spot[Secondary][lo].latitude );
       snprintf(path,  255, "Spot_S%02d/radius", lo);
       gnome_config_set_float (path, Spot[Secondary][lo].radius );
       snprintf(path,  255, "Spot_S%02d/dimfactor", lo);
       gnome_config_set_float (path, Spot[Secondary][lo].dimfactor );

   }

   /* fit flags
    */
   for (lo = 0; lo <  64; ++lo) 
     {
       snprintf(path,  255, "Simplex/%02d", lo);
       gnome_config_set_int (path, Flags.simplex[lo] );
   }


   gnome_config_sync(); 
   gnome_config_pop_prefix ();

   discard_argv[2] = gnome_config_get_real_path
                    (gnome_client_get_config_prefix (client));
   gnome_client_set_discard_command (client, 3, discard_argv);
 
   gnome_client_set_clone_command   (client, 2, argv);
   gnome_client_set_restart_command (client, 2, argv);

   return TRUE;                                               
 }

#endif

