#! /bin/sh
#
# Adapted for nightfall by Rainer Wichmann
# Changes by H.J.Lu
# Original version Mitchum Dsouza <m.dsouza@mrc-apu.cam.ac.uk>
#
# Simple libc configuration script tested with `bash' and `ksh' and
# Sun `sh'

# The following two are the ANSI sequences for start and end embolden
case $TERM in
vt*|ansi*|con*|xterm*|linux*|screen*)
  S=[1m
  E=[m
  ;;
*)
  S=
  E=
  ;;
esac

# Define some defaults
PGPLOT_INC=${PGPLOT_DIR}
PGPLOT_LIB=${PGPLOT_DIR}
OLD_PGPLOT_INC=${PGPLOT_INC}
OLD_PGPLOT_LIB=${PGPLOT_LIB}
USE_GNUPLOT=y
USE_PGPLOT=n
USE_INTL=n
PREFIX=/usr/local
OLD_PREFIX=${PREFIX}
DO_BUILD=y
DO_INSTALL=y
DO_TEST=y

if (echo "testing\c"; echo 1,2,3) | grep c >/dev/null; then
  # Stardent Vistra SVR4 grep lacks -e, says ghazi@caip.rutgers.edu.
  if (echo -n testing; echo 1,2,3) | sed s/-n/xn/ | grep xn >/dev/null; then
    ac_n= 
  else
    ac_n=-n 
  fi
else
  ac_n= 
fi


response() {
	echo $ac_n "$1 [$2] ? " 1> /dev/tty
	read answer
	if test x${answer} = x; then
		echo $2
	else
		echo ${answer}
	fi
}

getresponse ()
{
  PGPLOT_INC=${OLD_PGPLOT_INC}
  PGPLOT_LIB=${OLD_PGPLOT_LIB}

  USE_PGPLOT=`response "Use PGPLOT instead of GNUPLOT for plotting (y/n)" "${USE_PGPLOT}"`

  if test x${USE_PGPLOT} = xy; then
    USE_GNUPLOT=n
    PGPLOT_INC=`response "PGPLOT header  files are in (RETURN=accept default) " "${PGPLOT_INC}"` 
    PGPLOT_LIB=`response "PGPLOT library files are in (RETURN=accept default) " "${PGPLOT_LIB}"` 
  else
    PGPLOT_INC=
    PGPLOT_LIB=
  fi

  OLD_PGPLOT_INC=${PGPLOT_INC}
  OLD_PGPLOT_LIB=${PGPLOT_LIB}

  USE_INTL=`response "Compile with support for internationalization (y/n)" "${USE_PGPLOT}"`

  PREFIX=${OLD_PREFIX}

  PREFIX1=`response "Root path to installed files (RETURN=accept default) " "${PREFIX}"`

# cut trailing slash
  PREFIX=`echo $PREFIX1 | sed 's%\([^/]\)/*$%\1%'`

  OLD_PREFIX=${PREFIX}

  DO_BUILD=`response "Build the program   (y/n)"  "${DO_BUILD}"` 
  DO_TEST=`response "Test the program   (y/n)"  "${DO_TEST}"` 
  DO_INSTALL=`response "Install the program (y/n)"  "${DO_INSTALL}"` 
}

showdefaults ()
{
  echo 
  echo "*******************  Current defaults  *******************"
  echo "**"
  if test "A${USE_PGPLOT}" = "Ay"; then
    echo "**  Use ${S}PGPLOT${E} (in ${S}${PGPLOT_LIB}${E}) for plotting"
  else
    echo "**  Use the ${S}GNUPLOT${E} program for plotting"
  fi
  if test "A${USE_INTL}" = "Ay"; then
    echo "**  Compile ${S}with${E} support for ${S}internationalization${E}"
  else
    echo "**  Compile ${S}without${E} support for ${S}internationalization${E}"
  fi
  echo "**"
  echo "**  Root path to ${S}installed${E} files is ${S}${PREFIX}${E}"
  echo "**    -- install binary to ${S}${PREFIX}/bin${E}"
  echo "**    -- install data   to ${S}${PREFIX}/share/nighfall${E}"
  echo "**"
  if test "A${DO_BUILD}" = "Ay"; then
    echo "**  Build   program: ${S}yes${E}"
  else
    echo "**  Build   program: ${S}no${E}"
  fi
  if test "A${DO_TEST}" = "Ay"; then
    echo "**  Test    program: ${S}yes${E}"
  else
    echo "**  Test    program: ${S}no${E}"
  fi
  if test "A${DO_INSTALL}" = "Ay"; then
    echo "**  Install program: ${S}yes${E}"
  else
    echo "**  Install program: ${S}no${E}"
  fi
  echo "**"
  echo "**********************************************************"
  echo
  echo
  echo

}




showdefaults


while ! test x${ans} = xy 
do
  getresponse
  showdefaults
  ans=`response "Values correct (y/n)" "y"`
done

echo
echo
if [ "A${USE_INTL}" = "Ay" ]; then
    intl="--with-gnu-gettext"
else
    intl="--disable-nls"
fi

if [ "A${USE_PGPLOT}" = "Ay" ]; then
    echo "${S}./configure${E} ${intl} --with-pgplot-dir=${PGPLOT_DIR} --prefix=${PREFIX}"
    echo
    echo
    ./configure ${intl} --with-pgplot-include=${PGPLOT_INC} --with-pgplot-lib=${PGPLOT_LIB} --prefix=${PREFIX} 
else
    echo "${S}./configure${E} ${intl} --with-pgplot-include=/supercalli --with-pgplot-lib=/fragili --prefix=${PREFIX}"
    echo
    echo
    ./configure ${intl} --with-pgplot-prefix=/supercallifragili --prefix=${PREFIX}
fi

if ! test -f Makefile; then
    echo 
    echo "${S}ERROR:${E} no Makefile created"
    exit 1
else
    echo 
    echo 
    echo "${S}CONFIGURE:${E} Makefile has been created"
    echo 
    echo 
fi    


if test "A${DO_BUILD}" = "Ay"; then
    make clean
    echo
    echo
    echo "${S}make${E} all"
    echo
    echo
    make all
    if ! test -f nightfall; then
	echo 
	echo 
	echo "${S}BUILD ERROR:${E} could not build the program"
	exit 1
    else
	echo 
	echo 
	echo "${S}BUILD:${E} successfully build the program"
	echo 
	echo 
    fi
fi

if test "A${DO_TEST}" = "Ay"; then
    if ! test -f nightfall; then
	echo 
	echo 
	echo "${S}TEST ERROR:${E} program not available"
	exit 1
    else
	ON_EXIT=0
	echo 
	echo
 	echo "${S}./nightfall${E} -Db -C cfg/ty_boo.cfg"
	echo 
	echo
	./nightfall -Db -C cfg/ty_boo.cfg 
	ON_EXIT=$?
	echo 
	echo 
	if test $ON_EXIT = "0"; then
	    echo "${S}TEST:${E} program tested (non-interactive,non-plotting mode)"
	else
	    echo "${S}TEST:${E} exited with error"
	fi
	echo 
	echo 
    fi
fi

if test "A${DO_INSTALL}" = "Ay"; then
    if ! test -f nightfall; then
	echo 
	echo "${S}INSTALL ERROR:${E} program not found"
	exit 1
    else
	ON_EXIT=0
	echo "${S}make${E} install"
	echo
	echo
	make install
	ON_EXIT=$?
	echo 
	echo 
	if test $ON_EXIT = "0"; then
	    echo "${S}INSTALL:${E} finished"
	else
	    echo "${S}INSTALL ERROR:${E} exited with error"
	fi
	echo 
	echo 
    fi
fi