/*

  sshadt_list_i.h

  Author: Antti Huima <huima@ssh.fi>

  Copyright (c) 1999 SSH Communications Security, Finland
  All rights reserved.

  Created Thu Sep  9 11:54:09 1999.

  */

#ifndef SSHADT_LIST_I_H_INCLUDED
#define SSHADT_LIST_I_H_INCLUDED

#include "sshadt_i.h"

typedef struct ssh_adt_list_node {
  struct ssh_adt_list_node *next, *prev;
} SshADTListNode;

typedef struct ssh_adt_list_enode {
  void *object;
  SshADTListNode i;
} SshADTListENode;

typedef struct {
  SshADTListNode *first_node, *last_node;
} SshADTListRoot;

extern SshADTStaticData ssh_adt_list_static_data;

#define SSH_ADT__LIST_INSERT_TO_END(root, node)                               \
do                                                                            \
{                                                                             \
  SshADTListNode *__last = (root)->last_node;                                 \
  node->next = NULL;                                                          \
  if (__last == NULL)                                                         \
    {                                                                         \
      node->prev = NULL;                                                      \
      (root)->last_node = (root)->first_node = node;                          \
    }                                                                         \
  else                                                                        \
    {                                                                         \
      node->prev = __last; __last->next = node;                               \
      (root)->last_node = node;                                               \
    }                                                                         \
}                                                                             \
while(0)

#define SSH_ADT__LIST_INSERT_TO_BEGINNING(root, node)                         \
do                                                                            \
{                                                                             \
  SshADTListNode *__first = (root)->first_node;                               \
  node->prev = NULL;                                                          \
  if (__first == NULL)                                                        \
    {                                                                         \
      node->next = NULL;                                                      \
      (root)->last_node = (root)->first_node = node;                          \
    }                                                                         \
  else                                                                        \
    {                                                                         \
      node->next = __first; __first->prev = node;                             \
      (root)->first_node = node;                                              \
    }                                                                         \
}                                                                             \
while(0)

#endif /* SSHADT_LIST_I_H_INCLUDED */
