/*
SKIP Source Code License Statement:
------------------------------------------------------------------
  Copyright
  Sun Microsystems, Inc.


  Copyright (C) 1994, 1995 Sun Microsystems, Inc.  All Rights
  Reserved.

  Permission is hereby granted, free of charge, to any person
  obtaining a copy of this software and associated documentation
  files (the "Software"), to deal in the Software without
  restriction, including without limitation the rights to use,
  copy, modify, merge, publish, distribute, sublicense, and/or sell
  copies of the Software or derivatives of the Software, and to 
  permit persons to whom the Software or its derivatives is furnished 
  to do so, subject to the following conditions:

  The above copyright notice and this permission notice shall be
  included in all copies or substantial portions of the Software.

  The Software must not be transferred to persons who are not US
  citizens or permanent residents of the US or exported outside
  the US (except Canada) in any form (including by electronic
  transmission) without prior written approval from the US
  Government. Non-compliance with these restrictions constitutes
  a violation of the U.S. Export Control Laws.

  THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
  EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES
  OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
  NONINFRINGEMENT.  IN NO EVENT SHALL SUN MICROSYSTEMS, INC., BE LIABLE
  FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION
  OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
  CONNECTION WITH THE SOFTWARE OR DERIVATES OF THIS SOFTWARE OR 
  THE USE OR OTHER DEALINGS IN THE SOFTWARE.

  Except as contained in this notice, the name of Sun Microsystems, Inc.
  shall not be used in advertising or otherwise to promote
  the sale, use or other dealings in this Software or its derivatives 
  without prior written authorization from Sun Microsystems, Inc.
*/

#pragma ident "@(#)skip_keymgrmsgs.c	1.8 95/11/16 Sun Microsystems"

/*
 * System includes
 */
#ifdef SYSV
#include <skip_sysv.h>
#endif
#ifdef SUNOS
#include <skip_sunos.h>
#endif
#if !defined(SYSV) && !defined(SUNOS)
#include <skip_os.h>
#endif

/*
 * SKIP includes
 */
#include <bdcmod.h>
#include <skip_proto.h>
#include <skip_types.h>
#include <skip_keymgrmsgs.h>
#include <skip_key.h>
#include <skip_ioctl.h>


/* skip_fmt_kmgr()
 *
 * format a message to send to the key manager daemon
 *
 * Returns: size of the message
 */
int
skip_fmt_kmgr(union skip_messages *sm, skip_keycb_t *cp)
{
	register unsigned int		size = 0;

	SKIP_ESP_DEBUG1("skip_fmt_kmgr: send to keymgr VI = %d\n",
						cp->hdr.params.version);
	switch (sm->msgtype) {

		case SKIP_ENCRYPTED_PKT_KEY_REQ:
		/*
		 * request key to encrypt packet
		 */
		sm->enc_req.params	= cp->hdr.params;
		size = sizeof (sm->enc_req);
		break;


		case SKIP_DECRYPTED_PKT_KEY_REQ:
		/*
		 * request key to decrypt packet
		 */
		sm->dec_req.params	= cp->hdr.params;
		sm->dec_req.ekp_offset	= sizeof (sm->dec_req);
		sm->dec_req.ekp_keylen	= cp->hdr.ekp.len;
		bcopy(cp->hdr.ekp.buf, (caddr_t) &sm->dec_req +
					sizeof (sm->dec_req), cp->hdr.ekp.len);
		size = sizeof (sm->dec_req) + cp->hdr.ekp.len;
		break;
	}

	return(size);
}

/* skip_key_fromkm()
 *
 * receive a message from the key manager daemon
 *
 * Returns: none
 */
void
skip_key_fromkm(union skip_messages *sm, unsigned int size)
{
	struct Encrypted_key_rsp	*er = &sm->enc_rsp;
	struct Decrypted_key_rsp	*dr = &sm->dec_rsp;
	struct Set_supported_kij	*ks = &sm->set_kij_alg;
	skip_param_t			*params;

	if (size < sizeof (sm->msgtype)) {
		SKIP_DEBUG("skip_key_fromkm: short message received\n");
		return;
	}
	switch (sm->msgtype) {

		case SKIP_ENCRYPTED_PKT_KEY_RSP:
		/*
		 * key to encrypt packet returned
		 */

		params = &er->params;

		/*
		 * XXX - Check is Kp is supported...
		 */
		if (params->kp_alg > SKIP_MAXCRYPTORS) {
			SKIP_DEBUG("skip_key_fromkm: "
			"invalid kp_alg in SKIP_ENCRYPTED_PKT_KEY_RSP "
			"from key manager\n");
			break;
		}

		/*
		 *  Process the encrypted kp (ekp)...
		 */
		if (size < sizeof (*er)) {
			SKIP_DEBUG("skip_key_fromkm: "
			"short SKIP_ENCRYPTED_PKT_KEY_RSP "
			"from key manager\n");
			break;
		}

		if (er->kp_keylen == 0) {
			SKIP_DEBUG("skip_key_fromkm: "
			"kp_keylen == 0 in SKIP_ENCRYPTED_PKT_KEY_RSP "
			"from key manager\n");
			break;
		}

		if ((er->kp_offset + er->kp_keylen) > size) {
			SKIP_DEBUG("skip_key_fromkm: "
			"invalid kp in SKIP_ENCRYPTED_PKT_KEY_RSP "
			" from key manager\n");
			break;
		}

		if (er->kp_keylen > MAXVARSZ) {
			SKIP_DEBUG("skip_key_fromkm: kp_keylen in "
			"SKIP_ENCRYPTED_PKT_KEY_RSP > MAXVARSZ\n");
			break;
		}
		if (er->iv_len &&
			((er->iv_offset + er->iv_len) > size)) {
			SKIP_DEBUG("skip_key_fromkm: "
			"invalid iv in SKIP_ENCRYPTED_PKT_KEY_RSP "
			"from key manager\n");
			break;
		}

		if (er->iv_len > MAXVARSZ) {
			SKIP_DEBUG("skip_key_fromkm: iv_len in "
			"SKIP_ENCRYPTED_PKT_KEY_RSP > MAXVARSZ\n");
			break;
		}
		if (er->ekp_keylen > MAXVARSZ) {
			SKIP_DEBUG("skip_key_fromkm: ekp_keylen in "
			"SKIP_ENCRYPTED_PKT_KEY_RSP > MAXVARSZ\n");
			break;
		}
		if (er->ekp_keylen &&
			((er->ekp_offset + er->ekp_keylen) > size)) {
			SKIP_DEBUG("skip_key_fromkm: "
			"invalid ekp in SKIP_ENCRYPTED_PKT_KEY_RSP "
			"from key manager\n");
			break;
		}

		if (params->version == SKIP_V2 && params->kp_alg) {
			/*
			 * Process the derived E_kp...
			 */
			if (er->E_kp_keylen > MAXVARSZ) {
				SKIP_DEBUG("skip_key_fromkm: E_kp_keylen in "
				"SKIP_ENCRYPTED_PKT_KEY_RSP > MAXVARSZ\n");
				break;
			}
			if (er->E_kp_keylen &&
				((er->E_kp_offset + er->E_kp_keylen) > size)) {
				SKIP_DEBUG("skip_key_fromkm: "
				"invalid E_kp in SKIP_ENCRYPTED_PKT_KEY_RSP "
				"from key manager\n");
				break;
			}
		}

		if (params->version == SKIP_V2 && params->mac_alg) {
			/*
			 * Process the derived A_kp...
			 */
			if (params->mac_alg > SKIP_MAX_AH_CRYPTORS) {
				SKIP_DEBUG("skip_key_fromkm: "
				"invalid mac_alg in SKIP_ENCRYPTED_PKT_KEY_RSP "
				"from key manager\n");
				break;
			}
			if (er->A_kp_keylen > MAXVARSZ) {
				SKIP_DEBUG("skip_key_fromkm: A_kp_keylen in "
				"SKIP_ENCRYPTED_PKT_KEY_RSP > MAXVARSZ\n");
				break;
			}
			if (er->A_kp_keylen &&
				((er->A_kp_offset + er->A_kp_keylen) > size)) {
				SKIP_DEBUG("skip_key_fromkm: "
				"invalid A_kp in SKIP_ENCRYPTED_PKT_KEY_RSP "
				"from key manager\n");
				break;
			}
		}

		/*
		 * update the keystore control block with the response
		 */
		skip_update_encrypt_key(er);
		break;

		case SKIP_DECRYPTED_PKT_KEY_RSP:
		/*
		 * key to decrypt packet returned
		 */
		if (dr->params.kp_alg > SKIP_MAXCRYPTORS) {
			SKIP_DEBUG("skip_key_fromkm: invalid kp_alg in "
			"SKIP_DECRYPTED_PKT_KEY_RSP from key manager\n");
			break;
		}
		if (size < sizeof (*dr)) {
			SKIP_DEBUG("skip_key_fromkm: short "
			"SKIP_DECRYPTED_PKT_KEY_RSP from key manager\n");
			break;
		}

		if (dr->kp_keylen > MAXVARSZ) {
			SKIP_DEBUG("skip_key_fromkm: kp_keylen in "
			"SKIP_DECRYPTED_PKT_KEY_RSP > MAXVARSZ\n");
			break;
		}
		if (dr->kp_keylen == 0) {
			SKIP_DEBUG("skip_key_fromkm: kp_keylen == 0 in "
			"SKIP_DECRYPTED_PKT_KEY_RSP from key manager\n");
			break;
		}
		if ((dr->kp_offset + dr->kp_keylen) > size) {
			SKIP_DEBUG("skip_key_fromkm: invalid kp in "
			"SKIP_DECRYPTED_PKT_KEY_RSP from key manager\n");
			break;
		}
		if (dr->ekp_keylen > MAXVARSZ) {
			SKIP_DEBUG("skip_key_fromkm: ekp_keylen in "
			"SKIP_DECRYPTED_PKT_KEY_RSP > MAXVARSZ\n");
			break;
		}
		if (dr->ekp_keylen &&
				((dr->ekp_offset + dr->ekp_keylen) > size)) {
			SKIP_DEBUG("skip_key_fromkm: invalid ekp in "
			"SKIP_DECRYPTED_PKT_KEY_RSP from key manager\n");
			break;
		}

		/*
		 * update the keystore control block with the response
		 */
		skip_update_decrypt_key(dr);
		break;

		case SKIP_SET_LOCAL_KEYID:
		/*
		 * configure the local nodeid
		 */
		if (size != sizeof (struct Set_local_keyid)) {
			SKIP_DEBUG("skip_key_fromkm: wrong-sized "
			"SKIP_SET_LOCAL_KEYID from key manager\n");
			break;
		}

		if ((int) sm->set_keyid.nsid >= SKIP_MAX_NSID) {
			SKIP_DEBUG("skip_key_fromkm: bad NSID in "
			"SKIP_SET_LOCAL_KEYID from key manager\n");
			break;
		}

		if (sm->set_keyid.mkeyid.len !=
					skip_nsid[sm->set_keyid.nsid]) {
			SKIP_DEBUG("skip_key_fromkm: bad key length in "
			"SKIP_SET_LOCAL_KEYID from key manager\n");
			break;
		}
		KEYVARSET(skip_local_keys[sm->set_keyid.nsid],
						sm->set_keyid.mkeyid);
		break;

		case SKIP_SET_SUPPORTED_KIJ:
		/*
		 * configure the local nodeid
		 */
		if (size != sizeof (struct Set_supported_kij)) {
			SKIP_DEBUG("skip_key_fromkm: wrong-sized "
			"SKIP_SET_SUPPORTED_KIJ from key manager\n");
			break;
		}

		if (ks->version == SKIP_V2) {
			skip_kmgr_kij_alg[ks->kij_alg] = B_TRUE;
		} else {
			skip_kmgr_kij_alg_v1[ks->kij_alg] = B_TRUE;
		}
		break;

		default:
		/*
		 * naughty key manager...
		 */
		SKIP_DEBUG1("skip_key_fromkm: bad msg (%d) from key manager\n",
								sm->msgtype);
		break;
	}
}
