/*
 * Decompiled with CFR 0.152.
 */
package NIST;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.StringTokenizer;

public final class KAT {
    static final String VERSION = "$Revision: 1.0$";
    static final String SUBMITTER = "<as stated on the submission cover sheet>";
    boolean varKey = false;
    boolean varText = false;
    String dirName;
    String keylengths;
    String cipherName;
    File destination;
    int[] keys = new int[]{128, 192, 256};
    final String vkFileName = "ecb_vk.txt";
    final String vtFileName = "ecb_vt.txt";
    long encBlocks;
    long decBlocks;
    long keyCount;
    Method makeKey;
    Method encrypt;
    Method decrypt;
    private static final char[] HEX_DIGITS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};

    public static void main(String[] stringArray) {
        System.out.println("NIST Known Answer Tests data generator/exerciser\n$Revision: 1.0$\nCopyright (c) 1998 Systemics Ltd. on behalf of\nthe Cryptix Development Team.  All rights reserved.\n\n");
        KAT kAT = new KAT();
        kAT.processOptions(stringArray);
        kAT.run();
    }

    private void processOptions(String[] stringArray) {
        Object object;
        Object[] objectArray;
        int n = stringArray.length;
        if (n == 0) {
            this.printUsage();
        }
        System.out.println("(type \"java NIST.KAT\" with no arguments for help)\n\n");
        int n2 = -1;
        String string = "";
        boolean bl = true;
        while (true) {
            if (bl) {
                if (++n2 >= n) break;
                string = stringArray[n2];
            } else {
                string = "-" + string.substring(2);
            }
            if (string.startsWith("-k")) {
                this.varKey = true;
                bl = string.length() == 2;
                continue;
            }
            if (string.startsWith("-t")) {
                this.varText = true;
                bl = string.length() == 2;
                continue;
            }
            if (string.startsWith("-l")) {
                this.keylengths = stringArray[n2 + 1];
                ++n2;
                bl = true;
                continue;
            }
            if (string.startsWith("-d")) {
                this.dirName = stringArray[n2 + 1];
                ++n2;
                bl = true;
                continue;
            }
            this.cipherName = string;
        }
        if (this.cipherName == null) {
            KAT.halt("Missing cipher algorithm name");
        }
        if (this.cipherName.length() > 1 && (this.cipherName.startsWith("\"") || this.cipherName.startsWith("'"))) {
            this.cipherName = this.cipherName.substring(2, this.cipherName.length() - 2);
        }
        if (this.keylengths != null) {
            int n3 = 0;
            objectArray = new int[3];
            object = new StringTokenizer(this.keylengths, ", \t\"");
            while (((StringTokenizer)object).hasMoreTokens()) {
                int n4 = Integer.parseInt(((StringTokenizer)object).nextToken());
                if (n4 <= 0) {
                    KAT.halt("Negative key length not allowed: " + n4);
                }
                if (n3 == 3) {
                    KAT.halt("Only three key-length values are allowed.");
                }
                objectArray[n3++] = n4;
            }
            if (n3 != 0) {
                this.keys = new int[n3];
                System.arraycopy(objectArray, 0, this.keys, 0, n3);
            }
        }
        if (!this.varKey && !this.varText) {
            this.varText = true;
            this.varKey = true;
        }
        if (this.dirName == null) {
            this.dirName = System.getProperty("user.dir");
        }
        this.destination = new File(this.dirName);
        if (!this.destination.isDirectory()) {
            KAT.halt("Destination <" + this.destination.getName() + "> is not a directory");
        }
        String string2 = String.valueOf(this.cipherName) + "." + this.cipherName + "_Algorithm";
        try {
            Class<?> clazz = Class.forName(string2);
            objectArray = clazz.getDeclaredMethods();
            n2 = 0;
            while (n2 < objectArray.length) {
                object = objectArray[n2].getName();
                int n5 = objectArray[n2].getParameterTypes().length;
                if (((String)object).equals("makeKey") && n5 == 1) {
                    this.makeKey = (Method)objectArray[n2];
                } else if (((String)object).equals("blockEncrypt") && n5 == 3) {
                    this.encrypt = (Method)objectArray[n2];
                } else if (((String)object).equals("blockDecrypt") && n5 == 3) {
                    this.decrypt = (Method)objectArray[n2];
                }
                ++n2;
            }
            if (this.makeKey == null) {
                throw new NoSuchMethodException("makeKey()");
            }
            if (this.encrypt == null) {
                throw new NoSuchMethodException("blockEncrypt()");
            }
            if (this.decrypt == null) {
                throw new NoSuchMethodException("blockDecrypt()");
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            KAT.halt("Unable to find " + string2 + " class");
            return;
        }
        catch (NoSuchMethodException noSuchMethodException) {
            KAT.halt("Unable to find " + string2 + "." + noSuchMethodException.getMessage() + " method");
        }
    }

    static void halt(String string) {
        System.err.println("\n*** " + string + "...");
        System.exit(-1);
    }

    static void notify(String string) {
        System.out.println("KAT: " + string + "...");
    }

    void printUsage() {
        System.out.println("NAME\n  KAT: A Known Answer Tests data generator/exerciser for any AES\n  candidate cipher algorithm.\n\nSYNTAX\n  java NIST.KAT\n    [ -k | -t ]\n    [ -l <comma-separated-key-lengths>]\n    [ -d <output-directory>]\n    <cipher>\n\nDESCRIPTION\n  For a designated candidate AES cipher algorithm, KAT generates\n  and exercises Known Answer Tests data for both Variable Key and\n  Variable Text suites.\n  KAT's output file format conforms to the layout described in\n  Section 3 of NIST's document \"Description of Known Answer Tests\n  and Monte Carlo Tests for Advanced Encryption Standard (AES)\n  Candidate Algorithm Submissions\" dated January 7, 1998.\n\nOPTIONS\n  -k   Generate data for variable-key tests only.  By default KAT\n       generates both variable-key and variable-text test uites.\n\n  -t   Generate data for variable-text tests only. By default KAT\n       generates both variable-key and variable-text test suites.\n\n  -l <comma-separated-key-lengths>\n       Comma separated list (maximum of three) of key lengths to use\n       for the tests.  If omitted, the following three values are\n       assumed: 128, 192 and 256.\n\n  -d <output-directory>\n       Pathname of the directory where output files: \"ecb_vk.txt\"\n       and \"ecb_vt.txt\" will be generated.  If this destination\n       directory is not specified, those files will be placed in\n       the current user directory.\n\n  <cipher>\n       Cipher algorithm name.\n\nCOPYRIGHT\n  Copyright (c) 1998 Systemics Ltd. on behalf of\n  the Cryptix Development Team.  All rights reserved.\n");
        System.exit(0);
    }

    void run() {
        long l = System.currentTimeMillis();
        if (this.varKey) {
            this.vkKAT("ecb_vk.txt");
        }
        if (this.varText) {
            this.vtKAT("ecb_vt.txt");
        }
        KAT.notify("Java interpreter used: Version " + System.getProperty("java.version"));
        KAT.notify("Java Just-In-Time (JIT) compiler: " + System.getProperty("java.compiler"));
        KAT.notify("Total execution time (ms): " + (System.currentTimeMillis() - l));
        KAT.notify("During this time, " + this.cipherName + ":");
        KAT.notify("  Encrypted " + this.encBlocks + " blocks");
        KAT.notify("  Decrypted " + this.decBlocks + " blocks");
        KAT.notify("  Created " + this.keyCount + " session keys");
    }

    void vkKAT(String string) {
        File file = new File(this.destination, string);
        PrintWriter printWriter = null;
        try {
            printWriter = new PrintWriter((Writer)new FileWriter(file), true);
        }
        catch (IOException iOException) {
            KAT.halt("Unable to initialize <" + string + "> as a Writer:\n" + iOException.getMessage());
        }
        printWriter.println();
        printWriter.println("=========================");
        printWriter.println();
        printWriter.println("FILENAME:  \"" + string + "\"");
        printWriter.println();
        printWriter.println("Electronic Codebook (ECB) Mode");
        printWriter.println("Variable Key Known Answer Tests");
        printWriter.println();
        printWriter.println("Algorithm Name: " + this.cipherName);
        printWriter.println("Principal Submitter: <as stated on the submission cover sheet>");
        printWriter.println();
        try {
            int n = 0;
            while (n < this.keys.length) {
                this.vkForKey(this.keys[n], printWriter);
                ++n;
            }
        }
        catch (Exception exception) {
            KAT.halt("Exception encountered in a " + this.cipherName + "_Algorithm method:\n" + exception.getMessage());
        }
        printWriter.println("==========");
        printWriter.close();
    }

    void vkForKey(int n, PrintWriter printWriter) throws IllegalAccessException, InvocationTargetException {
        KAT.notify("Generating and testing Variable Key KAT (short); key size: " + n);
        Object[] objectArray = new Object[]{};
        int n2 = n / 8;
        byte[] byArray = new byte[n2];
        byte[] byArray2 = new byte[16];
        int n3 = 0;
        printWriter.println("==========");
        printWriter.println();
        printWriter.println("KEYSIZE=" + n);
        printWriter.println();
        printWriter.println("PT=" + KAT.toString(byArray2));
        printWriter.println();
        int n4 = 0;
        while (n4 < n2) {
            int n5 = 0;
            while (n5 < 8) {
                printWriter.println("I=" + ++n3);
                byArray[n2 - n4 - 1] = (byte)(1 << 7 - n5);
                printWriter.println("KEY=" + KAT.toString(byArray));
                objectArray = new Object[]{byArray};
                Object object = this.makeKey.invoke(null, objectArray);
                ++this.keyCount;
                objectArray = new Object[]{byArray2, new Integer(0), object};
                byte[] byArray3 = (byte[])this.encrypt.invoke(null, objectArray);
                ++this.encBlocks;
                printWriter.print("CT=" + KAT.toString(byArray3));
                objectArray[0] = byArray3;
                byte[] byArray4 = (byte[])this.decrypt.invoke(null, objectArray);
                ++this.decBlocks;
                if (!KAT.areEqual(byArray2, byArray4)) {
                    printWriter.print(" *** ERROR ***");
                }
                printWriter.println();
                printWriter.println();
                ++n5;
            }
            byArray[n2 - n4 - 1] = 0;
            ++n4;
        }
    }

    void vtKAT(String string) {
        File file = new File(this.destination, string);
        PrintWriter printWriter = null;
        try {
            printWriter = new PrintWriter((Writer)new FileWriter(file), true);
        }
        catch (IOException iOException) {
            KAT.halt("Unable to initialize <" + string + "> as a Writer:\n" + iOException.getMessage());
        }
        printWriter.println();
        printWriter.println("=========================");
        printWriter.println();
        printWriter.println("FILENAME:  \"" + string + "\"");
        printWriter.println();
        printWriter.println("Electronic Codebook (ECB) Mode");
        printWriter.println("Variable Text Known Answer Tests");
        printWriter.println();
        printWriter.println("Algorithm Name: " + this.cipherName);
        printWriter.println("Principal Submitter: <as stated on the submission cover sheet>");
        printWriter.println();
        try {
            int n = 0;
            while (n < this.keys.length) {
                this.vtForKey(this.keys[n], printWriter);
                ++n;
            }
        }
        catch (Exception exception) {
            KAT.halt("Exception encountered in a " + this.cipherName + "_Algorithm method:\n" + exception.getMessage());
        }
        printWriter.println("==========");
        printWriter.close();
    }

    void vtForKey(int n, PrintWriter printWriter) throws IllegalAccessException, InvocationTargetException {
        KAT.notify("Generating and testing Variable Text KAT (short); key size: " + n);
        Object[] objectArray = new Object[]{};
        byte[] byArray = new byte[n / 8];
        byte[] byArray2 = new byte[16];
        int n2 = 0;
        objectArray = new Object[]{byArray};
        Object object = this.makeKey.invoke(null, objectArray);
        ++this.keyCount;
        printWriter.println("==========");
        printWriter.println();
        printWriter.println("KEYSIZE=" + n);
        printWriter.println();
        printWriter.println("KEY=" + KAT.toString(byArray));
        printWriter.println();
        objectArray = new Object[3];
        objectArray[1] = new Integer(0);
        objectArray[2] = object;
        int n3 = 0;
        while (n3 < 16) {
            int n4 = 0;
            while (n4 < 8) {
                printWriter.println("I=" + ++n2);
                byArray2[15 - n3] = (byte)(1 << 7 - n4);
                printWriter.println("PT=" + KAT.toString(byArray2));
                objectArray[0] = byArray2;
                byte[] byArray3 = (byte[])this.encrypt.invoke(null, objectArray);
                ++this.encBlocks;
                printWriter.print("CT=" + KAT.toString(byArray3));
                objectArray[0] = byArray3;
                byte[] byArray4 = (byte[])this.decrypt.invoke(null, objectArray);
                ++this.decBlocks;
                if (!KAT.areEqual(byArray2, byArray4)) {
                    printWriter.print(" *** ERROR ***");
                }
                printWriter.println();
                printWriter.println();
                ++n4;
            }
            byArray2[15 - n3] = 0;
            ++n3;
        }
    }

    private static boolean areEqual(byte[] byArray, byte[] byArray2) {
        int n = byArray.length;
        if (n != byArray2.length) {
            return false;
        }
        int n2 = 0;
        while (n2 < n) {
            if (byArray[n2] != byArray2[n2]) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    private static String toString(byte[] byArray) {
        int n = byArray.length;
        char[] cArray = new char[n * 2];
        int n2 = n;
        int n3 = 0;
        while (n2 > 0) {
            byte by = byArray[--n2];
            cArray[n3++] = HEX_DIGITS[by >>> 4 & 0xF];
            cArray[n3++] = HEX_DIGITS[by & 0xF];
        }
        return new String(cArray);
    }
}

