/*
 * Decompiled with CFR 0.152.
 */
package MARS;

import MARS.MARS_Properties;
import java.io.PrintWriter;
import java.security.InvalidKeyException;

public final class MARS_Algorithm {
    static final String NAME = "MARS_Algorithm";
    static final boolean IN = true;
    static final boolean OUT = false;
    static final boolean DEBUG = false;
    static final int debuglevel = 0;
    static final PrintWriter err = null;
    static final boolean TRACE = MARS_Properties.isTraceable("MARS_Algorithm");
    private static int NUM_MIX = 8;
    private static int NUM_ROUNDS = 16;
    private static int NUM_SETUP = 7;
    private static int W = 32;
    private static int NUM_DATA = 4;
    private static int MAX_KEY = 40;
    private static int EKEY_WORDS = 2 * (NUM_DATA + NUM_ROUNDS);
    private static int[] S = new int[]{164676729, 684261344, -2069205959, -1649577337, 2113903587, -735673503, -915562028, 2037697683, -2049943506, 709580549, 480340578, -1011013731, 253699557, 1365260079, -963264005, 1300230628, -1369478156, 225635910, -14426486, -1311797629, -246873374, 1050156610, -1946861898, 2135685292, -2090655869, 630653445, 1991239556, 981021140, 1334076496, 1550107638, 554327832, -963089882, 687138854, 979413020, -750737820, 2124947652, 1382451141, 2128466219, 849419549, -1667305338, -2131302351, -1418787667, 1459329875, -1959917220, -1232775506, -769324275, 692746017, -501239213, -1374460087, -399855994, -1825156860, -1723839898, 2024244444, -1231312821, 67397523, 601578526, 1187701206, 803373364, 1512192322, 409193819, -1047476509, 132102214, 1857587222, 755878986, -1530089895, 932734733, -872770413, 1330126149, -352547672, -619632170, -1337680352, 257165307, 1634195880, -772515997, 1303025347, 1005345112, -1414815724, -1228090879, 953558943, 40378901, -1892193067, 153887614, -1077582445, 847813932, -2058666347, 96181059, 2110610893, -1607560596, -85645339, 916570928, 873652654, -229116830, 1011817841, 815982601, 1759901009, -1671316924, 1575815864, 1976437192, -1772816066, 1770785994, 607957988, 721824663, 255561118, 14700767, -60989082, -480275832, -1065790195, 93433576, -1907155340, 1979594104, 795706010, -167042642, -1779897459, 1721321579, -1877115493, -43160015, 277916911, -530117160, -625809774, -848477339, -449235692, 989021680, 1648491597, 1175298979, 2077177641, -1947086368, 346734704, 361229653, 989691198, -755851775, 698995190, -273609645, -818182385, -1273719972, 1715758573, 38456007, 1504134337, 489240231, -598209882, -816362328, 67795472, 1826101255, -1969701300, -1395744669, -1019309387, -773791683, -1289596546, 546487571, 946547786, 1390992728, 1483042299, 1350697841, 1098979478, -482873474, -744509159, -914420234, 1761517595, -1588549915, 1428523362, -344984549, -674640518, -1508258402, -1125083786, 645054579, -268174532, 1253549323, 344199786, 1216063921, -1504720442, -157975223, 951085685, -578789427, 1674613967, -182675042, 447009603, -1203154284, -828404071, -1073948816, -943557172, 931419047, 2065808947, 964641213, 1318375729, -1832116328, 1494608465, -1711775305, -912782712, 494206303, -1331390984, 1632497360, -1250455830, 1497463085, -91176456, 871900340, -996781198, 1073141072, 1285947072, -2043614876, 1530903510, 2107796040, -1308417254, 69825812, 761500422, 783364425, 379867762, 1394891168, -1906358158, -110704679, 118656448, 222616418, -1345792723, 0x6316131, -667359282, 465837312, 976129039, -360479874, -1182502019, 330975377, -990332599, -1495880525, -1575629362, -2091285621, 1808902705, -176562862, 565788563, -183015551, 410910174, -380966026, 725155156, 1126031834, -1422309339, -1697446769, -538299734, 1704227811, 1648326755, -214668199, -1422215547, 860268811, 1800815678, -958529032, -1925046336, -1693527796, -1997430295, 1421996073, 2112542075, -1921276890, 1291130762, 1427799242, 446324488, -53063239, 627069314, -518011197, -1224894858, 863711271, -1211569388, -1637887952, 1800921940, -1382990601, 2115397773, 1485253225, 741328863, -477508410, 812879345, 136619828, -512132469, -1532439173, 1532827963, -928501605, 1945741688, 1933151538, 257513278, -371250429, -391792952, -2071132412, -1730178110, 1913265603, 1750017434, -1808029624, -1506344622, -2042929501, -780429429, 1838897391, 175115732, -1489160513, -1905653719, -2037007340, -480562105, -1824864920, -2003521502, 793844775, -570700740, 0x6662B6, 293372926, 1309848596, -1027823770, 976219152, -195681248, 1434005034, 1190516823, -824564274, -1017111237, 1811983174, -273900504, -1279045561, 1629355747, 628896263, -36338558, 991221839, 599706468, -1602882653, 143625901, 128840024, 2006357052, -87376067, -1063833395, -144205463, -633017875, 746933266, 898850723, 788888991, 1762010360, 481344253, 2064498118, -2129714245, -91055590, 1838586391, 1732417435, 1957461253, 17720772, -2036082333, -116935264, -805033005, 361594115, 679117397, -1146603921, 158260275, 563178107, 2008378246, -1793711367, -1496979888, -1930815535, -846437700, -1546243021, 898263293, 261856572, -693491365, -30197686, -1073712242, -848827601, -487887422, -1758229758, 113898054, 1100804525, 730054725, 925102474, -883216247, 369879767, 1565083222, 905488203, 508456094, 235965, 1732667520, -1273542607, -1393286222, -897492301, 1516475879, 808085445, -1948564373, 277843876, 270679770, -1833388917, 2134429934, -1423506988, 40031253, -1356707280, -1277654342, -122502225, -621285520, -862465097, -379499668, 732872692, 1895204815, 946639190, -838258971, 32013734, 1827217002, -1149514620, -946721760, -1657048579, 101597638, -682029291, 1308867399, 406591886, 1676587584, 769389722, 1834793556, -1841868625, -102677962, 2016941611, 1500671090, -2118752416, -1154931007, 1218498061, -1497347731, -1388097413, 1905084778, -1645193297, 1152499174, 88299228, -562238155, -719711349, 1644727497, 897778449, -915473246, 1752139500, -1904751768, 1675744952, -938502280, 2042925565, 457992178, 1919520125, 1580633137, -136749522, -1579988673, -589741250, -1989208750, 1271188090, -1496204556, -1515622964, 200248134, -1586889305, 1960788151, 1310754820, -1703582201, 59672520, 539041348, -1954884417, -968868043, 407429997, -2135052232, 509774108, 1681727751, -1090201864, 554249356, -163253367, 125321294, 2071506360, -1564136109, 1108703934, -1574617554, 2079585454, -2131389191, -1791912729, 2011927277, -1283364560, -628255946, -1086032791, -227699581, -294670635, 1899434549, -566075533, -1260019901, 2109615438, 758624645, 1239194211, -1732010600, 318884258, 949689279, 202922125, -1541291590, 2057537116, 1910539608, 1012726954, 2099485860, 43506141, -673437648, 1261928491, 1948822356, -1360133305, 1262467973, 1764699912, 323901326, 920248511, -1366597681, -306626865, 723985550, 386839023, 2110095318, 511053590, -1324128767, -2041701477, -672500967, 985166269, -811280529, -484714622, 230601833, -1413914527, 1399912541, -5210569, -634334981, -339118154, 194556943, 978128870, -548421013, 362607146, -1030170910, 729345898, 1638484672, -1420422777, 351183088, -552779420, 430928110};
    static final int BLOCK_SIZE = 16;
    private static final char[] HEX_DIGITS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};

    static void debug(String string) {
        ((PrintWriter)null).println(">>> MARS_Algorithm: " + string);
    }

    static void trace(boolean bl, String string) {
        if (TRACE) {
            ((PrintWriter)null).println(String.valueOf(bl ? "==> " : "<== ") + NAME + "." + string);
        }
    }

    static void trace(String string) {
        if (TRACE) {
            ((PrintWriter)null).println("<=> MARS_Algorithm." + string);
        }
    }

    public static synchronized Object makeKey(byte[] byArray) throws InvalidKeyException {
        if (byArray == null) {
            throw new InvalidKeyException("empty key given");
        }
        if (byArray.length != 16 && byArray.length != 24 && byArray.length != 32) {
            throw new InvalidKeyException("bad key length");
        }
        int[] nArray = new int[40];
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = byArray.length / 4;
        n = 0;
        while (n < n4) {
            nArray[n] = 0;
            n2 = 3;
            while (n2 >= 0) {
                nArray[n] = nArray[n] << 8 ^ byArray[n3 + n2] & 0xFF;
                --n2;
            }
            n3 += 4;
            ++n;
        }
        int[] nArray2 = new int[EKEY_WORDS];
        int[] nArray3 = new int[7 + EKEY_WORDS];
        MARS_Algorithm.wordKeySetup(nArray, n4, nArray3, nArray2);
        return nArray2;
    }

    public static final void wordKeySetup(int[] nArray, int n, int[] nArray2, int[] nArray3) {
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        n2 = 0;
        while (n2 < 7) {
            nArray2[n2] = S[n2];
            ++n2;
        }
        n2 = 0;
        n3 = 0;
        while (n2 < EKEY_WORDS - 1) {
            n4 = nArray2[n2] ^ nArray2[n2 + 5];
            if (n3 >= n) {
                n3 -= n;
            }
            nArray2[7 + n2] = (n4 >>> 29 | n4 << 3) ^ nArray[n3] ^ n2;
            ++n2;
            ++n3;
        }
        nArray2[MARS_Algorithm.EKEY_WORDS + 6] = n;
        n2 = 0;
        while (n2 < NUM_SETUP) {
            int n5;
            n3 = 1;
            while (n3 < EKEY_WORDS) {
                int n6 = 7 + n3;
                nArray2[n6] = nArray2[n6] + S[nArray2[n3 + 7 - 1] & 0x1FF];
                n5 = nArray2[7 + n3];
                nArray2[7 + n3] = n5 << 9 | n5 >>> W - 9;
                ++n3;
            }
            nArray2[7] = nArray2[7] + S[nArray2[7 + EKEY_WORDS - 1] & 0x1FF];
            n5 = nArray2[7];
            nArray2[7] = n5 << 9 | n5 >>> W - 9;
            ++n2;
        }
        n2 = 0;
        while (n2 < nArray3.length) {
            nArray3[n2] = 0;
            ++n2;
        }
        n2 = 0;
        while (n2 < nArray3.length) {
            nArray3[7 * n2 % 40] = nArray2[7 + n2];
            ++n2;
        }
        n2 = NUM_DATA + 1;
        while (n2 < EKEY_WORDS - NUM_DATA) {
            nArray3[n2] = MARS_Algorithm.fix_subkey(nArray3[n2], nArray3[n2 + 3]);
            n2 += 2;
        }
    }

    public static byte[] blockEncrypt(byte[] byArray, int n, Object object) {
        int[] nArray = (int[])object;
        int[] nArray2 = new int[NUM_DATA];
        byte[] byArray2 = new byte[4 * NUM_DATA];
        int n2 = 0;
        int n3 = 0;
        n2 = 0;
        while (n2 < 4) {
            nArray2[n2] = 0;
            n3 = 3;
            while (n3 >= 0) {
                nArray2[n2] = nArray2[n2] << 8 ^ byArray[n + n3] & 0xFF;
                --n3;
            }
            n += 4;
            ++n2;
        }
        MARS_Algorithm.wordEncrypt(nArray2, nArray);
        n2 = 0;
        while (n2 < 4) {
            n3 = 0;
            while (n3 < 4) {
                byArray2[(n2 << 2) + n3] = (byte)(nArray2[n2] & 0xFF);
                int n4 = n2;
                nArray2[n4] = nArray2[n4] >>> 8;
                ++n3;
            }
            ++n2;
        }
        return byArray2;
    }

    public static final void wordEncrypt(int[] nArray, int[] nArray2) {
        int n;
        int n2;
        int n3 = 0;
        int n4 = 0;
        int n5 = nArray[0] + nArray2[0];
        int n6 = nArray[1] + nArray2[1];
        int n7 = nArray[2] + nArray2[2];
        int n8 = nArray[3] + nArray2[3];
        n3 = 0;
        while (n3 < 8) {
            n2 = n5 >>> 24 | n5 << 8;
            n5 = (n6 ^ S[n5 & 0xFF]) + S[(n5 >>> 8 & 0xFF) + 256];
            n6 = n7 + S[n2 >>> 24 & 0xFF];
            n7 = n8 ^ S[(n2 & 0xFF) + 256];
            n8 = n2;
            if (n3 == 0 | n3 == 4) {
                n8 += n7;
            } else if (n3 == 1 | n3 == 5) {
                n8 += n5;
            }
            ++n3;
        }
        n4 = 4;
        n3 = 0;
        while (n3 < 16) {
            int n9 = n8;
            int n10 = n5 + nArray2[n4];
            n8 = n5 >>> 19 | n5 << 13;
            n2 = n8 * nArray2[n4 + 1];
            int n11 = n2 >>> 27;
            n2 = n2 << 5 | n11;
            n = S[n10 & 0x1FF] ^ n2;
            n10 = n10 >>> 32 - n11 | n10 << n11;
            n11 = n2 >>> 27;
            n2 = n2 << 5 | n11;
            n ^= n2;
            if (n3 < 8) {
                n = n >>> 32 - n11 | n << n11;
                n5 = n6 + n;
                n6 = n7 + n10;
                n7 = n9 ^ n2;
            } else {
                n5 = n6 ^ n2;
                n6 = n7 + n10;
                n = n >>> 32 - n11 | n << n11;
                n7 = n9 + n;
            }
            n4 += 2;
            ++n3;
        }
        n3 = 0;
        while (n3 < 8) {
            if (n3 == 2 | n3 == 6) {
                n5 -= n8;
            } else if (n3 == 3 | n3 == 7) {
                n5 -= n6;
            }
            n = n5 >>> 8 | n5 << 24;
            n5 = n6 ^ S[(n5 & 0xFF) + 256];
            n6 = n7 - S[n >>> 16 & 0xFF];
            n7 = n8 - S[(n >>> 8 & 0xFF) + 256] ^ S[n & 0xFF];
            n8 = n;
            ++n3;
        }
        nArray[0] = n5 - nArray2[2 * NUM_ROUNDS + 4];
        nArray[1] = n6 - nArray2[2 * NUM_ROUNDS + 5];
        nArray[2] = n7 - nArray2[2 * NUM_ROUNDS + 6];
        nArray[3] = n8 - nArray2[2 * NUM_ROUNDS + 7];
    }

    public static byte[] blockDecrypt(byte[] byArray, int n, Object object) {
        int[] nArray = (int[])object;
        int[] nArray2 = new int[NUM_DATA];
        byte[] byArray2 = new byte[4 * NUM_DATA];
        int n2 = 0;
        int n3 = 0;
        n2 = 0;
        while (n2 < 4) {
            nArray2[3 - n2] = 0;
            n3 = 3;
            while (n3 >= 0) {
                nArray2[3 - n2] = nArray2[3 - n2] << 8 ^ byArray[n + n3] & 0xFF;
                --n3;
            }
            n += 4;
            ++n2;
        }
        MARS_Algorithm.wordDecrypt(nArray2, nArray);
        n2 = 0;
        while (n2 < 4) {
            n3 = 0;
            while (n3 < 4) {
                byArray2[(n2 << 2) + n3] = (byte)(nArray2[3 - n2] & 0xFF);
                int n4 = 3 - n2;
                nArray2[n4] = nArray2[n4] >>> 8;
                ++n3;
            }
            ++n2;
        }
        return byArray2;
    }

    public static final void wordDecrypt(int[] nArray, int[] nArray2) {
        int n;
        int n2;
        int n3 = 0;
        int n4 = 0;
        int n5 = nArray[0] + nArray2[2 * NUM_ROUNDS + 7];
        int n6 = nArray[1] + nArray2[2 * NUM_ROUNDS + 6];
        int n7 = nArray[2] + nArray2[2 * NUM_ROUNDS + 5];
        int n8 = nArray[3] + nArray2[2 * NUM_ROUNDS + 4];
        n3 = 0;
        while (n3 < 8) {
            n2 = n5 >>> 24 | n5 << 8;
            n5 = (n6 ^ S[n5 & 0xFF]) + S[(n5 >>> 8 & 0xFF) + 256];
            n6 = n7 + S[n2 >>> 24 & 0xFF];
            n7 = n8 ^ S[(n2 & 0xFF) + 256];
            n8 = n2;
            if (n3 == 0 | n3 == 4) {
                n8 += n7;
            } else if (n3 == 1 | n3 == 5) {
                n8 += n5;
            }
            ++n3;
        }
        n4 = 35;
        n3 = 0;
        while (n3 < 16) {
            int n9 = n8;
            n2 = n5 * nArray2[n4];
            n8 = n5 >>> 13 | n5 << 19;
            int n10 = n2 >>> 27;
            n2 = n10 | n2 << 5;
            int n11 = n8 + nArray2[n4 - 1];
            n = S[n11 & 0x1FF] ^ n2;
            n11 = n11 << n10 | n11 >>> 32 - n10;
            n10 = n2 >>> 27;
            n2 = n10 | n2 << 5;
            n ^= n2;
            if (n3 < 8) {
                n = n >>> 32 - n10 | n << n10;
                n5 = n6 - n;
                n6 = n7 - n11;
                n7 = n9 ^ n2;
            } else {
                n5 = n6 ^ n2;
                n6 = n7 - n11;
                n = n >>> 32 - n10 | n << n10;
                n7 = n9 - n;
            }
            n4 -= 2;
            ++n3;
        }
        n3 = 0;
        while (n3 < 8) {
            if (n3 == 2 | n3 == 6) {
                n5 -= n8;
            } else if (n3 == 3 | n3 == 7) {
                n5 -= n6;
            }
            n = n5 >>> 8 | n5 << 24;
            n5 = n6 ^ S[(n5 & 0xFF) + 256];
            n6 = n7 - S[n >>> 16 & 0xFF];
            n7 = n8 - S[(n >>> 8 & 0xFF) + 256] ^ S[n & 0xFF];
            n8 = n;
            ++n3;
        }
        nArray[0] = n5 - nArray2[3];
        nArray[1] = n6 - nArray2[2];
        nArray[2] = n7 - nArray2[1];
        nArray[3] = n8 - nArray2[0];
    }

    public static boolean self_test() {
        return MARS_Algorithm.self_test(16);
    }

    public static final int fix_subkey(int n, int n2) {
        int n3 = n & 3;
        int n4 = ~(n |= 3) ^ n << 1;
        int n5 = n4 & n4 << 1;
        n5 &= n5 << 2;
        n5 &= n5 << 4;
        n5 &= n4 << 8;
        if ((n5 &= 0xFFFFFE00) == 0) {
            return n;
        }
        n4 = n5 | n5 >>> 1;
        n4 |= n4 >>> 2;
        n4 |= n5 >>> 4;
        n4 |= n4 >>> 5;
        n4 &= (~n ^ n << 1) & (~n ^ n >>> 1) & 0xFFFFFFFC;
        int n6 = S[265 + n3];
        return n ^= (n6 << (n2 & 0x1F) | n6 >>> W - (n2 & 0x1F)) & n4;
    }

    public static final int LROTATE(int n, int n2) {
        return n << (n2 & 0x1F) | n >>> W - (n2 & 0x1F);
    }

    public static final int RROTATE(int n, int n2) {
        return n >>> (n2 & 0x1F) | n << W - (n2 & 0x1F);
    }

    public static int blockSize() {
        return 16;
    }

    private static final boolean self_test(int n) {
        boolean bl = false;
        try {
            byte[] byArray = new byte[n];
            byte[] byArray2 = new byte[16];
            int n2 = 0;
            while (n2 < n) {
                byArray[n2] = (byte)n2;
                ++n2;
            }
            n2 = 0;
            while (n2 < 16) {
                byArray2[n2] = (byte)n2;
                ++n2;
            }
            Object object = MARS_Algorithm.makeKey(byArray);
            byte[] byArray3 = MARS_Algorithm.blockEncrypt(byArray2, 0, object);
            byte[] byArray4 = MARS_Algorithm.blockDecrypt(byArray3, 0, object);
            bl = MARS_Algorithm.areEqual(byArray2, byArray4);
            if (!bl) {
                throw new RuntimeException("Symmetric operation failed");
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return bl;
    }

    private static boolean areEqual(byte[] byArray, byte[] byArray2) {
        int n = byArray.length;
        if (n != byArray2.length) {
            return false;
        }
        int n2 = 0;
        while (n2 < n) {
            if (byArray[n2] != byArray2[n2]) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    private static String toString(byte[] byArray) {
        return MARS_Algorithm.toString(byArray, 0, byArray.length);
    }

    private static String toString(byte[] byArray, int n, int n2) {
        char[] cArray = new char[n2 * 2];
        int n3 = n;
        int n4 = 0;
        while (n3 < n + n2) {
            byte by = byArray[n3++];
            cArray[n4++] = HEX_DIGITS[by >>> 4 & 0xF];
            cArray[n4++] = HEX_DIGITS[by & 0xF];
        }
        return new String(cArray);
    }

    public static void main(String[] stringArray) {
        MARS_Algorithm.self_test(16);
        MARS_Algorithm.self_test(24);
        MARS_Algorithm.self_test(32);
        try {
            byte[] byArray = new byte[16];
            int[] nArray = new int[NUM_DATA];
            int n = 0;
            while (n < 16) {
                byArray[n] = (byte)n;
                ++n;
            }
            n = 0;
            while (n < NUM_DATA) {
                nArray[n] = n;
                ++n;
            }
            int[] nArray2 = (int[])MARS_Algorithm.makeKey(byArray);
            long l = System.currentTimeMillis();
            n = 0;
            while (n < 200000) {
                MARS_Algorithm.wordEncrypt(nArray, nArray2);
                ++n;
            }
            l = System.currentTimeMillis() - l;
            System.out.println("time to encrypt 200000 blocks: " + l + " ms.");
            System.out.println("     " + 25600.0 / (double)l + "Mbit/sec");
            l = System.currentTimeMillis();
            n = 0;
            while (n < 200000) {
                MARS_Algorithm.wordDecrypt(nArray, nArray2);
                ++n;
            }
            l = System.currentTimeMillis() - l;
            System.out.println("time to decrypt 200000 blocks: " + l + " ms.");
            System.out.println("     " + 25600.0 / (double)l + "Mbit/sec");
            int[] nArray3 = new int[7 + EKEY_WORDS];
            int[] nArray4 = new int[]{16909060, 84281096, 151653132, 219025168};
            l = System.currentTimeMillis();
            n = 0;
            while (n < 20000) {
                MARS_Algorithm.wordKeySetup(nArray4, 4, nArray3, nArray2);
                ++n;
            }
            l = System.currentTimeMillis() - l;
            System.out.println("time to expand 20000 keys: " + l + " ms.");
            System.out.println("     " + 2560.0 / (double)l + "Mbit/sec");
            return;
        }
        catch (Exception exception) {
            System.out.println("self test timing test had exception " + exception.getMessage());
            return;
        }
    }

    static {
        long l = System.currentTimeMillis();
        l = System.currentTimeMillis() - l;
    }
}

